/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.dqmetrics;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.dataquality.dqmetrics.ValuesInSetMetric;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.DSSMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ValuesInSetStreamComputer
extends DSSMetricsEngine.DSSMetricsEngineComputer {
    @Override
    public String getProbeType() {
        return "temporary_metrics_probe";
    }

    @Override
    public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object dataset, MetricTargetType objectType, Partition partition) {
        return new DSSMetricsEngine.DSSMetricsEngineRun().with(new MetricComputation(probe, this, metric, 10.0));
    }

    @Override
    public DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession start(DSSMetricsEngine.DSSMetricsEngineCallbacks engine, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        ValuesInSetStreamComputerSession session = new ValuesInSetStreamComputerSession();
        for (MetricComputation computation : computations) {
            ValuesInSetStreamComputerSingleSession sess = new ValuesInSetStreamComputerSingleSession();
            ValuesInSetMetric metric = (ValuesInSetMetric)computation.metric;
            sess.computation = computation;
            sess.column = engine.getColumnFactory().column(metric.getColumn());
            sess.whitelist = new HashSet<String>(metric.values);
            session.aliveSubSessions.add(sess);
        }
        return session;
    }

    @Override
    public boolean accumulate(Row row, DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession rawSession) throws Exception {
        ValuesInSetStreamComputerSession session = (ValuesInSetStreamComputerSession)rawSession;
        ArrayList<ValuesInSetStreamComputerSingleSession> toRemove = new ArrayList<ValuesInSetStreamComputerSingleSession>();
        for (ValuesInSetStreamComputerSingleSession sess : session.aliveSubSessions) {
            String dataValue = row.get(sess.column);
            if (!StringUtils.isNotBlank((CharSequence)dataValue) || sess.whitelist.contains(dataValue)) continue;
            sess.outliers.add(dataValue);
            if (sess.outliers.size() <= ((ValuesInSetMetric)sess.computation.metric).maxOutlierCount) continue;
            toRemove.add(sess);
        }
        session.doneSubSessions.addAll(toRemove);
        session.aliveSubSessions.removeAll(toRemove);
        return !session.aliveSubSessions.isEmpty();
    }

    @Override
    public Map<Metric, String> getAggregates(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession rawSession) throws Exception {
        ValuesInSetStreamComputerSession session = (ValuesInSetStreamComputerSession)rawSession;
        HashMap<Metric, String> aggregates = new HashMap<Metric, String>();
        for (ValuesInSetStreamComputerSingleSession sess : session.aliveSubSessions) {
            aggregates.put(sess.computation.metric, JSON.json(sess.outliers));
        }
        for (ValuesInSetStreamComputerSingleSession sess : session.doneSubSessions) {
            aggregates.put(sess.computation.metric, JSON.json(sess.outliers));
        }
        return aggregates;
    }

    @Override
    public boolean canComputeWith(List<MetricComputation> handledComputations, List<MetricComputation> otherComputations) {
        return otherComputations.stream().allMatch(computation -> computation.computer instanceof ValuesInSetStreamComputer);
    }

    @Override
    public void cleanup(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
    }

    @Override
    public JsonObject writeJson(JsonSerializationContext ctx) {
        return new JsonObject();
    }

    @Override
    public void readJson(JsonObject jsonObj, JsonDeserializationContext ctx) {
    }

    public static class ValuesInSetStreamComputerSession
    implements DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession {
        public List<ValuesInSetStreamComputerSingleSession> aliveSubSessions = new ArrayList<ValuesInSetStreamComputerSingleSession>();
        public List<ValuesInSetStreamComputerSingleSession> doneSubSessions = new ArrayList<ValuesInSetStreamComputerSingleSession>();
    }

    public static class ValuesInSetStreamComputerSingleSession
    implements DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession {
        public MetricComputation computation;
        public Column column;
        public Set<String> whitelist;
        public Set<String> outliers = new LinkedHashSet<String>();
    }
}

