/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.input;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.export.input.RemotableExportInput;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.input.TableColoring;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;

public class ExportDataset
extends RemotableExportInput {
    public SerializedDataset dataset;
    private ExportInput.InputDescription description = new ExportInput.InputDescription();
    private StreamableDatasetSelection selection;
    private TableColoring coloring;
    public DSSAuthCtx authCtx;
    private transient ColumnFactory cf;

    public ExportDataset() {
    }

    public ExportDataset(AuthCtx authCtx, SerializedDataset ds, TableColoring coloring) {
        this.authCtx = (DSSAuthCtx)authCtx;
        this.dataset = ds;
        this.description.name = ds.name;
        this.description.projectKey = ds.getProjectKey();
        this.description.description = "Dataset \"" + ds.name + "\" (" + ds.type + ")";
        this.description.status = "Initializing";
        this.coloring = coloring;
    }

    public ExportDataset(AuthCtx authCtx, SerializedDataset ds) {
        this(authCtx, ds, null);
    }

    public ExportDataset(AuthCtx authCtx, ExportInput.InputDescription desc, SerializedDataset ds) {
        this.authCtx = (DSSAuthCtx)authCtx;
        this.dataset = ds;
        this.description = desc;
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, StreamableDatasetSelection selection, ColumnFactory cf) throws Exception {
        this.selection = selection;
        this.cf = cf;
    }

    @Override
    public Schema getSchema() throws Exception {
        return this.dataset.getSchema();
    }

    @Override
    public ExportInput.InputDescription describe() {
        return this.description;
    }

    @Override
    public long getInputSize() {
        return -1L;
    }

    @Override
    public void close() {
    }

    @Override
    public void stream(ProcessorOutput output) throws Exception {
        UniversalSingleThreadPusher.push((AuthCtx)this.authCtx, Dataset.fromSerialized(this.dataset), this.selection, output, this.cf, (RowFactory)new StreamRowFactory());
        output.lastRowEmitted();
    }

    @Override
    public FuturePayload.FuturePayloadTarget getSource() {
        return DSSFuturePayloadUtils.forTaggableObject(this.dataset);
    }

    public TableColoring getColoring() {
        return this.coloring;
    }
}

