/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.avro;

import com.dataiku.dip.coremodel.SchemaValidator;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.formats.avro.AvroFormatConfig;
import com.dataiku.dip.formats.avro.AvroReusableRow;
import com.dataiku.dip.formats.avro.AvroReusableRowWriter;
import com.dataiku.dip.formats.avro.AvroRowConverter;
import com.dataiku.dip.formats.avro.SchemaConverter;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;

public class AvroOutputFormatter
implements OutputFormatter {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.output.avro");
    private final AvroFormatConfig params;
    private WarningsContext warningsContext = new WarningsContext.DummyWarningsContext();
    private com.dataiku.dip.coremodel.Schema outputSchema;
    private Schema avroSchema;
    private OutputStream outputStream = null;
    private DataFileWriter<AvroReusableRow> fileWriter = null;
    private AvroReusableRow reusableRow = new AvroReusableRow();
    private AvroRowConverter rowConverter;
    private AvroReusableRowWriter writer;

    public AvroOutputFormatter(AvroFormatConfig params) {
        this.params = (AvroFormatConfig)Preconditions.checkNotNull((Object)params);
    }

    public void header(ColumnFactory columnFactory, OutputStream outputStream) throws IOException {
        this.outputStream = outputStream;
        new SchemaValidator().validate(this.outputSchema);
        this.avroSchema = SchemaConverter.convertSchema(this.outputSchema, SchemaConverter.AvroFlavor.HIVE);
        logger.info((Object)("Avro schema : " + String.valueOf(this.avroSchema)));
        this.rowConverter = new AvroRowConverter(columnFactory, this.outputSchema, this.avroSchema);
        this.writer = new AvroReusableRowWriter();
        this.fileWriter = new DataFileWriter((DatumWriter)this.writer);
        switch (this.params.avroCompressionMethod) {
            case DEFLATE_1: {
                this.fileWriter.setCodec(CodecFactory.deflateCodec((int)1));
                break;
            }
            case DEFLATE_5: {
                this.fileWriter.setCodec(CodecFactory.deflateCodec((int)5));
                break;
            }
            case DEFLATE_9: {
                this.fileWriter.setCodec(CodecFactory.deflateCodec((int)9));
                break;
            }
            case SNAPPY: {
                this.fileWriter.setCodec(CodecFactory.snappyCodec());
                break;
            }
            default: {
                this.fileWriter.setCodec(CodecFactory.nullCodec());
            }
        }
        this.fileWriter.create(this.avroSchema, outputStream);
    }

    public void format(Row row, ColumnFactory columnFactory, OutputStream outputStream) throws IOException {
        if (outputStream != this.outputStream) {
            throw new IOException("Format must be used with the exact same outputstream as header is.");
        }
        boolean ok = false;
        this.reusableRow.clear();
        try {
            this.rowConverter.write(row, this.reusableRow);
            ok = true;
        }
        catch (Exception e) {
            this.warningsContext.addWarning(WarningsContext.WarningType.OUTPUT_DATA_BAD_TYPE, "Unable to write row: " + e.getMessage(), (Throwable)e, logger);
        }
        if (ok) {
            this.fileWriter.append((Object)this.reusableRow);
        }
    }

    public void footer(ColumnFactory columnFactory, OutputStream outputStream) throws IOException {
        if (this.fileWriter == null) {
            this.header(columnFactory, outputStream);
        }
        if (this.fileWriter != null) {
            this.fileWriter.flush();
            this.fileWriter.close();
        }
    }

    public void cancel(OutputStream os) throws Exception {
    }

    public void setOutputSchema(com.dataiku.dip.coremodel.Schema schema) {
        this.outputSchema = schema;
    }

    public void setWarningsContext(WarningsContext warningsContext) {
        this.warningsContext = warningsContext;
    }
}

