/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.execution;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.util.AutoDelete;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;

public class PdfMerger {
    public void merge(List<PdfSource> sources, File destinationFile) throws IOException {
        Preconditions.checkNotNull(sources, (Object)"sources cannot be null");
        Preconditions.checkArgument((!sources.isEmpty() ? 1 : 0) != 0, (Object)"sources cannot be empty");
        Preconditions.checkNotNull((Object)destinationFile, (Object)"destinationFile cannot be null");
        PDFMergerUtility pdfMergerUtility = new PDFMergerUtility();
        pdfMergerUtility.setDestinationFileName(destinationFile.toString());
        PDDocumentInformation pdfInfo = new PDDocumentInformation();
        pdfInfo.setAuthor("Dataiku DSS");
        pdfInfo.setCreator("Dataiku DSS");
        pdfInfo.setCreationDate(Calendar.getInstance());
        pdfInfo.setModificationDate(Calendar.getInstance());
        pdfMergerUtility.setDestinationDocumentInformation(pdfInfo);
        for (PdfSource source : sources) {
            pdfMergerUtility.addSource(source.file);
        }
        try (AutoDelete tempDir = DSSTempUtils.getTempFolder((String)"pdfmerger");){
            pdfMergerUtility.mergeDocuments(MemoryUsageSetting.setupTempFileOnly().setTempDir((File)tempDir));
        }
    }

    public static class PdfSource {
        public final File file;
        public final String bgColor;

        public PdfSource(File file, String bgColor) {
            this.file = file;
            this.bgColor = bgColor;
        }
    }
}

