/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet.datetime;

import com.dataiku.dip.input.formats.parquet.datetime.AbstractFormatter;
import com.dataiku.dip.input.formats.parquet.datetime.DateFormatSymbolsEx;
import com.dataiku.dip.input.formats.parquet.datetime.DateTimeStamp;
import com.dataiku.dip.input.formats.parquet.datetime.JDateTime;
import com.dataiku.dip.input.formats.parquet.datetime.LocaleUtil;

public class Iso8601JdtFormatter
extends AbstractFormatter {
    public Iso8601JdtFormatter() {
        this.preparePatterns(new String[]{"YYYY", "MM", "DD", "D", "MML", "MMS", "DL", "DS", "hh", "mm", "ss", "mss", "DDD", "WW", "WWW", "W", "E", "TZL", "TZS"});
    }

    @Override
    protected String convertPattern(int patternIndex, JDateTime jdt) {
        DateFormatSymbolsEx dfs = LocaleUtil.getDateFormatSymbols(jdt.getLocale());
        switch (patternIndex) {
            case 0: {
                return this.printPad4(jdt.getYear());
            }
            case 1: {
                return this.print2(jdt.getMonth());
            }
            case 2: {
                return this.print2(jdt.getDay());
            }
            case 3: {
                return Integer.toString(jdt.getDayOfWeek());
            }
            case 4: {
                return dfs.getMonth(jdt.getMonth() - 1);
            }
            case 5: {
                return dfs.getShortMonth(jdt.getMonth() - 1);
            }
            case 6: {
                return dfs.getWeekday(jdt.getDayOfWeek() % 7 + 1);
            }
            case 7: {
                return dfs.getShortWeekday(jdt.getDayOfWeek() % 7 + 1);
            }
            case 8: {
                return this.print2(jdt.getHour());
            }
            case 9: {
                return this.print2(jdt.getMinute());
            }
            case 10: {
                return this.print2(jdt.getSecond());
            }
            case 11: {
                return this.print3(jdt.getMillisecond());
            }
            case 12: {
                return this.print3(jdt.getDayOfYear());
            }
            case 13: {
                return this.print2(jdt.getWeekOfYear());
            }
            case 14: {
                return "W" + this.print2(jdt.getWeekOfYear());
            }
            case 15: {
                return Integer.toString(jdt.getWeekOfMonth());
            }
            case 16: {
                return jdt.getEra() == 1 ? dfs.getAdEra() : dfs.getBcEra();
            }
            case 17: {
                return jdt.getTimeZone().getDisplayName(jdt.isInDaylightTime(), 1, jdt.getLocale());
            }
            case 18: {
                return jdt.getTimeZone().getDisplayName(jdt.isInDaylightTime(), 0, jdt.getLocale());
            }
        }
        return new String(this.patterns[patternIndex]);
    }

    @Override
    protected void parseValue(int patternIndex, String value, DateTimeStamp destination) {
        int v = Integer.parseInt(value);
        switch (patternIndex) {
            case 0: {
                destination.year = v;
                break;
            }
            case 1: {
                destination.month = v;
                break;
            }
            case 2: {
                destination.day = v;
                break;
            }
            case 8: {
                destination.hour = v;
                break;
            }
            case 9: {
                destination.minute = v;
                break;
            }
            case 10: {
                destination.second = v;
                break;
            }
            case 11: {
                destination.millisecond = v;
                break;
            }
            default: {
                throw new IllegalArgumentException("Parsing template failed: " + new String(this.patterns[patternIndex]));
            }
        }
    }
}

