/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.h2.ColumnAdderFilteringProcessorOutput;
import com.dataiku.dip.dataflow.exec.h2.DatasetToH2ConnectionLoader;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.labeling.LabelsDatasetParams;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.labeling.BaseLabelingAnswer;
import com.dataiku.dip.labeling.ClassCountBuilder;
import com.dataiku.dip.labeling.Label;
import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.LabelingAnswerCRUDService;
import com.dataiku.dip.labeling.LabelingRecord;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTaskCheck;
import com.dataiku.dip.labeling.LabelingTaskStats;
import com.dataiku.dip.labeling.PerAnnotatorStatsBuilder;
import com.dataiku.dip.labeling.TextLabelingTask;
import com.dataiku.dip.labeling.VerifiedLabel;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.labeling.score.LabelingScoreComputerFactory;
import com.dataiku.dip.labeling.text.TextLabelingRecord;
import com.dataiku.dip.labeling.text.TokenizedTextLabelingRecord;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.rpc.LocalPrivilegedIntercomAPIClient;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.sql.H2SQLDialect;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.DeleteQueryBuilder;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.sql.queries.UpsertQueryBuilder;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LabelingInternalDBService
extends AbstractDSSDBService {
    @Autowired
    private DSSDBConnectionsManagementService internalDBConnectionsService;
    @Autowired
    private ReadOnlyJobsInternalDB jobsDBService;
    private final ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
    private static final String DB_NAME = "labelings";
    private static final int SCHEMA_VERSION = 1;
    private static final String DKU_INTERNAL_COLUMN_PREFIX = "__DKU_INTERNAL__";
    public static final List<String> TABLES = ImmutableList.of((Object)"LABELING_ANSWERS", (Object)"VERIFIED_LABELING_ANSWERS");
    private static final String DKU_GENERATED_ID_COLUMN_NAME = "__DKU_GENERATED_ID_COLUMN__";
    private static final String DKU_INVALID_PRELABEL_COLUMN_NAME = "__DKU_INVALID_PRELABEL_COLUMN__";
    private final Map<String, MetadataDatasetLoadStatus> metadataDatasetsLoadStatuses = new HashMap<String, MetadataDatasetLoadStatus>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.labeling.internal-db.service");

    public LabelingInternalDBService() {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 1, true);
    }

    protected LabelingInternalDBService(boolean autoServer) {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 1, autoServer);
    }

    @PostConstruct
    public void init() throws SQLException {
        this.create();
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws SQLException {
        if (currentSchemaVersion == 0) {
            try (Statement st2 = conn.createStatement();){
                this.createTable("LABELING_ANSWERS", LabelingAnswerTable.TABLE_COLUMNS, LabelingAnswerTable.KEY_COLUMNS, st2);
                this.createTable("VERIFIED_LABELING_ANSWERS", VerifiedLabelingAnswerTable.TABLE_COLUMNS, VerifiedLabelingAnswerTable.KEY_COLUMNS, st2);
            }
            catch (SQLException e) {
                throw new CodedSQLException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_EIDB, "Failed to access internal database", (Throwable)e);
            }
        }
    }

    public void fillPerAnswerStats(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset, LabelingTaskStats stats, boolean includePerAnnotatorScore) throws Exception {
        SelectQueryBuilder sqb = this.createListAllAnswersForLabelingTaskQuery(authCtx, labelingTask, metadataDataset);
        ClassCountBuilder classCountBuilder = new ClassCountBuilder();
        PerAnnotatorStatsBuilder perAnnotatorStatsBuilder = includePerAnnotatorScore ? new PerAnnotatorStatsBuilder(LabelingScoreComputerFactory.getScoreComputer(labelingTask)) : null;
        new LabelingAnswersFetcher().consumeAnswersFromDB(sqb, answer -> {
            if (labelingTask.type.hasClasses) {
                classCountBuilder.fillWithAnswer((LabelingAnswer)answer);
            }
            if (includePerAnnotatorScore) {
                perAnnotatorStatsBuilder.fillWithAnswer((LabelingAnswer)answer);
            }
        });
        if (labelingTask.type.hasClasses) {
            stats.perClassCount = classCountBuilder.getPerClassCount();
        }
        if (includePerAnnotatorScore) {
            stats.perAnnotatorRecordsStats = perAnnotatorStatsBuilder.getPerLabelerStats();
        }
    }

    public LabelingTaskCheck checkLabelingTask(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        this.loadMetadataToInternalDbIfNeeded(authCtx, labelingTask, metadataDataset);
        MetadataDatasetLoadStatus metadataTableCacheItem = this.getMetadataDatasetLoadStatus(labelingTask, metadataDataset);
        LabelingTaskCheck check = new LabelingTaskCheck();
        check.invalidPrelabelsCount = metadataTableCacheItem.loadResult.invalidPrelabels;
        check.invalidPrelabelError = Optional.ofNullable(metadataTableCacheItem.loadResult.firstPrelabelError).map(Throwable::getMessage).orElse(null);
        return check;
    }

    public synchronized List<String> getAnnotatedButNotReviewedRecordIds(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        this.loadMetadataToInternalDbIfNeeded(authCtx, labelingTask, metadataDataset);
        SelectQueryBuilder sqb = this.createAnnotatedButNotReviewedRecordsQuery(labelingTask, metadataDataset);
        ArrayList<String> res = new ArrayList<String>();
        try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
            ResultSet rs2 = context.execute(sqb, this.getDialect());
            while (rs2.next()) {
                res.add(rs2.getString(this.getIdColumnNameInDB(labelingTask)));
            }
        }
        return res;
    }

    public List<String> getReviewedRecordIds(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        SelectQueryBuilder sqb = this.createListAllVerifiedAnswersForLabelingTaskQuery(authCtx, labelingTask, metadataDataset);
        sqb.order("LAST_UPDATE_TIME", QueryAst.OrderType.DESC);
        ArrayList<String> res = new ArrayList<String>();
        try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
            ResultSet rs2 = context.execute(sqb, this.getDialect());
            while (rs2.next()) {
                res.add(rs2.getString(this.getIdColumnNameInDB(labelingTask)));
            }
        }
        return res;
    }

    private void dropAnswerTable(String projectKey, String labelingTaskId, String tableBaseName) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            PreparedStatement ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(this.resolveTable(tableBaseName)).withParameterizedEqualWheres("PROJECT_KEY").withParameterizedEqualWheres("LABELING_TASK_ID").toSql(this.getDialect()));
            ps2.setString(1, projectKey);
            ps2.setString(2, labelingTaskId);
            ps2.execute();
            ac.commit();
        }
    }

    public void dropLabelingAnswers(String projectKey, String labelingTaskId) throws SQLException {
        this.dropAnswerTable(projectKey, labelingTaskId, "LABELING_ANSWERS");
        this.dropAnswerTable(projectKey, labelingTaskId, "VERIFIED_LABELING_ANSWERS");
    }

    public void dropMetadataTable(LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        this.invalidateMetadataTableCache(labelingTask, metadataDataset);
        try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
            context.execute("DROP TABLE IF EXISTS " + this.getDialect().getQuotedTableFullName(this.getMetadataSQLTable(metadataDataset, labelingTask)));
            context.connection.commit();
        }
    }

    public void deleteAllAnswersForRecord(LabelingTask labelingTask, String recordId) throws SQLException {
        logger.info((Object)("Deleting all answers of record " + recordId + " in labeling task '" + labelingTask.getDisplayName() + "' (id: " + labelingTask.id + " )"));
        this.deleteAnswersForRecordFromTable(labelingTask, this.resolveTable("VERIFIED_LABELING_ANSWERS"), recordId);
        this.deleteAnswersForRecordFromTable(labelingTask, this.resolveTable("LABELING_ANSWERS"), recordId);
    }

    private void deleteAnswersForRecordFromTable(LabelingTask labelingTask, SQLUtils.SQLTable table, String recordId) throws SQLException {
        try (DSSDBConnection ac = this.acquireConnection();){
            PreparedStatement ps2 = ac.prepareNonPersistedStatement(DeleteQueryBuilder.deleteFrom(table).withParameterizedEqualWheres("PROJECT_KEY").withParameterizedEqualWheres("LABELING_TASK_ID").withParameterizedEqualWheres("IDENTIFIER").toSql(this.getDialect()));
            ps2.setString(1, labelingTask.projectKey);
            ps2.setString(2, labelingTask.id);
            ps2.setString(3, recordId);
            ps2.execute();
            ac.commit();
        }
    }

    public void saveAnswer(BaseLabelingAnswer answer) throws Exception {
        this.saveAnswers(Collections.singletonList(answer));
    }

    public void saveAnswers(List<? extends BaseLabelingAnswer> baseLabelingAnswers) throws Exception {
        if (baseLabelingAnswers == null || baseLabelingAnswers.isEmpty()) {
            return;
        }
        try (DSSDBConnection ac = this.acquireConnection();){
            LabelingAnswersSaver answersSaver = new LabelingAnswersSaver(ac);
            VerifiedLabelingAnswersSaver verifiedAnswersSaver = new VerifiedLabelingAnswersSaver(ac);
            for (BaseLabelingAnswer baseLabelingAnswer : baseLabelingAnswers) {
                if (baseLabelingAnswer instanceof LabelingAnswer) {
                    answersSaver.save((LabelingAnswer)baseLabelingAnswer);
                    continue;
                }
                if (baseLabelingAnswer instanceof VerifiedLabelingAnswer) {
                    verifiedAnswersSaver.save((VerifiedLabelingAnswer)baseLabelingAnswer);
                    continue;
                }
                throw new IllegalArgumentException("Cannot save answer of class " + String.valueOf(baseLabelingAnswer.getClass()));
            }
            answersSaver.lastAnswerSaved();
            verifiedAnswersSaver.lastAnswerSaved();
            ac.commit();
        }
    }

    public void copyLabelingAnswers(AuthCtx authCtx, LabelingTask original, LabelingTask copy) throws Exception {
        ArrayList<BaseLabelingAnswer> answersToCopy = new ArrayList<BaseLabelingAnswer>();
        answersToCopy.addAll(this.listAllNoCheckMetadata(authCtx, original));
        answersToCopy.addAll(this.listAllVerifiedNoCheckMetadata(authCtx, original));
        long currentTime = System.currentTimeMillis();
        for (BaseLabelingAnswer answer : answersToCopy) {
            answer.labelingTaskId = copy.id;
            answer.creationTime = currentTime;
        }
        this.saveAnswers(answersToCopy);
    }

    public void fillPerRecordStatusGlobalStats(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset, LabelingTaskStats stats) throws Exception {
        String countColName = "__DKU_INTERNAL__number_annotations_per_record";
        String isReviewed = "__DKU_INTERNAL__is_reviewed";
        String stateCountCol = "__DKU_INTERNAL__state_count";
        String stateCol = "__DKU_INTERNAL__state";
        this.loadMetadataToInternalDbIfNeeded(authCtx, labelingTask, metadataDataset);
        MetadataDatasetLoadStatus metadataTableCacheItem = this.getMetadataDatasetLoadStatus(labelingTask, metadataDataset);
        SelectQueryBuilder sqb = this.getAnswersGroupedBy(labelingTask, countColName, "IDENTIFIER");
        sqb.select(this.ebf.caseWhen(this.ebf.col("STATUS").eq(LabelingAnswer.AnswerStatus.REVIEWED.toString()), 1, 0).max(), isReviewed);
        SelectQueryBuilder joinSqb = this.joinAnswersWithMetadataDataset(sqb, this.getMetadataTable(metadataDataset, labelingTask), labelingTask, QueryAst.JoinType.LEFT);
        joinSqb.select(this.ebf.count("*"), stateCountCol);
        joinSqb.select(this.ebf.caseWhen(this.ebf.col(isReviewed).eq(1), LabelingTaskStats.RecordStatus.REVIEWED.name()).caseWhen(this.ebf.col(countColName).gte(labelingTask.minNbAnnotatorsPerRecord), LabelingTaskStats.RecordStatus.READY_FOR_REVIEW.name()).caseWhen(this.ebf.col(countColName).gt(0), LabelingTaskStats.RecordStatus.PARTIALLY_LABELED.name()).caseWhen(LabelingTaskStats.RecordStatus.TO_LABEL.name()), stateCol);
        joinSqb.group(this.ebf.col(stateCol));
        try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
            ResultSet rs2 = context.execute(joinSqb, this.getDialect());
            while (rs2.next()) {
                stats.globalRecordsStat.perRecordStatusCount.put(LabelingTaskStats.RecordStatus.valueOf(rs2.getString(stateCol)), rs2.getLong(stateCountCol));
            }
        }
        if (metadataTableCacheItem != null) {
            stats.globalRecordsStat.perRecordStatusCount.put(LabelingTaskStats.RecordStatus.INVALID, metadataTableCacheItem.loadResult.getInvalidRows());
        }
    }

    private SelectQueryBuilder getAnswersGroupedBy(LabelingTask labelingTask, String countColumnName, String ... groupedByCols) {
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        for (String groupedByCol : groupedByCols) {
            sqb.select(this.ebf.col(groupedByCol));
            sqb.group(this.ebf.col(groupedByCol));
        }
        sqb.select(this.ebf.count("*"), countColumnName);
        sqb.from(this.getAnswersTable());
        this.matchLabelingTask(labelingTask.projectKey, labelingTask.id, sqb);
        return sqb;
    }

    private SelectQueryBuilder createNotYetAnnotatedRecordsQuery(LabelingTask labelingTask, Dataset metadataDataset, String userId, int nRows, @Nullable String currentRecordId) throws Exception {
        SelectQueryBuilder answersSqb = new SelectQueryBuilder();
        answersSqb.select("IDENTIFIER");
        answersSqb.from(this.getAnswersTable());
        this.matchLabelingTask(labelingTask.projectKey, labelingTask.id, answersSqb);
        answersSqb.group("IDENTIFIER");
        answersSqb.having(this.ebf.or(this.ebf.count("*").gte(labelingTask.minNbAnnotatorsPerRecord), this.ebf.caseWhen(this.ebf.col("ANNOTATOR_ID").eq(userId), 1, 0).max().eq(1), this.ebf.caseWhen(this.ebf.col("STATUS").eq(LabelingAnswer.AnswerStatus.REVIEWED.name()), 1, 0).max().eq(1)));
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.getMetadataTable(metadataDataset, labelingTask));
        sqb.where(this.ebf.col(this.getIdColumnNameInDB(labelingTask)).in(this.ebf.expr(answersSqb.toSQL(this.getDialect()))).not());
        this.selectMetadataColumns(sqb, labelingTask, metadataDataset);
        if (currentRecordId != null) {
            sqb.where(this.ebf.col(this.getIdColumnNameInDB(labelingTask)).gt(currentRecordId));
        }
        sqb.order(this.getIdColumnNameInDB(labelingTask), QueryAst.OrderType.ASC);
        sqb.limit(Long.valueOf(nRows));
        return sqb;
    }

    private SelectQueryBuilder joinAnswersWithMetadataDataset(SelectQueryBuilder sqb, QueryAst.TableLike metadataTable, LabelingTask labelingTask, QueryAst.JoinType joinType) {
        SelectQueryBuilder joinSqb = new SelectQueryBuilder();
        String subQueryAlias = "__dku_joined_with_metadata_dataset";
        joinSqb.from(metadataTable);
        joinSqb.join(sqb, joinType, subQueryAlias).on(this.ebf.col(metadataTable, this.getIdColumnNameInDB(labelingTask)).nullUnsafeEq(this.ebf.col(subQueryAlias, "IDENTIFIER")));
        return joinSqb;
    }

    private void matchLabelingTask(String projectKey, String labelingTaskId, SelectQueryBuilder answersSqb) {
        answersSqb.where(this.ebf.col("PROJECT_KEY").eq(projectKey));
        answersSqb.where(this.ebf.col("LABELING_TASK_ID").eq(labelingTaskId));
    }

    private SelectQueryBuilder createAnnotatedButNotReviewedRecordsQuery(LabelingTask labelingTask, Dataset metadataDataset) {
        QueryAst.TableLike metadataTable = this.getMetadataTable(metadataDataset, labelingTask);
        String lastAnnotationTimeColName = "__DKU_INTERNAL__last_annotation_time";
        SelectQueryBuilder answersSqb = new SelectQueryBuilder();
        answersSqb.select("IDENTIFIER");
        answersSqb.select(this.ebf.col("CREATION_TIME").max(), lastAnnotationTimeColName);
        answersSqb.from(this.getAnswersTable());
        this.matchLabelingTask(labelingTask.projectKey, labelingTask.id, answersSqb);
        answersSqb.where(this.ebf.col("STATUS").eq(LabelingAnswer.AnswerStatus.PENDING_REVIEW.name()));
        answersSqb.group("IDENTIFIER");
        answersSqb.having(this.ebf.count("*").gte(labelingTask.minNbAnnotatorsPerRecord));
        SelectQueryBuilder joinSqb = this.joinAnswersWithMetadataDataset(answersSqb, metadataTable, labelingTask, QueryAst.JoinType.INNER);
        this.selectMetadataColumns(joinSqb, labelingTask, metadataDataset);
        joinSqb.order(lastAnnotationTimeColName, QueryAst.OrderType.ASC);
        return joinSqb;
    }

    private SelectQueryBuilder createListAllAnswersForLabelingTaskQuery(AuthCtx authCtx, LabelingTask labelingTask, QueryAst.TableLike answersTable, @Nullable Dataset metadataDataset) throws Exception {
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(answersTable);
        if (metadataDataset != null) {
            this.loadMetadataToInternalDbIfNeeded(authCtx, labelingTask, metadataDataset);
            QueryAst.TableLike metadataDatasetTable = this.getMetadataTable(metadataDataset, labelingTask);
            sqb.join(metadataDatasetTable, QueryAst.JoinType.INNER).on(this.ebf.col(answersTable, "IDENTIFIER").nullUnsafeEq(this.ebf.col(metadataDatasetTable, this.getIdColumnNameInDB(labelingTask))));
        }
        this.matchLabelingTask(labelingTask.projectKey, labelingTask.id, sqb);
        return sqb;
    }

    private SelectQueryBuilder createListAllAnswersForLabelingTaskQuery(AuthCtx authCtx, LabelingTask labelingTask, @Nullable Dataset metadataDataset) throws Exception {
        return this.createListAllAnswersForLabelingTaskQuery(authCtx, labelingTask, this.getAnswersTable(), metadataDataset);
    }

    private SelectQueryBuilder createListAllVerifiedAnswersForLabelingTaskQuery(AuthCtx authCtx, LabelingTask labelingTask, @Nullable Dataset metadataDataset) throws Exception {
        return this.createListAllAnswersForLabelingTaskQuery(authCtx, labelingTask, this.getVerifiedAnswersTable(), metadataDataset);
    }

    private SelectQueryBuilder createListAllAnswersForLabelingTaskQuery(AuthCtx authCtx, LabelingTask labelingTask) throws Exception {
        return this.createListAllAnswersForLabelingTaskQuery(authCtx, labelingTask, null);
    }

    private SelectQueryBuilder createListAllAnswersQuery(AuthCtx authCtx, LabelingTask labelingTask, String recordId) throws Exception {
        SelectQueryBuilder sqb = this.createListAllAnswersForLabelingTaskQuery(authCtx, labelingTask);
        sqb.where(this.ebf.col("IDENTIFIER").eq(recordId));
        return sqb;
    }

    private SelectQueryBuilder createListNotReviewedQuery(AuthCtx authCtx, LabelingTask labelingTask, String recordId) throws Exception {
        SelectQueryBuilder sqb = this.createListAllAnswersQuery(authCtx, labelingTask, recordId);
        sqb.where(this.ebf.col("STATUS").eq(LabelingAnswer.AnswerStatus.PENDING_REVIEW.name()));
        return sqb;
    }

    private SelectQueryBuilder createListVerifiedQuery(AuthCtx authCtx, LabelingTask labelingTask, String recordId) throws Exception {
        SelectQueryBuilder sqb = this.createListAllVerifiedAnswersForLabelingTaskQuery(authCtx, labelingTask, null);
        sqb.where(this.ebf.col("IDENTIFIER").eq(recordId));
        return sqb;
    }

    public List<LabelingAnswer> listAll(AuthCtx authCtx, LabelingTask labelingTask, String recordId) throws Exception {
        return this.getLabelingAnswersFromDB(this.createListAllAnswersQuery(authCtx, labelingTask, recordId));
    }

    public List<LabelingAnswer> listNotReviewed(AuthCtx authCtx, LabelingTask labelingTask, String recordId) throws Exception {
        return this.getLabelingAnswersFromDB(this.createListNotReviewedQuery(authCtx, labelingTask, recordId));
    }

    public Optional<VerifiedLabelingAnswer> getVerified(AuthCtx authCtx, LabelingTask labelingTask, String recordId) throws Exception {
        List<VerifiedLabelingAnswer> verifiedAnswers = this.getVerifiedAnswersFromDB(this.createListVerifiedQuery(authCtx, labelingTask, recordId));
        assert (verifiedAnswers.size() <= 1);
        return verifiedAnswers.size() == 1 ? Optional.of(verifiedAnswers.get(0)) : Optional.empty();
    }

    public List<LabelingAnswer> listAllNoCheckMetadata(AuthCtx authCtx, LabelingTask labelingTask) throws Exception {
        return this.getLabelingAnswersFromDB(this.createListAllAnswersForLabelingTaskQuery(authCtx, labelingTask));
    }

    public List<VerifiedLabelingAnswer> listAllVerifiedNoCheckMetadata(AuthCtx authCtx, LabelingTask labelingTask) throws Exception {
        return this.getVerifiedAnswersFromDB(this.createListAllVerifiedAnswersForLabelingTaskQuery(authCtx, labelingTask, null));
    }

    private List<LabelingAnswer> getLabelingAnswersFromDB(SelectQueryBuilder sqb) throws Exception {
        return new LabelingAnswersFetcher().getAnswersFromDB(sqb);
    }

    private List<VerifiedLabelingAnswer> getVerifiedAnswersFromDB(SelectQueryBuilder sqb) throws Exception {
        return new VerifiedAnswersFetcher().getAnswersFromDB(sqb);
    }

    private List<LabelingAnswerCRUDService.VerifiedLabelingAnswerWithOutputData> getVerifiedAnswersWithOutputDataFromDB(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        SelectQueryBuilder query = this.createListAllVerifiedAnswersForLabelingTaskQuery(authCtx, labelingTask, metadataDataset);
        return new VerifiedAnswersFetcher().getAnswersWithOutputDataFromDB(labelingTask, query, metadataDataset);
    }

    private List<LabelingAnswerCRUDService.LabelingAnswerWithOutputData> getLabelingAnswersWithOutputDataFromDB(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        SelectQueryBuilder query = this.createListAllAnswersForLabelingTaskQuery(authCtx, labelingTask, metadataDataset);
        return new LabelingAnswersFetcher().getAnswersWithOutputDataFromDB(labelingTask, query, metadataDataset);
    }

    public List<String> listAnnotatorIds(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        ArrayList<String> annotators = new ArrayList<String>();
        SelectQueryBuilder sqb = this.createAnnotatorsQuery(authCtx, labelingTask, metadataDataset);
        try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
            ResultSet rs2 = context.execute(sqb, this.getDialect());
            while (rs2.next()) {
                annotators.add(rs2.getString("ANNOTATOR_ID"));
            }
        }
        return annotators;
    }

    private SelectQueryBuilder createAnnotatorsQuery(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.select("ANNOTATOR_ID");
        sqb.selectDistinct();
        sqb.from(this.createListAllAnswersForLabelingTaskQuery(authCtx, labelingTask, metadataDataset), "labeling_task_answers");
        sqb.order("ANNOTATOR_ID");
        return sqb;
    }

    @Nullable
    public LabelingAnswer getAnnotationForPathFromAnnotator(AuthCtx authCtx, LabelingTask labelingTask, String recordId) throws Exception {
        SelectQueryBuilder sqb = this.createListAllAnswersQuery(authCtx, labelingTask, recordId);
        sqb.where(this.ebf.col("ANNOTATOR_ID").eq(authCtx.getIdentifier()));
        return new LabelingAnswersFetcher().getFirstAnswerFromDB(sqb).orElse(null);
    }

    public synchronized List<LabelingRecord> getNextRecordsToAnnotate(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset, int nRecords, @Nullable String currentRecordId) throws Exception {
        logger.info((Object)"Joining metadata and internal answer db");
        this.loadMetadataToInternalDbIfNeeded(authCtx, labelingTask, metadataDataset);
        SelectQueryBuilder query = this.createNotYetAnnotatedRecordsQuery(labelingTask, metadataDataset, authCtx.getIdentifier(), nRecords, currentRecordId);
        try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
            ResultSet rs2 = context.execute(query, this.getDialect());
            List<LabelingRecord> list = this.getLabelingRecordsFromResultSet(rs2, labelingTask, metadataDataset, nRecords);
            return list;
        }
    }

    public List<? extends LabelingAnswerCRUDService.BaseLabelingAnswerWithOutputData<? extends BaseLabelingAnswer>> listAllForLabelsDataset(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset, LabelsDatasetParams.View view) throws Exception {
        switch (view) {
            case VERIFIED_ONLY: {
                return this.getVerifiedAnswersWithOutputDataFromDB(authCtx, labelingTask, metadataDataset);
            }
            case ALL: {
                return Stream.concat(this.getVerifiedAnswersWithOutputDataFromDB(authCtx, labelingTask, metadataDataset).stream(), this.getLabelingAnswersWithOutputDataFromDB(authCtx, labelingTask, metadataDataset).stream()).collect(Collectors.toList());
            }
        }
        throw new IllegalArgumentException("Unreachable");
    }

    private long countQuery(SelectQueryBuilder sqb) throws Exception {
        long count = 0L;
        String countColumn = "__DKU_INTERNAL__count";
        SelectQueryBuilder countSqb = new SelectQueryBuilder();
        countSqb.select(this.ebf.count("*"), "__DKU_INTERNAL__count");
        countSqb.from(sqb, "query_to_count");
        try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
            ResultSet rs2 = context.execute(countSqb, this.getDialect());
            if (rs2.next()) {
                count = rs2.getLong("__DKU_INTERNAL__count");
            }
        }
        return count;
    }

    public long countAllForLabelsDataset(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset, LabelsDatasetParams.View view) throws Exception {
        switch (view) {
            case VERIFIED_ONLY: {
                return this.countQuery(this.createListAllVerifiedAnswersForLabelingTaskQuery(authCtx, labelingTask, metadataDataset));
            }
            case ALL: {
                return this.countQuery(this.createListAllVerifiedAnswersForLabelingTaskQuery(authCtx, labelingTask, metadataDataset)) + this.countQuery(this.createListAllAnswersForLabelingTaskQuery(authCtx, labelingTask, metadataDataset));
            }
        }
        throw new IllegalArgumentException("Unreachable");
    }

    long getLastUpdate(SelectQueryBuilder sqb) throws Exception {
        SelectQueryBuilder lastUpdatedSqb = new SelectQueryBuilder();
        lastUpdatedSqb.select("LAST_UPDATE_TIME");
        lastUpdatedSqb.from(sqb, "answers");
        lastUpdatedSqb.order("LAST_UPDATE_TIME", QueryAst.OrderType.DESC);
        lastUpdatedSqb.limit(1L);
        try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
            ResultSet rs2 = context.execute(lastUpdatedSqb, this.getDialect());
            if (rs2.next()) {
                long l = rs2.getLong("LAST_UPDATE_TIME");
                return l;
            }
        }
        return 0L;
    }

    public long getLastUpdateForLabelsDataset(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset, LabelsDatasetParams.View view) throws Exception {
        switch (view) {
            case VERIFIED_ONLY: {
                return this.getLastUpdate(this.createListAllVerifiedAnswersForLabelingTaskQuery(authCtx, labelingTask, metadataDataset));
            }
            case ALL: {
                return Math.max(this.getLastUpdate(this.createListAllVerifiedAnswersForLabelingTaskQuery(authCtx, labelingTask, metadataDataset)), this.getLastUpdate(this.createListAllAnswersForLabelingTaskQuery(authCtx, labelingTask, metadataDataset)));
            }
        }
        throw new IllegalArgumentException("Unreachable");
    }

    public synchronized void loadMetadataToInternalDbIfNeeded(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        labelingTask.checkMinimalPreconditions();
        switch (ClusterSelector.getContext()) {
            case BACKEND: {
                this._backendOnlyLoadMetadataToInternalDbIfNeeded(authCtx, labelingTask, metadataDataset);
                return;
            }
            case FEK: {
                int backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
                try (LocalPrivilegedIntercomAPIClient apiClient = new LocalPrivilegedIntercomAPIClient(backendPort);){
                    apiClient.postFormToJSON("/dip/api/pintercom/labeling/load-metadata-if-needed", Void.class, new Object[]{"projectKey", labelingTask.projectKey, "labelingTaskId", labelingTask.id, "authCtxIdentifier", authCtx.getIdentifier()});
                }
                return;
            }
            case JEK: {
                APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();
                     TicketBasedIntercomAPIClient apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());){
                    apiClient.postFormToJSON("/dip/api/tintercom/labeling/load-metadata-if-needed", Void.class, new Object[]{"projectKey", labelingTask.projectKey, "labelingTaskId", labelingTask.id});
                }
                return;
            }
            case CDE: {
                throw new UnsupportedOperationException("Cannot handle labeling tasks from containerized jobs");
            }
        }
        throw new IllegalArgumentException("Cannot call this function from process: " + String.valueOf(ClusterSelector.getContext()));
    }

    public synchronized void invalidateMetadataTableCache(LabelingTask labelingTask, Dataset metadataDataset) {
        logger.info((Object)("Invalidate table cache for Labeling task: id=" + labelingTask.id + ", projectKey=" + labelingTask.projectKey));
        this.metadataDatasetsLoadStatuses.remove(this.getMetadataTableUniqueId(metadataDataset, labelingTask));
    }

    private synchronized void _backendOnlyLoadMetadataToInternalDbIfNeeded(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        String metadataDatasetTableId = this.getMetadataTableUniqueId(metadataDataset, labelingTask);
        if (!metadataDataset.isManaged()) {
            if (this.metadataDatasetsLoadStatuses.containsKey(metadataDatasetTableId)) {
                logger.info((Object)"Metadata dataset not-managed and table already cached, not reloading it into internal DB");
            } else {
                MetadataDatasetLoadResult loadResult = this.loadMetadataToInternalDb(authCtx, labelingTask, metadataDataset);
                this.metadataDatasetsLoadStatuses.put(metadataDatasetTableId, new MetadataDatasetLoadStatus(-1L, loadResult));
            }
        } else {
            boolean needsLoading;
            long lastBuildDate;
            ReadOnlyJobsInternalDB.DatasetBuild build = this.jobsDBService.getLatestBuildForDataset(metadataDataset.getProjectKey(), metadataDataset.getName());
            long l = lastBuildDate = build == null ? 0L : build.buildEndTime;
            if (this.metadataDatasetsLoadStatuses.containsKey(metadataDatasetTableId)) {
                Long cachedModificationDate = this.metadataDatasetsLoadStatuses.get((Object)metadataDatasetTableId).modificationDate;
                if (lastBuildDate > cachedModificationDate) {
                    logger.info((Object)"MetadataDataset has been rebuilt, reloading it into internal DB");
                    needsLoading = true;
                } else {
                    logger.info((Object)"MetadataDataset already loaded in internal DB, not reloading it");
                    needsLoading = false;
                }
            } else {
                logger.info((Object)"MetadataDataset not loaded into internal DB, loading it");
                needsLoading = true;
            }
            if (needsLoading) {
                this.metadataDatasetsLoadStatuses.remove(metadataDatasetTableId);
                MetadataDatasetLoadResult loadResult = this.loadMetadataToInternalDb(authCtx, labelingTask, metadataDataset);
                this.metadataDatasetsLoadStatuses.put(metadataDatasetTableId, new MetadataDatasetLoadStatus(lastBuildDate, loadResult));
            }
        }
    }

    public synchronized MetadataDatasetLoadStatus getMetadataDatasetLoadStatus(LabelingTask labelingTask, Dataset metadataDataset) {
        return this.metadataDatasetsLoadStatuses.get(this.getMetadataTableUniqueId(metadataDataset, labelingTask));
    }

    private synchronized MetadataDatasetLoadResult loadMetadataToInternalDb(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        long beforeLoading = System.currentTimeMillis();
        SQLUtils.SQLTable table = this.getMetadataSQLTable(metadataDataset, labelingTask);
        logger.info((Object)("Loading metadata dataset into internal db for Labeling task: id=" + labelingTask.id + ", projectKey=" + labelingTask.projectKey + " with name: '" + table.getTable() + "'"));
        InternalMetadataRecordProcessor internalMetadataRecordProcessor = new InternalMetadataRecordProcessor(labelingTask);
        if (this.internalDBConnectionsService.isUsingInternalH2()) {
            logger.info((Object)"Loading metadata to h2 internal db");
            this.loadMetadataToH2(authCtx, labelingTask, metadataDataset, this.metadataColumnsToLoad(labelingTask, metadataDataset), internalMetadataRecordProcessor);
        } else {
            logger.info((Object)"Loading metadata to postgres internal db");
            this.loadMetadataToPostgres(authCtx, labelingTask, metadataDataset, this.metadataColumnsToLoad(labelingTask, metadataDataset), internalMetadataRecordProcessor);
        }
        logger.info((Object)("Done loading metadata: " + (System.currentTimeMillis() - beforeLoading) + "ms"));
        this.createIndexOnMetadata(labelingTask, metadataDataset);
        return internalMetadataRecordProcessor.getLoadResult();
    }

    private QueryAst.TableLike getAnswersTable() {
        return SelectQueryBuilder.table(this.resolveTable("LABELING_ANSWERS"), "LABELING_ANSWERS");
    }

    private QueryAst.TableLike getVerifiedAnswersTable() {
        return SelectQueryBuilder.table(this.resolveTable("VERIFIED_LABELING_ANSWERS"), "VERIFIED_LABELING_ANSWERS");
    }

    static String makeTableNameAcceptable(String baseTableName, int maxSize) {
        if (maxSize <= 0 || baseTableName.length() <= maxSize) {
            return baseTableName;
        }
        String baseNameHashSuffix = "__" + DigestUtils.md5Hex((String)baseTableName).substring(0, 8).toUpperCase();
        if (maxSize < baseNameHashSuffix.length()) {
            throw new IllegalArgumentException("Base table name is too long");
        }
        return baseTableName.substring(0, maxSize - baseNameHashSuffix.length()) + baseNameHashSuffix;
    }

    private String getMetadataTableUniqueId(Dataset metadataDataset, LabelingTask labelingTask) {
        return metadataDataset.getProjectKey() + "_" + labelingTask.id + "_METADATA";
    }

    private SQLUtils.SQLTable getMetadataSQLTable(Dataset metadataDataset, LabelingTask labelingTask) {
        SQLUtils.SQLTable table = this.resolveTable(this.getMetadataTableUniqueId(metadataDataset, labelingTask));
        String acceptableTableName = LabelingInternalDBService.makeTableNameAcceptable(table.getTable(), this.getDialect().getIdentifiersMaxLength());
        return new SQLUtils.SQLTable(table.getCatalog(), table.getSchemaNullIfBlank(), acceptableTableName, table.isTrueTable());
    }

    private QueryAst.TableLike getMetadataTable(Dataset metadataDataset, LabelingTask labelingTask) {
        SQLUtils.SQLTable sqlTable = this.getMetadataSQLTable(metadataDataset, labelingTask);
        return SelectQueryBuilder.table(sqlTable, sqlTable.getTable());
    }

    private void loadMetadataToPostgres(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset, List<String> columnsToLoad, InternalMetadataRecordProcessor internalMetadataRecordProcessor) throws Exception {
        StreamColumnFactory cf = new StreamColumnFactory();
        Dataset fakeDataset = this.createFakePostgreSQLDataset(metadataDataset, labelingTask, columnsToLoad, internalMetadataRecordProcessor);
        try (DSSDBConnection ac = this.acquireConnection();){
            AbstractSQLTableDatasetHandler handler = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(authCtx, fakeDataset);
            handler.forceDSSConnection(ac.getConn().getConnectionData().getConnection());
            Output output = handler.buildOutput(Partition.newNP(), 0, 1, new WarningsContext());
            OutputWriter outputWriter = output.getWriter(Output.WriteMode.OVERWRITE);
            try {
                outputWriter.init((ColumnFactory)cf);
                internalMetadataRecordProcessor.withColumnFactory((ColumnFactory)cf);
                internalMetadataRecordProcessor.setDownstream((ProcessorOutput)outputWriter);
                UniversalSingleThreadPusher pusher = new UniversalSingleThreadPusher(authCtx, metadataDataset, (ProcessorOutput)internalMetadataRecordProcessor, (ColumnFactory)cf, (RowFactory)new StreamRowFactory());
                pusher.setDatasetSelection(StreamableDatasetSelection.full());
                pusher.push();
                outputWriter.lastRowEmitted();
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to load metadata in postgresql DB", e);
                outputWriter.cancel();
                throw e;
            }
        }
    }

    private void loadMetadataToH2(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset, List<String> columnsToLoad, InternalMetadataRecordProcessor internalMetadataRecordProcessor) throws Exception {
        try (DSSDBConnection ac = this.acquireConnection();){
            SQLConnectionProvider.SQLConnectionWrapper conn = ac.getConn();
            AutoDelete intermediateFilesFolder = FlowJobUtils.getTmpFolder("internal-to-sql", SecretKeyGenerator.generate((int)8));
            DatasetToH2ConnectionLoader internalDBLoader = new DatasetToH2ConnectionLoader(authCtx, new WarningsContext(), labelingTask.projectKey, conn, new H2SQLDialect(), (File)intermediateFilesFolder);
            internalDBLoader.loadInDB(metadataDataset, StreamableDatasetSelection.full(), this.getMetadataSQLTable(metadataDataset, labelingTask).getTable(), columnsToLoad, internalMetadataRecordProcessor);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to load metadata in H2 DB", e);
            throw e;
        }
    }

    private void createIndexOnMetadata(LabelingTask labelingTask, Dataset metadataDataset) throws Exception {
        SQLUtils.SQLTable metadataTable = this.getMetadataSQLTable(metadataDataset, labelingTask);
        SQLDialect dialect = this.getDialect();
        long beforeIndexing = System.currentTimeMillis();
        try (DSSDBConnection ac = this.acquireConnection();){
            StringBuilder sqlStringBuilder = new StringBuilder();
            sqlStringBuilder.append("CREATE INDEX ON ");
            sqlStringBuilder.append(dialect.getQuotedTableFullName(metadataTable));
            sqlStringBuilder.append(" (");
            sqlStringBuilder.append(dialect.quoteIdentifier(this.getIdColumnNameInDB(labelingTask)));
            sqlStringBuilder.append(" ASC");
            if (dialect.supportsNullsOrdering()) {
                sqlStringBuilder.append(" NULLS FIRST");
            }
            sqlStringBuilder.append(")");
            String sql = sqlStringBuilder.toString();
            logger.info((Object)("  Executing SQL: " + sql));
            try (Statement st2 = ac.createStatement();){
                st2.execute(sql);
            }
            ac.commit();
        }
        logger.info((Object)("Done creating index for " + metadataTable.getTable() + ": " + (System.currentTimeMillis() - beforeIndexing) + "ms"));
    }

    private String getIdColumnNameInDB(LabelingTask task) {
        if (this.needGeneratedIDColumn(task)) {
            return DKU_GENERATED_ID_COLUMN_NAME;
        }
        return task.idColumn;
    }

    private boolean needGeneratedIDColumn(LabelingTask task) {
        return task.idColumn == null;
    }

    private Dataset createFakePostgreSQLDataset(Dataset metadataDataset, LabelingTask labelingTask, List<String> columnsToLoad, InternalMetadataRecordProcessor internalMetadataRecordProcessor) throws IOException, DKUSecurityException {
        Dataset fakeDataset = new Dataset();
        fakeDataset.setFullName(metadataDataset.getFullName() + "_" + labelingTask.id);
        Schema schema = metadataDataset.getSchema().filter(columnsToLoad);
        this.downcastUnsupportedTypes(schema);
        if (internalMetadataRecordProcessor != null) {
            for (SchemaColumn column : internalMetadataRecordProcessor.addedColumns()) {
                schema.addColumn(column);
            }
        }
        String idColumnInDB = this.getIdColumnNameInDB(labelingTask);
        schema.updateColumn(idColumnInDB, new SchemaColumn(idColumnInDB, Type.STRING));
        fakeDataset.setSchema(schema);
        fakeDataset.setType("PostgreSQL");
        PostgreSQLDialect.PostgreSQLDatasetConfig fakeConfig = new PostgreSQLDialect.PostgreSQLDatasetConfig();
        fakeConfig.mode = "table";
        SQLUtils.SQLTable metadataTable = this.getMetadataSQLTable(metadataDataset, labelingTask);
        fakeConfig.schema = metadataTable.getSchemaNullIfBlank();
        fakeConfig.table = metadataTable.getTable();
        fakeConfig.catalog = metadataTable.getCatalog();
        fakeDataset.setParams(fakeConfig);
        SchemaUtils.fixupExistingStringColumnsMaxLengths(schema, new PostgreSQLDialect());
        return fakeDataset;
    }

    private void downcastUnsupportedTypes(Schema schema) {
        schema.getColumns().forEach(column -> column.setType(DatasetToH2ConnectionLoader.downcastToSupportedTypeIfRequired(column.getType())));
    }

    private LabelingAnswer.AnswerStatus readStatusFromResultSet(ResultSet rs2) throws SQLException {
        String status = rs2.getString("STATUS");
        try {
            return LabelingAnswer.AnswerStatus.valueOf(status);
        }
        catch (IllegalArgumentException e) {
            throw ErrorContext.iaef((String)"Unknown status: %s'", (Object)status, (Object[])new Object[0]);
        }
    }

    public List<LabelingRecord> getRecords(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset, List<String> recordIds) throws Exception {
        this.loadMetadataToInternalDbIfNeeded(authCtx, labelingTask, metadataDataset);
        SelectQueryBuilder query = new SelectQueryBuilder();
        query.from(this.getMetadataTable(metadataDataset, labelingTask));
        query.where(this.ebf.col(this.getIdColumnNameInDB(labelingTask)).inList(recordIds));
        HashMap<String, LabelingRecord> records = new HashMap<String, LabelingRecord>();
        try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
            ResultSet rs2 = context.execute(query, this.getDialect());
            for (LabelingRecord record : this.getLabelingRecordsFromResultSet(rs2, labelingTask, metadataDataset)) {
                records.put(record.id, record);
            }
        }
        return recordIds.stream().map(records::get).collect(Collectors.toList());
    }

    @Nullable
    public LabelingRecord getRecord(AuthCtx authCtx, LabelingTask labelingTask, Dataset metadataDataset, String recordId) throws Exception {
        this.loadMetadataToInternalDbIfNeeded(authCtx, labelingTask, metadataDataset);
        SelectQueryBuilder query = new SelectQueryBuilder();
        query.from(this.getMetadataTable(metadataDataset, labelingTask));
        query.where(this.ebf.col(this.getIdColumnNameInDB(labelingTask)).eq(recordId));
        try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
            ResultSet rs2 = context.execute(query, this.getDialect());
            List<LabelingRecord> recordsFromRs = this.getLabelingRecordsFromResultSet(rs2, labelingTask, metadataDataset);
            if (!recordsFromRs.isEmpty()) {
                LabelingRecord labelingRecord = recordsFromRs.get(0);
                return labelingRecord;
            }
        }
        return null;
    }

    private List<LabelingRecord> getLabelingRecordsFromResultSet(ResultSet rs2, LabelingTask labelingTask, Dataset metadataDataset, int nRecords) throws SQLException {
        ArrayList<LabelingRecord> records = new ArrayList<LabelingRecord>();
        List<ExtraColumnInfo> extraColumnInfoList = this.buildExtraColumnInfoList(rs2, labelingTask, metadataDataset);
        while (rs2.next() && (records.size() < nRecords || nRecords == -1)) {
            records.add(this.labelingRecordFromResultSet(rs2, extraColumnInfoList, labelingTask));
        }
        return records;
    }

    private List<LabelingRecord> getLabelingRecordsFromResultSet(ResultSet rs2, LabelingTask task, Dataset metadataDataset) throws SQLException {
        return this.getLabelingRecordsFromResultSet(rs2, task, metadataDataset, -1);
    }

    private List<ExtraColumnInfo> buildExtraColumnInfoList(ResultSet rs2, LabelingTask task, Dataset metadataDataset) throws SQLException {
        ArrayList<ExtraColumnInfo> extraColumnInfoList = new ArrayList<ExtraColumnInfo>();
        Schema metadataDatasetSchema = metadataDataset.getSchema().getCopy();
        this.downcastUnsupportedTypes(metadataDatasetSchema);
        ResultSetMetaData rsmd = rs2.getMetaData();
        HashMap columnIndices = Maps.newHashMap();
        for (int i = 1; i <= rs2.getMetaData().getColumnCount(); ++i) {
            columnIndices.put(rsmd.getColumnName(i), i);
        }
        for (String extraColumnName : task.extraColumns) {
            SchemaColumn schemaColumn = metadataDatasetSchema.getColumn(extraColumnName);
            if (schemaColumn == null) {
                logger.info((Object)("Context column '" + extraColumnName + "' for task id=" + task.id + " cannot be found in metadata dataset, ignoring it"));
                continue;
            }
            int columnIndex = (Integer)columnIndices.get(extraColumnName);
            extraColumnInfoList.add(new ExtraColumnInfo(columnIndex, schemaColumn.timestampNoTzAsDate && !metadataDataset.isManaged(), rsmd.getColumnType(columnIndex), schemaColumn));
        }
        return extraColumnInfoList;
    }

    private Label<?> newLabel(LabelingTask.LabelingTaskType type) {
        switch (type) {
            case NAMED_ENTITY_EXTRACTION: {
                return new Label.NamedEntityExtractionLabel();
            }
            case IMAGE_CLASSIFICATION: 
            case RECORD_CLASSIFICATION: 
            case TEXT_CLASSIFICATION: {
                return new Label.ClassificationLabel();
            }
            case OBJECT_DETECTION: {
                return new Label.ObjectDetectionLabel();
            }
            case RECORD_FREETEXT: {
                return new Label.FreeTextLabel();
            }
        }
        throw new IllegalStateException("Unexpected LabelingTask type: " + String.valueOf((Object)type));
    }

    private LabelingRecord labelingRecordFromResultSet(ResultSet rs2, List<ExtraColumnInfo> extraColumnInfoList, LabelingTask task) throws SQLException {
        LabelingRecord record = task.type == LabelingTask.LabelingTaskType.NAMED_ENTITY_EXTRACTION ? new TokenizedTextLabelingRecord(rs2.getString(this.getIdColumnNameInDB(task)), rs2.getString(((TextLabelingTask)task).dataColumn)) : (task.type == LabelingTask.LabelingTaskType.TEXT_CLASSIFICATION ? new TextLabelingRecord(rs2.getString(this.getIdColumnNameInDB(task)), rs2.getString(((TextLabelingTask)task).dataColumn)) : new LabelingRecord(rs2.getString(this.getIdColumnNameInDB(task))));
        SQLDialect dialect = this.getDialect();
        for (ExtraColumnInfo columnInfo : extraColumnInfoList) {
            String extraColumnValue = dialect.getValueAsDSSString(rs2, columnInfo.columnType, columnInfo.index, columnInfo.schemaColumn, true, columnInfo.timestampNoTzAsDate, DateTimeZone.getDefault());
            record.extraColumns.put(columnInfo.schemaColumn.getName(), extraColumnValue);
        }
        if (task.preLabelColumn != null) {
            record.preLabel = this.getPreLabelOrNullFromResultSet(rs2, task.preLabelColumn).orElse(null);
            record.invalidPreLabel = rs2.getBoolean(DKU_INVALID_PRELABEL_COLUMN_NAME);
        }
        return record;
    }

    private Optional<Label<?>> getPreLabelOrNullFromResultSet(ResultSet rs2, String preLabelColumn) throws SQLException {
        String preLabelString = rs2.getString(preLabelColumn);
        if (!Strings.isNullOrEmpty((String)preLabelString)) {
            return Optional.of((Label)JSON.parse((String)preLabelString, Label.class));
        }
        return Optional.empty();
    }

    private void selectMetadataColumns(SelectQueryBuilder sqb, LabelingTask task, Dataset metadataDataset) {
        List<String> columns = this.metadataColumnsToLoad(task, metadataDataset);
        for (String column : columns) {
            sqb.select(column);
        }
        String column = this.getIdColumnNameInDB(task);
        if (!columns.contains(column)) {
            sqb.select(column);
        }
        if (task.preLabelColumn != null) {
            sqb.select(DKU_INVALID_PRELABEL_COLUMN_NAME);
        }
    }

    private List<String> metadataColumnsToLoad(LabelingTask labelingTask, Dataset metadataDataset) {
        HashSet<String> columns = new HashSet<String>();
        if (labelingTask.idColumn != null) {
            columns.add(labelingTask.idColumn);
        }
        if (labelingTask.dataColumn() != null) {
            columns.add(labelingTask.dataColumn());
        }
        if (labelingTask.preLabelColumn != null) {
            columns.add(labelingTask.preLabelColumn);
        }
        Schema metadataDatasetSchema = metadataDataset.getSchema();
        for (String column : labelingTask.extraColumns) {
            if (!metadataDatasetSchema.hasColumn(column)) {
                logger.info((Object)("Metadata dataset for labeling task id=" + labelingTask.id + " does not have column '" + column + "' in its schema, not loading it"));
                continue;
            }
            columns.add(column);
        }
        return new ArrayList<String>(columns);
    }

    private static class LabelingAnswerTable
    extends BaseAnswerTable {
        static final String NAME = "LABELING_ANSWERS";
        static final String ANNOTATOR_ID = "ANNOTATOR_ID";
        static final String STATUS = "STATUS";
        static final String REVIEW_TIME = "REVIEW_TIME";
        static final String VERIFIED_LABEL = "VERIFIED_LABEL";
        static final SchemaColumn[] TABLE_COLUMNS = (SchemaColumn[])ArrayUtils.addAll((Object[])COMMON_TABLE_COLUMNS, (Object[])new SchemaColumn[]{new SchemaColumn("ANNOTATOR_ID", Type.STRING), new SchemaColumn("STATUS", Type.STRING), new SchemaColumn("REVIEW_TIME", Type.BIGINT), new SchemaColumn("VERIFIED_LABEL", Type.STRING)});
        static final String[] KEY_COLUMNS = new String[]{"PROJECT_KEY", "LABELING_TASK_ID", "IDENTIFIER", "ANNOTATOR_ID"};

        private LabelingAnswerTable() {
        }
    }

    private static class VerifiedLabelingAnswerTable
    extends BaseAnswerTable {
        static final String NAME = "VERIFIED_LABELING_ANSWERS";
        static final SchemaColumn[] TABLE_COLUMNS = COMMON_TABLE_COLUMNS;
        static final String[] KEY_COLUMNS = new String[]{"PROJECT_KEY", "LABELING_TASK_ID", "IDENTIFIER"};

        private VerifiedLabelingAnswerTable() {
        }
    }

    private class LabelingAnswersFetcher
    extends AbstractAnswersFetcher<LabelingAnswer, LabelingAnswerCRUDService.LabelingAnswerWithOutputData> {
        private LabelingAnswersFetcher() {
            super(LabelingInternalDBService.this.getAnswersTable());
        }

        @Override
        protected LabelingAnswer newAnswerFromResultSet(ResultSet rs2) throws SQLException {
            LabelingAnswer res = new LabelingAnswer();
            this.fillBaseAnswerFromResultSet(res, rs2);
            res.annotatorId = rs2.getString("ANNOTATOR_ID");
            res.reviewTime = rs2.getLong("REVIEW_TIME");
            res.status = LabelingInternalDBService.this.readStatusFromResultSet(rs2);
            String verifiedLabelStr = rs2.getString("VERIFIED_LABEL");
            res.verifiedLabel = verifiedLabelStr != null ? (VerifiedLabel)JSON.parse((String)verifiedLabelStr, VerifiedLabel.class) : null;
            return res;
        }

        @Override
        protected LabelingAnswerCRUDService.LabelingAnswerWithOutputData newAnswerWithOutputData() {
            return new LabelingAnswerCRUDService.LabelingAnswerWithOutputData();
        }
    }

    private static class MetadataDatasetLoadStatus {
        final long modificationDate;
        final MetadataDatasetLoadResult loadResult;

        private MetadataDatasetLoadStatus(long modificationDate, MetadataDatasetLoadResult loadResult) {
            this.modificationDate = modificationDate;
            this.loadResult = loadResult;
        }
    }

    private static class MetadataDatasetLoadResult {
        long totalRows = 0L;
        long filteredRows = 0L;
        long invalidPrelabels = 0L;
        Exception firstPrelabelError;

        private MetadataDatasetLoadResult() {
        }

        long getInvalidRows() {
            return this.totalRows - this.filteredRows;
        }
    }

    private class SingleStatementQueryExecutionContext
    implements AutoCloseable {
        private PreparedStatement st;
        private final DSSDBConnection connection;

        public SingleStatementQueryExecutionContext() throws SQLException {
            this.connection = LabelingInternalDBService.this.acquireConnection();
        }

        public ResultSet execute(SelectQueryBuilder sqb, SQLDialect dialect) throws SQLException {
            return this.execute(sqb.toSQL(dialect));
        }

        public ResultSet execute(String sql) throws SQLException {
            this.st = this.connection.prepareNonPersistedStatement(sql);
            logger.debug((Object)("Execute SQL: " + String.valueOf(this.st)));
            this.st.execute();
            return this.st.getResultSet();
        }

        @Override
        public void close() throws Exception {
            try {
                if (this.st != null) {
                    logger.debug((Object)("Done executing : " + String.valueOf(this.st)));
                    this.st.close();
                } else {
                    logger.warn((Object)"Execution context closed before execution was done");
                }
            }
            finally {
                this.connection.close();
            }
        }
    }

    private static class BaseAnswerTable {
        static final String PROJECT_KEY = "PROJECT_KEY";
        static final String LABELING_TASK_ID = "LABELING_TASK_ID";
        static final String RECORD_ID = "IDENTIFIER";
        static final String CREATION_TIME = "CREATION_TIME";
        static final String LAST_UPDATE_TIME = "LAST_UPDATE_TIME";
        static final String LABEL = "LABEL";
        static final String REVIEWER_ID = "REVIEWER_ID";
        static final SchemaColumn[] COMMON_TABLE_COLUMNS = new SchemaColumn[]{new SchemaColumn("PROJECT_KEY", Type.STRING), new SchemaColumn("LABELING_TASK_ID", Type.STRING), new SchemaColumn("IDENTIFIER", Type.STRING), new SchemaColumn("CREATION_TIME", Type.BIGINT), new SchemaColumn("LAST_UPDATE_TIME", Type.BIGINT), new SchemaColumn("LABEL", Type.STRING), new SchemaColumn("REVIEWER_ID", Type.STRING)};

        private BaseAnswerTable() {
        }
    }

    private class LabelingAnswersSaver
    extends AnswersSaver<LabelingAnswer> {
        public LabelingAnswersSaver(DSSDBConnection connection) throws SQLException {
            super(connection);
        }

        @Override
        UpsertQueryBuilder getUpsertQueryBuilder() {
            UpsertQueryBuilder uqb = UpsertQueryBuilder.into(LabelingInternalDBService.this.resolveTable("LABELING_ANSWERS"));
            uqb.addColumns(LabelingAnswerTable.TABLE_COLUMNS);
            uqb.addKeyColumns(LabelingAnswerTable.KEY_COLUMNS);
            return uqb;
        }

        @Override
        void setValuesOnPrepareStatement(PreparedStatement ps2, LabelingAnswer answer) throws SQLException {
            super.setValuesOnPrepareStatement(ps2, answer);
            ps2.setString(8, answer.annotatorId);
            ps2.setString(9, answer.status.name());
            if (answer.reviewTime != null) {
                ps2.setLong(10, answer.reviewTime);
            } else {
                ps2.setNull(10, -5);
            }
            if (answer.verifiedLabel != null) {
                ps2.setString(11, JSON.json((Object)answer.verifiedLabel));
            } else {
                ps2.setNull(11, 12);
            }
        }
    }

    private class VerifiedLabelingAnswersSaver
    extends AnswersSaver<VerifiedLabelingAnswer> {
        public VerifiedLabelingAnswersSaver(DSSDBConnection connection) throws SQLException {
            super(connection);
        }

        @Override
        UpsertQueryBuilder getUpsertQueryBuilder() {
            UpsertQueryBuilder uqb = UpsertQueryBuilder.into(LabelingInternalDBService.this.resolveTable("VERIFIED_LABELING_ANSWERS"));
            uqb.addColumns(VerifiedLabelingAnswerTable.TABLE_COLUMNS);
            uqb.addKeyColumns(VerifiedLabelingAnswerTable.KEY_COLUMNS);
            return uqb;
        }
    }

    private class VerifiedAnswersFetcher
    extends AbstractAnswersFetcher<VerifiedLabelingAnswer, LabelingAnswerCRUDService.VerifiedLabelingAnswerWithOutputData> {
        private VerifiedAnswersFetcher() {
            super(LabelingInternalDBService.this.getVerifiedAnswersTable());
        }

        @Override
        protected VerifiedLabelingAnswer newAnswerFromResultSet(ResultSet rs2) throws SQLException {
            VerifiedLabelingAnswer res = new VerifiedLabelingAnswer();
            this.fillBaseAnswerFromResultSet(res, rs2);
            return res;
        }

        @Override
        protected LabelingAnswerCRUDService.VerifiedLabelingAnswerWithOutputData newAnswerWithOutputData() {
            return new LabelingAnswerCRUDService.VerifiedLabelingAnswerWithOutputData();
        }
    }

    public class InternalMetadataRecordProcessor
    extends ColumnAdderFilteringProcessorOutput {
        private final LabelingTask labelingTask;
        private final boolean needsGeneratedId;
        private Column idColumn;
        @Nullable
        private Column dataColumn;
        @Nullable
        private Column preLabelColumn;
        @Nullable
        private Column generatedIdColumn;
        @Nullable
        private Column invalidPreLabelColumn;
        private final MetadataDatasetLoadResult result = new MetadataDatasetLoadResult();
        private static final int MAX_CHARACTERS = 30;

        public InternalMetadataRecordProcessor(LabelingTask labelingTask) {
            this.labelingTask = labelingTask;
            this.needsGeneratedId = LabelingInternalDBService.this.needGeneratedIDColumn(labelingTask);
        }

        private boolean isValidRecord(Row row) {
            if (!this.needsGeneratedId && Strings.isNullOrEmpty((String)row.get(this.idColumn))) {
                return false;
            }
            return this.dataColumn == null || !Strings.isNullOrEmpty((String)row.get(this.dataColumn));
        }

        private boolean adaptPreLabel(Row row) {
            String rawPreLabel = row.get(this.preLabelColumn);
            if (Strings.isNullOrEmpty((String)rawPreLabel)) {
                row.put(this.preLabelColumn, null);
                return true;
            }
            try {
                Label<?> preLabel = LabelingInternalDBService.this.newLabel(this.labelingTask.type);
                preLabel.setAnnotations(rawPreLabel);
                row.put(this.preLabelColumn, JSON.json(preLabel));
                return true;
            }
            catch (Exception e) {
                ++this.result.invalidPrelabels;
                if (this.result.firstPrelabelError == null) {
                    String errorMessage = e.getMessage() + " (record id: " + this.getRecordIdentifier(row) + ")";
                    this.result.firstPrelabelError = new IllegalArgumentException(errorMessage, e);
                    logger.warn((Object)errorMessage, (Throwable)e);
                }
                row.put(this.preLabelColumn, null);
                return false;
            }
        }

        public void emitRow(Row row) throws Exception {
            ++this.result.totalRows;
            if (this.isValidRecord(row)) {
                if (this.preLabelColumn != null) {
                    boolean successfulImport = this.adaptPreLabel(row);
                    row.put(this.invalidPreLabelColumn, !successfulImport);
                }
                if (this.needsGeneratedId) {
                    this.addGeneratedId(row);
                }
                ++this.result.filteredRows;
                this.downstream.emitRow(row);
            }
        }

        private void addGeneratedId(Row row) {
            String text = row.get(this.dataColumn);
            if (text != null) {
                row.put(this.generatedIdColumn, DigestUtils.md5Hex((String)text));
            }
        }

        private String getRecordIdentifier(Row row) {
            if (!this.needsGeneratedId) {
                return row.get(this.idColumn);
            }
            String text = row.get(this.dataColumn);
            return StringUtils.abbreviate((String)text, (int)30);
        }

        @Override
        public void withColumnFactory(ColumnFactory cf) {
            this.idColumn = cf.column(LabelingInternalDBService.this.getIdColumnNameInDB(this.labelingTask));
            this.dataColumn = Optional.ofNullable(this.labelingTask.dataColumn()).map(arg_0 -> ((ColumnFactory)cf).column(arg_0)).orElse(null);
            this.preLabelColumn = Optional.ofNullable(this.labelingTask.preLabelColumn).map(arg_0 -> ((ColumnFactory)cf).column(arg_0)).orElse(null);
            Column column = this.invalidPreLabelColumn = this.preLabelColumn != null ? cf.column(LabelingInternalDBService.DKU_INVALID_PRELABEL_COLUMN_NAME) : null;
            if (this.needsGeneratedId) {
                this.generatedIdColumn = cf.column(LabelingInternalDBService.DKU_GENERATED_ID_COLUMN_NAME);
            }
        }

        @Override
        public List<SchemaColumn> addedColumns() {
            ArrayList<SchemaColumn> addedColumns = new ArrayList<SchemaColumn>();
            if (this.needsGeneratedId) {
                addedColumns.add(new SchemaColumn(LabelingInternalDBService.DKU_GENERATED_ID_COLUMN_NAME, Type.STRING));
            }
            if (this.labelingTask.preLabelColumn != null) {
                addedColumns.add(new SchemaColumn(LabelingInternalDBService.DKU_INVALID_PRELABEL_COLUMN_NAME, Type.BOOLEAN));
            }
            return addedColumns;
        }

        public MetadataDatasetLoadResult getLoadResult() {
            return this.result;
        }
    }

    private static class ExtraColumnInfo {
        final int index;
        final boolean timestampNoTzAsDate;
        final int columnType;
        final SchemaColumn schemaColumn;

        private ExtraColumnInfo(int index, boolean timestampNoTzAsDate, int columnType, SchemaColumn schemaColumn) {
            this.index = index;
            this.timestampNoTzAsDate = timestampNoTzAsDate;
            this.columnType = columnType;
            this.schemaColumn = schemaColumn;
        }
    }

    private abstract class AbstractAnswersFetcher<A extends BaseLabelingAnswer, T extends LabelingAnswerCRUDService.BaseLabelingAnswerWithOutputData<A>> {
        private static final String PRELABEL_COLUMN_ALIAS = "__DKU_PRELABEL__";
        private static final String DATA_COLUMN_ALIAS = "__DKU_DATA__";
        private final QueryAst.TableLike answersTable;

        private AbstractAnswersFetcher(QueryAst.TableLike answersTable) {
            this.answersTable = answersTable;
        }

        public List<A> getAnswersFromDB(SelectQueryBuilder sqb) throws Exception {
            ArrayList answers = new ArrayList();
            this.consumeAnswersFromDB(sqb, answers::add);
            return answers;
        }

        public void consumeAnswersFromDB(SelectQueryBuilder sqb, Consumer<A> consumer) throws Exception {
            try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
                ResultSet rs2 = context.execute(sqb, LabelingInternalDBService.this.getDialect());
                while (rs2.next()) {
                    A answer = this.newAnswerFromResultSet(rs2);
                    consumer.accept(answer);
                }
            }
        }

        public Optional<A> getFirstAnswerFromDB(SelectQueryBuilder sqb) throws Exception {
            try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
                ResultSet rs2 = context.execute(sqb, LabelingInternalDBService.this.getDialect());
                if (rs2.next()) {
                    Optional<A> optional = Optional.of(this.newAnswerFromResultSet(rs2));
                    return optional;
                }
                Optional optional = Optional.empty();
                return optional;
            }
        }

        public List<T> getAnswersWithOutputDataFromDB(LabelingTask labelingTask, SelectQueryBuilder sqb, Dataset metadataDataset) throws Exception {
            sqb.select(LabelingInternalDBService.this.ebf.col(this.answersTable, "*"));
            QueryAst.TableLike metadataTable = LabelingInternalDBService.this.getMetadataTable(metadataDataset, labelingTask);
            if (labelingTask.preLabelColumn != null) {
                sqb.select(LabelingInternalDBService.this.ebf.col(metadataTable, labelingTask.preLabelColumn), PRELABEL_COLUMN_ALIAS);
            }
            if (labelingTask.dataColumn() != null) {
                sqb.select(LabelingInternalDBService.this.ebf.col(metadataTable, labelingTask.dataColumn()), DATA_COLUMN_ALIAS);
            }
            ArrayList<T> answers = new ArrayList<T>();
            try (SingleStatementQueryExecutionContext context = new SingleStatementQueryExecutionContext();){
                ResultSet rs2 = context.execute(sqb, LabelingInternalDBService.this.getDialect());
                while (rs2.next()) {
                    T answerWithOutputData = this.newAnswerWithOutputData();
                    ((LabelingAnswerCRUDService.BaseLabelingAnswerWithOutputData)answerWithOutputData).answer = this.newAnswerFromResultSet(rs2);
                    this.fillOutputDataFromResultSet(labelingTask, rs2, answerWithOutputData);
                    answers.add(answerWithOutputData);
                }
            }
            return answers;
        }

        protected abstract A newAnswerFromResultSet(ResultSet var1) throws SQLException;

        protected abstract T newAnswerWithOutputData();

        protected void fillOutputDataFromResultSet(LabelingTask labelingTask, ResultSet rs2, T labelingAnswerWithOutputData) throws SQLException {
            String preLabel;
            if (labelingTask.dataColumn() != null) {
                ((LabelingAnswerCRUDService.BaseLabelingAnswerWithOutputData)labelingAnswerWithOutputData).data = rs2.getString(DATA_COLUMN_ALIAS);
            }
            if (labelingTask.preLabelColumn != null && !Strings.isNullOrEmpty((String)(preLabel = rs2.getString(PRELABEL_COLUMN_ALIAS)))) {
                ((LabelingAnswerCRUDService.BaseLabelingAnswerWithOutputData)labelingAnswerWithOutputData).preLabel = (Label)JSON.parse((String)preLabel, Label.class);
            }
        }

        protected void fillBaseAnswerFromResultSet(BaseLabelingAnswer answer, ResultSet rs2) throws SQLException {
            answer.projectKey = rs2.getString("PROJECT_KEY");
            answer.labelingTaskId = rs2.getString("LABELING_TASK_ID");
            answer.label = (Label)JSON.parse((String)rs2.getString("LABEL"), Label.class);
            answer.recordId = rs2.getString("IDENTIFIER");
            answer.creationTime = rs2.getLong("CREATION_TIME");
            answer.lastUpdateTime = rs2.getLong("LAST_UPDATE_TIME");
            answer.reviewer = rs2.getString("REVIEWER_ID");
        }
    }

    private abstract class AnswersSaver<T extends BaseLabelingAnswer> {
        private static final int BATCH_SIZE = 10000;
        private final PreparedStatement ps;
        private long totalAnswersSaved = 0L;
        private int answersInBatch = 0;

        public AnswersSaver(DSSDBConnection connection) throws SQLException {
            this.ps = LabelingInternalDBService.this.getPreparedStatement(connection, this.getUpsertQueryBuilder().toSQL(LabelingInternalDBService.this.getDialect()));
        }

        abstract UpsertQueryBuilder getUpsertQueryBuilder();

        void setValuesOnPrepareStatement(PreparedStatement ps2, T answer) throws SQLException {
            ps2.setString(1, ((BaseLabelingAnswer)answer).projectKey);
            ps2.setString(2, ((BaseLabelingAnswer)answer).labelingTaskId);
            ps2.setString(3, ((BaseLabelingAnswer)answer).recordId);
            ps2.setLong(4, ((BaseLabelingAnswer)answer).creationTime);
            ps2.setLong(5, ((BaseLabelingAnswer)answer).lastUpdateTime);
            ps2.setString(6, JSON.json(((BaseLabelingAnswer)answer).label));
            ps2.setString(7, ((BaseLabelingAnswer)answer).reviewer);
        }

        public void save(T answer) throws SQLException {
            this.setValuesOnPrepareStatement(this.ps, answer);
            this.ps.addBatch();
            ++this.totalAnswersSaved;
            ++this.answersInBatch;
            if (this.totalAnswersSaved % 10000L == 0L) {
                this.flushBatch();
            }
        }

        private void flushBatch() throws SQLException {
            if (this.answersInBatch > 0) {
                logger.info((Object)("Insert batch of " + this.answersInBatch + " answers"));
                this.ps.executeBatch();
                this.ps.clearBatch();
                this.answersInBatch = 0;
            }
        }

        public void lastAnswerSaved() throws SQLException {
            this.flushBatch();
            if (this.totalAnswersSaved > 0L) {
                logger.info((Object)("Done saving " + this.totalAnswersSaved + " answers"));
            }
        }
    }
}

