/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.objectdetection;

import com.dataiku.dip.labeling.BaseLabelingAnswer;
import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.VerifiedLabel;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.labeling.objectdetection.BoundingBox;
import com.dataiku.dip.labeling.objectdetection.SimpleObjectDetectionRegionDispatcher;
import com.dataiku.dip.labeling.region.RegionElement;
import com.dataiku.dip.labeling.score.LabelingClassicalScoreComputer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SimpleObjectDetectionScoreComputer
extends LabelingClassicalScoreComputer<VerifiedLabel.ObjectDetectionVerifiedLabel.BoundingBoxPair> {
    private final double iouThreshold;

    public SimpleObjectDetectionScoreComputer(double iouThreshold) {
        this.iouThreshold = iouThreshold;
    }

    @Override
    public VerifiedLabel.ObjectDetectionVerifiedLabel computeVerifiedLabel(LabelingAnswer answer, VerifiedLabelingAnswer verifiedAnswer) {
        List<BaseLabelingAnswer> answersToDispatch = Arrays.asList(answer, verifiedAnswer);
        List regions = new SimpleObjectDetectionRegionDispatcher(this.iouThreshold).dispatch(answersToDispatch);
        List<VerifiedLabel.ObjectDetectionVerifiedLabel.BoundingBoxPair> boundingBoxPairs = regions.stream().map(region -> {
            RegionElement annotation = region.elements.stream().filter(e -> e.answerIdx == 0).findFirst().orElse(null);
            RegionElement verifiedAnnotation = region.elements.stream().filter(e -> e.answerIdx == 1).findFirst().orElse(null);
            double iou = 0.0;
            if (annotation != null && verifiedAnnotation != null) {
                iou = ((BoundingBox)annotation.annotation).bbox.computeIoUWith(((BoundingBox)verifiedAnnotation.annotation).bbox);
            }
            return new VerifiedLabel.ObjectDetectionVerifiedLabel.BoundingBoxPair(iou, verifiedAnnotation != null ? ((BoundingBox)verifiedAnnotation.annotation).category : null, annotation != null ? Integer.valueOf(annotation.annotationIdx) : null);
        }).collect(Collectors.toList());
        return new VerifiedLabel.ObjectDetectionVerifiedLabel(boundingBoxPairs);
    }

    @Override
    public List<VerifiedLabel.ObjectDetectionVerifiedLabel.BoundingBoxPair> getPairsFromVerifiedLabel(VerifiedLabel verifiedLabel) {
        return ((VerifiedLabel.ObjectDetectionVerifiedLabel)verifiedLabel).boundingBoxPairs;
    }

    @Override
    public boolean isFalsePositive(VerifiedLabel.ObjectDetectionVerifiedLabel.BoundingBoxPair boundingBoxPair) {
        return super.isFalsePositive(boundingBoxPair) || boundingBoxPair.iou < this.iouThreshold;
    }
}

