/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class LLMChatMessageUtils {
    public static List<LLMClient.ChatMessage> collapseAdjacentSameRoleMessages(List<LLMClient.ChatMessage> messages) {
        ArrayList<LLMClient.ChatMessage> newMessages = new ArrayList<LLMClient.ChatMessage>();
        LLMClient.ChatMessage currentMessage = null;
        for (LLMClient.ChatMessage message : messages) {
            if (currentMessage == null) {
                currentMessage = new LLMClient.ChatMessage(message);
                continue;
            }
            if (!currentMessage.role.equals(message.role)) {
                newMessages.add(currentMessage);
                currentMessage = new LLMClient.ChatMessage(message);
                continue;
            }
            List<LLMClient.ChatMessagePart> messageParts = LLMChatMessageUtils.chatMessageAsParts(message);
            if (!messageParts.isEmpty()) {
                if (currentMessage.parts == null) {
                    List<LLMClient.ChatMessagePart> currentMessageParts = LLMChatMessageUtils.chatMessageAsParts(currentMessage);
                    currentMessage.parts = new ArrayList<LLMClient.ChatMessagePart>(currentMessageParts);
                }
                currentMessage.parts.addAll(messageParts);
            }
            if (message.toolCalls != null) {
                if (currentMessage.toolCalls == null) {
                    currentMessage.toolCalls = new ArrayList<LLMClient.AbstractToolCall>();
                }
                currentMessage.toolCalls.addAll(message.toolCalls);
            }
            if (message.toolOutputs == null) continue;
            if (currentMessage.toolOutputs == null) {
                currentMessage.toolOutputs = new ArrayList<LLMClient.ToolOutput>();
            }
            currentMessage.toolOutputs.addAll(message.toolOutputs);
        }
        if (currentMessage != null) {
            newMessages.add(currentMessage);
        }
        return newMessages;
    }

    public static List<LLMClient.ChatMessage> convertMessageRole(List<LLMClient.ChatMessage> messages, String fromRole, String toRole) {
        return messages.stream().map(LLMClient.ChatMessage::new).map(message -> {
            if (message.role.equals(fromRole)) {
                message.role = toRole;
            }
            return message;
        }).collect(Collectors.toList());
    }

    public static List<LLMClient.ChatMessage> convertExtraSystemMessageToUser(List<LLMClient.ChatMessage> messages) {
        ArrayList<LLMClient.ChatMessage> newMessages = new ArrayList<LLMClient.ChatMessage>();
        boolean firstSystemMessage = true;
        for (LLMClient.ChatMessage message : messages) {
            LLMClient.ChatMessage newMessage = new LLMClient.ChatMessage(message);
            if (!message.role.equals("system")) {
                firstSystemMessage = false;
            }
            if (message.role.equals("system") && !firstSystemMessage) {
                newMessage.role = "user";
            }
            newMessages.add(newMessage);
        }
        return newMessages;
    }

    public static List<LLMClient.ChatMessage> convertPartsToContentMessagesIfPossible(List<LLMClient.ChatMessage> messages) {
        boolean messagesAreTextOnly = messages.stream().allMatch(message -> message.isTextOnly());
        return messages.stream().map(message -> messagesAreTextOnly ? new LLMClient.ChatMessage(message.role, message.getText()) : message).collect(Collectors.toList());
    }

    private static List<LLMClient.ChatMessagePart> chatMessageAsParts(LLMClient.ChatMessage message) {
        if (message.parts != null) {
            return List.copyOf(message.parts);
        }
        String text = message.getText();
        if (text == null) {
            return Collections.emptyList();
        }
        LLMClient.ChatMessagePart part = new LLMClient.ChatMessagePart();
        part.text = text;
        return List.of(part);
    }

    public static JsonObject completionQueryToLightJsonObject(LLMClient.SingleCompletionQuery query) {
        JsonObject jsonQuery = new JsonObject();
        JsonArray jsonMessages = new JsonArray();
        jsonQuery.add("messages", (JsonElement)jsonMessages);
        for (LLMClient.ChatMessage message : query.messages) {
            if (message.isTextOnly()) {
                jsonMessages.add((JsonElement)JSON.toJsonObject((Object)message));
                continue;
            }
            JsonObject jsonMessage = new JsonObject();
            jsonMessages.add((JsonElement)jsonMessage);
            JsonArray jsonParts = new JsonArray();
            jsonMessage.add("parts", (JsonElement)jsonParts);
            for (LLMClient.ChatMessagePart part : message.parts) {
                JsonObject jsonPart = new JsonObject();
                jsonParts.add((JsonElement)jsonPart);
                switch (part.type) {
                    case TEXT: {
                        jsonPart.addProperty("text", part.text);
                        break;
                    }
                    case IMAGE_INLINE: {
                        jsonPart.addProperty("image", "<inline-image>");
                        jsonPart.addProperty("imageMimeType", part.imageMimeType);
                        break;
                    }
                    case IMAGE_URI: {
                        jsonPart.addProperty("imageUrl", part.imageUrl);
                    }
                }
            }
            jsonMessage.addProperty("role", message.role);
            jsonMessage.add("toolOutputs", (JsonElement)JSON.toJsonObject(message.toolOutputs));
            jsonMessage.add("toolCalls", (JsonElement)JSON.toJsonObject(message.toolCalls));
        }
        return jsonQuery;
    }

    public static List<String> completionQueryToStringsOfTexts(LLMClient.SingleCompletionQuery query) {
        ArrayList<String> ret = new ArrayList<String>();
        for (LLMClient.ChatMessage message : query.messages) {
            String txt = message.getTextEvenIfNotTextOnly();
            if (!StringUtils.isNotBlank((String)txt)) continue;
            ret.add(txt);
        }
        return ret;
    }

    public static JsonObject embeddingQueryToLightJsonObject(LLMClient.EmbeddingQuery query) {
        JsonObject jsonQuery = new JsonObject();
        if (query.hasText()) {
            jsonQuery.addProperty("text", query.text);
        }
        if (query.hasImage()) {
            jsonQuery.addProperty("image", "<inline-image>");
        }
        return jsonQuery;
    }

    public static JsonObject rerankingQueryToLightJsonObject(LLMClient.RerankingQuery query) {
        if (query.queryParts.stream().anyMatch(part -> !part.isText())) {
            throw new UnsupportedOperationException("Only text supported for reranking");
        }
        JsonObject jsonQuery = new JsonObject();
        jsonQuery.add("query", (JsonElement)JSON.toJsonObject((Object)query));
        return jsonQuery;
    }
}

