/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.managedfolder;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.PartitionableHandler;
import com.dataiku.dip.datasets.fs.ACLAware;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSLikeFSProvider;
import com.dataiku.dip.datasets.fs.FSProviderConnectionFactory;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.FsProviderToReadWriteFSTransferer;
import com.dataiku.dip.datasets.fs.FsToFsProviderTransferer;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.DirectoryAware;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderCodes;
import com.dataiku.dip.partitioning.FileBucket;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.CloseShieldInputStream;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ManagedFolderHandler
implements PartitionableHandler {
    @Autowired
    private VariablesService variablesService;
    private final ManagedFolder managedFolder;
    private final AbstractFSDatasetHandler.AbstractFSConfig resolvedConfig;
    private final AuthCtx authCtx;
    private FSProvider provider;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.managedfolders.handler");

    public ManagedFolderHandler(AuthCtx authCtx, ManagedFolder managedFolder) {
        SpringUtils.getInstance().autowire((Object)this);
        this.authCtx = authCtx;
        this.managedFolder = managedFolder;
        this.resolvedConfig = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.deepCopy((Object)managedFolder.getParams());
        VariablesContext vc = this.variablesService.getForProject(managedFolder.projectKey);
        vc.add("projectKey", managedFolder.projectKey);
        vc.add("odbId", managedFolder.id);
        this.resolvedConfig.path = vc.expand(this.resolvedConfig.path);
        if (this.resolvedConfig instanceof AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig) {
            AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig metastoreAwareFSConfig = (AbstractFSDatasetHandler.AbstractMetastoreAwareFSConfig)this.resolvedConfig;
            metastoreAwareFSConfig.metastoreDatabaseName = vc.expand(metastoreAwareFSConfig.metastoreDatabaseName);
            metastoreAwareFSConfig.metastoreTableName = vc.expand(metastoreAwareFSConfig.metastoreTableName);
        }
    }

    public AbstractFSDatasetHandler.AbstractFSConfig getResolvedConfig() {
        return this.resolvedConfig;
    }

    public ManagedFolder getFolder() {
        return this.managedFolder;
    }

    @Override
    public void close() throws IOException {
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
    }

    public synchronized FSProvider getProvider() throws IOException, DKUSecurityException, CodedException {
        if (this.provider == null) {
            this.provider = this.buildOneProvider();
        }
        return this.provider;
    }

    public FSProvider buildOneProvider() throws IOException, DKUSecurityException, CodedException {
        if (StringUtils.isBlank((String)this.resolvedConfig.path)) {
            throw new IllegalArgumentException("No path set for folder " + this.managedFolder.getFullName());
        }
        FSProviderConnectionFactory connectionFactory = new FSProviderConnectionFactory();
        DSSConnection connection = connectionFactory.getConnectionForProvider(this.managedFolder.getType(), this.authCtx, this.managedFolder.params, "folder " + this.managedFolder.getFullName());
        logger.info((Object)("Create provider for " + this.managedFolder.getFullName() + " with path " + this.resolvedConfig.path));
        return FSProviderFactory.getProvider(this.managedFolder.getType(), this.authCtx, this.managedFolder.getProjectKey(), this.resolvedConfig, this.resolvedConfig.path, connection);
    }

    public String getResolvedPath() throws IOException, DKUSecurityException, CodedException {
        if (this.getProvider() instanceof LocalFSProvider) {
            return ((LocalFSProvider)this.getProvider()).getRoot();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Partition> listPartitions() throws IOException, DKUSecurityException, CodedException {
        PartitioningScheme scheme = this.managedFolder.getPartitioningSchema();
        FSEnumerationResult enumerationResult = this.getProvider().enumerateRecursive("/", new FSEnumerationSettings());
        if (!enumerationResult.isSuccessful()) {
            return Lists.newArrayList();
        }
        if (!enumerationResult.enumerationPrefixExists()) {
            throw new FileNotFoundException("Folder doesn't exist");
        }
        ArrayList paths = Lists.newArrayList((Iterable)enumerationResult.getPaths());
        FilePartitioner partitioner = new FilePartitioner(scheme);
        ArrayList partitions = Lists.newArrayList();
        partitions.addAll(partitioner.getPartitionsFromFiles(paths));
        return partitions;
    }

    @Override
    public boolean partitionExists(Partition p) throws IOException, DKUSecurityException, CodedException {
        for (Partition _p : this.listPartitions()) {
            if (!_p.id().equals(p.id())) continue;
            return true;
        }
        return false;
    }

    public DatasetReadiness getReadiness(Partition partition) {
        try {
            StringBuilder identifier = new StringBuilder();
            String markerFile = this.managedFolder.getParams().markerFile;
            if (StringUtils.isBlank((String)markerFile)) {
                List<FSPath> paths = this.enumeratePartition(partition);
                if (paths == null) {
                    logger.warn((Object)("No path returned for folder " + this.managedFolder.getFullName() + " (empty or error) - still considering as ready"));
                } else {
                    for (FSPath p : paths) {
                        identifier.append(p.path() + "=" + p.getSize() + "@" + p.getLastModified());
                    }
                }
            } else {
                for (FSPath p : this.enumerateFilesystem(markerFile)) {
                    identifier.append(p.path() + "=" + p.getSize() + "@" + p.getLastModified());
                }
            }
            return DatasetReadiness.ready(DKUtils.md5Base64((String)identifier.toString()));
        }
        catch (Exception e) {
            return DatasetReadiness.error(e);
        }
    }

    private List<FSPath> enumerateFilesystem(String prefix) throws IOException, DKUSecurityException, CodedException {
        logger.info((Object)("Enumerating managed folder prefix=" + prefix));
        FSEnumerationSettings enumerationSettings = new FSEnumerationSettings();
        FSEnumerationResult enumerationResult = this.getProvider().enumerateRecursive(prefix, enumerationSettings);
        if (!enumerationResult.isSuccessful()) {
            if (enumerationResult.getError() instanceof CodedIOException && ((CodedIOException)enumerationResult.getError()).getCode() == FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES) {
                throw (CodedIOException)enumerationResult.getError();
            }
            return Lists.newArrayList();
        }
        if (!enumerationResult.enumerationPrefixExists()) {
            throw new FileNotFoundException("Nothing at path " + prefix);
        }
        return Lists.newArrayList((Iterable)enumerationResult.getPaths());
    }

    private List<FSPath> enumeratePartition(Partition partition) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        List<FSPath> paths = null;
        try {
            String prefix = this.managedFolder.getPartitioningSchema() != null && FilePartitioner.isSchemeRepresentableAsFolder(this.managedFolder.getPartitioningSchema()) ? FilePartitioner.computePartitionRelPathAsFolder(partition, this.managedFolder.getPartitioningSchema()) : "";
            paths = this.enumerateFilesystem(prefix);
        }
        catch (CodedIOException e) {
            if (e.getCode() == FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES) {
                throw e;
            }
            logger.warn((Object)("Could not enumerate partition " + String.valueOf(partition) + ", it does not exist"), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            logger.warn((Object)("Could not enumerate partition " + String.valueOf(partition) + ", it does not exist"), (Throwable)e);
            return null;
        }
        if (paths == null || paths.isEmpty()) {
            if (this.managedFolder.getPartitioningSchema().isPartitioned() && this.managedFolder.getPartitioningSchema().considerMissingRequestedPartitionsAsEmpty) {
                logger.warn((Object)("Considering missing partition " + String.valueOf(partition) + " as empty"));
                return new ArrayList<FSPath>();
            }
            return null;
        }
        ArrayList<FSPath> partitionPaths = new ArrayList<FSPath>();
        if (this.managedFolder.getPartitioningSchema() != null && FilePartitioner.isSchemeRepresentableAsFolder(this.managedFolder.getPartitioningSchema())) {
            partitionPaths.addAll(paths);
        } else {
            FilePartitioner partitioner = new FilePartitioner(this.managedFolder.getPartitioningSchema());
            List<FilePartition> partitions = partitioner.getPartitionsFromFiles(paths);
            for (FilePartition candidate : partitions) {
                if (!candidate.id().equals(partition.id())) continue;
                for (FileBucket fb : candidate.buckets) {
                    partitionPaths.addAll(fb.paths);
                }
            }
        }
        return partitionPaths;
    }

    public ManagedFolderListing listFS(Partition partition, boolean alwaysListFiles, boolean relativeToPartition) throws IOException, DKUSecurityException, CodedException {
        FSPathOrDirectory stat;
        String basePath;
        ManagedFolderListing ret = new ManagedFolderListing();
        ret.folderPath = basePath = this.getProvider() instanceof FSLikeFSProvider ? ((FSLikeFSProvider)this.getProvider()).getRoot() : null;
        String prefix = "";
        PartitioningScheme scheme = this.managedFolder.getPartitioningSchema();
        if (scheme.isPartitioned() && partition != null && !"ALL".equals(partition.id()) && !"NP".equals(partition.id()) && FilePartitioner.isSchemeRepresentableAsFolder(scheme)) {
            prefix = FilePartitioner.computePartitionRelPathAsFolder(partition, this.managedFolder.getPartitioningSchema());
            ret.partitioningSchemeRepresentableAsFolder = true;
            ret.partitionPrefix = prefix;
        }
        if ((stat = this.getProvider().stat(prefix)) == null || !stat.isDirectory) {
            return ret;
        }
        if (alwaysListFiles || !ret.partitioningSchemeRepresentableAsFolder) {
            return this.listAndEnumerateFS(partition, relativeToPartition, ret, prefix, scheme);
        }
        return ret;
    }

    private ManagedFolderListing listAndEnumerateFS(Partition partition, boolean relativeToPartition, ManagedFolderListing ret, String prefix, PartitioningScheme scheme) throws CodedIOException {
        List<FSPath> paths = null;
        try {
            String partitionPrefix = FilePartitioner.isSchemeRepresentableAsFolder(scheme) ? FilePartitioner.computePartitionRelPathAsFolder(partition, this.managedFolder.getPartitioningSchema()) : "";
            logger.info((Object)("Enumerate folder contents from " + partitionPrefix));
            paths = this.enumerateFilesystem(partitionPrefix);
        }
        catch (CodedIOException e) {
            if (e.getCode() == FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES) {
                throw e;
            }
            logger.warn((Object)("Could not enumerate partition " + String.valueOf(partition) + ", it does not exist"), (Throwable)e);
            return ret;
        }
        catch (Exception e) {
            logger.warn((Object)("Could not enumerate partition " + String.valueOf(partition) + ", it does not exist"), (Throwable)e);
            return ret;
        }
        ArrayList<FSPath> partitionPaths = new ArrayList<FSPath>();
        if (paths != null) {
            this.filterPathsForPartition(partition, scheme, paths, partitionPaths);
        }
        HashMap pathByAbsolutePath = Maps.newHashMap();
        for (FSPath path : partitionPaths) {
            pathByAbsolutePath.put(path.path(), path);
        }
        FilePartitioner partitioner = new FilePartitioner(scheme);
        for (FilePartition filePartition : partitioner.getPartitionsFromFiles(paths)) {
            if (partition != null && !partition.isAll() && !partition.isNP() && !partition.id().equals(filePartition.id())) continue;
            for (FSPath path : filePartition.getAllPaths()) {
                ManagedFolderListingItem item = new ManagedFolderListingItem();
                item.lastModified = path.getLastModified();
                item.size = path.getSize();
                item.path = relativeToPartition && ret.partitioningSchemeRepresentableAsFolder ? StringUtils.replaceOnce((String)path.path(), (String)prefix, (String)"") : path.path();
                ret.items.add(item);
                pathByAbsolutePath.remove(path.path());
            }
        }
        if (partition == null || partition.isAll() || partition.isNP()) {
            for (FSPath path : pathByAbsolutePath.values()) {
                ManagedFolderListingItem item = new ManagedFolderListingItem();
                item.lastModified = path.getLastModified();
                item.size = path.getSize();
                item.path = path.path();
                ret.items.add(item);
            }
        }
        return ret;
    }

    private void filterPathsForPartition(Partition partition, PartitioningScheme scheme, List<FSPath> paths, List<FSPath> partitionPaths) {
        if (FilePartitioner.isSchemeRepresentableAsFolder(scheme)) {
            partitionPaths.addAll(paths);
        } else if (partition == null || "NP".equals(partition.id()) || "ALL".equals(partition.id())) {
            partitionPaths.addAll(paths);
        } else {
            this.filterPartitionPathUsingScheme(partition, scheme, paths, partitionPaths);
        }
    }

    private void filterPartitionPathUsingScheme(Partition partition, PartitioningScheme scheme, List<FSPath> paths, List<FSPath> partitionPaths) {
        FilePartitioner partitioner = new FilePartitioner(scheme);
        List<FilePartition> partitions = partitioner.getPartitionsFromFiles(paths);
        for (FilePartition candidate : partitions) {
            if (!candidate.id().equals(partition.id())) continue;
            for (FileBucket fb : candidate.buckets) {
                partitionPaths.addAll(fb.paths);
            }
        }
    }

    public void clear() throws InterruptedException, IOException, DKUSecurityException, CodedException {
        logger.info((Object)"Clear all");
        this.checkFolderAtRoot();
        if ("HDFS".equals(this.getFolder().getType())) {
            new HDFSPermissionsHandler(this).setDataUsabilityAndDeletabilityACL(this.authCtx);
        }
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedConfig.connection);
        if (this.getProvider() instanceof DirectoryAware) {
            ((DirectoryAware)this.getProvider()).makeEmpty("/");
        } else {
            this.getProvider().deleteRecursive("/");
        }
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        logger.info((Object)"Clear partitions");
        this.checkFolderAtRoot();
        if ("HDFS".equals(this.getFolder().getType())) {
            for (Partition p : partitions) {
                new HDFSPermissionsHandler(this).setDataUsabilityAndDeletabilityACL(this.authCtx, p);
            }
        }
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedConfig.connection);
        PartitioningScheme scheme = this.managedFolder.getPartitioningSchema();
        if (scheme != null && scheme.isPartitioned() && FilePartitioner.isSchemeRepresentableAsFolder(scheme)) {
            for (Partition p : partitions) {
                logger.info((Object)("Clearing partition \"" + p.id() + "\""));
                String partitionPath = FilePartitioner.computePartitionRelPathAsFolder(p, this.managedFolder.getPartitioningSchema());
                this.getProvider().deleteRecursive(partitionPath);
                logger.info((Object)("Done clearing partition \"" + p.id() + "\""));
            }
        } else {
            for (Partition p : partitions) {
                logger.info((Object)("Clearing partition \"" + p.id() + "\""));
                List<FSPath> paths = this.enumeratePartition(p);
                for (FSPath path : paths) {
                    this.getProvider().deleteRecursive(path.path());
                }
                logger.info((Object)("Done clearing partition \"" + p.id() + "\""));
            }
        }
    }

    private void checkFolderAtRoot() throws CodedIOException {
        if (StringUtils.isBlank((String)this.resolvedConfig.path) || "/".equals(this.resolvedConfig.path)) {
            String connectionName = StringUtils.defaultIfBlank((String)this.resolvedConfig.connection, (String)"no_connection");
            boolean allowed = ApplicationConfigurator.getParams().getBoolParam("dku.datasets.managed." + connectionName + ".allowClearRoot", false);
            if (!allowed) {
                throw new CodedIOException((InfoMessage.MessageCode)ManagedFolderCodes.ERR_FOLDER_INVALID_CONFIG, "Placing a managed folder at the root of a connection is not permitted");
            }
        }
    }

    public EnrichedInputStream getInputStream(String itemPath) throws IOException, DKUSecurityException, CodedException {
        return this.getProvider().read(itemPath);
    }

    public OutputStream getOutputStream(String itemPath) throws IOException, DKUSecurityException, CodedException, InterruptedException {
        if ("HDFS".equals(this.getFolder().getType())) {
            new HDFSPermissionsHandler(this).setGatewayACLCreate(this.authCtx);
        }
        return this.getProvider().write(itemPath);
    }

    public FSPathOrDirectory getFile(String itemPath) throws IOException, DKUSecurityException, CodedException {
        return this.getProvider().stat(itemPath);
    }

    public long getFileSize(String itemPath) throws IOException, DKUSecurityException, CodedException {
        FSPathOrDirectory path = this.getProvider().stat(itemPath);
        if (path == null) {
            throw new FileNotFoundException("No file at path " + itemPath);
        }
        return path.getSize();
    }

    public String getFileContentType(String itemPath) throws IOException {
        return DKUtils.guessMimeTypeFromExtension((String)((String)PathUtils.splitBasename((String)itemPath).second));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompress(String itemPath) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        block39: {
            if ("HDFS".equals(this.getFolder().getType())) {
                new HDFSPermissionsHandler(this).setGatewayACLCreate(this.authCtx);
            }
            Pair splitItemPath = PathUtils.splitBasename((String)itemPath);
            String fileName = (String)splitItemPath.second;
            String itemPathParent = (String)splitItemPath.first;
            FSPathOrDirectory path = this.getProvider().stat(itemPath);
            if (path.isDirectory) {
                throw new IllegalArgumentException("File " + itemPath + " is a folder");
            }
            ZipArchiveInputStream ais = null;
            GzipCompressorInputStream cis = null;
            try (InputStream itemInputStream = this.getInputStream(itemPath).rawStream();){
                String suffix;
                String fileNameLowerCase = fileName.toLowerCase(Locale.ROOT);
                if (fileNameLowerCase.endsWith(".zip")) {
                    suffix = ".zip";
                    ais = new ZipArchiveInputStream(itemInputStream);
                } else if (fileNameLowerCase.endsWith(".tar")) {
                    suffix = ".tar";
                    ais = new TarArchiveInputStream(itemInputStream);
                } else if (fileNameLowerCase.endsWith(".tar.gz")) {
                    suffix = ".tar.gz";
                    ais = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(itemInputStream));
                } else if (fileNameLowerCase.endsWith(".tgz")) {
                    suffix = ".tgz";
                    ais = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(itemInputStream));
                } else if (fileNameLowerCase.endsWith(".tar.bz2")) {
                    suffix = ".tar.bz2";
                    ais = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(itemInputStream));
                } else if (fileNameLowerCase.endsWith(".gz")) {
                    suffix = ".gz";
                    cis = new GzipCompressorInputStream(itemInputStream);
                } else if (fileNameLowerCase.endsWith(".bz2")) {
                    suffix = ".bz2";
                    cis = new BZip2CompressorInputStream(itemInputStream);
                } else {
                    throw new IllegalArgumentException("Doesn't know how to decompress " + fileName);
                }
                String decompressedFile = PathUtils.concatLNT((String[])new String[]{itemPathParent, fileName.substring(0, fileName.length() - suffix.length())});
                decompressedFile = PathUtils.canonical((String)decompressedFile);
                FSPathOrDirectory existing = this.getProvider().stat(decompressedFile);
                if (existing != null) {
                    ArrayList contents;
                    if (cis != null) {
                        throw new IOException("Destination " + decompressedFile + " already exist");
                    }
                    if (!existing.isDirectory) {
                        throw new IOException("Destination " + decompressedFile + " already exist and is a file");
                    }
                    FSEnumerationResult decompressedFileContents = this.getProvider().enumerateRecursive(decompressedFile, new FSEnumerationSettings());
                    if (decompressedFileContents.isSuccessful() && decompressedFileContents.getPaths() != null && (contents = Lists.newArrayList((Iterable)decompressedFileContents.getPaths())).size() > 0) {
                        throw new IOException("Destination " + decompressedFile + " already exist and contains files");
                    }
                }
                if (cis != null) {
                    logger.info((Object)("Decompress single-file archive to " + decompressedFile));
                    try (OutputStream out = this.getProvider().write(decompressedFile);){
                        IOUtils.copy((InputStream)cis, (OutputStream)out);
                        break block39;
                    }
                }
                logger.info((Object)("Decompress multi-file archive to " + decompressedFile));
                if (existing != null) {
                    this.getProvider().deleteRecursive(decompressedFile);
                }
                this.decompressArchive((ArchiveInputStream)ais, decompressedFile);
            }
            finally {
                if (ais != null) {
                    ais.close();
                }
                if (cis != null) {
                    cis.close();
                }
            }
        }
    }

    private void decompressArchive(ArchiveInputStream ais, String decompressedFile) throws IOException, DKUSecurityException, CodedException {
        ArchiveEntry entry = ais.getNextEntry();
        while (entry != null) {
            if (!entry.isDirectory()) {
                String entryFile = PathUtils.concatLNT((String[])new String[]{decompressedFile, entry.getName()});
                logger.info((Object)("Process enty " + entryFile));
                entryFile = PathUtils.canonical((String)entryFile);
                if (this.getProvider().stat(entryFile) != null) {
                    throw new IllegalArgumentException("File " + entryFile + " exists");
                }
                if (!entryFile.startsWith(decompressedFile)) {
                    throw new IOException("No cheating and trying to get a file outside the folder...");
                }
                try (CloseShieldInputStream in = new CloseShieldInputStream((InputStream)ais);
                     OutputStream out = this.getProvider().write(entryFile);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
            entry = ais.getNextEntry();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String ensurePartitionFolder(Partition p) throws InterruptedException, IOException, DKUSecurityException, CodedException {
        FsConnection fsConn;
        String partitionPath;
        PartitioningScheme scheme;
        if ("HDFS".equals(this.getFolder().getType())) {
            new HDFSPermissionsHandler(this).setGatewayACLCreate(this.authCtx);
        }
        if ((scheme = this.managedFolder.getPartitioningSchema()) != null && scheme.isPartitioned() && p != null) {
            if (StringUtils.isBlank((String)scheme.getFilePathPattern())) {
                throw new CodedException((InfoMessage.MessageCode)ManagedFolderCodes.ERR_FOLDER_INVALID_PARTITIONING_CONFIG, "Pattern not set in partitioning scheme");
            }
            if (!FilePartitioner.isSchemeRepresentableAsFolder(scheme)) throw new CodedException((InfoMessage.MessageCode)ManagedFolderCodes.ERR_FOLDER_INVALID_PARTITIONING_CONFIG, "Partitioning scheme is not representable as folders");
            partitionPath = FilePartitioner.computePartitionRelPathAsFolder(p, this.managedFolder.getPartitioningSchema());
        } else {
            partitionPath = "/";
        }
        if (!(this.getProvider() instanceof DirectoryAware)) return partitionPath;
        ((DirectoryAware)this.getProvider()).ensureDirectory(partitionPath);
        if (!partitionPath.isEmpty() && !"/".equals(partitionPath)) return partitionPath;
        logger.info((Object)"Ensured folder for root of managed folder");
        if (!"Filesystem".equals(this.managedFolder.getType()) || (fsConn = (FsConnection)ConnectionsDAO.get().getConnection(this.authCtx, this.managedFolder.getParams().connection)) == null || !fsConn.params.manageLocalACLsForManagedFolders || !(this.getProvider() instanceof ACLAware)) return partitionPath;
        ((ACLAware)this.getProvider()).tightenAccess(this.authCtx);
        return partitionPath;
    }

    public void grantFullACLs() throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (this.getProvider() instanceof ACLAware) {
            ((ACLAware)this.getProvider()).grantFullACLs(this.authCtx, this.managedFolder.getProjectKey());
        }
    }

    public void grantReadACLs() throws IOException, InterruptedException, DKUSecurityException, CodedException {
        if (this.getProvider() instanceof ACLAware) {
            ((ACLAware)this.getProvider()).grantReadACLs(this.authCtx, this.managedFolder.getProjectKey());
        }
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, DKUSecurityException, CodedException {
        Map info = this.getProvider().getAccessInfo(withSensitiveInfo);
        if (this.getProvider() instanceof LocalFSProvider) {
            info.put("path", ((LocalFSProvider)this.getProvider()).getRoot());
        }
        return info;
    }

    public String getAbsolutePath(String path) throws IOException, DKUSecurityException, CodedException {
        if (this.getProvider() instanceof LocalFSProvider) {
            return DKUFileUtils.getWithinOrSame((File)new File(((LocalFSProvider)this.getProvider()).getRoot()), (String[])new String[]{path == null ? "" : path}).getAbsolutePath();
        }
        return null;
    }

    public void zipToStream(String itemPath, OutputStream out) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        FSEnumerationResult toZip = this.getProvider().enumerateRecursive(itemPath, new FSEnumerationSettings());
        if (!toZip.isSuccessful()) {
            throw new IOException("No file or folder at '" + itemPath + "'");
        }
        if (!toZip.enumerationPrefixExists()) {
            throw new IOException("No folder at '" + itemPath + "'");
        }
        if (toZip.getPaths() == null) {
            throw new IOException("Nothing to zip in '" + itemPath + "'");
        }
        try (ZipOutputStream zout = new ZipOutputStream(out);){
            for (FSPath path : toZip.getPaths()) {
                zout.putNextEntry(new ZipEntry(PathUtils.slashes((String)path.path(), (Boolean)false, null, (boolean)true, (String)"")));
                InputStream in = this.getProvider().read(path.path()).rawStream();
                try {
                    byte[] buffer = new byte[4096];
                    int length = in.read(buffer);
                    while (length > 0) {
                        zout.write(buffer, 0, length);
                        length = in.read(buffer);
                    }
                    zout.closeEntry();
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    public void recursiveDownload(String basePath, File targetDirectory) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        FSEnumerationResult items = this.getProvider().enumerateRecursive(basePath, new FSEnumerationSettings());
        if (!items.isSuccessful() || items.getPaths() == null) {
            throw new IOException("No files to download at '" + basePath + "'");
        }
        URI baseURI = this.toCleanURI(basePath);
        for (FSPath path : items.getPaths()) {
            URI entryURI = this.toCleanURI(path.path());
            String entryPath = baseURI.relativize(entryURI).getPath();
            if (entryPath.startsWith("/") && !StringUtils.isBlank((String)basePath)) {
                throw new IllegalArgumentException("Error while computing local path for managed folder entry \"" + path.path() + "\". \"" + path.path() + "\" was found to be an absolute path, while it was expected to be relative to: \"" + basePath + "\".");
            }
            File outputFile = DKUFileUtils.getWithin((File)targetDirectory, (String[])new String[]{entryPath});
            DKUFileUtils.mkdirsParent((File)outputFile);
            try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                InputStream inputStream = this.getProvider().read(path.path()).rawStream();
                try {
                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
    }

    private URI toCleanURI(String path) {
        return new File(PathUtils.slashes((String)path, (Boolean)true, null, (boolean)true, (String)"")).toURI();
    }

    public void delete(String itemPath) throws IOException, DKUSecurityException, CodedException {
        this.getProvider().deleteRecursive(itemPath);
    }

    public void deleteDirectory(String itemPath) throws IOException, DKUSecurityException, CodedException {
        this.getProvider().deleteDirectory(itemPath);
    }

    public void deleteFile(String itemPath) throws IOException, DKUSecurityException, CodedException {
        this.getProvider().deleteFile(itemPath);
    }

    public FSBrowsePath browse(String path, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException, CodedException {
        FSBrowsePath browsed = this.getProvider().browse(path, strategy);
        return browsed == null ? null : new FSBrowsePathWithMime(browsed);
    }

    public FSBrowsePath browse(String path) throws IOException, DKUSecurityException, CodedException {
        return this.browse(path, FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
    }

    public FSBrowsePath browseDirectory(String path) throws IOException, DKUSecurityException, CodedException {
        return this.browse(path, FSProvider.FSBrowseStrategy.DIRECTORY);
    }

    public long transferToReadWriteFS(ReadWriteFS baseFS, RelFile to) throws IOException, DKUSecurityException, CodedException {
        return new FsProviderToReadWriteFSTransferer(this.getProvider(), baseFS).transfer("", to.toString());
    }

    public long transferFrom(File from) throws IOException, DKUSecurityException, CodedException {
        try (LocalFSProvider fromProvider = LocalFSProvider.makeFSProviderOnRoot(from.getAbsolutePath());){
            long l = new FsToFsProviderTransferer(fromProvider, this.getProvider()).transfer("", "");
            return l;
        }
    }

    public static class ManagedFolderListing {
        public String folderPath;
        public boolean partitioningSchemeRepresentableAsFolder;
        public String partitionPrefix;
        public List<ManagedFolderListingItem> items = new ArrayList<ManagedFolderListingItem>();
    }

    public static class ManagedFolderListingItem {
        public String path;
        public long size;
        public long lastModified;

        public FSPath toPath() {
            return new FSPath(this.path, this.size, this.lastModified);
        }
    }

    public class FSBrowsePathWithMime
    extends FSBrowsePath {
        public String mimeType;

        public FSBrowsePathWithMime(FSBrowsePath raw) {
            this.directory = raw.directory;
            this.exists = raw.exists;
            this.truncated = raw.truncated;
            this.fullPath = raw.fullPath;
            this.pathElts = raw.pathElts;
            this.size = raw.size;
            this.lastModified = raw.lastModified;
            this.name = raw.name;
            for (FSBrowsePath child : raw.children) {
                this.children.add(new FSBrowsePathWithMime(child));
            }
            if (this.fullPath == null) {
                logger.warn((Object)("Null fullPath: " + JSON.json((Object)raw)));
            }
            if (!this.directory && this.fullPath != null) {
                this.mimeType = DKUtils.guessMimeTypeFromExtension((String)this.fullPath);
            }
        }
    }

    public static class WrappedInputStream
    extends InputStream
    implements Closeable {
        private final ManagedFolderHandler handler;
        private final InputStream is;

        public WrappedInputStream(ManagedFolderHandler handler, InputStream is) {
            this.handler = handler;
            this.is = is;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.is.close();
            this.handler.close();
        }
    }
}

