/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.automaticbin;

import com.dataiku.dip.pivot.backend.common.automaticbin.ComputedBinningMode;
import com.dataiku.dip.pivot.backend.common.automaticbin.ComputedBinningModesIterator;
import com.dataiku.dip.pivot.backend.model.DateAxisParams;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;

public class ComputedBinningModes {
    private List<AxisComputedBinningMode> axisComputedBinningModes = new ArrayList<AxisComputedBinningMode>();
    private final TreeSet<Integer> sortedAxesIndices = new TreeSet();
    private ComputedBinningModesIterator iterator;

    void setOrCreateIterator(ComputedBinningModesIterator computedBinningModesIterator) {
        this.iterator = computedBinningModesIterator == null ? new ComputedBinningModesIterator(this) : computedBinningModesIterator;
    }

    public ComputedBinningModesIterator getIterator() {
        return this.iterator;
    }

    public ComputedBinningModes add(int axisIndex, ComputedBinningMode computedBinningMode) {
        this.axisComputedBinningModes.add(new AxisComputedBinningMode(axisIndex, computedBinningMode));
        this.sortedAxesIndices.add(axisIndex);
        return this;
    }

    List<AxisComputedBinningMode> axisModes() {
        return this.axisComputedBinningModes;
    }

    public boolean isEmpty() {
        return this.axisComputedBinningModes.isEmpty();
    }

    Iterator<Integer> getDescendingAxesIndicesIterator() {
        return this.sortedAxesIndices.descendingIterator();
    }

    public AxisComputedBinningMode get(int axisIndex) {
        Optional<AxisComputedBinningMode> result = this.getSafe(axisIndex);
        if (result.isPresent()) {
            return result.get();
        }
        throw new IllegalArgumentException(String.format("Could not find computed binning mode for axis index %s", axisIndex));
    }

    public Optional<AxisComputedBinningMode> getSafe(int axisIndex) {
        for (AxisComputedBinningMode axisComputedBinningMode : this.axisComputedBinningModes) {
            if (axisComputedBinningMode.axisIndex != axisIndex) continue;
            return Optional.of(axisComputedBinningMode);
        }
        return Optional.empty();
    }

    public static class AxisComputedBinningMode {
        private int axisIndex;
        private ComputedBinningMode computedBinningMode;

        AxisComputedBinningMode(int axisIndex, ComputedBinningMode computedBinningMode) {
            this.axisIndex = axisIndex;
            this.computedBinningMode = computedBinningMode;
        }

        int getAxisIndex() {
            return this.axisIndex;
        }

        public DateAxisParams.BinningMode getMode() {
            return this.computedBinningMode.getMode();
        }

        public int getNumberOfBin() {
            return this.computedBinningMode.getNumberOfBin();
        }
    }
}

