/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.facets;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFaceter;
import com.dataiku.dip.pivot.backend.model.FilterFacet;

public class NumericalAxisFaceter
implements AxisFaceter {
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double globalMin = Double.POSITIVE_INFINITY;
    private double globalMax = Double.NEGATIVE_INFINITY;

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
        for (int i = 0; i < block.nbRecords(); ++i) {
            double d = block.doubles[i];
            if (Double.isNaN(d)) continue;
            this.globalMin = Math.min(d, this.globalMin);
            this.globalMax = Math.max(d, this.globalMax);
            if (filters != null && !filters[i]) continue;
            this.min = Math.min(d, this.min);
            this.max = Math.max(d, this.max);
        }
    }

    @Override
    public FilterFacet compute(boolean shouldKeepRelevantValuesOnly) {
        FilterFacet ff = new FilterFacet();
        if (this.min == Double.POSITIVE_INFINITY) {
            this.min = this.max = this.globalMin;
        }
        ff.globalMaxValue = this.globalMax;
        ff.globalMinValue = this.globalMin;
        if (shouldKeepRelevantValuesOnly) {
            ff.minValue = this.min;
            ff.maxValue = this.max;
        } else {
            ff.minValue = this.globalMin;
            ff.maxValue = this.globalMax;
        }
        return ff;
    }
}

