/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.binners;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisSortPrune;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.pivot.backend.sql.binners.AlphanumAxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.AxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.BinnedNumericalAxisBinner;
import com.dataiku.dip.pivot.backend.sql.binners.DateBinner;
import com.dataiku.dip.pivot.backend.sql.binners.UnbinnedNumericalAxisBinner;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.utils.NullableDoubleArrayList;
import com.dataiku.dip.pivot.backend.sql.utils.NullableLongArrayList;
import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class BinnerBuilder {
    private final BasicStatsBuilder.BasicStats stats;
    private final boolean generateTotalBin;

    public BinnerBuilder(BasicStatsBuilder.BasicStats stats, boolean generateTotalBin) {
        this.stats = stats;
        this.generateTotalBin = generateTotalBin;
    }

    public AxisBinner buildFromData(AxisDef def, Object data) {
        if (def.type == AxisDef.Type.NUMERICAL ? def.numParams.mode == NumericalAxisParams.BinningMode.FIXED_NB || def.numParams.mode == NumericalAxisParams.BinningMode.FIXED_SIZE : def.type == AxisDef.Type.DATE) {
            return this.buildFromAxis(def, data);
        }
        throw new UnsupportedOperation("Failed to construct the appropriate binner from 2D data");
    }

    public AxisBinner buildFromAxis(AxisDef def, Object data) {
        return switch (def.type) {
            case AxisDef.Type.ALPHANUM -> this.buildAlphanumBinner(def, (ArrayList)data);
            case AxisDef.Type.NUMERICAL -> this.buildNumericalBinner(def, data);
            case AxisDef.Type.DATE -> this.buildDateBinner(def, (TLongArrayList)data);
            default -> throw new UnsupportedOperationException("Failed to construct the appropriate binner from the materialized axis");
        };
    }

    public int getNbBins(AxisDef def, Object data) {
        if (data == null) {
            return 0;
        }
        switch (def.type) {
            case ALPHANUM: {
                Long sCount = ((ArrayList)data).stream().filter(s -> s != null).collect(Collectors.counting());
                return 2 + (sCount == null ? 0 : sCount.intValue());
            }
            case NUMERICAL: {
                if (def.numParams.mode == NumericalAxisParams.BinningMode.NONE) {
                    return 2 + ((NullableDoubleArrayList)((Object)data)).countNonNull();
                }
                if (def.numParams.mode == NumericalAxisParams.BinningMode.FIXED_SIZE) {
                    NullableLongArrayList values = (NullableLongArrayList)((Object)data);
                    return 1 + (int)((double)(values.max() - values.min()) / def.numParams.binSize);
                }
                if (def.numParams.mode == NumericalAxisParams.BinningMode.FIXED_NB) {
                    return 1 + def.numParams.nbBins;
                }
                if (def.numParams.mode == NumericalAxisParams.BinningMode.CUSTOM) {
                    return def.numParams.customBinValues.size() + 1;
                }
                throw new UnsupportedOperationException("Invalid numerical binning mode: " + String.valueOf((Object)def.numParams.mode));
            }
            case DATE: {
                return DateBinner.getNbBins(def.dateParams.mode, (TLongArrayList)data);
            }
        }
        throw new UnsupportedOperationException("Failed to construct the appropriate binner from the materialized axis");
    }

    private AlphanumAxisBinner buildAlphanumBinner(AxisDef def, ArrayList<String> data) {
        return new AlphanumAxisBinner(data, def.sortPrune.generateOthersCategory, this.generateTotalBin);
    }

    private AxisBinner buildNumericalBinner(AxisDef def, Object data) {
        if (def.numParams.mode == NumericalAxisParams.BinningMode.NONE) {
            return new UnbinnedNumericalAxisBinner((NullableDoubleArrayList)((Object)data), def.sortPrune.generateOthersCategory, this.generateTotalBin);
        }
        if (def.numParams.mode == NumericalAxisParams.BinningMode.FIXED_NB || def.numParams.mode == NumericalAxisParams.BinningMode.FIXED_SIZE || def.numParams.mode == NumericalAxisParams.BinningMode.CUSTOM) {
            return new BinnedNumericalAxisBinner((NullableLongArrayList)((Object)data), def, this.stats, def.sortPrune.sortType == AxisSortPrune.SortType.NATURAL, this.generateTotalBin);
        }
        throw new UnsupportedOperationException("Invalid numerical binning mode: " + String.valueOf((Object)def.numParams.mode));
    }

    private AxisBinner buildDateBinner(AxisDef def, TLongArrayList data) {
        boolean natural = def.sortPrune.sortType == AxisSortPrune.SortType.NATURAL;
        return new DateBinner(def.dateParams.mode, data, natural, this.generateTotalBin);
    }

    public static Class<?> getStorageType(AxisDef def) {
        return switch (def.type) {
            case AxisDef.Type.ALPHANUM -> String.class;
            case AxisDef.Type.NUMERICAL -> BinnerBuilder.getNumericalStorageType(def.numParams.mode);
            case AxisDef.Type.DATE -> Long.class;
            default -> throw new UnsupportedOperationException("Unsupported axis type: " + String.valueOf((Object)def.type));
        };
    }

    private static Class<?> getNumericalStorageType(NumericalAxisParams.BinningMode mode) {
        return switch (mode) {
            case NumericalAxisParams.BinningMode.NONE -> Double.class;
            case NumericalAxisParams.BinningMode.FIXED_NB, NumericalAxisParams.BinningMode.FIXED_SIZE, NumericalAxisParams.BinningMode.CUSTOM -> Long.class;
            default -> throw new UnsupportedOperationException("Unsupported binning mode: " + String.valueOf((Object)mode));
        };
    }
}

