/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.excel.BaseDataSheet2DBuilder;
import com.dataiku.dip.pivot.frontend.excel.CellStyler;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartSources;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartTextSource;
import com.dataiku.dip.pivot.frontend.excel.xssf.ChartUtils;
import com.dataiku.dip.pivot.frontend.excel.xssf.SheetUtils;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Workbook;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellRangeAddress;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StdAggrDataSheet2DBuilder
extends BaseDataSheet2DBuilder {
    public static DataSheet2DRef buildMatrixSheet(XSSFWorkbook workbook, ChartDef chartDef, final PivotTableTensorResponse response, int animationFrameIdx) {
        final XSSFSheet sheet = workbook.createSheet("Data");
        CellStyler styler = new CellStyler((Workbook)workbook);
        CellStyle titleStyle = styler.getTitleStyle();
        CellStyle subTitleStyle = styler.getSubtitleStyle();
        CellStyle headerStyle = styler.getHeaderStyle();
        SheetUtils.writeCell(sheet, 0, 0, chartDef.name).setCellStyle(titleStyle);
        SheetUtils.writeCell(sheet, 1, 0, com.dataiku.dip.pivot.frontend.ChartUtils.getNiceMeasureName(chartDef.genericMeasures.get(0))).setCellStyle(subTitleStyle);
        SheetUtils.writeCell(sheet, 2, 0, com.dataiku.dip.pivot.frontend.ChartUtils.getNiceDimensionName(ChartUtils.getGenericDimension(chartDef))).setCellStyle(headerStyle);
        StdAggrDataSheet2DBuilder.fill(sheet, response, styler, headerStyle, animationFrameIdx);
        StdAggrDataSheet2DBuilder.appendFilteringDetails(chartDef, sheet);
        SheetUtils.autoFitColumns(sheet);
        return new DataSheet2DRef(){

            @Override
            public XSSFSheet getSheet() {
                return sheet;
            }

            @Override
            public XDDFDataSource<String> getXAxisSource() {
                return XDDFDataSourcesFactory.fromStringCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(3, 2 + response.axisLabels[0].size(), 0, 0));
            }

            @Override
            public ChartTextSource getTitleSource() {
                return ChartSources.fromCellRange(sheet, new CellRangeAddress(0, 0, 0, 0));
            }

            @Override
            public ChartTextSource getAggregationTitle() {
                return ChartSources.fromCellRange(sheet, new CellRangeAddress(1, 1, 0, 0));
            }

            @Override
            public ChartTextSource getFirstAxisTitle() {
                return ChartSources.fromCellRange(sheet, new CellRangeAddress(2, 2, 0, 0));
            }

            @Override
            public int getSerieCount() {
                return response.axisLabels[1].size();
            }

            @Override
            public ChartTextSource getSerieTitleSource(int yIdx) {
                return ChartSources.fromCellRange(sheet, new CellRangeAddress(2, 2, 1 + yIdx, 1 + yIdx));
            }

            @Override
            public XDDFNumericalDataSource<Double> getSerieSource(int yIdx) {
                return XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(3, 2 + response.axisLabels[0].size(), 1 + yIdx, 1 + yIdx));
            }
        };
    }

    public static interface DataSheet2DRef {
        public XSSFSheet getSheet();

        public XDDFDataSource<String> getXAxisSource();

        public ChartTextSource getTitleSource();

        public int getSerieCount();

        public ChartTextSource getSerieTitleSource(int var1);

        public XDDFNumericalDataSource<Double> getSerieSource(int var1);

        public ChartTextSource getAggregationTitle();

        public ChartTextSource getFirstAxisTitle();
    }
}

