/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntime;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.containers.exec.UsedContainerExec;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.CodeStudioObjectsDAO;
import com.dataiku.dip.dao.CodeStudioTemplatesDAO;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.SearchNotebooksDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.datasets.DatasetConnectionUtils;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.datasets.fs.FilesystemDatasetHandler;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.labeling.AnnotationService;
import com.dataiku.dip.labeling.AnswerList;
import com.dataiku.dip.labeling.BaseLabelingAnswer;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeUtils;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderCodes;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.MECPaths;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginVersionUtils;
import com.dataiku.dip.plugins.model.InstalledPluginDesc;
import com.dataiku.dip.projects.importexport.AbstractCodeEnvRemapper;
import com.dataiku.dip.projects.importexport.AutomationNodeCodeEnvRemapper;
import com.dataiku.dip.projects.importexport.BundleActivator;
import com.dataiku.dip.projects.importexport.BundleCodes;
import com.dataiku.dip.projects.importexport.ConnectionRemapper;
import com.dataiku.dip.projects.importexport.ContainerExecRemapper;
import com.dataiku.dip.projects.importexport.DesignNodeCodeEnvRemapper;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.RunAsUserAdjuster;
import com.dataiku.dip.projects.importexport.model.BundleContentSummary;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.projects.importexport.timeline.TimelineImporterProvider;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.searchnotebooks.SearchNotebook;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DatasetFileTransferer;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsDAO;
import com.dataiku.dip.wikis.WikisService;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectImporterBase {
    public static final String KNOWLEDGE_BANK_FOLDER_NAME = "knowledge-banks";
    protected String targetProjectKey;
    protected File importSourceDirectory;
    protected boolean deleteImportSourceDirectory;
    protected final AuthCtx authCtx;
    @Autowired
    protected ProjectsService projectsService;
    @Autowired
    protected ConnectionsDAO connectionsDAO;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    protected RecipesDAO recipesDAO;
    @Autowired
    protected ScenariosDAO scenariosDAO;
    @Autowired
    protected WebAppsDAO webAppsDAO;
    @Autowired
    protected InsightsDAO insightsDAO;
    @Autowired
    protected ProjectsDAO projectsDAO;
    @Autowired
    protected SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    protected SearchNotebooksDAO searchNotebooksDAO;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected SavedModelsDAO savedModelsDAO;
    @Autowired
    protected ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    protected ManagedFolderDAO managedFolderDAO;
    @Autowired
    protected CodeStudioObjectsDAO codeStudioObjectsDAO;
    @Autowired
    protected CodeStudioTemplatesDAO codeStudioTemplatesDAO;
    @Autowired
    protected LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private WikisService wikisService;
    @Autowired
    protected IPluginsRegistryService pluginsService;
    @Autowired
    protected DatasetAccessService datasetAccessService;
    @Autowired
    protected ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    protected AnalysisCRUDService analysisCRUDService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private IPermissionsService permissionService;
    @Autowired
    private AnnotationService annotationService;
    @Autowired
    private TimelineImporterProvider timelineImporterProvider;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    @Autowired
    private PluginUsagesInspector pluginUsagesInspector;
    @Autowired
    protected RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    protected AgentToolsDAO agentToolsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.bundles.import");

    protected ProjectImporterBase(AuthCtx authCtx) {
        this.authCtx = authCtx;
    }

    protected File importFile(String ... chunks) {
        return DKUFileUtils.getWithin((File)this.importSourceDirectory, (String[])chunks);
    }

    protected void importWholeConfig() throws Exception {
        NativeFS srcFolderFS = NativeFS.from((File)this.importSourceDirectory).build();
        RWTransactionRef t = TransactionContext.retrieveWrite();
        FSUtils.newRecursiveCopy().from((ReadOnlyFS)srcFolderFS, "project_config").to((ReadWriteFS)t, new RelFile(new String[]{"projects", this.targetProjectKey})).run();
    }

    protected void importWikiData() throws IOException {
        File dir = this.importFile("wiki-attachments");
        if (dir.isDirectory()) {
            DKUFileUtils.copyDirectory((File)dir, (File)ApplicationConfigurator.getFile((String[])new String[]{"wiki-attachments", this.targetProjectKey}));
        }
        if (TransactionContext.hasAttachedTransaction()) {
            this.wikisService.removeForbiddenAttachments(this.targetProjectKey);
        } else {
            try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
                boolean needCommit = this.wikisService.removeForbiddenAttachments(this.targetProjectKey);
                if (needCommit) {
                    t.commit("Removed Wiki attachments with forbidden extensions");
                }
            }
        }
    }

    protected void v3CheckConnectionsWritability(ExportedProject ep, InfoMessage.InfoMessages ims) throws IOException, DKUSecurityException {
        DSSConnection conn;
        List<DatasetConnectionUtils.UsedConnection> usedConnections;
        DatasetConnectionUtils dcu = new DatasetConnectionUtils();
        for (BundleContentSummary.IncludedDataset id : ep.actualContent.includedDatasets) {
            SerializedDataset ds = (SerializedDataset)this.datasetsDAO.getMandatory(this.targetProjectKey, id.name);
            usedConnections = dcu.getUsedConnections(this.authCtx, ds, false);
            for (DatasetConnectionUtils.UsedConnection used : usedConnections) {
                conn = this.connectionsDAO.getConnection(this.authCtx, used.name);
                if (conn == null) {
                    if (ep.allowedMissingConnections.contains(used.name)) continue;
                    throw ErrorContext.iaef((String)"Connection %s does not exist", (Object)used.name, (Object[])new Object[0]);
                }
                if (conn.allowWrite) continue;
                ims.withFatal((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_CONNECTION_NOT_WRITABLE, "Write not allowed on connection " + used.name + ", cannot import data of included dataset " + id.name);
            }
        }
        for (BundleContentSummary.IncludedManagedFolder imf : ep.actualContent.includedManagedFolders) {
            ManagedFolder mf = (ManagedFolder)this.managedFolderDAO.getMandatory(this.targetProjectKey, imf.id);
            usedConnections = dcu.getUsedConnections(this.authCtx, mf, false);
            for (DatasetConnectionUtils.UsedConnection used : usedConnections) {
                conn = this.connectionsDAO.getConnection(this.authCtx, used.name);
                if (conn == null) {
                    if (ep.allowedMissingConnections.contains(used.name)) continue;
                    throw ErrorContext.iaef((String)"Connection %s does not exist", (Object)used.name, (Object[])new Object[0]);
                }
                if (conn.allowWrite) continue;
                ims.withFatal((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_CONNECTION_NOT_WRITABLE, "Write not allowed on connection " + used.name + ", cannot import data of included managed folder " + imf.name);
            }
        }
    }

    protected void v3CheckConnectionsWritabilityWithFail(ExportedProject ep) throws IOException, DKUSecurityException {
        DSSConnection conn;
        List<DatasetConnectionUtils.UsedConnection> usedConnections;
        DatasetConnectionUtils dcu = new DatasetConnectionUtils();
        for (BundleContentSummary.IncludedDataset id : ep.actualContent.includedDatasets) {
            SerializedDataset ds = (SerializedDataset)this.datasetsDAO.getMandatory(this.targetProjectKey, id.name);
            usedConnections = dcu.getUsedConnections(this.authCtx, ds, false);
            for (DatasetConnectionUtils.UsedConnection used : usedConnections) {
                conn = this.connectionsDAO.getConnection(this.authCtx, used.name);
                if (conn == null) {
                    if (ep.allowedMissingConnections.contains(used.name)) continue;
                    throw ErrorContext.iaef((String)"Connection %s does not exist", (Object)used.name, (Object[])new Object[0]);
                }
                if (conn.allowWrite) continue;
                throw new SecurityException("Write not allowed on connection " + used.name + ", cannot import data of included dataset " + id.name);
            }
        }
        for (BundleContentSummary.IncludedManagedFolder imf : ep.actualContent.includedManagedFolders) {
            ManagedFolder mf = (ManagedFolder)this.managedFolderDAO.getMandatory(this.targetProjectKey, imf.id);
            usedConnections = dcu.getUsedConnections(this.authCtx, mf, false);
            for (DatasetConnectionUtils.UsedConnection used : usedConnections) {
                conn = this.connectionsDAO.getConnection(this.authCtx, used.name);
                if (conn == null) {
                    if (ep.allowedMissingConnections.contains(used.name)) continue;
                    throw ErrorContext.iaef((String)"Connection %s does not exist", (Object)used.name, (Object[])new Object[0]);
                }
                if (conn.allowWrite) continue;
                throw new SecurityException("Write not allowed on connection " + used.name + ", cannot import data of included managed folder " + imf.name);
            }
        }
    }

    protected void v3ForceReloadedDatasetsPath(ExportedProject ep) throws IOException, DKUSecurityException {
        for (BundleContentSummary.IncludedDataset id : ep.actualContent.includedDatasets) {
            SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(this.targetProjectKey, id.name);
            if (!"Filesystem".equals(sd.type)) continue;
            String connName = sd.getParamsAs(FilesystemDatasetConfig.class).connection;
            DSSConnection connForTesting = this.connectionsDAO.getConnection(this.authCtx, connName);
            if (connForTesting == null && ep.allowedMissingConnections.contains(connName)) {
                logger.infoV("Not forcing path in missing connection %s (allowed missing)", new Object[]{connName});
                continue;
            }
            FsConnection conn = this.connectionsDAO.getMandatoryConnectionAs(this.authCtx, connName, FsConnection.class);
            if (!conn.params.forcePathsOnDatasetsImport) continue;
            logger.infoV("Forcing path in connection (%s) for FS dataset (%s)", new Object[]{connName, sd.name});
            String newPath = "/" + this.targetProjectKey + "." + sd.name;
            sd.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).path = newPath;
            logger.info((Object)("Forced path to " + newPath));
            this.datasetsDAO.save(sd);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void v3ReloadDataset(BundleContentSummary.IncludedDataset idd, Collection<InfoMessage> messages) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f2 = FutureProgress.pushAutoCloseableState((String)("Importing dataset data: " + idd.name));){
            Dataset dataset = null;
            try (Transaction t = this.transactionService.beginRead();){
                dataset = this.datasetAccessService.getMandatory(this.targetProjectKey, idd.name);
            }
            switch (idd.usedTransferMethod) {
                case RAW_FILES: {
                    this.reloadFSDatasetData(dataset, messages);
                    return;
                }
                case UPLOAD: {
                    this.reloadUploadedDatasetData(dataset, messages);
                    return;
                }
                case DATA_BUNDLE: {
                    this.reloadAnyDatasetData(dataset, messages);
                    return;
                }
                case INLINE: {
                    this.reloadInlineDatasetData(dataset, messages);
                    return;
                }
            }
            return;
        }
    }

    protected void v3ReloadManagedFolder(BundleContentSummary.IncludedManagedFolder ism) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f2 = FutureProgress.pushAutoCloseableState((String)("Importing managed folder data: " + ism.id));){
            ManagedFolder managedFolder;
            try (Transaction t = this.transactionService.beginRead();){
                managedFolder = (ManagedFolder)this.managedFolderDAO.getMandatory(this.targetProjectKey, ism.id);
            }
            this.reloadManagedFolderData(managedFolder);
        }
    }

    protected void v3ReloadLabelingTask(BundleContentSummary.IncludedLabelingTask includedLabelingTask) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f2 = FutureProgress.pushAutoCloseableState((String)("Importing labeling task data: " + includedLabelingTask.id));){
            LabelingTask labelingTask;
            try (Transaction t = this.transactionService.beginRead();){
                labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(this.targetProjectKey, includedLabelingTask.id);
            }
            this.reloadLabelingTaskData(labelingTask);
        }
    }

    protected void v3ReloadSavedModel(BundleContentSummary.IncludedSavedModel ism) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f2 = FutureProgress.pushAutoCloseableState((String)("Importing saved model data: " + ism.id));){
            SavedModel savedModel;
            try (Transaction t = this.transactionService.beginRead();){
                savedModel = (SavedModel)this.savedModelsDAO.getMandatory(this.targetProjectKey, ism.id);
            }
            this.reloadSavedModelData(savedModel);
        }
    }

    protected void v3ReloadModelEvaluationStore(BundleContentSummary.IncludedModelEvaluationStore imes) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f2 = FutureProgress.pushAutoCloseableState((String)("Importing model evaluation store data: " + imes.id));){
            ModelEvaluationStore modelEvaluationStore;
            try (Transaction t = this.transactionService.beginRead();){
                modelEvaluationStore = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatory(this.targetProjectKey, imes.id);
            }
            this.reloadModelEvaluationStoreData(modelEvaluationStore);
        }
    }

    protected void v3ReloadCodeStudio(BundleContentSummary.IncludedCodeStudio ikub) throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState f2 = FutureProgress.pushAutoCloseableState((String)("Importing Code Studio data: " + ikub.id));){
            CodeStudioObject kub;
            try (Transaction t = this.transactionService.beginRead();){
                kub = (CodeStudioObject)this.codeStudioObjectsDAO.getMandatory(this.targetProjectKey, ikub.id);
            }
            this.reloadCodeStudioData(kub);
        }
    }

    protected void v3ReloadAllData(ExportedProject ep, Collection<InfoMessage> messages) throws InterruptedException {
        this.v3ReloadAllDataExceptTimeline(ep, messages);
        this.importTimeline(ep);
    }

    protected void v3ReloadAllDataExceptTimeline(ExportedProject ep, Collection<InfoMessage> messages) throws InterruptedException {
        File srcDir;
        int i;
        try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Importing saved models", (double)ep.actualContent.includedSavedModels.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            i = 0;
            for (BundleContentSummary.IncludedSavedModel includedSavedModel : ep.actualContent.includedSavedModels) {
                srcDir = this.importFile("saved_models", includedSavedModel.id);
                if (!srcDir.isDirectory()) {
                    logger.warn((Object)"No data for saved model");
                    messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_SAVED_MODEL_NO_DATA, (String)("No data for saved model: " + includedSavedModel.id)));
                    continue;
                }
                try {
                    this.v3ReloadSavedModel(includedSavedModel);
                }
                catch (Exception e) {
                    logger.warn((Object)"Got error while importing a bundle saved model", (Throwable)e);
                    messages.add(InfoMessage.error((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_SAVED_MODEL_LOAD_FAILED, (String)(includedSavedModel.id + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e))));
                }
                FutureProgress.updateState((double)(++i));
            }
        }
        f = FutureProgress.pushAutoCloseableState((String)"Importing model evaluation stores", (double)ep.actualContent.includedModelEvaluationStores.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
        try {
            i = 0;
            for (BundleContentSummary.IncludedModelEvaluationStore includedModelEvaluationStore : ep.actualContent.includedModelEvaluationStores) {
                srcDir = this.importFile("model_evaluation_stores", includedModelEvaluationStore.id);
                if (!srcDir.isDirectory()) {
                    logger.warn((Object)"No data for model evaluation store");
                    messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_MODEL_EVALUATION_STORE_NO_DATA, (String)("No data for model evaluation store: " + includedModelEvaluationStore.id)));
                    continue;
                }
                try {
                    this.v3ReloadModelEvaluationStore(includedModelEvaluationStore);
                }
                catch (Exception e) {
                    logger.warn((Object)"Got error while importing a bundle model evaluation store", (Throwable)e);
                    messages.add(InfoMessage.error((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_MODEL_EVALUATION_STORE_LOAD_FAILED, (String)(includedModelEvaluationStore.id + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e))));
                }
                FutureProgress.updateState((double)(++i));
            }
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
        f = FutureProgress.pushAutoCloseableState((String)"Importing Code Studios", (double)ep.actualContent.includedCodeStudios.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
        try {
            i = 0;
            for (BundleContentSummary.IncludedCodeStudio includedCodeStudio : ep.actualContent.includedCodeStudios) {
                srcDir = this.importFile("code_studios", includedCodeStudio.id);
                if (!srcDir.isDirectory()) {
                    logger.warn((Object)"No data for Code Studio");
                    messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_CODE_STUDIO_NO_DATA, (String)("No data for Code Studio: " + includedCodeStudio.id)));
                    continue;
                }
                try {
                    this.v3ReloadCodeStudio(includedCodeStudio);
                }
                catch (Exception e) {
                    logger.warn((Object)"Got error while importing a bundle Code Studio", (Throwable)e);
                    messages.add(InfoMessage.error((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_CODE_STUDIO_LOAD_FAILED, (String)(includedCodeStudio.id + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e))));
                }
                FutureProgress.updateState((double)(++i));
            }
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
        f = FutureProgress.pushAutoCloseableState((String)"Importing datasets data", (double)ep.actualContent.includedDatasets.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
        try {
            i = 0;
            for (BundleContentSummary.IncludedDataset includedDataset : ep.actualContent.includedDatasets) {
                try {
                    this.v3ReloadDataset(includedDataset, messages);
                }
                catch (Exception e) {
                    logger.warn((Object)"Got error while importing a bundle dataset", (Throwable)e);
                    messages.add(InfoMessage.error((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_DATASET_LOAD_FAILED, (String)(includedDataset.name + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e))));
                }
                FutureProgress.peekState().set((double)(++i));
            }
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
        if (ep.exportedWithOptions.exportDatasetResources) {
            f = FutureProgress.pushAutoCloseableState((String)"Importing datasets resources", (double)ep.actualContent.includedDatasets.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
            try {
                i = 0;
                for (BundleContentSummary.IncludedDataset includedDataset : ep.actualContent.includedDatasets) {
                    try {
                        this.importDatasetResources(includedDataset);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Got error while importing dataset resources", (Throwable)e);
                        messages.add(InfoMessage.error((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_DATASET_RESOURCES_LOAD_FAILED, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    }
                }
                FutureProgress.peekState().set((double)(++i));
            }
            finally {
                if (f != null) {
                    f.close();
                }
            }
        }
        f = FutureProgress.pushAutoCloseableState((String)"Importing managed folders data", (double)ep.actualContent.includedManagedFolders.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
        try {
            i = 0;
            for (BundleContentSummary.IncludedManagedFolder includedManagedFolder : ep.actualContent.includedManagedFolders) {
                try {
                    this.v3ReloadManagedFolder(includedManagedFolder);
                }
                catch (Exception e) {
                    logger.warn((Object)"Got error while importing a bundle managed folder", (Throwable)e);
                    messages.add(InfoMessage.error((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_MANAGED_FOLDER_LOAD_FAILED, (String)(includedManagedFolder.id + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e))));
                }
                FutureProgress.updateState((double)(++i));
            }
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
        f = FutureProgress.pushAutoCloseableState((String)"Importing labeling tasks data", (double)ep.actualContent.includedLabelingTasks.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
        try {
            i = 0;
            for (BundleContentSummary.IncludedLabelingTask includedLabelingTask : ep.actualContent.includedLabelingTasks) {
                try {
                    this.v3ReloadLabelingTask(includedLabelingTask);
                }
                catch (Exception e) {
                    logger.warn((Object)"Got error while importing a bundle labeling task", (Throwable)e);
                    messages.add(InfoMessage.error((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_LABELING_TASK_LOAD_FAILED, (String)(includedLabelingTask.id + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e))));
                }
                FutureProgress.updateState((double)(++i));
            }
        }
        finally {
            if (f != null) {
                f.close();
            }
        }
    }

    private void importTimeline(ExportedProject exportedProject) {
        logger.debugV("Importing timeline for %s", new Object[]{this.targetProjectKey});
        try {
            this.timelineImporterProvider.importer(this.importSourceDirectory, this.targetProjectKey, exportedProject).importTimeline();
        }
        catch (IOException e) {
            logger.errorV((Throwable)e, "Failed to load timeline archive file for %s.", new Object[]{this.targetProjectKey});
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Failed to import timeline for %s", new Object[]{this.targetProjectKey});
        }
    }

    protected void importProjectResources() throws IOException {
        if (this.importFile("project-resources").isDirectory()) {
            DKUFileUtils.copyDirectory((File)this.importFile("project-resources"), (File)ApplicationConfigurator.getFile((String[])new String[]{"lib", "projects", this.targetProjectKey}));
        }
    }

    protected void importNotebooksOutputs() throws IOException {
        if (this.importFile("notebook_results", "jupyter").isDirectory()) {
            DKUFileUtils.copyDirectory((File)this.importFile("notebook_results", "jupyter"), (File)ApplicationConfigurator.getFile((String[])new String[]{"notebook_results", "jupyter", this.targetProjectKey}));
        }
    }

    protected void deleteImportedNotebooksOutputsExcept(Set<String> localNotebookIds) throws IOException {
        File notebookResults = ApplicationConfigurator.getFile((String[])new String[]{"notebook_results", "jupyter", this.targetProjectKey});
        if (!notebookResults.isDirectory()) {
            return;
        }
        if (localNotebookIds.isEmpty()) {
            DKUFileUtils.deleteDirectory((File)notebookResults);
        } else {
            for (File f : DKUFileUtils.recursiveListFiles((File)notebookResults)) {
                if (localNotebookIds.contains(f.getName())) continue;
                DKUFileUtils.delete((File)f);
            }
        }
    }

    protected void importInsightsData() throws IOException {
        if (this.importFile("insights-data").isDirectory()) {
            DKUFileUtils.copyDirectory((File)this.importFile("insights-data"), (File)ApplicationConfigurator.getFile((String[])new String[]{"insights-data", this.targetProjectKey}));
        }
    }

    protected void deleteInsightsData() throws IOException {
        if (ApplicationConfigurator.getFile((String[])new String[]{"insights-data", this.targetProjectKey}).isDirectory()) {
            DKUFileUtils.deleteDirectory((File)ApplicationConfigurator.getFile((String[])new String[]{"insights-data", this.targetProjectKey}));
        }
    }

    protected void importPromptStudioHistories() throws IOException {
        if (this.importFile("prompt-studios").isDirectory()) {
            DKUFileUtils.copyDirectory((File)this.importFile("prompt-studios"), (File)ApplicationConfigurator.getFile((String[])new String[]{"prompt-studios", this.targetProjectKey}));
        }
    }

    protected void importKnowledgeBanksData() throws IOException, InterruptedException {
        if (this.importFile(KNOWLEDGE_BANK_FOLDER_NAME).isDirectory()) {
            File projectKnowledgeBanks = ApplicationConfigurator.getFile((String[])new String[]{KNOWLEDGE_BANK_FOLDER_NAME, this.targetProjectKey});
            DKUFileUtils.copyDirectory((File)this.importFile(KNOWLEDGE_BANK_FOLDER_NAME), (File)projectKnowledgeBanks);
            if (projectKnowledgeBanks.isDirectory()) {
                for (File kbFolder : projectKnowledgeBanks.listFiles()) {
                    if (!kbFolder.isDirectory()) continue;
                    FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(kbFolder);
                }
            }
        }
    }

    protected void importDatasetResources(BundleContentSummary.IncludedDataset dataset) throws IOException, InterruptedException {
        File srcDatasetResourcesFolder = this.importFile("dataset_resources", dataset.name);
        if (srcDatasetResourcesFolder.isDirectory()) {
            File projectDatasetResources = DKUApp.getFile((String[])new String[]{"dataset_resources", this.targetProjectKey, dataset.name});
            DKUFileUtils.copyDirectory((File)srcDatasetResourcesFolder, (File)projectDatasetResources);
            if (projectDatasetResources.isDirectory()) {
                FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(projectDatasetResources);
            }
        }
    }

    private void reloadInlineDatasetData(Dataset dataset, Collection<InfoMessage> messages) {
        logger.infoV("Reloading Inline datasets data: %s", new Object[]{dataset.getFullName()});
        File srcDir = this.importFile("project_config", "datasets", dataset.getName() + ".data");
        if (!srcDir.isFile()) {
            logger.warnV("No data for dataset %s", new Object[]{dataset.getFullName()});
            messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_DATASET_NO_DATA, (String)("No data for " + dataset.getFullName())));
            return;
        }
        SerializedDataset sd = dataset.getModel();
        this.neverBuiltComputablesCacheService.remove(new TaggableObjectsService.TaggableObjectRef(this.targetProjectKey, sd.getTaggableType(), sd.getId()));
        logger.infoV("Inline dataset %s reloaded", new Object[]{dataset.getFullName()});
    }

    private void reloadFSDatasetData(Dataset dataset, Collection<InfoMessage> messages) throws Exception {
        logger.infoV("Reloading FS datasets data: %s", new Object[]{dataset.getFullName()});
        File srcDir = this.importFile("fs_datasets_data", dataset.getName());
        if (!srcDir.isDirectory()) {
            logger.warnV("No data for dataset %s", new Object[]{dataset.getFullName()});
            messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_DATASET_NO_DATA, (String)("No data for " + dataset.getFullName())));
            return;
        }
        try (FilesystemDatasetHandler fsdh = (FilesystemDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            fsdh.transferFrom(srcDir);
        }
        SerializedDataset sd = dataset.getModel();
        this.neverBuiltComputablesCacheService.remove(new TaggableObjectsService.TaggableObjectRef(this.targetProjectKey, sd.getTaggableType(), sd.getId()));
        logger.infoV("Copy done", new Object[0]);
    }

    private void reloadAnyDatasetData(Dataset dataset, Collection<InfoMessage> messages) throws Exception {
        if (dataset.getType().equals("ExperimentsDB")) {
            logger.infoV("Skipping data reload for experiment tracking dataset: %s", new Object[]{dataset.getFullName()});
            return;
        }
        File srcDir = this.importFile("any_datasets_data", dataset.getName());
        if (!srcDir.isDirectory()) {
            logger.warnV("No data for dataset %s", new Object[]{dataset.getFullName()});
            messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_DATASET_NO_DATA, (String)("No data for " + dataset.getFullName())));
            return;
        }
        DatasetFileTransferer dft = new DatasetFileTransferer();
        dft.loadDatasetFromDir(this.authCtx, srcDir, dataset);
        SerializedDataset sd = dataset.getModel();
        this.neverBuiltComputablesCacheService.remove(new TaggableObjectsService.TaggableObjectRef(this.targetProjectKey, sd.getTaggableType(), sd.getId()));
    }

    protected void reloadUploadedDatasetData(Dataset dataset, Collection<InfoMessage> messages) throws Exception {
        assert (dataset.getType().equals("UploadedFiles"));
        File srcDir = this.importFile("uploads", dataset.getName());
        if (!srcDir.isDirectory()) {
            logger.warnV("No data for dataset %s", new Object[]{dataset.getFullName()});
            messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_DATASET_NO_DATA, (String)("No data for " + dataset.getFullName())));
            return;
        }
        try (AbstractFSDatasetHandler fsdh = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            if (fsdh instanceof UploadedFilesDatasetHandler) {
                UploadedFilesDatasetHandler ufdh = (UploadedFilesDatasetHandler)fsdh;
                ufdh.getRealHandler().createManaged();
            }
            fsdh.transferFrom(srcDir);
        }
        SerializedDataset sd = dataset.getModel();
        this.neverBuiltComputablesCacheService.remove(new TaggableObjectsService.TaggableObjectRef(this.targetProjectKey, sd.getTaggableType(), sd.getId()));
    }

    protected void reloadSavedModelData(SavedModel savedModel) throws Exception {
        File srcDir = this.importFile("saved_models", savedModel.id);
        File dstDir = MLPaths.savedModelBaseFolder(savedModel);
        if (!srcDir.isDirectory()) {
            throw ErrorContext.iae((String)("Invalid import bundle: did not find " + String.valueOf(srcDir)));
        }
        if (dstDir.exists()) {
            DKUFileUtils.forceDelete((File)dstDir);
        }
        DKUFileUtils.copyDirectory((File)srcDir, (File)dstDir);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(dstDir);
    }

    protected void reloadModelEvaluationStoreData(ModelEvaluationStore modelEvaluationStore) throws Exception {
        File srcDir = this.importFile("model_evaluation_stores", modelEvaluationStore.id);
        File dstDir = MECPaths.modelEvaluationStoreBaseFolder(modelEvaluationStore);
        if (!srcDir.isDirectory()) {
            throw ErrorContext.iae((String)("Invalid import bundle: did not find " + String.valueOf(srcDir)));
        }
        if (dstDir.exists()) {
            DKUFileUtils.forceDelete((File)dstDir);
        }
        DKUFileUtils.copyDirectory((File)srcDir, (File)dstDir);
        MECPaths.restrictPermissionsMESFolder(dstDir);
    }

    protected void reloadCodeStudioData(CodeStudioObject codeStudio) throws Exception {
        File srcDir = this.importFile("code_studios", codeStudio.id);
        File dstDir = CodeStudioRuntime.getResourcesCodeStudioFolder(codeStudio);
        if (!srcDir.isDirectory()) {
            throw ErrorContext.iae((String)("Invalid import bundle: did not find " + String.valueOf(srcDir)));
        }
        if (dstDir.exists()) {
            DKUFileUtils.forceDelete((File)dstDir);
        }
        DKUFileUtils.copyDirectory((File)srcDir, (File)dstDir);
    }

    protected void reloadManagedFolderData(ManagedFolder managedFolder) throws Exception {
        File srcDir = this.importFile("managed_folders", managedFolder.id);
        try (ManagedFolderHandler handler = (ManagedFolderHandler)managedFolder.buildHandler(this.authCtx);){
            handler.transferFrom(srcDir);
        }
    }

    protected void reloadLabelingTaskData(LabelingTask labelingTask) throws Exception {
        File dir = this.importFile("labeling", labelingTask.id);
        if (dir.isDirectory()) {
            ArrayList<BaseLabelingAnswer> answers = new ArrayList<BaseLabelingAnswer>();
            answers.addAll(((AnswerList.LabelingAnswerList)JSON.parseFile((File)new File((File)dir, (String)"labeling-answers.json"), AnswerList.LabelingAnswerList.class)).labelingAnswers);
            answers.addAll(((AnswerList.VerifiedLabelingAnswerList)JSON.parseFile((File)new File((File)dir, (String)"verified-labeling-answers.json"), AnswerList.VerifiedLabelingAnswerList.class)).verifiedLabelingAnswers);
            for (BaseLabelingAnswer labelingAnswer : answers) {
                labelingAnswer.projectKey = this.targetProjectKey;
            }
            this.annotationService.importLabelingAnswers(answers);
        }
    }

    protected void checkPlugins(List<ExportedProject.InstalledPluginRef> exportInstancePluginList, String targetProjectKey, InfoMessage.InfoMessages result) {
        ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        boolean warningOnUsedPluginsOnly = gs.deployerClientSettings.getRef().warningOnUsedPluginsOnly;
        ArrayList<String> missingPlugins = new ArrayList<String>();
        block0: for (ExportedProject.InstalledPluginRef ipr : exportInstancePluginList) {
            PluginUsagesInspector.PluginUsages usages;
            InstalledPluginDesc ipd = this.pluginsService.getInstalledDesc(ipr.pluginId);
            if (ipd == null) {
                Object[] missingTypes;
                if (!warningOnUsedPluginsOnly) {
                    missingPlugins.add(ipr.pluginId);
                    continue;
                }
                usages = this.pluginUsagesInspector.getUsages(targetProjectKey, ipr.pluginId);
                if (usages.missingTypes.isEmpty()) continue;
                for (Object cur : missingTypes = usages.missingTypes.toArray()) {
                    PluginUsagesInspector.MissingType curMissingType = (PluginUsagesInspector.MissingType)cur;
                    if (!StringUtils.equals((String)curMissingType.pluginId, (String)ipr.pluginId)) continue;
                    logger.debug((Object)"Usage found, adding to missing plugins.");
                    missingPlugins.add(ipr.pluginId);
                    continue block0;
                }
                continue;
            }
            if (ipd.desc == null || ipd.desc.version == null || !this.shouldWarnOnPluginVersion(ipd.desc.version, ipr.version)) continue;
            if (!warningOnUsedPluginsOnly) {
                this.addPluginVersionMismatchWarning(result, nodeType, ipr, ipd);
                continue;
            }
            usages = this.pluginUsagesInspector.getUsages(targetProjectKey, ipr.pluginId);
            if (usages.usages.isEmpty()) continue;
            this.addPluginVersionMismatchWarning(result, nodeType, ipr, ipd);
        }
        if (!missingPlugins.isEmpty()) {
            String messageVerb = !warningOnUsedPluginsOnly ? "with" : "using";
            if (missingPlugins.size() == 1) {
                result.messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_MISSING_PLUGIN, (String)("Bundle was created on a design node " + messageVerb + " plugin " + (String)missingPlugins.get(0) + " but it's not installed")));
            } else {
                result.messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_MISSING_PLUGIN, (String)("Bundle was created on a design node " + messageVerb + " plugins " + StringUtils.join(missingPlugins, (String)", ") + " but they're not installed")));
            }
        }
    }

    private void addPluginVersionMismatchWarning(InfoMessage.InfoMessages result, ApplicationConfigurator.DSSNodeType nodeType, ExportedProject.InstalledPluginRef ipr, InstalledPluginDesc ipd) {
        result.messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_PLUGIN_VERSION_MISMATCH, (String)("Bundle was created on a design node using plugin " + ipr.pluginId + " version " + ipr.version + " but this " + nodeType.name().toLowerCase() + " node has version " + ipd.desc.version)));
    }

    private boolean shouldWarnOnPluginVersion(String installedPluginVersion, String exportedPluginVersion) {
        try {
            return PluginVersionUtils.comparePluginVersion(installedPluginVersion, exportedPluginVersion) < 0;
        }
        catch (Exception e) {
            return !installedPluginVersion.equals(exportedPluginVersion);
        }
    }

    protected void checkCodeStudioTemplates(ExportedProject ep, InfoMessage.InfoMessages result) throws IOException {
        ArrayList<String> missingCodeStudioTemplates = new ArrayList<String>();
        for (ExportedProject.InstalledCodeStudioTemplateRef icstr : ep.requiredCodeStudioTemplates) {
            CodeStudioTemplate kt = this.codeStudioTemplatesDAO.getOrNull(icstr.templateId);
            if (kt != null) continue;
            String txt = StringUtils.isBlank((String)icstr.templateLabel) ? String.format("[%s]", icstr.templateId) : String.format("[%s](%s)", icstr.templateId, icstr.templateLabel);
            missingCodeStudioTemplates.add(txt);
        }
        if (!missingCodeStudioTemplates.isEmpty()) {
            if (missingCodeStudioTemplates.size() == 1) {
                result.messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_MISSING_CODE_STUDIO_TEMPLATE, (String)("Bundle uses the Code Studio template " + (String)missingCodeStudioTemplates.get(0) + " but it's not installed")));
            } else {
                result.messages.add(InfoMessage.warning((InfoMessage.MessageCode)BundleCodes.WARN_BUNDLE_ACTIVATE_MISSING_CODE_STUDIO_TEMPLATE, (String)("Bundle uses the Code Studio templates " + StringUtils.join(missingCodeStudioTemplates, (String)", ") + " but they're not installed")));
            }
        }
    }

    protected void readAdditionalExportManifest(ExportedProject ep, File importPath) throws IOException {
        File additionsFile = new File(importPath, "export-manifest-additions.json");
        if (additionsFile.exists()) {
            logger.info((Object)"Found additions to the manifest");
            ExportedProject additions = (ExportedProject)JSON.parseFile((File)additionsFile, ExportedProject.class);
            for (Map.Entry<String, DatasetConnectionUtils.UsedConnection> requiredConnection : additions.requiredConnections.entrySet()) {
                if (ep.requiredConnections.containsKey(requiredConnection.getKey())) {
                    if (StringUtils.equals((String)requiredConnection.getValue().type, (String)ep.requiredConnections.get((Object)requiredConnection.getKey()).type)) continue;
                    logger.warn((Object)("Additional connection " + requiredConnection.getKey() + " conflicts in type with the one in the export manifest"));
                    continue;
                }
                ep.requiredConnections.put(requiredConnection.getKey(), requiredConnection.getValue());
            }
            for (CodeEnvModel.UsedCodeEnvRef usedCodeEnvRef : additions.usedCodeEnvRefs) {
                if (ep.usedCodeEnvRefs.contains(usedCodeEnvRef)) {
                    logger.warn((Object)("Additional code-env '" + usedCodeEnvRef.envName + "'(" + String.valueOf((Object)usedCodeEnvRef.envLang) + ")  already listed in used code envs, not adding it"));
                    continue;
                }
                ep.usedCodeEnvRefs.add(usedCodeEnvRef);
            }
            for (UsedContainerExec usedContainerExecConf : additions.usedContainerExecConfs) {
                if (ep.usedContainerExecConfs.contains(usedContainerExecConf)) {
                    logger.warn((Object)("Additional container-exec conf '" + usedContainerExecConf.name + "' already listed in used container-exec confs, not adding it"));
                    continue;
                }
                ep.usedContainerExecConfs.add(usedContainerExecConf);
            }
        } else {
            logger.info((Object)"No addition to the manifest");
        }
    }

    protected void fixFolderType(InfoMessage.InfoMessages ret, ManagedFolder folder) {
        try {
            if (!StringUtils.equals((String)"SCP", (String)folder.getType()) && !StringUtils.equals((String)"SFTP", (String)folder.getType())) {
                DSSConnection folderConnection = this.connectionsDAO.getMandatoryConnectionUnsafeUnexpanded(this.authCtx, folder.getParams().getConnection());
                FSProviderizableConnection providerizableConnection = (FSProviderizableConnection)((Object)folderConnection);
                if (folder.getType() == null || !providerizableConnection.getProviderTypes().contains(folder.getType())) {
                    logger.infoV("Fixing folder type because it's not compatible with its connection %s / %s", new Object[]{folder.type, folderConnection.getType()});
                    folder.type = providerizableConnection.getProviderTypes().get(0);
                    this.managedFolderDAO.save(folder);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to ensure the folder's connection is correct", (Throwable)e);
            ret.addMessage(InfoMessage.warning((InfoMessage.MessageCode)ManagedFolderCodes.WARN_FOLDER_CONNECTION_TYPE_ERROR, (String)("Failed to ensure that the folder type matches its connection : " + ExceptionUtils.getMessageWithCauses((Throwable)e))));
        }
    }

    protected void adjustRunAsUsers(StashedLocalConfig stashedLocalConfig, boolean inScenarios, boolean inWebApps, boolean inInsights) throws IOException {
        if (inScenarios) {
            new RunAsUserAdjuster.ScenarioRunAsAdjuster(this.scenariosDAO, this.authCtx, stashedLocalConfig, this.targetProjectKey).adjust();
        }
        if (inWebApps) {
            new RunAsUserAdjuster.WebappRunAsUserAdjuster(this.webAppsDAO, this.authCtx, stashedLocalConfig, this.targetProjectKey).adjust();
        }
        if (inInsights) {
            new RunAsUserAdjuster.InsightRunAsAdjuster(this.insightsDAO, this.authCtx, stashedLocalConfig, this.targetProjectKey).adjust();
        }
    }

    protected void shareForeignObjects(AuthCtx user, ExportedProject ep, InfoMessage.InfoMessages infoMessages) {
        for (TaggableObjectsService.TaggableObjectRef object : ep.foreignObjects) {
            try {
                ExposedObject exposedObject = this.exposedObjectsService.getExposedObject(object.projectKey, object.type, object.id);
                if (exposedObject != null && exposedObject.canAccess(this.targetProjectKey)) continue;
                SerializedProject project = this.getSerializedProject(object.projectKey);
                if (project != null) {
                    if (this.canShareObject(user, project, object)) {
                        this.exposedObjectsService.addExposedObject(object.projectKey, object.type, object.id, this.targetProjectKey);
                        continue;
                    }
                    infoMessages.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, String.format("Insufficient privileges to use the %s \"%s\" (from %s) in the imported project", object.type.toHumanReadableString(), object.id, object.projectKey), String.format("Ask an administrator of the project \"%s\" to share it with the imported project.", object.projectKey)));
                    continue;
                }
                infoMessages.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, String.format("%s \"%s\" will not be usable as its source project %s does not exist", object.type.toHumanReadableString(), object.id, object.projectKey), String.format("Import project \"%s\" on this instance or remove the %s \"%s\" from this project.", object.projectKey, object.type.toHumanReadableString(), object.id)));
            }
            catch (Exception e) {
                infoMessages.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, String.format("Error sharing foreign object %s \"%s\" (source project %s)", object.type.toHumanReadableString(), object.id, object.projectKey), String.format("%s \"%s\" will not be usable as its source project %s does not exist", object.type.toHumanReadableString(), object.id, object.projectKey)));
            }
        }
    }

    protected SerializedProject getSerializedProject(String projectKey) {
        try {
            return this.projectsDAO.getOrNullUnsafe(projectKey);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read project permissions", (Throwable)e);
            return null;
        }
    }

    private boolean canShareObject(AuthCtx user, SerializedProject project, TaggableObjectsService.TaggableObjectRef object) throws DKUSecurityException, IOException {
        if (this.permissionService.hasProjectPrivilege(user, project, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS)) {
            return true;
        }
        return this.exposedObjectsService.isQuickSharingEnabled(object.projectKey, object.type, object.id) && this.projectsService.hasDashboardReadPermission(user, new SmartObjectRef(object.projectKey, object.type, object.id), object.projectKey);
    }

    protected void executeModelEvaluationConnectionRemapping(ExportedProject ep, ProjectRemappingSettings remappingSettings) throws IOException, DKUSecurityException {
        List<ModelEvaluationStore> evaluationStores;
        ConnectionRemapper connectionRemapper = new ConnectionRemapper(this.authCtx, null, remappingSettings, ep);
        try (Transaction t = this.transactionService.beginRead();){
            evaluationStores = this.modelEvaluationStoresCRUDService.listUnsafe(this.targetProjectKey);
        }
        for (ModelEvaluationStore modelEvaluationStore : evaluationStores) {
            for (ModelEvaluationStoresCRUDService.ModelEvaluationHeader evaluationHeader : this.modelEvaluationStoresCRUDService.listEvaluations(modelEvaluationStore, null, -1)) {
                FullModelEvaluationId fme = evaluationHeader.evaluation.ref;
                connectionRemapper.remapAndSaveModelEvaluation(fme);
            }
        }
    }

    protected AbstractCodeEnvRemapper buildCodeEnvRemapper(ExportedProject ep, ProjectRemappingSettings remappingSettings) {
        if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.AUTOMATION) {
            return new AutomationNodeCodeEnvRemapper(this.authCtx, remappingSettings, ep);
        }
        return new DesignNodeCodeEnvRemapper(this.authCtx, remappingSettings, ep);
    }

    protected void executeCompletedAnalysisRemapping(ExportedProject ep, ProjectRemappingSettings remappingSettings) throws IOException, DKUSecurityException {
        ConnectionRemapper connectionRemapper = new ConnectionRemapper(this.authCtx, null, remappingSettings, ep);
        try (Transaction t = this.transactionService.beginRead();){
            for (AnalysisCoreParams acp : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
                connectionRemapper.remapAndSaveCompletedVisualAnalysisData(acp);
            }
        }
    }

    protected void executeSavedModelConnectionRemapping(ExportedProject ep, ProjectRemappingSettings remappingSettings) throws IOException, DKUSecurityException {
        List savedModels;
        ConnectionRemapper connectionRemapper = new ConnectionRemapper(this.authCtx, null, remappingSettings, ep);
        try (Transaction t = this.transactionService.beginRead();){
            savedModels = this.savedModelsDAO.list(this.targetProjectKey);
        }
        for (SavedModel sm : savedModels) {
            if (!connectionRemapper.remapSavedModel(sm)) continue;
            RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);
            try {
                this.savedModelsDAO.save(sm);
                String msg = String.format("Remapped connection of saved model %s", sm.id);
                logger.info((Object)msg);
                t.commit(msg);
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
    }

    protected void executeSavedModelContainerExecRemapping(ExportedProject ep, ProjectRemappingSettings remappingSettings) throws IOException {
        List savedModels;
        ContainerExecRemapper remapper = new ContainerExecRemapper(this.authCtx, remappingSettings, ep);
        try (Transaction t = this.transactionService.beginRead();){
            savedModels = this.savedModelsDAO.list(this.targetProjectKey);
        }
        for (SavedModel sm : savedModels) {
            if (!remapper.remapSavedModels(sm)) continue;
            RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);
            try {
                this.savedModelsDAO.save(sm);
                String msg = String.format("Remapped container exec of saved model %s", sm.id);
                logger.info((Object)msg);
                t.commit(msg);
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
    }

    protected void executeAnalysisDataContainerExecRemapping(ExportedProject ep, ProjectRemappingSettings remappingSettings) throws IOException {
        ContainerExecRemapper remapper = new ContainerExecRemapper(this.authCtx, remappingSettings, ep);
        HashMap<AnalysisCoreParams, List<MLTask>> acps = new HashMap<AnalysisCoreParams, List<MLTask>>();
        try (Transaction t = this.transactionService.beginRead();){
            for (AnalysisCoreParams acp : this.analysisCRUDService.listCoreUnsafe(this.targetProjectKey, null)) {
                acps.put(acp, this.analysisCRUDService.listRawMLTasks(this.targetProjectKey, acp.id));
            }
        }
        for (Map.Entry entry : acps.entrySet()) {
            for (MLTask mlTask : (List)entry.getValue()) {
                if (!remapper.remapTrainedModels((AnalysisCoreParams)entry.getKey(), mlTask)) continue;
                logger.infoV("Remapped container-exec of MlTask %s", new Object[]{mlTask.id});
            }
        }
    }

    protected void executeAgentToolContainerExecRemapping(ExportedProject ep, ProjectRemappingSettings remappingSettings) throws IOException {
        List agentTools;
        ContainerExecRemapper remapper = new ContainerExecRemapper(this.authCtx, remappingSettings, ep);
        try (Transaction t = this.transactionService.beginRead();){
            agentTools = this.agentToolsDAO.list(this.targetProjectKey);
        }
        for (AgentTool agentTool : agentTools) {
            if (!remapper.remapAgentTool(agentTool)) continue;
            RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);
            try {
                this.agentToolsDAO.save(agentTool);
                String msg = String.format("Remapped container exec of agent tool %s", agentTool.getDisplayName());
                logger.info((Object)msg);
                t.commit(msg);
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
    }

    protected boolean remapKnowledgeBankImagesFolder(RetrievableKnowledge rk, String originalProjectKey) {
        if (StringUtils.isEmpty((String)rk.managedFolderId)) {
            return false;
        }
        AnyLoc folderLoc = AnyLoc.resolveSmart(this.targetProjectKey, rk.managedFolderId);
        if (!Objects.equals(folderLoc.getProjectKey(), originalProjectKey) || Objects.equals(this.targetProjectKey, originalProjectKey)) {
            return false;
        }
        rk.managedFolderId = new AnyLoc(this.targetProjectKey, folderLoc.getId()).getFullName();
        return true;
    }

    protected void executeKnowledgeBankDataImagesFolderRemapping(ExportedProject ep) throws IOException, DKUSecurityException {
        this.executeKnowledgeBankDataRemapping("images folder id", rk -> this.remapKnowledgeBankImagesFolder(rk, ep.originalProjectKey));
    }

    protected void executeKnowledgeBankDataConnectionRemapping(ExportedProject ep, ProjectRemappingSettings remappingSettings) throws IOException, DKUSecurityException {
        ConnectionRemapper remapper = new ConnectionRemapper(this.authCtx, null, remappingSettings, ep);
        this.executeKnowledgeBankDataRemapping("connection", remapper::remapRetrievableKnowledge);
    }

    protected void executeKnowledgeBankDataCodeEnvRemapping(ExportedProject ep, ProjectRemappingSettings remappingSettings) throws IOException, DKUSecurityException {
        AbstractCodeEnvRemapper remapper = this.buildCodeEnvRemapper(ep, remappingSettings);
        this.executeKnowledgeBankDataRemapping("code env", remapper::remap);
    }

    protected void executeKnowledgeBankDataContainerExecRemapping(ExportedProject ep, ProjectRemappingSettings remappingSettings) throws IOException, DKUSecurityException {
        ContainerExecRemapper remapper = new ContainerExecRemapper(this.authCtx, remappingSettings, ep);
        this.executeKnowledgeBankDataRemapping("container exec", remapper::remapRetrievableKnowledge);
    }

    private void executeKnowledgeBankDataRemapping(String type, KnowledgeBankRemapper remapper) throws IOException, DKUSecurityException {
        List knowledgeBanks;
        try (Transaction t = this.transactionService.beginRead();){
            knowledgeBanks = this.retrievableKnowledgeDAO.list(this.targetProjectKey);
        }
        for (RetrievableKnowledge kb : knowledgeBanks) {
            String version = RetrievableKnowledgeUtils.getCurrentVersionUnsafe(kb);
            File dataFolder = RetrievableKnowledgeUtils.getVersionFolder(kb, version);
            File kbSettingsFile = DKUApp.getFile((File)dataFolder, (String[])new String[]{"kb.json"});
            if (!kbSettingsFile.isFile()) continue;
            RetrievableKnowledge dataKb = (RetrievableKnowledge)JSON.parseFile((File)kbSettingsFile, RetrievableKnowledge.class);
            dataKb.id = kb.getId();
            dataKb.projectKey = kb.getProjectKey();
            if (!remapper.remap(dataKb)) continue;
            logger.info((Object)"Remapped %s for knowledge bank %s within the data folder".formatted(type, dataKb.getId()));
            JSON.prettyToFile((Object)dataKb, (File)kbSettingsFile);
        }
    }

    public static class StashedLocalConfig {
        public JsonObject localVariables;
        public Map<String, Boolean> scenariosActiveState = new HashMap<String, Boolean>();
        public List<WebApp> allWebApps = new ArrayList<WebApp>();
        public List<Insight> allInsights = new ArrayList<Insight>();
        public List<Scenario> allScenarios = new ArrayList<Scenario>();
        public List<BundleActivator.ScenarioAndPayload> localScenarios = new ArrayList<BundleActivator.ScenarioAndPayload>();
        public List<BundleActivator.SQLNotebookWithQueries> localSQLNotebooks = new ArrayList<BundleActivator.SQLNotebookWithQueries>();
        public List<SearchNotebook> localSearchNotebooks = new ArrayList<SearchNotebook>();
        public List<BundleActivator.JupyterNotebook> localJupyterNotebooks = new ArrayList<BundleActivator.JupyterNotebook>();

        public Scenario getScenario(String id) {
            for (Scenario scenario : this.allScenarios) {
                if (!scenario.id.equals(id)) continue;
                return scenario;
            }
            return null;
        }

        public WebApp getWebApp(String id) {
            for (WebApp webApp : this.allWebApps) {
                if (!webApp.id.equals(id)) continue;
                return webApp;
            }
            return null;
        }

        public Insight getInsight(String id) {
            for (Insight insight : this.allInsights) {
                if (!insight.id.equals(id)) continue;
                return insight;
            }
            return null;
        }
    }

    private static interface KnowledgeBankRemapper {
        public boolean remap(RetrievableKnowledge var1) throws IOException, DKUSecurityException;
    }
}

