/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.bivariate.Chi2IndTest;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.AnumGrouping;
import com.dataiku.dip.eda.worksheets.cards.fragments.BivariateFrequencyTableFragment;
import com.dataiku.dip.eda.worksheets.models.BinningMode;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.recipes.eda.EDASchemaColumns;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractTestStat;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Chi2IndependenceTestStat
extends AbstractTestStat {
    private static final String CHI2_INDEPENDENCE_TEST = "CHI2_INDEPENDENCE_TEST";
    public String xColumn;
    public String yColumn;

    public Chi2IndependenceTestStat(String xColumn, String yColumn) {
        this.xColumn = xColumn;
        this.yColumn = yColumn;
    }

    public Chi2IndependenceTestStat() {
    }

    @Override
    public Computation getComputationPlan(StatsTestRecipePayloadParams<?> payloadParams) {
        Variable xVariable = new Variable(this.xColumn, Variable.Type.CATEGORICAL);
        Variable yVariable = new Variable(this.yColumn, Variable.Type.CATEGORICAL);
        Computation freqTablePlan = BivariateFrequencyTableFragment.getFrequencyTablePlan(xVariable, yVariable, BinningMode.AUTO, BinningMode.AUTO, null, null, true, true, null, null);
        Chi2IndTest chi2plan = new Chi2IndTest(new AnumGrouping(this.xColumn, null, false), new AnumGrouping(this.yColumn, null, false));
        return new MultiComputation(freqTablePlan, chi2plan);
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        row.put(cf.column("test"), CHI2_INDEPENDENCE_TEST);
        row.put(cf.column(EDASchemaColumns.testVariable(1)), this.xColumn);
        row.put(cf.column(EDASchemaColumns.testVariable(2)), this.yColumn);
    }

    @Override
    public List<Row> extractRows(ComputationResult result, StatsTestRecipePayloadParams<?> payloadParams, ColumnFactory cf, RowFactory rf) {
        double significanceLevel = payloadParams.significanceLevel();
        List<String> warnings = result.collectWarnings();
        Collection<String> errors = result.collectErrors();
        Row row = this.rowBase(significanceLevel, warnings, errors, cf, rf);
        if (!result.isAvailable()) {
            return Collections.singletonList(row);
        }
        MultiComputation.MultiComputationResult mcr = result.asMulti();
        if (mcr.get(0).isAvailable()) {
            BivariateFrequencyTableFragment frequencyTable = BivariateFrequencyTableFragment.buildFrequencyTable(mcr.get(0));
            List<ContingencyTableEntry> contingencyTable = this.buildContingencyTable(frequencyTable);
            row.put(cf.column("contingency_table"), JSON.json(contingencyTable));
        }
        if (mcr.get(1).isAvailable()) {
            Chi2IndTest.Chi2IndTestResult tr = mcr.get(1).as(Chi2IndTest.Chi2IndTestResult.class);
            double pValue = tr.pvalue;
            String conclusion = Chi2IndependenceTestStat.conclusion(pValue, significanceLevel);
            row.put(cf.column("pearson_chi2_statistic"), tr.statistic);
            row.put(cf.column("degrees_of_freedom"), tr.dof);
            row.put(cf.column("p_value"), pValue);
            row.put(cf.column("conclusion"), conclusion);
        }
        return Collections.singletonList(row);
    }

    private List<ContingencyTableEntry> buildContingencyTable(BivariateFrequencyTableFragment frequencyTable) {
        ArrayList<ContingencyTableEntry> contingencyTable = new ArrayList<ContingencyTableEntry>();
        int nbCells = frequencyTable.xValues.size() * frequencyTable.yValues.size();
        if (frequencyTable.counts.length != nbCells) {
            throw new IllegalArgumentException(String.format("Expected %d values for the actual counts, got %d", nbCells, frequencyTable.counts.length));
        }
        if (frequencyTable.expectedCounts.length != nbCells) {
            throw new IllegalArgumentException(String.format("Expected %d values for the expected counts, got %d", nbCells, frequencyTable.expectedCounts.length));
        }
        int cellIndex = 0;
        for (Filter xFilter : frequencyTable.xValues) {
            String xValue = this.extractModality(xFilter, this.xColumn);
            for (Filter yFilter : frequencyTable.yValues) {
                String yValue = this.extractModality(yFilter, this.yColumn);
                ContingencyTableEntry cell = new ContingencyTableEntry(xValue, yValue, frequencyTable.counts[cellIndex], frequencyTable.expectedCounts[cellIndex]);
                contingencyTable.add(cell);
                ++cellIndex;
            }
        }
        return contingencyTable;
    }

    private String extractModality(Filter filter, String column) {
        if (!(filter instanceof AnumFilter)) {
            throw new IllegalArgumentException(String.format("Unexpected filter type: %s", ((Object)((Object)filter)).getClass().getSimpleName()));
        }
        AnumFilter anumFilter = (AnumFilter)filter;
        if (!anumFilter.column.equals(column)) {
            throw new IllegalArgumentException(String.format("Expected filter on column %s, got column %s", column, anumFilter.column));
        }
        if (anumFilter.values.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected exactly 1 modality, got %d", anumFilter.values.size()));
        }
        return new ArrayList<String>(anumFilter.values).get(0);
    }

    private class ContingencyTableEntry {
        final Map<String, String> values;
        final long actual_count;
        final double expected_count;

        public ContingencyTableEntry(String xValue, String yValue, long actual_count, double expected_count) {
            HashMap<String, String> vals = new HashMap<String, String>();
            vals.put(Chi2IndependenceTestStat.this.xColumn, xValue);
            vals.put(Chi2IndependenceTestStat.this.yColumn, yValue);
            this.values = Collections.unmodifiableMap(vals);
            this.actual_count = actual_count;
            this.expected_count = expected_count;
        }
    }
}

