/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common.doc_extraction;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.docextraction.StructuredExtractor;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.PretrainedModelsService;
import com.dataiku.dip.recipes.FakeJobActivityFromRecipeBuilder;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRecipesParams;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRule;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DocExtractionRecipesStatusComputerBase
extends RecipeStatusComputer {
    @Autowired
    private CodeEnvResolutionService codeEnvResolutionService;
    @Autowired
    private PretrainedModelsService pretrainedModelsService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.nlp.doc_extraction_status_computer");

    public DocExtractionRecipesStatusComputerBase(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    public void fillDocExtractionCommonStatus(DocExtractionRecipesStatus status, AuthCtx authCtx) {
        DocExtractionRecipesParams params = this.recipe.getParamsAs(DocExtractionRecipesParams.class);
        List<DocExtractionRule> allCustomRules = params.getAllRules();
        if (params.extractionMode == DocExtractionRecipesParams.ExtractionMode.MANAGED_VISUAL_ONLY) {
            defaultVLMid = params.getDefaultVLMSelection();
            if (!this.isVlmUsable(authCtx, defaultVLMid)) {
                status.strategy.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "Select a vision model to use Visual-first extraction");
            }
        } else if (params.extractionMode == DocExtractionRecipesParams.ExtractionMode.MANAGED_TEXT_ONLY) {
            if (!this.isStructuredExtractionCodeEnvAvailable()) {
                String message = authCtx.isAdmin() ? "Text-first extraction requires the Document Extraction internal code environment. You can install it in Administration Settings." : "Text-first extraction requires the Document Extraction internal code environment. You can request its installation.";
                status.strategy.withWarning(RecipeCodes.WARN_RECIPE_CODE_ENV_NOT_AVAILABLE, message);
            }
            if (params.defaultImageHandlingMode == StructuredExtractor.ImageHandlingMode.VLM_ANNOTATE && !this.isVlmUsable(authCtx, defaultVLMid = params.getDefaultVLMSelection())) {
                status.strategy.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "Select a vision model to describe images in documents");
            }
        } else if (params.extractionMode == DocExtractionRecipesParams.ExtractionMode.CUSTOM_RULES) {
            List<EnrichedLLMStructuredRef> availableVlms = this.getAvailableVLM(authCtx);
            if (allCustomRules.isEmpty()) {
                status.strategy.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, "No custom rule defined");
            }
            if (allCustomRules.stream().anyMatch(rule -> rule.actionToPerform == null)) {
                status.strategy.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, "At least one custom rule requires to select an action to be applied");
            }
            if (allCustomRules.stream().allMatch(rule -> rule.actionToPerform.equals((Object)DocExtractionRule.ActionToPerform.DONOTEXTRACT))) {
                status.strategy.withFatal(RecipeCodes.ERR_RECIPE_VISUALSQL_INVALID_FILTER, "At least one custom rule requires to select an action to be applied");
            }
            if (allCustomRules.stream().anyMatch(rule -> rule.actionToPerform.equals((Object)DocExtractionRule.ActionToPerform.VLM) && !this.isVlmAmongUsable(rule.vlmSettings.llmId, availableVlms))) {
                status.strategy.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "At least one custom rule requires a vision model to be selected");
            }
            if (allCustomRules.stream().anyMatch(rule -> rule.actionToPerform.equals((Object)DocExtractionRule.ActionToPerform.STRUCTURED)) && !this.isStructuredExtractionCodeEnvAvailable()) {
                String message = authCtx.isAdmin() ? "At least one custom rule requires the Document Extraction internal code environment.\n You can install it in Administration Settings." : "At least one custom rule requires the Document Extraction internal code environment.\n You can request its installation.";
                status.strategy.withWarning(RecipeCodes.WARN_RECIPE_CODE_ENV_NOT_AVAILABLE, message);
            }
            if (allCustomRules.stream().anyMatch(rule -> rule.actionToPerform.equals((Object)DocExtractionRule.ActionToPerform.STRUCTURED) && rule.structuredSettings.imageHandlingMode == StructuredExtractor.ImageHandlingMode.VLM_ANNOTATE && !this.isVlmAmongUsable(rule.structuredSettings.llmId, availableVlms))) {
                status.strategy.withFatal(RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, "At least one custom rule requires a vision model to be selected");
            }
        }
        boolean outputFolderIsRequired = this.isOutputFolderRequired(params, allCustomRules);
        if (outputFolderIsRequired && this.recipe.getOutputsForRole("images").stream().findFirst().isEmpty()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_DOC_EXTRACTION_MISSING_FOLDER, "An output folder is required to store generated screenshots or detected images");
        }
    }

    protected abstract boolean isOutputFolderRequired(DocExtractionRecipesParams var1, List<DocExtractionRule> var2);

    private List<EnrichedLLMStructuredRef> getAvailableVLM(AuthCtx authCtx) {
        try {
            return this.pretrainedModelsService.listAvailableLLMs((AuthCtx)authCtx, (String)this.recipe.projectKey, (AbstractLLMConnection.LLMUsagePurpose)AbstractLLMConnection.LLMUsagePurpose.IMAGE_INPUT).identifiers;
        }
        catch (DKUSecurityException | IOException e) {
            logger.error((Object)("Failed to list available VLMs for recipe: " + this.recipe.projectKey), e);
            return new ArrayList<EnrichedLLMStructuredRef>();
        }
    }

    private boolean isVlmAmongUsable(String vlmId, List<EnrichedLLMStructuredRef> availableVlms) {
        if (Strings.isNullOrEmpty((String)vlmId) || vlmId.equals("DSS_NO_SELECTION")) {
            return false;
        }
        Optional<EnrichedLLMStructuredRef> llmRef = availableVlms.stream().filter(enrichedLLM -> vlmId.equals(enrichedLLM.id)).findFirst();
        return llmRef.isPresent();
    }

    private boolean isVlmUsable(AuthCtx authCtx, String vlmId) {
        return this.isVlmAmongUsable(vlmId, this.getAvailableVLM(authCtx));
    }

    private boolean isStructuredExtractionCodeEnvAvailable() {
        String structuredExtractionCodeEnv = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.embedDocumentsRecipeSettings.getTextExtractionCodeEnv();
        try {
            this.codeEnvResolutionService.checkEnvExists(CodeEnvModel.EnvLang.PYTHON, structuredExtractionCodeEnv);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public DocExtractionRecipesStatus buildStatus() {
        return new DocExtractionRecipesStatus();
    }

    @Override
    public RecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        DocExtractionRecipesStatus status = this.buildStatus();
        status.strategy = new RecipeStatus.StepStatus();
        status.output = new RecipeStatus.StepStatus();
        RecipeEngineStatus engineStatus = new RecipeEngineStatus("DSS", "DSS", "MEMORY", "In-memory", "DSS");
        status.engines = Lists.newArrayList((Object[])new RecipeEngineStatus[]{engineStatus});
        status.selectedEngine = engineStatus;
        this.performBasicStructureChecks(status, authCtx);
        JobActivity activity = new FakeJobActivityFromRecipeBuilder().buildFakeJobActivity(this.recipe);
        try {
            this.recipesValidationService.checkTargetsAreWritable(activity);
        }
        catch (CodedRuntimeException e) {
            status.topLevelMessages.withFatalV(e.code, e.getMessage(), new Object[0]);
        }
        return status;
    }

    public static class DocExtractionRecipesStatus
    extends RecipeStatus {
        RecipeStatus.StepStatus strategy;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.strategy != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.strategy);
            }
            if (this.output != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            }
            return ret;
        }
    }
}

