/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.reports;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportsDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedReportsDAO
extends AbstractStandardDAO<Report>
implements ReportsDAO {
    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.REPORT.toHumanReadableString();
    }

    @Override
    protected Report getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile reportFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(reportFile = this.getDAOFile(projectKey, id))) {
            return null;
        }
        Report report = unsafe ? (Report)t.readObjectUnsafe(reportFile, Report.class) : (Report)t.readObject(reportFile, Report.class);
        report.id = id;
        report.projectKey = projectKey;
        return report;
    }

    @Override
    public String getPayloadOrNull(String projectKey, String id) throws IOException {
        RelFile scriptFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(scriptFile = this.getScriptFile(projectKey, id))) {
            return null;
        }
        String script = t.readStringUTF8(scriptFile);
        this.logger.info((Object)("Script: " + script));
        return script;
    }

    @Override
    public void save(Report report, String script) throws IOException {
        super.save(report);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.logger.info((Object)("Write report with script: " + script));
        if (script != null) {
            RelFile scriptFile = this.getScriptFile(report.projectKey, report.id);
            t.writeStringUTF8(scriptFile, script);
        }
    }

    @Override
    protected List<Report> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<Report> ret = new ArrayList<Report>();
        RelFile reportsFolder = this.getReportsFolder(projectKey);
        if (!t.exists(reportsFolder)) {
            return ret;
        }
        for (RelFile file : t.listFiles(reportsFolder, (RelFileFilter)FileFilter.json())) {
            try {
                String id = StringUtils.removeEnd((String)file.getLeafName(), (String)".json");
                Report report = unsafe ? (Report)t.readObjectUnsafe(file, Report.class) : (Report)t.readObject(file, Report.class);
                report.id = id;
                report.projectKey = projectKey;
                ret.add(report);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to read report file " + String.valueOf(file) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        return ret;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile reportsFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(reportsFolder = this.getReportsFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(reportsFolder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RelFile file;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.isFile(file = this.getDAOFile(projectKey, id))) {
            throw new NotFoundException("Report does not exist: " + projectKey + "." + id);
        }
        t.deleteFile(file);
    }

    private RelFile getScriptFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Report id is not specified");
        return new RelFile(this.getReportsFolder(projectKey), new String[]{id + ".Rmd"});
    }

    private RelFile getReportsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Report project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "code-reports"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Report id is not specified");
        return new RelFile(this.getReportsFolder(projectKey), new String[]{id + ".json"});
    }
}

