/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.scheduler.runnables.DSSRunnable;
import com.dataiku.dip.scheduler.runnables.DSSRunnableMeta;
import com.dataiku.dip.scheduler.runnables.DSSRunnableRegistry;
import com.dataiku.dip.scheduler.runnables.DSSRunnableResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import javax.annotation.Nullable;

public class DSSRunnableThread
extends SimpleFutureThread<DSSRunnableResult> {
    @Nullable
    private DSSRunnable runnable;
    private final File contextDir;
    private final String projectKey;
    private final JsonObject params;
    private final String runnableType;
    private final FuturePayload futurePayload;
    private final APITicketService apiTicketService;
    private final FutureService futureService;

    public static FuturePayload buildFuturePayload(DSSRunnableMeta meta, String projectKey, boolean remote) {
        FuturePayload fp = new FuturePayload();
        fp.action = "macro";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(projectKey, meta.getType(), meta.getLabel(), "RUNNABLE"));
        fp.displayName = "Running " + meta.getLabel() + (remote ? " (out of core)" : "");
        return fp;
    }

    public DSSRunnableThread(AuthCtx authCtx, String runnableType, JsonObject params, String projectKey, File contextDir, APITicketService apiTicketService, FutureService futureService) {
        super(authCtx);
        this.runnableType = runnableType;
        this.params = params;
        this.projectKey = projectKey;
        this.contextDir = contextDir;
        this.apiTicketService = apiTicketService;
        this.futureService = futureService;
        this.futurePayload = DSSRunnableThread.buildFuturePayload(DSSRunnableRegistry.getMeta(runnableType), projectKey, false);
    }

    @Override
    protected DSSRunnableResult compute() throws Exception {
        DSSRunnableMeta meta = DSSRunnableRegistry.getMeta(this.runnableType);
        final APITicketService.Ticket ticket = this.apiTicketService.createTicket((AuthCtx)this.owner, "dss_macro:" + meta.getType(), (Object)this);
        this.apiTicketService.registerFutureUsingTicket(ticket, (FutureThreadBase)this);
        try {
            DSSRunnableResult dSSRunnableResult;
            block13: {
                FutureAborter.AutoCloseableAbortHook aborter;
                block11: {
                    DSSRunnableResult dSSRunnableResult2;
                    block12: {
                        aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                DSSRunnableThread.this.apiTicketService.abortFutureUsingTicket(ticket);
                            }
                        });
                        try {
                            if (!meta.runOutOfCore()) break block11;
                            DSSRemoteRunnableThread ft = new DSSRemoteRunnableThread(this.owner, this.runnableType, this.params, this.projectKey, this.contextDir, ticket);
                            FutureResponse fr = this.futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<DSSRunnableResult>>(){});
                            fr = this.futureService.waitForFinalResponse(fr);
                            dSSRunnableResult2 = (DSSRunnableResult)fr.result;
                            if (aborter == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (aborter != null) {
                                try {
                                    aborter.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        aborter.close();
                    }
                    return dSSRunnableResult2;
                }
                this.runnable = meta.buildRunnable(this.owner, this.projectKey, this.params);
                dSSRunnableResult = this.runnable.run(this.contextDir, ticket);
                if (aborter == null) break block13;
                aborter.close();
            }
            return dSSRunnableResult;
        }
        finally {
            this.apiTicketService.deregisterFutureUsingTicket(ticket, (FutureThreadBase)this);
            this.apiTicketService.expireTicket(ticket);
        }
    }

    public SmartLogTail getLog() {
        return this.runnable != null ? this.runnable.getLogTail() : null;
    }

    public String getRunnableType() {
        return this.runnableType;
    }

    public FuturePayload getPayload() {
        return this.futurePayload;
    }

    private static class DSSRemoteRunnableThread
    extends SimpleFutureThread<DSSRunnableResult> {
        private final String runnableType;
        private final JsonObject params;
        private final String projectKey;
        private final File contextDir;
        private final APITicketService.Ticket ticket;
        private final FuturePayload futurePayload;

        public DSSRemoteRunnableThread(DSSAuthCtx authCtx, String runnableType, JsonObject params, String projectKey, File contextDir, APITicketService.Ticket ticket) {
            super((AuthCtx)authCtx);
            this.runnableType = runnableType;
            this.params = params;
            this.projectKey = projectKey;
            this.contextDir = contextDir;
            this.ticket = ticket;
            this.futurePayload = DSSRunnableThread.buildFuturePayload(DSSRunnableRegistry.getMeta(runnableType), projectKey, true);
        }

        @Override
        public double getDangerosity() {
            return 1.0;
        }

        @Override
        protected DSSRunnableResult compute() throws Exception {
            DSSRunnableMeta meta = DSSRunnableRegistry.getMeta(this.runnableType);
            DSSRunnable runnable = meta.buildRunnable(this.owner, this.projectKey, this.params);
            return runnable.run(this.contextDir, this.ticket);
        }

        public String getRunnableType() {
            return this.runnableType;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        static {
            JSON.registerAdapter(DSSRemoteRunnableThread.class, (Object)new JSON.Adapter<DSSRemoteRunnableThread>(){

                public DSSRemoteRunnableThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                    String runnableType = jsonObj.get("runnableType").getAsString();
                    String projectKey = jsonObj.get("projectKey") == null || jsonObj.get("projectKey").isJsonNull() ? null : jsonObj.get("projectKey").getAsString();
                    String contextDirPath = jsonObj.get("contextDirPath").getAsString();
                    String ticketSecret = jsonObj.get("ticketSecret").getAsString();
                    JsonElement paramsObj = jsonObj.get("params");
                    JsonObject params = paramsObj != null ? (JsonObject)ctx.deserialize(paramsObj, JsonObject.class) : null;
                    APITicketService.Ticket ticket = new APITicketService.Ticket().withId("Remote_" + SecretKeyGenerator.generate((int)12)).withSecret(ticketSecret).withUser((AuthCtx)owner).withDescription("Remote ticket");
                    return new DSSRemoteRunnableThread(owner, runnableType, params, projectKey, new File(contextDirPath), ticket);
                }

                public JsonElement serialize(DSSRemoteRunnableThread ft, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.addProperty("runnableType", ft.runnableType);
                    ret.addProperty("projectKey", ft.projectKey);
                    ret.addProperty("ticketSecret", ft.ticket.getSecret());
                    ret.addProperty("contextDirPath", ft.contextDir.getAbsolutePath());
                    ret.add("owner", ctx.serialize((Object)ft.owner));
                    if (ft.params != null) {
                        ret.add("params", ctx.serialize((Object)ft.params));
                    }
                    return ret;
                }
            });
        }
    }
}

