/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.reports.Report;
import com.dataiku.dip.reports.ReportsService;
import com.dataiku.dip.reports.ReportsSnapshotsService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SnapshotRMarkdownReportStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return SnapshotRMarkdownReportStepParams.class;
        }

        @Override
        public String getType() {
            return "create_rmarkdown_report_export";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new SnapshotRMarkdownReportStepRunner(scenario, step, step.getParamsAs(SnapshotRMarkdownReportStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            SnapshotRMarkdownReportStepParams stepParams = step.getParamsAs(SnapshotRMarkdownReportStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("export");
            if (stepParams != null) {
                sb.append(" ");
                sb.append(stepParams.reportId);
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            SnapshotRMarkdownReportStepParams stepParams = step.getParamsAs(SnapshotRMarkdownReportStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("create_rmarkdown_report_export");
            if (stepParams != null) {
                sb.append("_");
                sb.append(stepParams.reportId);
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final SnapshotRMarkdownReportStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private ReportsService reportsService;
    @Autowired
    private ReportsSnapshotsService reportsSnapshotsService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.refreshinsight");

    SnapshotRMarkdownReportStepRunner(Scenario scenario, Step step, SnapshotRMarkdownReportStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        String script;
        Report report;
        logger.info((Object)("Start step " + this.step.name));
        String projectKey = this.scenario.getProjectKey();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)this.params.reportId), (Object)"Report id not specified");
        try (Transaction t = this.transactionService.beginRead();){
            report = this.reportsService.getMandatoryUnsafe(projectKey, this.params.reportId);
            script = this.reportsService.getScript(projectKey, this.params.reportId);
        }
        ReportTargetItem.RMarkdownReportItem target = new ReportTargetItem.RMarkdownReportItem(projectKey, this.params.reportId);
        ReportItem item = new ReportItem.SnapshotRMarkdownReport(target).withStart(System.currentTimeMillis());
        ReportItem.SnapshotRMarkdownReport reportItem = (ReportItem.SnapshotRMarkdownReport)item;
        try {
            logger.info((Object)"Start insight refresh");
            DSSAuthCtx authCtx = stepRun.getScenarioRun().getRunAsUser();
            FutureResponse<ReportsSnapshotsService.ReportSnapshotResponse> fr = this.reportsSnapshotsService.startCreate(report, script, authCtx);
            this.futureService.waitForFinalResponse(fr);
            logger.info((Object)"Refresh done");
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to export rmarkdown", (Throwable)ex);
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED).withThrown(ex);
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(projectKey, this.params.reportId), null, null, stepRun.getScenarioRun(), stepRun, reportItem);
        }
        stepReportItem.withOutcome(reportItem.getOutcome());
        logger.info((Object)("Done step " + this.step.name));
    }

    public static class SnapshotRMarkdownReportStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String reportId;

        public SnapshotRMarkdownReportStepParams withReportkId(String reportId) {
            this.reportId = reportId;
            return this;
        }
    }
}

