/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.analysis;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.coreservices.ClusteringService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.clustering.ClusteringResultsReader;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesService;
import com.dataiku.dip.analysis.model.clustering.ClusterHierarchy;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.clustering.ClusteringScatterplotSample;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MLClusteringController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ClusteringRecipesService clusteringRecipesService;
    @Autowired
    private GenericRecipesValidationService validationService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ClusteringService clusteringService;
    @Autowired
    private AuditTrailService auditTrailService;
    private static Logger logger = Logger.getLogger((String)"dku.server.common");

    private FullModelId unsmartifyAndCheck(HttpServletRequest req, FullModelId fmi) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            if (fmi.getType() == FullModelId.Type.SAVED) {
                SmartObjectRef smartObjectRef = SmartObjectRef.fromSmartName(ITaggingService.TaggableType.SAVED_MODEL, fmi.getSavedModelID());
                this.projectsService.failIfNoDashboardReadPermission(req, smartObjectRef, fmi.getProjectKey());
                FullModelId fullModelId = new FullModelId(smartObjectRef.getProjectKey(fmi.getProjectKey()), smartObjectRef.objectId, fmi.getSavedModelVersionID());
                return fullModelId;
            }
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            FullModelId fullModelId = fmi;
            return fullModelId;
        }
    }

    @AuditedCall(value={"msgType", "ml-clustering-model-get-details", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/clustering/get-model-details"})
    public void getClusteringModelDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        ClusteringModelDetails details = ClusteringResultsReader.makeDetails(fmi);
        MLClusteringController.writeJSON((HttpServletResponse)resp, (Object)details);
    }

    @AuditedCall(value={"msgType", "ml-clustering-model-get-details", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/clustering/get-scatter-plot"})
    public void getClusteringScatterPlot(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String variable1, @RequestParam String variable2) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        logger.debug((Object)("Requesting scatter plot for " + String.valueOf(fmi) + " " + variable1 + " " + variable2));
        ClusteringScatterplotSample sample = ClusteringScatterplotSample.build(fmi.getModelFolder().getAbsolutePath(), variable1, variable2);
        MLClusteringController.writeJSON((HttpServletResponse)resp, (Object)sample);
    }

    @AuditInline
    @RequestMapping(value={"/api/ml/clustering/get-prepared-input-schema"})
    public void getPreparedInputSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String recipeData) throws Exception {
        AuthCtx authCtx;
        SerializedRecipe sr = (SerializedRecipe)JSON.parse((String)recipeData, SerializedRecipe.class);
        JobActivity activity = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, sr.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            FlowRecipe fr = new FlowRecipe(sr);
            RecipeRunnableSubgraph sg = this.validationService.getSampleSubgraph(fr);
            activity = new JobActivity(sg);
        }
        this.auditTrailService.generic("ml-prediction-model-get-schema").with("projectKey", sr.projectKey).with("recipeType", sr.type).with("recipeName", sr.name).emit();
        Schema schema = this.clusteringRecipesService.getPreparedSchema_NT(authCtx, activity);
        MLClusteringController.writeJSON((HttpServletResponse)resp, (Object)schema);
    }

    @AuditedCall(value={"msgType", "ml-clustering-model-get-details", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/clustering/get-cluster-hierarchy"})
    public void getClusterHierarchy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        logger.info((Object)("Requesting hierarchy for " + fullModelId));
        ClusterHierarchy h = fmi.parseModelFile("hierarchy.json", ClusterHierarchy.class);
        MLClusteringController.writeJSON((HttpServletResponse)resp, (Object)h);
    }

    @AuditedCall(value={"msgType", "ml-clustering-model-get-details", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/clustering/get-anomalies"})
    public void getAnomalies(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = this.unsmartifyAndCheck(req, FullModelId.parse(fullModelId));
        logger.info((Object)("Requesting anomalies for " + fullModelId));
        AnomalyData h = fmi.parseModelFile("anomalies.json", AnomalyData.class);
        MLClusteringController.writeJSON((HttpServletResponse)resp, (Object)h);
    }

    @AuditedCall(value={"msgType", "ml-clustering-model-rescore", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/ml/clustering/rescore"})
    public void commitHierarchy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        logger.info((Object)("Committing hierarchy for " + fullModelId));
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            AuthCtx user = this.authService.getUser(req);
            FutureResponse<Void> response = this.clusteringService.rescoreStart(user, fmi);
            MLClusteringController.writeJSON((HttpServletResponse)resp, response);
        }
    }

    public static class AnomalyData {
        public String[] columns;
        public double[][] data;
        public double[][] regular_data;
        public double[] scores;
        public double[] regular_scores;
        public double[] averages;
        public double[] standard_deviations;
        public long total_anomalies;
        public String[] extra_profiling_columns;
        public String[][] extra_profiling_data;
        public String[][] extra_profiling_regular_data;
    }
}

