/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.submit;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.KubectlHelper;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.containers.exec.KubernetesNamespacesService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsUtils;
import com.dataiku.dip.spark.SparkCodes;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.spark.SparkJobBuilder;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.spark.SparkJobFilesInitialFetchRequest;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.submit.SparkSubmitHelper;
import com.dataiku.dip.spark.submit.SparkSubmitJob;
import com.dataiku.dip.util.DKUNetUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jcraft.jsch.JSchException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SparkKubernetesSubmitHelper
extends SparkSubmitHelper {
    private static Logger logger = Logger.getLogger((String)"dku.spark.submit.k8s.helper");

    protected SparkKubernetesSubmitHelper(String projectKey, AuthCtx authCtx, SparkSettings sparkSettings, HadoopSettings hadoopSettings, UserImpersonationTarget impersonationTarget, SparkExecutionConfig usedExecutionConfig) {
        super(projectKey, authCtx, sparkSettings, hadoopSettings, impersonationTarget, usedExecutionConfig);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected Closeable createAdditionalContextElement(SparkSubmitJob job, SparkJobHelper.RunMode runMode, File runDir, CodeEnvModel.UsedCodeEnvRef codeEnvRef, EnvironmentStash stash, boolean isCluster) throws IOException, InterruptedException {
        block63: {
            block62: {
                if (this.usedExecutionConfig == null || !this.usedExecutionConfig.kubernetesSettings.managedKubernetes) break block63;
                bc /* !! */  = null;
                ks = this.usedExecutionConfig.kubernetesSettings;
                SparkKubernetesSubmitHelper.logger.info((Object)("Setting up managed Kubernetes context. Kubernetes settings: " + JSON.json((Object)ks)));
                managedNamespace = KubernetesNamespacesService.getOrCreateNamespace(this.authCtx, this.projectKey, ks);
                job.addOrReplaceConfValue(new SimpleKeyValue("spark.kubernetes.namespace", managedNamespace));
                baseImageRef = ContainerExecImagesHelper.getBaseImageTag(ks.baseImage, ContainerExecUtils.BaseImageType.SPARK);
                if (codeEnvRef != null) {
                    try {
                        envVersion = ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getEnvVersionToUseForContainerImageLookup(codeEnvRef.envName, codeEnvRef.envLang, this.projectKey);
                        baseImageRef = ContainerExecImagesHelper.getImageTagToUse(ks.dockerHost, ks.baseImage, ContainerExecUtils.BaseImageType.SPARK, codeEnvRef.envLang, codeEnvRef.envName, envVersion);
                    }
                    catch (Exception e) {
                        SparkKubernetesSubmitHelper.logger.warn((Object)"Could not get image ref to use, reverting to base", (Throwable)e);
                        if (runMode != SparkJobHelper.RunMode.PYSPARK) break block62;
                        activityObj = JobContext.getCurrentActivityObj();
                        msg = String.format("The code env %s is not configured to build images for the Spark config %s", new Object[]{codeEnvRef.envName, this.usedExecutionConfig.name});
                        if (activityObj != null) {
                            activityObj.getStatus().messages.withWarningV((InfoMessage.MessageCode)SparkCodes.WARN_SPARK_UDFS_MAY_BE_BROKEN, msg, new Object[0]);
                        }
                        SparkKubernetesSubmitHelper.logger.warn((Object)msg);
                    }
                }
            }
            baseImageRef = ContainerExecImagesHelper.withRepositoryURL(ks, baseImageRef);
            if (!job.hasConfKey(new String[]{"spark.kubernetes.container.image", "spark.kubernetes.executor.container.image", "spark.kubernetes.driver.container.image"})) {
                job.conf.add(new SimpleKeyValue("spark.kubernetes.container.image", baseImageRef));
                if (isCluster) {
                    if (codeEnvRef != null && StringUtils.isNotBlank((String)codeEnvRef.envName)) {
                        imagePython = "/opt/dataiku/code-env/bin/python";
                        imageR = "/opt/dataiku/code-env/bin/R";
                        job.conf.add(new SimpleKeyValue("spark.pyspark.driver.python", imagePython));
                        job.conf.add(new SimpleKeyValue("spark.pyspark.python", imagePython));
                        stash.env.put("PYSPARK_PYTHON", imagePython);
                        stash.env.put("PYSPARK_DRIVER_PYTHON", imagePython);
                        job.conf.add(new SimpleKeyValue("spark.r.command", imageR));
                        job.conf.add(new SimpleKeyValue("spark.r.driver.command", imageR));
                        stash.env.put("SPARKR_R", imageR);
                        stash.env.put("SPARKR_DRIVER_R", imageR);
                    } else {
                        job.removeConfValues(Sets.newHashSet((Object[])new String[]{"spark.pyspark.driver.python", "spark.pyspark.python"}));
                        job.removeConfValues(Sets.newHashSet((Object[])new String[]{"spark.r.driver.command", "spark.r.command"}));
                        stash.env.remove("PYSPARK_DRIVER_PYTHON");
                        stash.env.put("PYSPARK_PYTHON", "/opt/dataiku/bin/python");
                        stash.env.remove("SPARKR_DRIVER_R");
                        stash.env.remove("SPARKR_R");
                    }
                } else if (codeEnvRef != null && StringUtils.isNotBlank((String)codeEnvRef.envName)) {
                    pysparkDriverPython = stash.env.get("PYSPARK_DRIVER_PYTHON");
                    if (StringUtils.isNotBlank((String)pysparkDriverPython)) {
                        job.conf.add(new SimpleKeyValue("spark.pyspark.driver.python", pysparkDriverPython));
                        job.conf.add(new SimpleKeyValue("spark.pyspark.python", "/opt/dataiku/code-env/bin/python"));
                    } else {
                        stash.env.put("PYSPARK_PYTHON", "/opt/dataiku/code-env/bin/python");
                    }
                    job.conf.add(new SimpleKeyValue("spark.r.command", "/opt/dataiku/code-env/bin/R"));
                } else {
                    stash.env.put("PYSPARK_PYTHON", "/opt/dataiku/bin/python");
                }
            }
            if (StringUtils.equals((String)baseImageRef, (String)job.getConfValue("spark.kubernetes.container.image")) || StringUtils.equals((String)baseImageRef, (String)job.getConfValue("spark.kubernetes.executor.container.image"))) {
                if (!job.hasConfKey(new String[]{"spark.dku.pathInImage.python"})) {
                    job.conf.add(new SimpleKeyValue("spark.dku.pathInImage.python", "/opt/dataiku/bin/python"));
                } else {
                    SparkKubernetesSubmitHelper.logger.warn((Object)"Property spark.dku.pathInImage.python is defined, didn't override");
                }
            }
            friendlyPodNameBase = StringUtils.defaultIfBlank((String)job.name, (String)"DSS job");
            if ((friendlyPodNameBase = friendlyPodNameBase.replaceAll("[^a-zA-Z0-9]", "")).length() > 30) {
                friendlyPodNameBase = friendlyPodNameBase.substring(0, 30);
            }
            friendlyPodNameBase = (String)friendlyPodNameBase + "-" + SecretKeyGenerator.generate((int)8);
            if (!job.hasConfKey(new String[]{"spark.kubernetes.executor.podNamePrefix"})) {
                job.conf.add(new SimpleKeyValue("spark.kubernetes.executor.podNamePrefix", friendlyPodNameBase.toLowerCase()));
            }
            if (isCluster && !job.hasConfKey(new String[]{"spark.kubernetes.driver.pod.name"})) {
                job.conf.add(new SimpleKeyValue("spark.kubernetes.driver.pod.name", friendlyPodNameBase.toLowerCase()));
            }
            if (!job.hasConfKey(new String[]{"spark.kubernetes.executor.podTemplateFile"}) && StringUtils.isNotBlank((String)this.usedExecutionConfig.kubernetesSettings.executorPodTemplate)) {
                executorPodTemplateFile = new File(runDir, "executor-pod-template.yaml");
                FileUtils.write((File)executorPodTemplateFile, (CharSequence)this.usedExecutionConfig.kubernetesSettings.executorPodTemplate);
                job.conf.add(new SimpleKeyValue("spark.kubernetes.executor.podTemplateFile", executorPodTemplateFile.getAbsolutePath()));
                if (StringUtils.isNotBlank((String)this.usedExecutionConfig.kubernetesSettings.executorPodTemplateContainerName)) {
                    job.conf.add(new SimpleKeyValue("spark.kubernetes.executor.podTemplateContainerName", this.usedExecutionConfig.kubernetesSettings.executorPodTemplateContainerName));
                }
            } else {
                podSecurityContextContent = "";
                if (Boolean.parseBoolean(job.getConfValue("podRunAsUid"))) {
                    uid = DKUApp.getParams().getParam("dku.container.dataiku.uid", "500");
                    podSecurityContextContent = (String)podSecurityContextContent + "\n    runAsUser: " + uid;
                    if (Boolean.parseBoolean(job.getConfValue("podRunAsGid")) && (gid = DKUApp.getParams().getParam("dku.container.dataiku.gid", null)) != null) {
                        podSecurityContextContent = (String)podSecurityContextContent + "\n    runAsGroup: " + gid;
                    }
                }
                if (Boolean.parseBoolean(job.getConfValue("podRunAsNonRoot"))) {
                    podSecurityContextContent = (String)podSecurityContextContent + "\n    runAsNonRoot: true";
                }
                executorPodTemplate = "apiVersion: v1\nkind: Pod\nspec:\n  securityContext:\n    " + (String)podSecurityContextContent;
                executorPodTemplateFile = new File(runDir, "executor-pod-template.yaml");
                FileUtils.write((File)executorPodTemplateFile, (CharSequence)executorPodTemplate);
                job.conf.add(new SimpleKeyValue("spark.kubernetes.executor.podTemplateFile", executorPodTemplateFile.getAbsolutePath()));
            }
            SparkKubernetesSubmitHelper.logger.info((Object)("Setting up resource usage reporting, cru=" + String.valueOf(this.cru)));
            executionId = null;
            if (this.cru != null) {
                if (this.cru.context.type == ComputeResourceUsageContext.ComputeResourceUsageContextType.JOB_ACTIVITY) {
                    ars = JobContext.getCurrentActivitySummary();
                    executionId = KubernetesExecUtils.getNormalizedExecutionId(ars.activityType + "-" + SecretKeyGenerator.generateSmall());
                } else if (this.cru.context.type == ComputeResourceUsageContext.ComputeResourceUsageContextType.POOLED_SPARKSQL_CONNECTION) {
                    executionId = "sparksql-pooled-" + SecretKeyGenerator.generateSmall();
                } else {
                    SparkKubernetesSubmitHelper.logger.warn((Object)("Do not know how to setup labels for Spark with usage context: " + String.valueOf(this.cru.context.type)));
                    executionId = SecretKeyGenerator.generateSmall();
                }
                this.cru.setupSparkK8SJob(this.k8sClusterIdInformationalOnly, (String)executionId, this.usedExecutionConfig.name);
                inlineConfig = new ContainerExecRuntimeConfig();
                inlineConfig.type = ContainerExecRuntimeConfig.Container.KUBERNETES;
                inlineConfig.name = executionId;
                laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(this.authCtx, (String)executionId, inlineConfig);
                SparkKubernetesSubmitHelper.logger.info((Object)("Setting labels and annotations: " + JSON.json((Object)laa)));
                for (Map.Entry<String, String> label : laa.getLabels().entrySet()) {
                    job.addOrReplaceConfValue(new SimpleKeyValue("spark.kubernetes.driver.label." + label.getKey(), label.getValue()));
                    job.addOrReplaceConfValue(new SimpleKeyValue("spark.kubernetes.executor.label." + label.getKey(), label.getValue()));
                }
                for (Map.Entry<String, String> annotation : laa.annotations.entrySet()) {
                    job.addOrReplaceConfValue(new SimpleKeyValue("spark.kubernetes.driver.annotation." + annotation.getKey(), annotation.getValue()));
                    job.addOrReplaceConfValue(new SimpleKeyValue("spark.kubernetes.executor.annotation." + annotation.getKey(), annotation.getValue()));
                }
            }
            SparkKubernetesSubmitHelper.logger.info((Object)"Dumping namespace pods state before starting Spark job");
            try {
                ret = KubectlHelper.executeKubectlToRawString(ks, new String[]{"get", "pods", "--namespace", managedNamespace});
                SparkKubernetesSubmitHelper.logger.info((Object)("\n" + ret));
            }
            catch (Exception e) {
                SparkKubernetesSubmitHelper.logger.warn((Object)"Listing pods of namespace failed, the Spark job is likely to hit issues", (Throwable)e);
            }
            if (StringUtils.isNotBlank((String)ks.kubeConfigPath)) {
                stash.env.put("KUBECONFIG", ks.kubeConfigPath);
            }
            if (StringUtils.isNotBlank((String)(currentSparkMaster = job.getConfValue("spark.master"))) && !currentSparkMaster.startsWith("k8s:")) {
                SparkKubernetesSubmitHelper.logger.warn((Object)("Managed Spark-over-Kubernetes configuration will override existing value of spark.master : " + currentSparkMaster));
            }
            if (StringUtils.isNotBlank((String)ks.kubeCtlContext)) {
                k8sContext = ks.kubeCtlContext;
                this.setK8sSparkMaster(job, ks, k8sContext);
            } else {
                this.setK8sSparkMaster(job, ks, null);
            }
            switch (3.$SwitchMap$com$dataiku$dip$spark$SparkExecutionConfig$KubernetesAuthenticationMode[ks.authenticationMode.ordinal()]) {
                case 1: {
                    bc /* !! */  = kpc = new KubernetesProxyContext();
                    proxyToken = SecretKeyGenerator.generate((int)32);
                    port = DKUNetUtils.findUnusedPort();
                    proxyTokenFile = new File(runDir, "shared-auth-token.txt");
                    DKUFileUtils.writeFileUTF8((File)proxyTokenFile, (String)proxyToken);
                    SparkKubernetesSubmitHelper.logger.info((Object)"Running kubectl proxy");
                    pb = new ProcessBuilder(new String[0]);
                    pb.directory(runDir);
                    cmd = Lists.newArrayList((Object[])new String[]{"kubectl", "proxy"});
                    if (StringUtils.isNotBlank((String)ks.kubeCtlContext)) {
                        cmd.add("--context");
                        cmd.add(ks.kubeCtlContext);
                    }
                    cmd.add("--port");
                    cmd.add("" + port);
                    cmd.add("-v");
                    cmd.add("9");
                    cmd.add("--bearer-token-file");
                    cmd.add(proxyTokenFile.getAbsolutePath());
                    pb.command(cmd);
                    if (StringUtils.isNotBlank((String)ks.kubeConfigPath)) {
                        pb.environment().put("KUBECONFIG", ks.kubeConfigPath);
                    }
                    kpc.process = new RegularProcess(pb, runDir);
                    kpc.process.start();
                    kpc.eoc = new DKUtils.ExecOutputConsumer().withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO));
                    kpc.eoc.start(kpc.process.getInputStream(), kpc.process.getErrorStream(), null);
                    job.addOrReplaceConfValue(new SimpleKeyValue("spark.master", "k8s://http://localhost:" + port));
                    job.addOrReplaceConfValue(new SimpleKeyValue("spark.kubernetes.authenticate.oauthTokenFile", proxyTokenFile.getAbsolutePath()));
                    stash.env.put("KUBERNETES_AUTH_TRYKUBECONFIG", "false");
                    break;
                }
                case 2: {
                    ksac = new KubernetesServiceAccountContext();
                    bc /* !! */  = ksac;
                    ksac.namespace = managedNamespace;
                    ksac.ks = ks;
                    prefix = this.authCtx.getIdentifier().replaceAll("[^A-Za-z0-9]", "-").toLowerCase(Locale.ENGLISH) + "-" + SecretKeyGenerator.generate((int)8).toLowerCase(Locale.ENGLISH);
                    ksac.svcAccountName = "dss-svc-account-" + prefix;
                    KubectlHelper.executeKubectlToVoid(ks, new String[]{"create", "serviceaccount", "--namespace=" + managedNamespace, ksac.svcAccountName});
                    ksac.podsRoleName = "dss-role-pods-" + prefix;
                    KubectlHelper.executeKubectlToVoid(ks, new String[]{"create", "role", ksac.podsRoleName, "--namespace=" + managedNamespace, "--resource=pods", "--verb=get,list,create,delete,deletecollection,watch"});
                    ksac.svcsRoleName = "dss-role-svcs-" + prefix;
                    KubectlHelper.executeKubectlToVoid(ks, new String[]{"create", "role", ksac.svcsRoleName, "--namespace=" + managedNamespace, "--resource=services", "--verb=get,list,create,delete,deletecollection,watch"});
                    ksac.cfgsRoleName = "dss-role-cfgs-" + prefix;
                    KubectlHelper.executeKubectlToVoid(ks, new String[]{"create", "role", ksac.cfgsRoleName, "--namespace=" + managedNamespace, "--resource=configmaps", "--verb=get,list,create,delete,deletecollection,watch"});
                    if (DKUApp.getParams().getBoolParam("dku.spark.serviceAccount.addPVC", true)) {
                        ksac.pvcsRoleName = "dss-role-pvcs-" + prefix;
                        KubectlHelper.executeKubectlToVoid(ks, new String[]{"create", "role", ksac.pvcsRoleName, "--namespace=" + managedNamespace, "--resource=persistentvolumeclaims", "--verb=get,list,delete,deletecollection,watch"});
                    }
                    ksac.podsRbName = "dss-rolebinding-pods-" + prefix;
                    KubectlHelper.executeKubectlToVoid(ks, new String[]{"create", "rolebinding", ksac.podsRbName, "--namespace=" + managedNamespace, "--role=" + ksac.podsRoleName, "--user=system:serviceaccount:" + managedNamespace + ":" + ksac.svcAccountName});
                    ksac.svcsRbName = "dss-rolebinding-svcs-" + prefix;
                    KubectlHelper.executeKubectlToVoid(ks, new String[]{"create", "rolebinding", ksac.svcsRbName, "--namespace=" + managedNamespace, "--role=" + ksac.svcsRoleName, "--user=system:serviceaccount:" + managedNamespace + ":" + ksac.svcAccountName});
                    ksac.cfgsRbName = "dss-rolebinding-cfgs-" + prefix;
                    KubectlHelper.executeKubectlToVoid(ks, new String[]{"create", "rolebinding", ksac.cfgsRbName, "--namespace=" + managedNamespace, "--role=" + ksac.cfgsRoleName, "--user=system:serviceaccount:" + managedNamespace + ":" + ksac.svcAccountName});
                    if (DKUApp.getParams().getBoolParam("dku.spark.serviceAccount.addPVC", true)) {
                        ksac.pvcsRbName = "dss-rolebinding-pvcs-" + prefix;
                        KubectlHelper.executeKubectlToVoid(ks, new String[]{"create", "rolebinding", ksac.pvcsRbName, "--namespace=" + managedNamespace, "--role=" + ksac.pvcsRoleName, "--user=system:serviceaccount:" + managedNamespace + ":" + ksac.svcAccountName});
                    }
                    if (StringUtils.isBlank((String)(secretName = KubectlHelper.executeKubectlToRawString(ks, new String[]{"get", "serviceaccount", "--namespace=" + managedNamespace, ksac.svcAccountName, "-o", "jsonpath={.secrets[0].name}"})))) {
                        secretName = String.format("%s-dku-token", new Object[]{ksac.svcAccountName});
                        secretSpec = KubernetesExecUtils.getServiceAccountTokenConf(ksac.svcAccountName, secretName);
                        secretFile = new File(runDir, "k8s-service-account-secret.yaml");
                        DKUFileUtils.writeFileUTF8((File)secretFile, (String)secretSpec);
                        SparkKubernetesSubmitHelper.logger.info((Object)"Creating service account token");
                        KubectlHelper.executeKubectlToVoid(ks, new String[]{"create", "-f", secretFile.getAbsolutePath(), "--namespace=" + managedNamespace});
                    }
                    if ((secretData = SparkKubernetesSubmitHelper.getSecretDataWithRetry(ks, managedNamespace, secretName)) == null || !secretData.has("data")) {
                        throw new IllegalArgumentException("no data in secret:  " + JSON.json((Object)secretData));
                    }
                    secretDataData = secretData.get("data").getAsJsonObject();
                    if (secretDataData.has("token")) ** GOTO lbl259
                    openshiftSecretName = null;
                    try {
                        secrets = KubectlHelper.executeKubectlToJSON(ks, new String[]{"get", "secret", "--namespace=" + managedNamespace, "-o", "json", "--field-selector", "type=kubernetes.io/service-account-token"});
                        if (!secrets.has("items")) ** GOTO lbl250
                        secretList = secrets.getAsJsonArray("items");
                        for (JsonElement secret : secretList) {
                            metadata = secret.getAsJsonObject().getAsJsonObject("metadata");
                            if (!metadata.has("annotations") || !(annotations = metadata.getAsJsonObject("annotations")).has("kubernetes.io/service-account.name") || !ksac.svcAccountName.equals(saName = annotations.getAsJsonPrimitive("kubernetes.io/service-account.name").getAsString())) continue;
                            openshiftSecretName = metadata.getAsJsonPrimitive("name").getAsString();
                            break;
                        }
                    }
                    catch (Exception e) {
                        SparkKubernetesSubmitHelper.logger.warn((Object)"Unable to find service account token among secrets", (Throwable)e);
                    }
lbl250:
                    // 4 sources

                    if (StringUtils.isNotBlank(openshiftSecretName)) {
                        SparkKubernetesSubmitHelper.logger.info((Object)("Found service account token secret: " + openshiftSecretName));
                        openshiftSecretData = SparkKubernetesSubmitHelper.getSecretDataWithRetry(ks, managedNamespace, openshiftSecretName);
                        if (openshiftSecretData == null || !openshiftSecretData.has("data")) {
                            SparkKubernetesSubmitHelper.logger.warn((Object)"Unable to get data from secret, keeping original secret");
                        } else {
                            secretDataData = openshiftSecretData.get("data").getAsJsonObject();
                        }
                    } else {
                        SparkKubernetesSubmitHelper.logger.warn((Object)"Did not find openshift service account token secret, will likely fail");
                    }
lbl259:
                    // 4 sources

                    tokenFile = new File(runDir, "k8s-service-account-token.txt");
                    caCRTFile = new File(runDir, "k8s-service-account-ca.pem");
                    DKUFileUtils.writeFileUTF8((File)tokenFile, (String)new String(Base64.decodeBase64((String)secretDataData.get("token").getAsString()), StandardCharsets.UTF_8));
                    DKUFileUtils.writeFileUTF8((File)caCRTFile, (String)new String(Base64.decodeBase64((String)secretDataData.get("ca.crt").getAsString()), StandardCharsets.UTF_8));
                    if (isCluster) {
                        job.addOrReplaceConfValue(new SimpleKeyValue("spark.kubernetes.authenticate.driver.serviceAccountName", ksac.svcAccountName));
                        job.addOrReplaceConfValue(new SimpleKeyValue("spark.kubernetes.authenticate.submission.oauthTokenFile", tokenFile.getAbsolutePath()));
                        job.addOrReplaceConfValue(new SimpleKeyValue("spark.kubernetes.authenticate.submission.caCertFile", caCRTFile.getAbsolutePath()));
                    } else {
                        job.addOrReplaceConfValue(new SimpleKeyValue("spark.kubernetes.authenticate.oauthTokenFile", tokenFile.getAbsolutePath()));
                        job.addOrReplaceConfValue(new SimpleKeyValue("spark.kubernetes.authenticate.caCertFile", caCRTFile.getAbsolutePath()));
                    }
                    stash.env.put("KUBERNETES_AUTH_TRYKUBECONFIG", "false");
                    break;
                }
                default: {
                    stash.env.put("KUBERNETES_AUTH_TRYKUBECONFIG", "true");
                }
            }
            if (bc /* !! */  == null) {
                boc = new BaseOnlyContext();
                bc /* !! */  = boc;
            }
            SparkKubernetesSubmitHelper.logger.info((Object)("Using context:" + String.valueOf(bc /* !! */ )));
            if (executionId != null && this.cru != null && this.cru.context.type == ComputeResourceUsageContext.ComputeResourceUsageContextType.JOB_ACTIVITY) {
                SparkKubernetesSubmitHelper.logger.info((Object)"In a job activity, gathering pods descriptions and logs in background");
                p = ProjectsUtils.getMandatoryUnsafe_AutoTXN(this.cru.context.projectKey).getDkuPropertiesAsParams(true);
                if (p.getBoolParam("dku.spark.k8s.gatherPodsDescribesDuringJobs.enabled", true)) {
                    intervalMS = p.getLongParam("dku.spark.k8s.gatherPodsDescribesDuringJobs.intervalMS", 60000L);
                    outputFile = FlowJobUtils.getJobTouchedFile("spark-k8s-recipe", "pods-describe.log");
                    JobContext.getCurrentActivityObj().getStatus().addStatutOutput("Pods describes", outputFile, "text/plain");
                    loopDescriber = new KubectlHelper.KubectlLoopCommandRunner("pods description", ks, outputFile, new KubernetesExecUtils.PodEventsSniffer(), intervalMS, new String[]{"describe", "pods", "--namespace=" + managedNamespace, "-l", "dataiku.com/dku-execution-id=" + (String)executionId});
                    loopDescriber.start();
                    bc /* !! */ .kubectlLoopCallers.add(loopDescriber);
                }
                if (p.getBoolParam("dku.spark.k8s.gatherPodsTopsDuringJobs.enabled", true)) {
                    intervalMS = p.getLongParam("dku.spark.k8s.gatherPodsTopsDuringJobs.intervalMS", 60000L);
                    outputFile = FlowJobUtils.getJobTouchedFile("spark-k8s-recipe", "pods-top.log");
                    JobContext.getCurrentActivityObj().getStatus().addStatutOutput("Pods tops", outputFile, "text/plain");
                    loopDescriber = new KubectlHelper.KubectlLoopCommandRunner("pods top", ks, outputFile, new KubernetesExecUtils.PodEventsSniffer(), intervalMS, new String[]{"top", "pods", "--namespace=" + managedNamespace, "-l", "dataiku.com/dku-execution-id=" + (String)executionId});
                    loopDescriber.start();
                    bc /* !! */ .kubectlLoopCallers.add(loopDescriber);
                }
                if (p.getBoolParam("dku.spark.k8s.gatherPodsLogsDuringJobs.enabled", true)) {
                    intervalMS = p.getLongParam("dku.spark.k8s.gatherPodsLogsDuringJobs.intervalMS", 20000L);
                    executorsOutputFile = FlowJobUtils.getJobTouchedFile("spark-k8s-recipe", "executors-logs.log");
                    JobContext.getCurrentActivityObj().getStatus().addStatutOutput("Executors logs", executorsOutputFile, "text/plain");
                    loopLogger = new KubectlHelper.KubectlLoopLogger(ks, executorsOutputFile, managedNamespace, "dataiku.com/dku-execution-id=" + (String)executionId, new SparkK8SExecutorLogParsingHandler(), intervalMS);
                    loopLogger.start();
                    bc /* !! */ .kubectlLoopCallers.add(loopLogger);
                }
            }
            return bc /* !! */ ;
        }
        return null;
    }

    private static JsonObject getSecretDataWithRetry(SparkExecutionConfig.SparkKubernetesSettings ks, String managedNamespace, String secretName) throws IOException, InterruptedException {
        JsonObject secretData = null;
        long secretDataFetchStart = System.currentTimeMillis();
        long secretDataFetchEnd = secretDataFetchStart + ApplicationConfigurator.getParams().getLongParam("dku.containerexec.kubernetes.secretData.fetchWaitTimeoutMS", 10000L);
        while (!(System.currentTimeMillis() >= secretDataFetchEnd || (secretData = KubectlHelper.executeKubectlToJSON(ks, "get", "secret", "--namespace=" + managedNamespace, secretName, "--ignore-not-found")) != null && secretData.has("data"))) {
            Thread.sleep(1000L);
        }
        return secretData;
    }

    @Override
    protected boolean doUploadForDistribution(String type) {
        return "jars".equals(type) || "main".equals(type);
    }

    @Override
    protected boolean shouldCallContextStopNonetheless() {
        return true;
    }

    @Override
    public SparkJobHelper.SparkJobContext setupRunUsingCluster(SparkJobHelper.RunMode runMode, SparkJobBuilder jobBuilder, final File processRunDir, SparkSubmitJob job, EnvironmentStash stash, SparkJobExecEnv jobExecEnv, CodeEnvModel.UsedCodeEnvRef codeEnvRef) throws InstantiationException, IllegalAccessException, IOException, DKUSecurityException, CodedException, JSchException, InterruptedException {
        File file;
        if (this.usedExecutionConfig == null || !this.usedExecutionConfig.kubernetesSettings.managedKubernetes) {
            throw new IllegalAccessException("Spark-over-k8s in cluster mode is only available with managed k8s settings");
        }
        final SparkJobHelper.SparkJobContext context = super.setupRunUsingCluster(runMode, jobBuilder, processRunDir, job, stash, jobExecEnv, codeEnvRef);
        RemoteRunEnvDef envResource = context.getRemoteRunEnvDef();
        final String jobId = context.getJobId();
        SparkJobFilesInitialFetchRequest fetchRequest = new SparkJobFilesInitialFetchRequest();
        fetchRequest.serverHost = envResource.env.get("DKU_SERVER_HOST");
        fetchRequest.serverPort = envResource.env.get("DKU_SERVER_PORT");
        fetchRequest.serverKind = envResource.env.get("DKU_SERVER_KIND");
        fetchRequest.serverProtocol = envResource.env.get("DKU_SERVER_PROTOCOL");
        if (EncryptedRPC.enabled()) {
            fetchRequest.serverCert = envResource.env.get("DKU_SERVER_CERT");
        }
        fetchRequest.apiTicket = envResource.env.get("DKU_API_TICKET");
        fetchRequest.executionId = jobId;
        File initialFilesStorage = new File(processRunDir, "initial-fetch");
        for (String path : job.secretDriverFiles) {
            file = new File(path);
            FileUtils.copyFileToDirectory((File)file, (File)initialFilesStorage);
            fetchRequest.pathsToFetch.add(file.getName());
        }
        for (String path : job.nonSecretGlobalFiles) {
            file = new File(path);
            FileUtils.copyFileToDirectory((File)file, (File)initialFilesStorage);
            fetchRequest.pathsToFetch.add(file.getName());
            fetchRequest.pathsToDistribute.add(file.getName());
        }
        for (String path : job.pyFiles) {
            file = new File(path);
            FileUtils.copyFileToDirectory((File)file, (File)initialFilesStorage);
            fetchRequest.pathsToFetch.add(file.getName());
            fetchRequest.pathsToPyDistribute.add(file.getName());
        }
        logger.info((Object)"Store initial fetch request in local file for k8s secret via spark-sub");
        File fetchRequestJson = new File(processRunDir, "initial-fetch-request.json");
        FileUtils.write((File)fetchRequestJson, (CharSequence)JSON.json((Object)fetchRequest));
        logger.info((Object)"Make a k8s secret of the initial fetch request");
        final String managedNamespace = this.getManagedNamespaceFromJob(job);
        final String secretName = ("initial-fetch-request-" + SecretKeyGenerator.generate((int)8)).toLowerCase();
        KubectlHelper.executeKubectlToVoid(this.usedExecutionConfig.kubernetesSettings, "create", "secret", "generic", secretName, "--namespace", managedNamespace, "--from-file=" + fetchRequestJson.getAbsolutePath());
        job.conf.add(new SimpleKeyValue("spark.kubernetes.driver.secrets." + secretName, "/etc/initial-fetch-request"));
        job.secretDriverFiles.clear();
        job.nonSecretGlobalFiles.clear();
        job.pyFiles.clear();
        job.conf.add(new SimpleKeyValue("spark.kubernetes.driver.label.dataiku.com/dku-job-id", jobId));
        job.conf.add(new SimpleKeyValue("spark.kubernetes.executor.label.dataiku.com/dku-job-id", jobId));
        RemoteRunsRegistry.get((String)jobId).uploadListener = new RemoteRunsRegistry.RemoteFileUploadListener(){

            @Override
            public void notifyUpload(String path) {
                if ("error.json".equals(path)) {
                    try {
                        JsonObject podObject2;
                        SparkExecutionConfig.SparkKubernetesSettings ks = SparkKubernetesSubmitHelper.this.usedExecutionConfig.kubernetesSettings;
                        JsonObject podList2 = KubectlHelper.executeKubectlToJSON(ks, "get", "pods", "--namespace", managedNamespace, "-l", "spark-role=executor,dataiku.com/dku-job-id=" + jobId);
                        if (podList2.has("items") && podList2.getAsJsonArray("items").size() >= 1 && (podObject2 = podList2.getAsJsonArray("items").get(0).getAsJsonObject()).has("metadata") && podObject2.getAsJsonObject("metadata").has("name")) {
                            String executorPodName = podObject2.getAsJsonObject("metadata").get("name").getAsString();
                            logger.info((Object)("Executor ran in pod " + executorPodName + ", checking its state"));
                            logger.info((Object)"--------------------------");
                            KubectlHelper.logKubectl(ks, false, new File(processRunDir, executorPodName + ".pod.log"), "logs", "--namespace", managedNamespace, executorPodName);
                            logger.info((Object)"--------------------------");
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Error while retrieving executor logs", (Throwable)e);
                    }
                }
            }
        };
        return new SparkJobHelper.SparkJobContext(){

            @Override
            public void close() throws Exception {
                try {
                    KubectlHelper.executeKubectlToVoid(SparkKubernetesSubmitHelper.this.usedExecutionConfig.kubernetesSettings, "delete", "secret", secretName, "--namespace", managedNamespace);
                }
                catch (IOException e) {
                    logger.warn((Object)"Failure while cleaning up Kubernetes authentication stuff", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn((Object)"Failure while cleaning up Kubernetes authentication stuff", (Throwable)e);
                }
                context.close();
                try {
                    KubectlHelper.executeKubectlToVoid(SparkKubernetesSubmitHelper.this.usedExecutionConfig.kubernetesSettings, "delete", "pods", "--namespace", managedNamespace, "-l", "dataiku.com/dku-job-id=" + jobId);
                }
                catch (IOException e) {
                    logger.warn((Object)"Failure while cleaning up Kubernetes authentication stuff", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn((Object)"Failure while cleaning up Kubernetes authentication stuff", (Throwable)e);
                }
            }

            @Override
            public String runAsHadoopUser() throws IOException {
                return context.runAsHadoopUser();
            }

            @Override
            public boolean impersonatesRemotely() {
                return context.impersonatesRemotely();
            }

            @Override
            public RemoteRunEnvDef getRemoteRunEnvDef() {
                return context.getRemoteRunEnvDef();
            }

            @Override
            public File getLocalRunDir() {
                return context.getLocalRunDir();
            }

            @Override
            public String getJobId() {
                return jobId;
            }

            @Override
            public AuthCtx getAuthCtx() {
                return context.getAuthCtx();
            }

            @Override
            public boolean driverRunsRemotely() {
                return context.driverRunsRemotely();
            }

            @Override
            public ComputeResourceUsage getComputeResourceUsage() {
                return SparkKubernetesSubmitHelper.this.cru;
            }

            @Override
            public int doubleCheckRunStarted() throws Exception {
                try {
                    JsonObject podObject;
                    SparkExecutionConfig.SparkKubernetesSettings ks = SparkKubernetesSubmitHelper.this.usedExecutionConfig.kubernetesSettings;
                    JsonObject podList = KubectlHelper.executeKubectlToJSON(ks, "get", "pods", "--namespace", managedNamespace, "-l", "spark-role=driver,dataiku.com/dku-job-id=" + jobId);
                    if (podList.has("items") && podList.getAsJsonArray("items").size() == 1 && (podObject = podList.getAsJsonArray("items").get(0).getAsJsonObject()).has("metadata") && podObject.getAsJsonObject("metadata").has("name")) {
                        String driverPodName = podObject.getAsJsonObject("metadata").get("name").getAsString();
                        logger.info((Object)("Driver ran in pod " + driverPodName + ", checking its state"));
                        int rv = 1;
                        if (podObject.has("status")) {
                            JsonObject statusObject = podObject.getAsJsonObject("status");
                            if (statusObject.has("phase") && "failed".equalsIgnoreCase(statusObject.get("phase").getAsString())) {
                                logger.warn((Object)"Pod status says failed");
                            } else if (statusObject.has("containerStatuses") && statusObject.getAsJsonArray("containerStatuses").size() > 0) {
                                JsonObject containerStatusObject = statusObject.getAsJsonArray("containerStatuses").get(0).getAsJsonObject();
                                if (containerStatusObject.has("state") && containerStatusObject.getAsJsonObject("state").has("terminated")) {
                                    JsonObject finalStateObject = containerStatusObject.getAsJsonObject("state").getAsJsonObject("terminated");
                                    if (finalStateObject.has("exitCode")) {
                                        rv = finalStateObject.get("exitCode").getAsInt();
                                        if (rv == 0) {
                                            return 0;
                                        }
                                    } else {
                                        logger.warn((Object)"Didn't find exit code of container, assuming something went wrong");
                                    }
                                } else {
                                    logger.warn((Object)"Didn't find final state of container, assuming something went wrong");
                                }
                            } else {
                                logger.warn((Object)"Didn't find container statuses, assuming something went wrong");
                            }
                        } else {
                            logger.warn((Object)"Didn't find pod status, assuming something went wrong");
                        }
                        logger.info((Object)"--------------------------");
                        KubectlHelper.logKubectl(ks, false, new File(processRunDir, driverPodName + ".pod.log"), "logs", "--namespace", managedNamespace, driverPodName);
                        logger.info((Object)"--------------------------");
                        return rv;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Error while retrieving driver logs", (Throwable)e);
                }
                return 0;
            }
        };
    }

    private String getManagedNamespaceFromJob(SparkSubmitJob job) {
        for (SimpleKeyValue kv : job.conf) {
            if (!"spark.kubernetes.namespace".equals(kv.key)) continue;
            return kv.value;
        }
        return null;
    }

    private void setK8sSparkMaster(SparkSubmitJob job, SparkExecutionConfig.SparkKubernetesSettings ks, String k8sContext) throws IOException, InterruptedException {
        JsonObject kubeConfigObj = KubectlHelper.executeKubectlToJSON(ks, "config", "view", "--flatten");
        String clusterName = null;
        if (StringUtils.isBlank((String)k8sContext)) {
            logger.info((Object)"Using current context");
            k8sContext = kubeConfigObj.get("current-context").getAsString();
        }
        for (JsonElement context : kubeConfigObj.get("contexts").getAsJsonArray()) {
            JsonObject contextObj = (JsonObject)context;
            if (!StringUtils.equals((String)k8sContext, (String)contextObj.get("name").getAsString())) continue;
            JsonObject contextDef = contextObj.get("context").getAsJsonObject();
            clusterName = contextDef.get("cluster").getAsString();
        }
        if (StringUtils.isBlank(clusterName)) {
            logger.warn((Object)"Unable to find the cluster endpoint, using default from kubectl");
        } else {
            Object server = null;
            for (JsonElement cluster : kubeConfigObj.get("clusters").getAsJsonArray()) {
                JsonObject clusterDef;
                JsonObject clusterObj = (JsonObject)cluster;
                if (!StringUtils.equals((String)clusterName, (String)clusterObj.get("name").getAsString()) || URI.create((String)(server = (clusterDef = clusterObj.get("cluster").getAsJsonObject()).get("server").getAsString())).getPort() != -1) continue;
                logger.warn((Object)"Undefined cluster port, using 443 as default");
                server = (String)server + ":443";
            }
            if (StringUtils.isBlank(server)) {
                logger.warn((Object)"Found the context, but unable to find the cluster endpoint, using default from kubectl");
            } else {
                job.addOrReplaceConfValue(new SimpleKeyValue("spark.master", "k8s://" + server));
            }
        }
    }

    private class KubernetesProxyContext
    extends BaseContext {
        private RegularProcess process;
        private DKUtils.ExecOutputConsumer eoc;

        private KubernetesProxyContext() {
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.process.evilKill();
            try {
                this.eoc.finish();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
    }

    private class KubernetesServiceAccountContext
    extends BaseContext {
        private String namespace;
        private String svcAccountName;
        private String podsRoleName;
        private String podsRbName;
        private String svcsRoleName;
        private String svcsRbName;
        private String cfgsRoleName;
        private String cfgsRbName;
        private String pvcsRoleName;
        private String pvcsRbName;
        private SparkExecutionConfig.SparkKubernetesSettings ks;

        private KubernetesServiceAccountContext() {
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (System.getenv("DKU_NO_CLEANUP_K8S_SECURITY_CONTEXT") != null) {
                return;
            }
            if (this.svcAccountName != null) {
                try {
                    KubectlHelper.executeKubectlToVoid(this.ks, "delete", "serviceaccount", "--namespace", this.namespace, this.svcAccountName);
                    KubectlHelper.executeKubectlToVoid(this.ks, "delete", "rolebinding", "--namespace", this.namespace, this.podsRbName);
                    KubectlHelper.executeKubectlToVoid(this.ks, "delete", "rolebinding", "--namespace", this.namespace, this.svcsRbName);
                    KubectlHelper.executeKubectlToVoid(this.ks, "delete", "rolebinding", "--namespace", this.namespace, this.cfgsRbName);
                    if (StringUtils.isNotBlank((String)this.pvcsRbName)) {
                        KubectlHelper.executeKubectlToVoid(this.ks, "delete", "rolebinding", "--namespace", this.namespace, this.pvcsRbName);
                    }
                    KubectlHelper.executeKubectlToVoid(this.ks, "delete", "role", "--namespace", this.namespace, this.podsRoleName);
                    KubectlHelper.executeKubectlToVoid(this.ks, "delete", "role", "--namespace", this.namespace, this.svcsRoleName);
                    KubectlHelper.executeKubectlToVoid(this.ks, "delete", "role", "--namespace", this.namespace, this.cfgsRoleName);
                    if (StringUtils.isNotBlank((String)this.pvcsRoleName)) {
                        KubectlHelper.executeKubectlToVoid(this.ks, "delete", "role", "--namespace", this.namespace, this.pvcsRoleName);
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Failure while cleaning up Kubernetes authentication stuff", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn((Object)"Failure while cleaning up Kubernetes authentication stuff", (Throwable)e);
                }
            }
        }
    }

    private class BaseOnlyContext
    extends BaseContext {
        private BaseOnlyContext() {
        }
    }

    private abstract class BaseContext
    implements Closeable {
        List<KubectlHelper.KubectlLoopCaller> kubectlLoopCallers = new ArrayList<KubectlHelper.KubectlLoopCaller>();

        private BaseContext() {
        }

        @Override
        public void close() throws IOException {
            for (KubectlHelper.KubectlLoopCaller loopCaller : this.kubectlLoopCallers) {
                logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(loopCaller)));
                loopCaller.cancel();
            }
        }
    }

    class SparkK8SExecutorLogParsingHandler
    implements DKUtils.LineSubscription {
        private final SerializedJobActivityStatus status = JobContext.getCurrentActivityObj().getStatus();

        SparkK8SExecutorLogParsingHandler() {
        }

        public void close() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String line, boolean replace) throws IOException {
            logger.info((Object)("Executor: " + line));
            if (line.contains("entrypoint.sh") && line.contains("Killed")) {
                logger.warn((Object)(SparkCodes.WARN_SPARK_K8S_KILLED_EXECUTORS.getCode() + " : " + SparkCodes.WARN_SPARK_K8S_KILLED_EXECUTORS.getCodeTitle()));
                SerializedJobActivityStatus serializedJobActivityStatus = this.status;
                synchronized (serializedJobActivityStatus) {
                    this.status.messages.withWarningV((InfoMessage.MessageCode)SparkCodes.WARN_SPARK_K8S_KILLED_EXECUTORS, line, new Object[0]);
                }
            }
        }
    }
}

