/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.yarnaware;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.SSHConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSProviderConnectionFactory;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.datasets.fs.hdfs.ACLUtils;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.fs.DirectoryAware;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.PathToURIConverter;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.spark.SparkCodes;
import com.dataiku.dip.spark.yarnaware.YarnClusterCache;
import com.dataiku.dip.spark.yarnaware.YarnClusterCacheDAO;
import com.dataiku.dip.spark.yarnaware.YarnClusterSSHTunnel;
import com.dataiku.dip.spark.yarnaware.YarnClusterSSHTunnelRegistry;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jcraft.jsch.JSchException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkYarnClusterHelper
implements AutoCloseable {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private YarnClusterCacheDAO cacheDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IImpersonationResolverService impersonationResolverService;
    private final String objectId;
    private final RemoteRunEnvDef.ExchangeBox exchangeBox;
    private final YarnClusterCache cache;
    private YarnClusterSSHTunnel tunnel;
    private String tunnelRemoteHost;
    private FSProvider fsProvider;
    private boolean keepFiles;
    public Map<String, byte[]> datas = Maps.newHashMap();
    private static Logger logger = Logger.getLogger((String)"dku.spark.yarn-cluster.helper");

    public SparkYarnClusterHelper(AuthCtx authCtx, String objectType, SparkSettings.YarnClusterSettings yarnClusterSettings, List<SimpleKeyValue> sparkConf) throws IOException, DKUSecurityException, CodedException, InstantiationException, IllegalAccessException, JSchException {
        if (StringUtils.isBlank((String)yarnClusterSettings.connectionName)) {
            throw new CodedException((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_YARN_CLUSTER_SETTING_INCOMPLETE, "No connection defined to upload files/jars");
        }
        if (StringUtils.isBlank((String)yarnClusterSettings.location)) {
            throw new CodedException((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_YARN_CLUSTER_SETTING_INCOMPLETE, "No location defined to upload files/jars");
        }
        this.objectId = objectType + "-" + SecretKeyGenerator.generate((int)16);
        String fullBatchFilesLocation = PathUtils.slashes((String)(yarnClusterSettings.location + "/" + this.objectId), (Boolean)true, (Boolean)false, (boolean)true, (String)"/");
        SpringUtils.getInstance().autowire((Object)this);
        DSSConnection connection = this.connectionsDAO.getMandatoryConnection(authCtx, yarnClusterSettings.connectionName);
        if (!connection.isFreelyUsableBy(authCtx)) {
            throw new CodedException((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_YARN_CLUSTER_SETTING_INCOMPLETE, "Can only use connections that the user can freely use to upload files/jars");
        }
        String providerType = connection.getType();
        if (connection instanceof SSHConnection) {
            providerType = "SCP";
        } else if (connection instanceof FSProviderizableConnection) {
            providerType = ((FSProviderizableConnection)((Object)connection)).getProviderTypes().get(0);
        }
        new FSProviderConnectionFactory().prepareConnectionForProvider(providerType, authCtx, connection);
        DatasetHandler.DatasetMeta<?, ?> datasetMeta = DatasetHandlerFactory.getMeta(providerType);
        AbstractFSDatasetHandler.AbstractFSConfig params = (AbstractFSDatasetHandler.AbstractFSConfig)datasetMeta.paramsClass().newInstance();
        params.connection = connection.name;
        if (connection instanceof EC2Connection) {
            ((BuiltinFSDatasets.S3DatasetConfig)params).bucket = ((EC2Connection)connection).params.defaultManagedBucket;
        } else if (connection instanceof GCSConnection) {
            ((BuiltinFSDatasets.GCSDatasetConfig)params).bucket = ((GCSConnection)connection).params.defaultManagedBucket;
        } else if (connection instanceof AzureConnection) {
            ((BuiltinFSDatasets.AzureBlobDatasetConfig)params).container = ((AzureConnection)connection).params.defaultManagedContainer;
        }
        this.fsProvider = FSProviderFactory.getProvider(providerType, authCtx, null, params, fullBatchFilesLocation, connection);
        if (!(this.fsProvider instanceof PathToURIConverter)) {
            throw new CodedException((InfoMessage.MessageCode)SparkCodes.ERR_SPARK_YARN_CLUSTER_SETTING_INCOMPLETE, "Can only use connections that can produce fully-qualified URIs");
        }
        for (SimpleKeyValue kv : sparkConf) {
            if (!"dku.keep.yarn.cluster.temp.files".equals(kv.key)) continue;
            try {
                this.keepFiles = Boolean.parseBoolean(kv.value);
            }
            catch (Exception e) {
                logger.warn((Object)("Invalid value for 'dku.keep.yarn.cluster.temp.files' : " + kv.value));
            }
        }
        this.exchangeBox = new RemoteRunEnvDef.ExchangeBox();
        this.exchangeBox.connection = connection;
        this.exchangeBox.location = fullBatchFilesLocation;
        this.exchangeBox.providerType = providerType;
        this.cache = this.getCacheIfUpToDate(yarnClusterSettings);
        if (this.fsProvider instanceof DirectoryAware) {
            ((DirectoryAware)this.fsProvider).ensureDirectory("/");
        }
        if (this.fsProvider instanceof HDFSProvider && this.impersonationResolverService.isEnabled()) {
            HDFSProvider hdfsProvider = (HDFSProvider)this.fsProvider;
            try {
                FileSystem fs = hdfsProvider.getImpersonatedFS();
                String dssUserHadoopName = UserGroupInformation.getLoginUser().getShortUserName();
                List<Path> paths = HDFSPermissionsHandler.buildHDFSPathsBetweenConnectionRootAndDatasetConfiguredRoot(hdfsProvider.getConnectionRootWithinURIAuthority(), hdfsProvider.getRoot());
                paths.add(new Path(hdfsProvider.getRoot()));
                for (Path path : paths) {
                    AclStatus aclStatus = fs.getAclStatus(path);
                    if (aclStatus.getOwner().equals(dssUserHadoopName)) {
                        logger.info((Object)("Setting ACLs on: " + String.valueOf(path) + " to give access to " + dssUserHadoopName + " : not needed, already owner"));
                        continue;
                    }
                    logger.info((Object)("Setting ACLs on: " + String.valueOf(path) + " to give access to " + dssUserHadoopName + " : adding entry"));
                    ArrayList acls = Lists.newArrayList((Iterable)aclStatus.getEntries());
                    acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.USER, null, FsAction.ALL));
                    acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.GROUP, null, FsAction.READ_EXECUTE));
                    acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.OTHER, null, FsAction.NONE));
                    acls.add(ACLUtils.acl(AclEntryScope.ACCESS, AclEntryType.USER, dssUserHadoopName, FsAction.ALL));
                    acls.add(ACLUtils.acl(AclEntryScope.DEFAULT, AclEntryType.USER, dssUserHadoopName, FsAction.ALL));
                    ACLUtils.dedupACLs(acls);
                    fs.setAcl(path, (List)acls);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to set acls for dssUser on " + hdfsProvider.getRootPathUri() + ", may not be able to cleanup."), (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((String)yarnClusterSettings.tunnelConnectionName)) {
            this.tunnel = YarnClusterSSHTunnelRegistry.getOrCreate(authCtx, yarnClusterSettings.tunnelConnectionName, yarnClusterSettings.tunnelRemoteHost);
            this.tunnelRemoteHost = yarnClusterSettings.tunnelRemoteHost;
            if (StringUtils.isBlank((String)this.tunnelRemoteHost)) {
                this.tunnelRemoteHost = this.tunnel.getHostName();
            }
        }
    }

    private YarnClusterCache getCacheIfUpToDate(SparkSettings.YarnClusterSettings yarnClusterSettings) throws IOException {
        if (TransactionContext.hasAttachedTransaction()) {
            return this.getCacheIfUpToDate_T(yarnClusterSettings);
        }
        try (Transaction t = this.transactionService.beginRead();){
            YarnClusterCache yarnClusterCache = this.getCacheIfUpToDate_T(yarnClusterSettings);
            return yarnClusterCache;
        }
    }

    private YarnClusterCache getCacheIfUpToDate_T(SparkSettings.YarnClusterSettings yarnClusterSettings) throws IOException {
        YarnClusterCache cachedFiles = this.cacheDAO.get();
        if (!JSON.jsonEquals((Object)yarnClusterSettings, (Object)cachedFiles.yarnClusterSettings)) {
            cachedFiles = new YarnClusterCache();
        }
        return cachedFiles;
    }

    @Override
    public void close() throws Exception {
        if (this.fsProvider != null) {
            try {
                if (!this.keepFiles) {
                    this.fsProvider.deleteRecursive("/");
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to cleanup temp files", (Throwable)e);
            }
            finally {
                this.fsProvider.close();
            }
        }
        if (this.tunnel != null) {
            YarnClusterSSHTunnelRegistry.give(this.tunnel);
            this.tunnel = null;
        }
    }

    public String getObjectId() {
        return this.objectId;
    }

    public RemoteRunEnvDef.ExchangeBox getExchangeBox() {
        return this.exchangeBox;
    }

    public void setupEnvVarsForReachingDSS(EnvironmentStash stash) {
        if (this.tunnel != null) {
            stash.env.put("DKU_TUNNEL_HOST", StringUtils.defaultIfBlank((String)this.tunnelRemoteHost, (String)"127.0.0.1"));
            stash.env.put("DKU_TUNNEL_PORT", Integer.toString(this.tunnel.getRemotePort()));
        }
    }

    public String getURIForUploadedPath(String uploadedPath) {
        return ((PathToURIConverter)this.fsProvider).convertPathToURI(uploadedPath);
    }

    protected void buildDatasJar() throws IOException, CodedException, DKUSecurityException {
        File jarFile;
        AutoDelete tempFolder = null;
        if (JobContext.getCurrentJobContext() != null) {
            jarFile = FlowJobUtils.getJobFile("spark-recipe", "dku-spark-datas.jar");
        } else {
            tempFolder = FlowJobUtils.getTmpFolder("dku-yarn-cluster", "datas");
            jarFile = new File((File)tempFolder, "dku-spark-datas.jar");
        }
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        try (JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);){
            for (Map.Entry<String, byte[]> data : this.datas.entrySet()) {
                this.add(data.getKey(), data.getValue(), target);
            }
        }
        this.uploadKeepName(jarFile);
        if (tempFolder != null) {
            tempFolder.close();
        }
    }

    private void add(String name, byte[] data, JarOutputStream target) throws IOException {
        JarEntry entry = new JarEntry(name);
        target.putNextEntry(entry);
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            IOUtils.copy((InputStream)is, (OutputStream)target);
        }
        target.closeEntry();
    }

    public List<String> dedup(List<String> files, String file) {
        HashSet jars = Sets.newHashSet();
        if (StringUtils.isNotBlank((String)file)) {
            jars.add(file);
        }
        ArrayList dedupedFiles = Lists.newArrayList();
        for (String f : files) {
            if (jars.contains(f)) continue;
            jars.add(f);
            dedupedFiles.add(f);
        }
        return dedupedFiles;
    }

    public String uploadKeepNameToUriUseCache(File file) throws IOException, CodedException, DKUSecurityException {
        YarnClusterCache.YarnClusterFile existing = this.cache.find(file);
        if (existing != null) {
            return existing.remoteUri;
        }
        String uploaded = this.upload(file.getName(), file);
        return this.getURIForUploadedPath(uploaded);
    }

    public String uploadKeepName(File file) throws IOException, CodedException, DKUSecurityException {
        return this.upload(file.getName(), file);
    }

    public String uploadToSubpathKeepName(String subPath, File file) throws IOException, CodedException, DKUSecurityException {
        return this.upload(subPath + "/" + file.getName(), file);
    }

    public String uploadUnicize(File file) throws IOException, CodedException, DKUSecurityException {
        String extension = FilenameUtils.getExtension((String)file.getName());
        String uploadedName = SecretKeyGenerator.generate((int)16) + (String)(StringUtils.isNotBlank((String)extension) ? "." + extension : "");
        return this.upload(uploadedName, file);
    }

    public String uploadToSubpathUnicize(String subPath, File file) throws IOException, CodedException, DKUSecurityException {
        String extension = FilenameUtils.getExtension((String)file.getName());
        String uploadedName = SecretKeyGenerator.generate((int)16) + (String)(StringUtils.isNotBlank((String)extension) ? "." + extension : "");
        return this.upload(subPath + "/" + uploadedName, file);
    }

    public String upload(String targetPath, File file) throws IOException, CodedException, DKUSecurityException {
        try (FileInputStream is = new FileInputStream(file);){
            String string = this.upload(targetPath, is);
            return string;
        }
    }

    private String upload(String uploadedPath, InputStream is) throws IOException, CodedException, DKUSecurityException {
        uploadedPath = PathUtils.slashes((String)uploadedPath, (Boolean)true, (Boolean)false, (boolean)true, (String)"");
        try (OutputStream os = this.fsProvider.write(uploadedPath);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        return uploadedPath;
    }

    public String zipAndUpload(File folder) throws IOException, CodedException, DKUSecurityException {
        return this.zipAndUpload(folder.getName(), folder);
    }

    public String zipAndUpload(String uploadedPath, File folder) throws IOException, CodedException, DKUSecurityException {
        uploadedPath = PathUtils.slashes((String)uploadedPath, (Boolean)true, (Boolean)false, (boolean)true, (String)"");
        try (OutputStream os = this.fsProvider.write(uploadedPath);){
            ZipUnzipDir.zipDirectoryToStream(folder, os);
        }
        return uploadedPath;
    }

    public String uploadData(String uploadedPath, byte[] data) throws IOException, CodedException, DKUSecurityException {
        uploadedPath = PathUtils.slashes((String)uploadedPath, (Boolean)true, (Boolean)false, (boolean)true, (String)"");
        this.datas.put(uploadedPath, data);
        return uploadedPath;
    }

    public boolean download(String downloadedPath, File localFile) throws IOException, CodedException, DKUSecurityException, InterruptedException {
        if (this.fsProvider.stat(downloadedPath = PathUtils.slashes((String)downloadedPath, (Boolean)true, (Boolean)false, (boolean)true, (String)"")) != null) {
            EnrichedInputStream eis = this.fsProvider.read(downloadedPath);
            try (InputStream is = eis.rawStream();
                 FileOutputStream os = new FileOutputStream(localFile);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            return true;
        }
        return false;
    }

    public void clear(String remotePath) throws IOException, CodedException, DKUSecurityException {
        if (this.fsProvider.stat(remotePath) != null) {
            this.fsProvider.deleteRecursive(remotePath);
        } else {
            logger.warn((Object)"File was alread cleared");
        }
    }
}

