/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.project;

import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringStatus;
import com.dataiku.dip.unifiedmonitoring.project.AbstractMonitoredProjectDeployment;
import com.dataiku.dip.unifiedmonitoring.project.ProjectDataQualityDTO;
import com.dataiku.dip.unifiedmonitoring.project.ProjectExecutionStatus;
import com.dataiku.dip.unifiedmonitoring.project.ProjectModelStatus;
import com.dataiku.dip.unifiedmonitoring.project.ProjectScenarioRunsDTO;
import com.dataiku.dss.shadelib.javax.annotation.Nonnull;
import com.dataiku.j2ts.annotations.UIModel;
import javax.annotation.Nullable;

@UIModel
public class MonitoredProjectDeployment
extends AbstractMonitoredProjectDeployment {
    @Nonnull
    public ProjectModelStatus projectModelStatus = new ProjectModelStatus();
    @Nullable
    public ProjectExecutionStatus projectExecutionStatus;
    @Nonnull
    public InfoMessage.InfoMessages projectModelStatusMessages = new InfoMessage.InfoMessages();
    @Nonnull
    public ProjectScenarioRunsDTO projectLastScenarioRuns = new ProjectScenarioRunsDTO();
    @Nonnull
    public InfoMessage.InfoMessages projectLastScenarioRunsMessages = new InfoMessage.InfoMessages();
    @Nullable
    public ProjectDataQualityDTO dataQualityStatus;
    @Nonnull
    public InfoMessage.InfoMessages dataQualityStatusMessages = new InfoMessage.InfoMessages();

    @Override
    public void computeUMStatuses() {
        this.umDeploymentStatus = UnifiedMonitoringStatus.map(this.deploymentHealth);
        this.umGovernanceStatus = UnifiedMonitoringStatus.map(this.governanceStatus, this.governCheckPolicy);
        if (this.governanceStatusMessages.anyMessage && this.governanceStatusMessages.maxSeverity != null) {
            this.umGovernanceStatus = UnifiedMonitoringStatus.worstStatus(this.umGovernanceStatus, UnifiedMonitoringStatus.map(this.governanceStatusMessages.maxSeverity));
            if ((this.umGovernanceStatus == UnifiedMonitoringStatus.WARNING || this.umGovernanceStatus == UnifiedMonitoringStatus.ERROR) && this.governCheckPolicy != null) {
                this.umGovernanceStatus = switch (this.governCheckPolicy) {
                    default -> throw new IncompatibleClassChangeError();
                    case AbstractDeploymentInfra.GovernCheckPolicy.WARN -> UnifiedMonitoringStatus.WARNING;
                    case AbstractDeploymentInfra.GovernCheckPolicy.PREVENT -> UnifiedMonitoringStatus.ERROR;
                    case AbstractDeploymentInfra.GovernCheckPolicy.NO_CHECK -> UnifiedMonitoringStatus.NO_STATUS;
                };
            }
        }
        this.umDataQualityStatus = UnifiedMonitoringStatus.map(this.dataQualityStatus);
        if (this.dataQualityStatusMessages.anyMessage && this.dataQualityStatusMessages.maxSeverity != null) {
            this.umDataQualityStatus = UnifiedMonitoringStatus.worstStatus(this.umDataQualityStatus, UnifiedMonitoringStatus.map(this.dataQualityStatusMessages.maxSeverity));
        }
        this.umProjectModelStatus = UnifiedMonitoringStatus.map(this.projectModelStatus);
        if (this.projectModelStatusMessages.anyMessage && this.projectModelStatusMessages.maxSeverity != null) {
            this.umProjectModelStatus = UnifiedMonitoringStatus.worstStatus(this.umProjectModelStatus, UnifiedMonitoringStatus.map(this.projectModelStatusMessages.maxSeverity));
        }
        this.umProjectExecutionStatus = UnifiedMonitoringStatus.map(this.projectExecutionStatus);
        this.umGlobalStatus = UnifiedMonitoringStatus.worstStatus(this.umDeploymentStatus, this.umProjectModelStatus, this.umProjectExecutionStatus, this.umDataQualityStatus, this.umGovernanceStatus);
    }
}

