/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.scheduler;

import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.apideployer.monitoring.ApiDeploymentSystemMonitoringService;
import com.dataiku.dip.apideployer.monitoring.ApiEndpointActivityMonitoringService;
import com.dataiku.dip.dao.UnifiedMonitoringSettings;
import com.dataiku.dip.dao.UnifiedMonitoringSettingsDAO;
import com.dataiku.dip.maintainance.InterruptAndPrintStackTraceAfterTimeoutTask;
import com.dataiku.dip.maintainance.UnloggedJob;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDeployerComputationService;
import com.dataiku.dip.unifiedmonitoring.logs.UnifiedMonitoringLogsService;
import com.dataiku.dip.unifiedmonitoring.settings.UnifiedMonitoringSettingsService;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@DisallowConcurrentExecution
public abstract class UnifiedMonitoringSnapshotComputationTask
extends InterruptAndPrintStackTraceAfterTimeoutTask
implements UnloggedJob {
    @Autowired
    UnifiedMonitoringDeployerComputationService unifiedMonitoringDeployerComputationService;
    @Autowired
    ApiEndpointActivityMonitoringService apiEndpointActivityMonitoringService;
    @Autowired
    UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO;
    @Autowired
    UnifiedMonitoringLogsService unifiedMonitoringLogsService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    UnifiedMonitoringSettingsService unifiedMonitoringSettingsService;
    @Autowired
    ApiDeploymentSystemMonitoringService apiDeploymentSystemMonitoringService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.deploymentComputationTask");

    protected UnifiedMonitoringSnapshotComputationTask() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public abstract void compute(JobExecutionContext var1) throws Exception;

    public void executeWithTimeout(JobExecutionContext jec) throws JobExecutionException {
        JobKey jobKey = jec.getJobDetail().getKey();
        logger.info((Object)String.format("Starting scheduled job %s", jobKey));
        try (UnifiedMonitoringLogsService.AutoClosableLogToUnifiedMonitoring ignored = new UnifiedMonitoringLogsService.AutoClosableLogToUnifiedMonitoring();){
            this.compute(jec);
        }
        catch (Exception e) {
            try {
                throw new JobExecutionException(String.format("Deployment monitoring snapshots computation failed for %s", jobKey), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (jec.getNextFireTime() != null && jec.getNextFireTime().compareTo(new Date()) < 0) {
                    logger.warn((Object)String.format("New execution of job %s has been fired before the previous one was over. The configured batch frequency might be too small.", jobKey));
                }
                logger.info((Object)String.format("Ending of scheduled job %s", jobKey));
                throw throwable;
            }
        }
        if (jec.getNextFireTime() != null && jec.getNextFireTime().compareTo(new Date()) < 0) {
            logger.warn((Object)String.format("New execution of job %s has been fired before the previous one was over. The configured batch frequency might be too small.", jobKey));
        }
        logger.info((Object)String.format("Ending of scheduled job %s", jobKey));
    }

    private static AuthCtx getAuthCtx(TransactionService transactionService, UnifiedMonitoringSettingsDAO unifiedMonitoringSettingsDAO) throws IOException {
        DSSAuthCtx authCtx;
        try (Transaction t = transactionService.retrieveOrBeginRead();){
            UnifiedMonitoringSettings unifiedMonitoringSettings = unifiedMonitoringSettingsDAO.getUnsafe();
            authCtx = unifiedMonitoringSettings.getAPIRunAsUser();
            if (StringUtils.isNotBlank((String)unifiedMonitoringSettings.apiRunAsUserLogin)) {
                logger.infoV("Using UM configured user for per-user auth: %s", new Object[]{unifiedMonitoringSettings.apiRunAsUserLogin});
                if (!authCtx.isAdmin()) {
                    logger.debugV("UM configured user does not have instance admin permissions. This may cause issues if it does not have permissions on all infras.", new Object[0]);
                }
            }
        }
        return authCtx;
    }

    @Component
    public static class ExternalEndpointStatusesAndActivityMetrics
    extends UnifiedMonitoringSnapshotComputationTask {
        @Override
        public void compute(JobExecutionContext jec) throws Exception {
            AuthCtx authCtx = UnifiedMonitoringSnapshotComputationTask.getAuthCtx(this.transactionService, this.unifiedMonitoringSettingsDAO);
            String externalEndpointsScopeName = (String)jec.getJobDetail().getJobDataMap().get((Object)"externalEndpointsScopeName");
            this.unifiedMonitoringDeployerComputationService.computeMonitoredExternalApiEndpoints_NT(authCtx, externalEndpointsScopeName);
            this.apiEndpointActivityMonitoringService.pullAndSaveScopeActivityMetrics_NT(authCtx, externalEndpointsScopeName, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout());
        }
    }

    @Component
    public static class DeployedProjectsStatuses
    extends UnifiedMonitoringSnapshotComputationTask {
        @Override
        public void compute(JobExecutionContext jec) throws IOException {
            this.unifiedMonitoringDeployerComputationService.computeMonitoredProjects_NT(DSSAuthCtx.internalAdminAuth(), DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout());
        }
    }

    @Component
    public static class ApiEndpointInfraSystemMetrics
    extends UnifiedMonitoringSnapshotComputationTask {
        @Override
        public void compute(JobExecutionContext jec) throws Exception {
            AuthCtx authCtx = UnifiedMonitoringSnapshotComputationTask.getAuthCtx(this.transactionService, this.unifiedMonitoringSettingsDAO);
            String infrastructureId = (String)jec.getJobDetail().getJobDataMap().get((Object)"infrastructureId");
            String overridingConnectionName = null;
            UnifiedMonitoringSettings ums = this.unifiedMonitoringSettingsService.get();
            if (ums != null) {
                overridingConnectionName = ums.overrideConnectionPerInfra.get(infrastructureId);
            }
            this.apiDeploymentSystemMonitoringService.pullAndSaveInfraSystemMetricsIfNeeded_NT(authCtx, infrastructureId, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout(), overridingConnectionName);
        }
    }

    @Component
    public static class ApiEndpointStatusesAndActivityMetrics
    extends UnifiedMonitoringSnapshotComputationTask {
        @Override
        public void compute(JobExecutionContext jec) throws Exception {
            AuthCtx authCtx = UnifiedMonitoringSnapshotComputationTask.getAuthCtx(this.transactionService, this.unifiedMonitoringSettingsDAO);
            String infrastructureId = (String)jec.getJobDetail().getJobDataMap().get((Object)"infrastructureId");
            String overridingConnectionName = null;
            UnifiedMonitoringSettings ums = this.unifiedMonitoringSettingsService.get();
            if (ums != null) {
                overridingConnectionName = ums.overrideConnectionPerInfra.get(infrastructureId);
            }
            this.unifiedMonitoringDeployerComputationService.computeMonitoredManagedApiEndpoints_NT(authCtx, infrastructureId, overridingConnectionName);
            this.apiEndpointActivityMonitoringService.pullAndSaveInfraActivityMetricsIfNeeded_NT(authCtx, infrastructureId, DeployerUtils.getUnifiedMonitoringConnectTimeout(), DeployerUtils.getUnifiedMonitoringSocketTimeout(), overridingConnectionName);
        }
    }
}

