/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class Type
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1) {
            Object v = args[0];
            if (v != null) {
                if (v instanceof String) {
                    return "string";
                }
                if (v instanceof Calendar || v instanceof Date) {
                    return "date";
                }
                if (v instanceof Number) {
                    return "number";
                }
                if (v.getClass().isArray() || v instanceof List) {
                    return "array";
                }
                if (v instanceof EvalError) {
                    return "error";
                }
                return v.getClass().getName();
            }
            return "undefined";
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects one argument");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Type.DOCUMENTATION", "Returns the type of <code>o</code>.").withParams("o").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("3.126").returns("\"number\""));
    }
}

