/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client;

import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.annotation.JsonRootName;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.core.type.TypeReference;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.DeserializationFeature;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.JavaType;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.JsonMappingException;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.ObjectMapper;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.ObjectReader;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.dataiku.dss.shadelibtd.com.google.common.collect.Multimap;
import com.dataiku.dss.shadelibtd.okhttp3.ConnectionPool;
import com.dataiku.dss.shadelibtd.okhttp3.MediaType;
import com.dataiku.dss.shadelibtd.okhttp3.OkHttpClient;
import com.dataiku.dss.shadelibtd.okhttp3.Request;
import com.dataiku.dss.shadelibtd.okhttp3.RequestBody;
import com.dataiku.dss.shadelibtd.okhttp3.Response;
import com.treasuredata.client.BackOff;
import com.treasuredata.client.BackOffStrategy;
import com.treasuredata.client.HttpStatus;
import com.treasuredata.client.ProxyConfig;
import com.treasuredata.client.TDApiRequest;
import com.treasuredata.client.TDClient;
import com.treasuredata.client.TDClientConfig;
import com.treasuredata.client.TDClientException;
import com.treasuredata.client.TDClientHttpException;
import com.treasuredata.client.TDClientInterruptedException;
import com.treasuredata.client.TDHttpMethod;
import com.treasuredata.client.TDHttpRequestHandler;
import com.treasuredata.client.TDHttpRequestHandlers;
import com.treasuredata.client.impl.ProxyAuthenticator;
import com.treasuredata.client.model.JsonCollectionRootName;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDHttpClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TDHttpClient.class);
    private static final String AUTHORIZATION = "Authorization";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String DATE = "Date";
    private static final String LOCATION = "Location";
    private static final String USER_AGENT = "User-Agent";
    static ObjectMapper defaultObjectMapper = new ObjectMapper().registerModule(new JsonOrgModule()).registerModule(new Jdk8Module()).configure(DeserializationFeature.UNWRAP_ROOT_VALUE, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final Pattern NAKED_TD1_KEY_PATTERN = Pattern.compile("^(?:[1-9][0-9]*/)?[a-f0-9]{40}$");
    protected final TDClientConfig config;
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;
    final Map<String, Collection<String>> headers;
    private static final ThreadLocal<SimpleDateFormat> RFC2822_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        }
    };
    private static MediaType mediaTypeJson = MediaType.parse("application/json");
    private static MediaType mediaTypeXwwwFormUrlencoded = MediaType.parse("application/x-www-form-urlencoded");
    private static MediaType mediaTypeOctetStream = MediaType.parse("application/octet-stream");

    public TDHttpClient(TDClientConfig config) {
        this.config = config;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(config.connectTimeoutMillis, TimeUnit.MILLISECONDS);
        builder.readTimeout(config.readTimeoutMillis, TimeUnit.MILLISECONDS);
        if (config.proxy.isPresent()) {
            ProxyConfig proxyConfig = config.proxy.get();
            logger.trace("proxy configuration: " + proxyConfig);
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfig.getHost(), proxyConfig.getPort())));
            if (proxyConfig.requireAuthentication()) {
                builder.proxyAuthenticator(new ProxyAuthenticator(proxyConfig));
            }
        }
        ConnectionPool connectionPool = new ConnectionPool(config.connectionPoolSize, 5L, TimeUnit.MINUTES);
        builder.connectionPool(connectionPool);
        this.httpClient = builder.build();
        this.headers = config.headersV2;
        this.objectMapper = defaultObjectMapper;
    }

    protected TDHttpClient(TDHttpClient reference) {
        this(reference.config, reference.httpClient, reference.objectMapper, reference.headers);
    }

    private TDHttpClient(TDClientConfig config, OkHttpClient httpClient, ObjectMapper objectMapper, Map<String, Collection<String>> headers) {
        this.config = config;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
        this.headers = headers;
    }

    @Deprecated
    public TDHttpClient withHeaders(Multimap<String, String> headers) {
        return this.withHeaders(headers.asMap());
    }

    public TDHttpClient withHeaders(Map<String, ? extends Collection<String>> headers) {
        HashMap<String, Collection<String>> mergedHeaders = new HashMap<String, Collection<String>>(this.headers);
        mergedHeaders.putAll(headers);
        return new TDHttpClient(this.config, this.httpClient, this.objectMapper, Collections.unmodifiableMap(mergedHeaders));
    }

    ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    protected Request.Builder setTDAuthHeaders(Request.Builder request, String dateHeader) {
        return request;
    }

    protected String getClientName() {
        return "td-client-java " + TDClient.getVersion();
    }

    public Request prepareRequest(TDApiRequest apiRequest, Optional<String> apiKeyCache) {
        String requestUri;
        String queryStr = "";
        String portStr = this.config.port.map(input -> ":" + input).orElse("");
        String string = apiRequest.getPath().startsWith("http") ? apiRequest.getPath() : (requestUri = String.format("%s://%s%s%s", this.config.useSSL ? "https" : "http", this.config.endpoint, portStr, apiRequest.getPath()));
        if (!apiRequest.getQueryParams().isEmpty()) {
            ArrayList<String> queryParamList = new ArrayList<String>(apiRequest.getQueryParams().size());
            for (Map.Entry<String, String> entry : apiRequest.getQueryParams().entrySet()) {
                queryParamList.add(String.format("%s=%s", TDApiRequest.urlEncode(entry.getKey()), TDApiRequest.urlEncode(entry.getValue())));
            }
            queryStr = String.join((CharSequence)"&", queryParamList);
            if (apiRequest.getMethod() == TDHttpMethod.GET || apiRequest.getMethod() == TDHttpMethod.POST && apiRequest.getPostJson().isPresent()) {
                requestUri = requestUri + "?" + queryStr;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sending API request to {}", (Object)requestUri);
        }
        String dateHeader = RFC2822_FORMAT.get().format(new Date());
        StringJoiner joiner = new StringJoiner(",");
        joiner.add(this.getClientName());
        for (String s2 : (Collection)this.headers.getOrDefault(USER_AGENT, Collections.emptyList())) {
            joiner.add(s2);
        }
        String string2 = joiner.toString();
        Request.Builder request = new Request.Builder().url(requestUri).header(USER_AGENT, string2).header(DATE, dateHeader);
        request = this.setTDAuthHeaders(request, dateHeader);
        for (Map.Entry<String, Collection<String>> e : this.headers.entrySet()) {
            if (e.getKey().equals(USER_AGENT)) continue;
            for (String v : e.getValue()) {
                request = request.addHeader(e.getKey(), v);
            }
        }
        for (Map.Entry<String, Collection<String>> entry : apiRequest.getAllHeaders().entrySet()) {
            String k = entry.getKey();
            for (String v : entry.getValue()) {
                request = request.addHeader(k, v);
            }
        }
        Optional apiKey = Stream.of(apiKeyCache, this.config.apiKey).flatMap(opt -> opt.map(Stream::of).orElseGet(Stream::empty)).findFirst();
        if (apiKey.isPresent()) {
            String auth = TDHttpClient.isNakedTD1Key((String)apiKey.get()) ? "TD1 " + (String)apiKey.get() : (String)apiKey.get();
            request = request.header(AUTHORIZATION, auth);
        }
        switch (apiRequest.getMethod()) {
            case GET: {
                request = request.get();
                break;
            }
            case DELETE: {
                request = request.delete();
                break;
            }
            case POST: {
                if (apiRequest.getPostJson().isPresent()) {
                    request = request.post(TDHttpClient.createRequestBodyWithoutCharset(mediaTypeJson, apiRequest.getPostJson().get()));
                    break;
                }
                if (queryStr.length() > 0) {
                    request = request.post(TDHttpClient.createRequestBodyWithoutCharset(mediaTypeXwwwFormUrlencoded, queryStr));
                    break;
                }
                request = request.header(CONTENT_LENGTH, "0").post(RequestBody.create(null, ""));
                break;
            }
            case PUT: {
                if (apiRequest.getPutFile().isPresent()) {
                    try {
                        request = request.put(RequestBody.create(mediaTypeOctetStream, apiRequest.getPutFile().get()));
                        break;
                    }
                    catch (NullPointerException e) {
                        throw new TDClientException(TDClientException.ErrorType.INVALID_INPUT, "Failed to read input file: " + apiRequest.getPutFile().get());
                    }
                }
                if (apiRequest.getContent().isPresent()) {
                    try {
                        request = request.put(RequestBody.create(mediaTypeOctetStream, apiRequest.getContent().get(), apiRequest.getContentOffset(), apiRequest.getContentLength()));
                        break;
                    }
                    catch (Throwable e) {
                        throw new TDClientException(TDClientException.ErrorType.INVALID_INPUT, "Failed to get Content");
                    }
                }
                request = queryStr.length() > 0 ? request.put(TDHttpClient.createRequestBodyWithoutCharset(mediaTypeXwwwFormUrlencoded, queryStr)) : request.header(CONTENT_LENGTH, "0").put(RequestBody.create(null, ""));
            }
        }
        return request.build();
    }

    private static RequestBody createRequestBodyWithoutCharset(MediaType contentType, String content) {
        Charset charset = StandardCharsets.UTF_8;
        if (contentType != null && (charset = contentType.charset()) == null) {
            charset = StandardCharsets.UTF_8;
        }
        byte[] bytes = content.getBytes(charset);
        return RequestBody.create(contentType, bytes);
    }

    private static boolean isNakedTD1Key(String s2) {
        return NAKED_TD1_KEY_PATTERN.matcher(s2).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <Result> Result submitRequest(RequestContext context, TDHttpRequestHandler<Result> handler) throws TDClientException, InterruptedException {
        int executionCount = context.backoff.getExecutionCount();
        if (executionCount > this.config.retryLimit) {
            logger.warn("API request retry limit exceeded: ({}/{})", (Object)this.config.retryLimit, (Object)this.config.retryLimit);
            if (!context.rootCause.isPresent()) throw new IllegalStateException("rootCause must be present here");
            throw context.rootCause.get();
        }
        if (executionCount == 0) {
            context.backoff.incrementExecutionCount();
        } else {
            long waitTimeMillis = this.calculateWaitTimeMillis(context.backoff.nextWaitTimeMillis(), context.rootCause);
            logger.warn(String.format("Retrying request to %s (%d/%d) in %.2f sec.", context.apiRequest.getPath(), executionCount, this.config.retryLimit, (double)waitTimeMillis / 1000.0));
            Thread.sleep(waitTimeMillis);
        }
        try {
            Request request = this.prepareRequest(context.apiRequest, context.apiKeyCache);
            request = handler.prepareRequest(request);
            try (Response response = handler.send(this.httpClient, request);){
                String location;
                int code = response.code();
                if ((code == 307 || code == 308) && (location = response.header(LOCATION)) != null) {
                    context = context.withTDApiRequest(context.apiRequest.withUri(location));
                    Result Result = this.submitRequest(context, handler);
                    return Result;
                }
                TDHttpRequestHandler.ResponseContext responseContext = new TDHttpRequestHandler.ResponseContext(context.apiRequest, response);
                if (handler.isSuccess(responseContext)) {
                    logger.debug(String.format("[%d:%s] API request to %s has succeeded", code, HttpStatus.getMessage(code), context.apiRequest.getPath()));
                    Result Result = handler.onSuccess(response);
                    return Result;
                }
                context = context.withRootCause(handler.resolveHttpResponseError(responseContext));
                return this.submitRequest(context, handler);
            }
        }
        catch (Exception e) {
            if (!TDClientHttpException.class.isAssignableFrom(e.getClass())) {
                logger.warn(String.format("API request to %s failed: %s, cause: %s", context.apiRequest.getPath(), e.getClass(), e.getCause() == null ? e.getMessage() : e.getCause().getClass()), (Throwable)e);
            }
            context = context.withRootCause(handler.resolveError(e));
        }
        return this.submitRequest(context, handler);
    }

    private long calculateWaitTimeMillis(long nextWaitTimeMillis, Optional<TDClientException> rootCause) {
        TDClientHttpException httpException;
        Optional<Date> retryAfter;
        if (rootCause.isPresent() && rootCause.get() instanceof TDClientHttpException && (retryAfter = (httpException = (TDClientHttpException)rootCause.get()).getRetryAfter()).isPresent()) {
            long maxWaitMillis = this.config.retryLimit * this.config.retryMaxIntervalMillis;
            long now = System.currentTimeMillis();
            long retryAfterMillis = retryAfter.get().getTime() - now;
            if (retryAfterMillis > maxWaitMillis) {
                throw httpException;
            }
            nextWaitTimeMillis = Math.max(nextWaitTimeMillis, retryAfterMillis);
        }
        return nextWaitTimeMillis;
    }

    public <Result> Result submitRequest(TDApiRequest apiRequest, Optional<String> apiKeyCache, TDHttpRequestHandler<Result> handler) throws TDClientException {
        RequestContext requestContext = new RequestContext(this.config, apiRequest, apiKeyCache);
        try {
            return this.submitRequest(requestContext, handler);
        }
        catch (InterruptedException e) {
            logger.warn("API request interrupted", (Throwable)e);
            throw new TDClientInterruptedException(e);
        }
        catch (TDClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_JSON_RESPONSE, e);
        }
    }

    public String call(TDApiRequest apiRequest, Optional<String> apiKeyCache) {
        String content = this.submitRequest(apiRequest, apiKeyCache, TDHttpRequestHandlers.stringContentHandler);
        if (logger.isTraceEnabled()) {
            logger.trace("response:\n{}", (Object)content);
        }
        return content;
    }

    @Deprecated
    public <Result> Result call(TDApiRequest apiRequest, Optional<String> apiKeyCache, com.dataiku.dss.shadelibtd.com.google.common.base.Function<InputStream, Result> contentStreamHandler) {
        return this.submitRequest(apiRequest, apiKeyCache, TDHttpRequestHandlers.newByteStreamHandler(contentStreamHandler));
    }

    public <Result> Result call(TDApiRequest apiRequest, Optional<String> apiKeyCache, Function<InputStream, Result> contentStreamHandler) {
        return this.submitRequest(apiRequest, apiKeyCache, TDHttpRequestHandlers.newByteStreamHandler(contentStreamHandler));
    }

    public <Result> Result call(TDApiRequest apiRequest, Optional<String> apiKeyCache, Class<Result> resultType) throws TDClientException {
        return this.call(apiRequest, apiKeyCache, this.objectMapper.getTypeFactory().constructType(resultType));
    }

    public <Result> Result call(TDApiRequest apiRequest, Optional<String> apiKeyCache, TypeReference<Result> resultType) throws TDClientException {
        return this.call(apiRequest, apiKeyCache, this.objectMapper.getTypeFactory().constructType(resultType));
    }

    public <Result> Result call(TDApiRequest apiRequest, Optional<String> apiKeyCache, JavaType resultType) throws TDClientException {
        try {
            byte[] content = this.submitRequest(apiRequest, apiKeyCache, TDHttpRequestHandlers.byteArrayContentHandler);
            if (logger.isTraceEnabled()) {
                logger.trace("response:\n{}", (Object)new String(content, StandardCharsets.UTF_8));
            }
            if (resultType.getRawClass() == String.class) {
                return (Result)new String(content, StandardCharsets.UTF_8);
            }
            return (Result)this.getJsonReader(resultType).readValue(content);
        }
        catch (JsonMappingException e) {
            logger.error("Jackson mapping error", (Throwable)e);
            throw new TDClientException(TDClientException.ErrorType.INVALID_JSON_RESPONSE, e);
        }
        catch (IOException e) {
            throw new TDClientException(TDClientException.ErrorType.INVALID_JSON_RESPONSE, e);
        }
    }

    private ObjectReader getJsonReader(JavaType type) {
        ObjectReader reader = this.objectMapper.readerFor(type);
        if (type.getContentType() != null) {
            JsonCollectionRootName rootName = type.getContentType().getRawClass().getAnnotation(JsonCollectionRootName.class);
            if (rootName != null) {
                reader = reader.withRootName(rootName.value());
            }
        } else {
            JsonRootName rootName = type.getRawClass().getAnnotation(JsonRootName.class);
            if (rootName != null) {
                reader = reader.withRootName(rootName.value());
            }
        }
        return reader;
    }

    protected static class RequestContext {
        private final BackOff backoff;
        public final TDApiRequest apiRequest;
        public final Optional<String> apiKeyCache;
        public final Optional<TDClientException> rootCause;

        public RequestContext(TDClientConfig config, TDApiRequest apiRequest, Optional<String> apiKeyCache) {
            this(BackOffStrategy.newBackOff(config), apiRequest, apiKeyCache, Optional.empty());
        }

        public RequestContext(BackOff backoff, TDApiRequest apiRequest, Optional<String> apiKeyCache, Optional<TDClientException> rootCause) {
            this.backoff = backoff;
            this.apiRequest = apiRequest;
            this.apiKeyCache = apiKeyCache;
            this.rootCause = rootCause;
        }

        public RequestContext withTDApiRequest(TDApiRequest newApiRequest) {
            return new RequestContext(this.backoff, newApiRequest, this.apiKeyCache, this.rootCause);
        }

        public RequestContext withRootCause(TDClientException e) {
            return new RequestContext(this.backoff, this.apiRequest, this.apiKeyCache, Optional.of(e));
        }
    }
}

