/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionExport;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionStatus;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.import_export.ExportedEntity;
import com.dataiku.gh.core.models.security.UsersContainersValidationConfig;
import com.dataiku.gh.core.models.ui.UIBlueprintVersion;
import com.dataiku.gh.core.services.blueprints.IAdminBlueprintsAnalysisService;
import com.dataiku.gh.core.services.blueprints.IAdminBlueprintsService;
import com.dataiku.gh.core.services.import_export.IExportedEntityMigrationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.auth.UIAuthService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminBlueprintVersionsController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IExportedEntityMigrationService importExportMigrationService;
    @Autowired
    private IAdminBlueprintsService adminBlueprintsService;
    @Autowired
    private IAdminBlueprintsAnalysisService adminBlueprintsAnalysisService;

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-versions/get"}, method={RequestMethod.GET})
    @ResponseBody
    public UIBlueprintVersion get(HttpServletRequest req, @RequestParam BlueprintVersionId blueprintVersionId) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            UIBlueprintVersion uiBlueprintVersion = this.adminBlueprintsService.getBlueprintVersion(authCtx, blueprintVersionId);
            this.auditTrailService.generic("admin-blueprint-version-get").with("blueprintId", uiBlueprintVersion.blueprintVersion.id.blueprintId).with("versionId", uiBlueprintVersion.blueprintVersion.id.versionId).emit();
            return uiBlueprintVersion;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-get", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-versions/import"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_IMPORT)
    @ResponseBody
    public UIBlueprintVersion importVersion(HttpServletRequest req, @RequestParam String blueprintId, @RequestParam JsonObject toImport, @RequestParam(required=false) Boolean ignoreOriginVersionErrors, @RequestParam(required=false) UsersContainersValidationConfig.ValidationBehavior signoffImportRoles, @RequestParam(required=false) BlueprintVersionExport.MigrationPathImportBehavior migrationPathImportBehavior) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            BlueprintVersionExport blueprintVersionExport = this.importExportMigrationService.unwrapAndMigrateExportedEntity(toImport, BlueprintVersionExport.class);
            if (blueprintVersionExport != null && blueprintVersionExport.blueprintVersion != null && blueprintVersionExport.blueprintVersion.id != null && blueprintVersionExport.blueprintVersion.id.blueprintId != null && !StringUtils.equals((CharSequence)blueprintId, (CharSequence)blueprintVersionExport.blueprintVersion.id.blueprintId)) {
                throw new ValidationException("Blueprint IDs do not match: " + blueprintId + " , " + blueprintVersionExport.blueprintVersion.id.blueprintId);
            }
            UIBlueprintVersion uiBlueprintVersion = this.adminBlueprintsService.importBlueprintVersion(authCtx, blueprintVersionExport, Boolean.TRUE.equals(ignoreOriginVersionErrors), Optional.ofNullable(signoffImportRoles).orElse(UsersContainersValidationConfig.ValidationBehavior.ALL), Optional.ofNullable(migrationPathImportBehavior).orElse(BlueprintVersionExport.MigrationPathImportBehavior.FAIL_IMPORT_ON_EXISTING_MIGRATION_OR_MISSING_VERSION));
            this.auditTrailService.generic("admin-blueprint-version-import").with("blueprintId", uiBlueprintVersion.blueprintVersion.id.blueprintId).with("versionId", uiBlueprintVersion.blueprintVersion.id.versionId).emit();
            return uiBlueprintVersion;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-import", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-versions/export"}, method={RequestMethod.POST})
    @ResponseBody
    public ExportedEntity<BlueprintVersionExport> exportVersion(HttpServletRequest req, @RequestParam BlueprintVersionId blueprintVersionId) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            BlueprintVersionExport bpv = this.adminBlueprintsService.exportBlueprintVersion(authCtx, blueprintVersionId);
            ExportedEntity<BlueprintVersionExport> export = this.importExportMigrationService.wrapToExportedEntity(bpv);
            this.auditTrailService.generic("admin-blueprint-version-export").with("blueprintId", blueprintVersionId.blueprintId).with("versionId", blueprintVersionId.versionId).emit();
            return export;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-export", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-versions/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_CREATE)
    @ResponseBody
    public UIBlueprintVersion create(HttpServletRequest req, @RequestParam String blueprintId, @RequestParam String newIdentifier, @RequestParam(required=false) String name, @RequestParam(required=false) String originVersionId) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            UIBlueprintVersion uiBlueprintVersion = this.adminBlueprintsService.createBlueprintVersion(authCtx, blueprintId, newIdentifier, name, originVersionId);
            this.auditTrailService.generic("admin-blueprint-version-create").with("blueprintId", uiBlueprintVersion.blueprintVersion.id.blueprintId).with("versionId", uiBlueprintVersion.blueprintVersion.id.versionId).emit();
            return uiBlueprintVersion;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-versions/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_SAVE)
    @ResponseBody
    public UIBlueprintVersion save(HttpServletRequest req, @RequestParam BlueprintVersion blueprintVersion, @RequestParam(required=false) Boolean dangerZoneAccepted) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            UIBlueprintVersion uiBlueprintVersion = this.adminBlueprintsService.saveBlueprintVersion(authCtx, blueprintVersion, Boolean.TRUE.equals(dangerZoneAccepted));
            this.auditTrailService.generic("admin-blueprint-version-save").with("blueprintId", uiBlueprintVersion.blueprintVersion.id.blueprintId).with("versionId", uiBlueprintVersion.blueprintVersion.id.versionId).emit();
            return uiBlueprintVersion;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-versions/update-status"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_STATUS_UPDATE)
    @ResponseBody
    public UIBlueprintVersion updateStatus(HttpServletRequest req, @RequestParam BlueprintVersionId blueprintVersionId, @RequestParam BlueprintVersionStatus blueprintVersionStatus) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            UIBlueprintVersion uiBlueprintVersion = this.adminBlueprintsService.updateBlueprintVersionStatus(authCtx, blueprintVersionId, blueprintVersionStatus);
            this.auditTrailService.generic("admin-blueprint-version-update-status").with("blueprintId", uiBlueprintVersion.blueprintVersion.id.blueprintId).with("versionId", uiBlueprintVersion.blueprintVersion.id.versionId).emit();
            return uiBlueprintVersion;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-update-status", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-versions/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UIBlueprintVersion> list(HttpServletRequest req, @RequestParam(required=false) String blueprintId) throws Exception {
        try {
            List<UIBlueprintVersion> uiBlueprintVersions;
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            AuditTrailService.EmittableAuditObj obj = this.auditTrailService.generic("admin-blueprint-versions-list");
            if (StringUtils.isNotBlank((CharSequence)blueprintId)) {
                obj.with("blueprintId", blueprintId);
                uiBlueprintVersions = this.adminBlueprintsService.listBlueprintVersionsByBlueprint(authCtx, blueprintId);
            } else {
                uiBlueprintVersions = this.adminBlueprintsService.listBlueprintVersions(authCtx);
            }
            obj.emit();
            return uiBlueprintVersions;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-versions-list", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-versions/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.BLUEPRINT_VERSION_DELETE)
    @ResponseBody
    public void delete(HttpServletRequest req, @RequestParam BlueprintVersionId blueprintVersionId) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.adminBlueprintsService.deleteBlueprintVersion(authCtx, blueprintVersionId);
            this.auditTrailService.generic("admin-blueprint-version-delete").with("blueprintId", blueprintVersionId.blueprintId).with("versionId", blueprintVersionId.versionId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-delete", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-versions/count-existing-artifacts"}, method={RequestMethod.GET})
    @ResponseBody
    public long countBlueprintVersionExistingArtifacts(HttpServletRequest req, @RequestParam BlueprintVersionId blueprintVersionId) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            long count = this.adminBlueprintsService.countBlueprintVersionExistingArtifacts(authCtx, blueprintVersionId);
            this.auditTrailService.generic("admin-blueprint-version-count-existing-artifacts").with("blueprintId", blueprintVersionId.blueprintId).with("versionId", blueprintVersionId.versionId).emit();
            return count;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-count-existing-artifacts", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-versions/analysis"}, method={RequestMethod.GET})
    @ResponseBody
    public InfoMessage.InfoMessages analysis(HttpServletRequest req, @RequestParam BlueprintVersionId blueprintVersionId) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.auditTrailService.generic("admin-blueprint-version-analysis").with("blueprintId", blueprintVersionId.blueprintId).with("versionId", blueprintVersionId.versionId).emit();
            return this.adminBlueprintsAnalysisService.analysis(authCtx, blueprintVersionId);
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-analysis", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-versions/analysis"}, method={RequestMethod.POST})
    @ResponseBody
    public InfoMessage.InfoMessages analysis(HttpServletRequest req, @RequestParam BlueprintVersion blueprintVersion) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            this.auditTrailService.generic("admin-blueprint-version-analysis").with("blueprintId", blueprintVersion.id.blueprintId).with("versionId", blueprintVersion.id.versionId).emit();
            return this.adminBlueprintsAnalysisService.analysis(authCtx, blueprintVersion);
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-blueprint-version-analysis", (Throwable)e).emit();
            throw e;
        }
    }
}

