/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.admin.migrations;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.admin.MigrationFile;
import com.dataiku.gh.core.services.admin.migrations.Migration;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationEntitiesUtilsBetweenV13300AndBeyond;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import com.google.common.collect.Iterators;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class MigrationV13300
extends Migration {
    private static final String[] BPV_BLUEPRINT_IDS = new String[]{"api_deployer_deployment", "api_deployer_infrastructure", "business_initiative", "dataiku_bundle", "dataiku_dataset", "dataiku_project", "dataiku_saved_model", "dataiku_saved_model_version", "govern_bundle", "govern_dataset", "govern_model", "govern_model_version", "govern_project", "group", "project_deployer_deployment", "project_deployer_infrastructure", "user"};
    private Long actionId;

    private Long getMigrationActionId(IDBMigrationDAO dbMigrationDAO, long migrationTS) throws IOException {
        if (this.actionId == null) {
            this.actionId = MigrationEntitiesUtilsBetweenV13300AndBeyond.createMigrationAction(dbMigrationDAO.getJdbcTemplate(), migrationTS);
        }
        return this.actionId;
    }

    @Override
    protected void preRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        MigrationV13300.viewsMigration(dbMigrationDAO);
        MigrationV13300.viewsHistoryMigration(dbMigrationDAO);
    }

    @Override
    protected void postRunSQLFiles(IDBMigrationDAO dbMigrationDAO, List<MigrationFile> migrationFiles) throws IOException {
        long migrationTS = this.getMigrationTimestamp();
        long actionId = this.getMigrationActionId(dbMigrationDAO, migrationTS);
        MigrationV13300.migrateAutoConfiguredProject(dbMigrationDAO.getJdbcTemplate(), migrationTS, actionId);
    }

    @Override
    protected void updateProvidedSystemObjects(IDBMigrationDAO dbMigrationDAO, @Nullable File providedObjectsFolder) throws IOException {
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        long migrationTS = this.getMigrationTimestamp();
        long actionId = this.getMigrationActionId(dbMigrationDAO, migrationTS);
        for (String bpvBlueprintId : BPV_BLUEPRINT_IDS) {
            MigrationEntitiesUtilsBetweenV13300AndBeyond.upsertBlueprintVersion(jdbcTemplate, DKUFileUtils.build((File)providedObjectsFolder, (String[])new String[]{bpvBlueprintId, "blueprint_version_default.json"}), "bp.system." + bpvBlueprintId, "bv.system.default", actionId, migrationTS);
        }
        MigrationV13300.migrateProjectDeployerInfraType(dbMigrationDAO, migrationTS, actionId);
        MigrationV13300.cleanBundlesAndModelVersionsArtifacts(dbMigrationDAO);
    }

    private static void cleanBundlesAndModelVersionsArtifacts(IDBMigrationDAO dbMigrationDAO) throws IOException {
        MigrationV13300.cleanArtifactsForUnexistingField(dbMigrationDAO, "bp.system.govern_bundle", "dataiku_project");
        MigrationV13300.cleanArtifactsForUnexistingField(dbMigrationDAO, "bp.system.govern_model_version", "dataiku_saved_model");
    }

    private static void cleanArtifactsForUnexistingField(IDBMigrationDAO dbMigrationDAO, String blueprintId, String fieldID) throws IOException {
        String update = "WITH find_lines_needing_fix AS (\n   SELECT * \n   FROM artifacts\n   JOIN blueprint_versions ON (artifact_blueprint_id = blueprint_version_blueprint_id AND artifact_version_id = blueprint_version_version_id)\n   WHERE artifact_blueprint_id = '" + blueprintId + "'\n   AND artifact_json -> 'fields' ? '" + fieldID + "'\n   AND NOT (blueprint_version_json -> 'fieldDefinitions' ? '" + fieldID + "')\n)\nUPDATE artifacts\nSET artifact_json = find_lines_needing_fix.artifact_json #- '{fields, " + fieldID + "}'\nFROM find_lines_needing_fix\nWHERE artifacts.artifact_id = find_lines_needing_fix.artifact_id";
        dbMigrationDAO.getJdbcTemplate().execute(update);
        String updateHistory = "WITH find_lines_needing_fix AS (\n    SELECT artifacts_history.*\n    FROM artifacts_history\n    LEFT JOIN LATERAL (\n        SELECT *\n        FROM blueprint_versions_history\n        WHERE blueprint_versions_history._revision_id IN (\n            SELECT DISTINCT ON (h.blueprint_version_blueprint_id, h.blueprint_version_version_id) h._revision_id\n            FROM blueprint_versions_history h\n            WHERE h._revision_timestamp <= artifacts_history._revision_timestamp\n            AND h.blueprint_version_blueprint_id = artifacts_history.artifact_blueprint_id\n            AND h.blueprint_version_version_id = artifacts_history.artifact_version_id\n            ORDER BY h.blueprint_version_blueprint_id, h.blueprint_version_version_id, h._revision_timestamp DESC, h._revision_id DESC\n        )\n        AND blueprint_versions_history._revision_json ->> 'operation' != 'DELETE'\n    ) blueprint_version_at_timestamp ON TRUE\n    WHERE artifacts_history.artifact_blueprint_id = '" + blueprintId + "'\n    AND artifacts_history.artifact_json -> 'fields' ? '" + fieldID + "'\n    AND blueprint_version_at_timestamp.blueprint_version_json IS NOT NULL\n    AND NOT (blueprint_version_at_timestamp.blueprint_version_json -> 'fieldDefinitions' ? '" + fieldID + "')\n)\nUPDATE artifacts_history\nSET artifact_json = find_lines_needing_fix.artifact_json #- '{fields, " + fieldID + "}'\nFROM find_lines_needing_fix\nWHERE artifacts_history._revision_id = find_lines_needing_fix._revision_id";
        dbMigrationDAO.getJdbcTemplate().execute(updateHistory);
    }

    private static void migrateProjectDeployerInfraType(IDBMigrationDAO dbMigrationDAO, long migrationTS, long actionId) throws IOException {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.fixArtifacts(dbMigrationDAO, "artifacts.artifact_blueprint_id = 'bp.system.project_deployer_deployment'  OR artifacts.artifact_blueprint_id = 'bv.system.project_deployer_infrastructure'", MigrationV13300::addDeployerInfraType, actionId, migrationTS);
    }

    private static JsonObject addDeployerInfraType(JsonObject input) {
        Optional<JsonObject> fields = MigrationJsonUtils.getObjectSubpath((JsonElement)input, "fields");
        fields.ifPresent(fieldsJsonObject -> fieldsJsonObject.addProperty("type", "AUTOMATION_NODE"));
        return input;
    }

    private static void migrateAutoConfiguredProject(JdbcTemplate jdbcTemplate, long migrationTS, long actionId) {
        Pair<String, String> autoGovernBundlesModelVersionsTemplates = MigrationV13300.getDefaultAutoGovernBundlesAndModelVersionsTemplate(jdbcTemplate);
        MigrationV13300.addAutoGovernConfigForTheInstance(jdbcTemplate, migrationTS, actionId, (String)autoGovernBundlesModelVersionsTemplates.getLeft(), (String)autoGovernBundlesModelVersionsTemplates.getRight());
    }

    private static Pair<String, String> getDefaultAutoGovernBundlesAndModelVersionsTemplate(JdbcTemplate jdbcTemplate) {
        String sqlSelect = "SELECT blueprint_version_trace_blueprint_id as bp_id,\nmin(blueprint_version_trace_version_id) as bpv_id\nFROM blueprint_version_traces\nWHERE\nblueprint_version_trace_json->>'status' = 'ACTIVE'\nand blueprint_version_trace_blueprint_id in ('bp.system.govern_bundle', 'bp.system.govern_model_version')\nGROUP BY blueprint_version_trace_blueprint_id\nHAVING COUNT(*) = 1";
        List rowResults = jdbcTemplate.queryForList(sqlSelect);
        String defaultBundlesTemplate = null;
        String defaultModelVersionsTemplate = null;
        for (Map row : rowResults) {
            String bpId = (String)row.get("bp_id");
            if (bpId != null && bpId.equals("bp.system.govern_bundle")) {
                defaultBundlesTemplate = (String)row.get("bpv_id");
                continue;
            }
            if (bpId == null || !bpId.equals("bp.system.govern_model_version")) continue;
            defaultModelVersionsTemplate = (String)row.get("bpv_id");
        }
        return Pair.of(defaultBundlesTemplate, defaultModelVersionsTemplate);
    }

    private static void addAutoGovernConfigForTheInstance(JdbcTemplate jdbcTemplate, long migrationTS, long actionId, @Nullable String autoGovernBundlesTemplate, @Nullable String autoGovernModelVersionsTemplate) {
        String autoGovernSettings = MigrationV13300.buildInstanceJsonAutoGovernConfig(autoGovernBundlesTemplate, autoGovernModelVersionsTemplate);
        MigrationV13300.upsertInstanceAutoGovernConfig(jdbcTemplate, autoGovernSettings, actionId, migrationTS);
    }

    private static void upsertInstanceAutoGovernConfig(JdbcTemplate jdbcTemplate, String autoGovernSettingsJson, long actionId, long migrationTSMilli) {
        MigrationEntitiesUtilsBetweenV13300AndBeyond.genericUpsert(jdbcTemplate, actionId, "govern_configuration", "configuration_item_json", autoGovernSettingsJson, "configuration_item_id=?", List.of("default-autogovern"), "govern_configuration_history", "GOVERN_CONFIGURATION", migrationTSMilli);
    }

    public static String buildInstanceJsonAutoGovernConfig(@Nullable String autoGovernBundlesTemplate, @Nullable String autoGovernModelVersionsTemplate) {
        JSON.JsonBuilder autoGovernConfigJsonBuilder = new JSON.JsonBuilder().kv("type", (Object)"project").kv("bundlesConfig", (Object)MigrationV13300.buildChildrenAutoGovernConfig("bp.system.govern_bundle", autoGovernBundlesTemplate)).kv("modelsConfig", (Object)MigrationV13300.buildChildrenAutoGovernConfig("", null)).kv("modelVersionsConfig", (Object)MigrationV13300.buildChildrenAutoGovernConfig("bp.system.govern_model_version", autoGovernModelVersionsTemplate));
        JSON.JsonBuilder instanceConfigJsonBuilder = new JSON.JsonBuilder().kv("type", (Object)"default-autogovern").kv("instanceConfiguration", (Object)autoGovernConfigJsonBuilder.get());
        return JSON.json((Object)instanceConfigJsonBuilder.get());
    }

    private static JsonObject buildChildrenAutoGovernConfig(String blueprintId, @Nullable String versionId) {
        JSON.JsonBuilder autoConfigJsonBuilder = new JSON.JsonBuilder().kv("status", (Object)(versionId != null ? "ENABLED" : "DISABLED"));
        if (versionId != null) {
            autoConfigJsonBuilder.kv("blueprintVersionId", (Object)new JSON.JsonBuilder().kv("blueprintId", (Object)blueprintId).kv("versionId", (Object)versionId).get());
        }
        return autoConfigJsonBuilder.get();
    }

    private static void viewsMigration(IDBMigrationDAO dbMigrationDAO) throws IOException {
        Map<String, BlueprintInfo> bpMapping = MigrationV13300.getBlueprintInfo(dbMigrationDAO.getJdbcTemplate(), null);
        RowViewsMappings rowViewsMapping = new RowViewsMappings();
        String orderByClause = "blueprint_version_blueprint_id, CASE blueprint_version_version_id WHEN 'bv.system.default' THEN 0 ELSE 1 END, blueprint_version_version_id";
        try (Stream queryStream = dbMigrationDAO.getJdbcTemplate().queryForStream("SELECT blueprint_version_json FROM blueprint_versions ORDER BY " + orderByClause, (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString("blueprint_version_json"), JsonObject.class));){
            queryStream.forEachOrdered(bpv -> MigrationV13300.migrateBpvViews(bpv, bpMapping, rowViewsMapping));
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
        MigrationEntitiesUtilsBetweenV13300AndBeyond.migrateObjectsStructure(dbMigrationDAO.getJdbcTemplate(), "blueprint_versions", "blueprint_version_blueprint_id=? AND blueprint_version_version_id=?", "blueprint_version_json", null, orderByClause, bpv -> Arrays.asList(MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "blueprintId").orElse(null), MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "versionId").orElse(null)), bpv -> MigrationV13300.migrateBpvViews(bpv, bpMapping, rowViewsMapping));
        MigrationEntitiesUtilsBetweenV13300AndBeyond.migrateObjectsStructure(dbMigrationDAO.getJdbcTemplate(), "custom_pages", "custom_page_id=?", "custom_page_json", null, null, cp -> Collections.singletonList(MigrationJsonUtils.getStringSubpath((JsonElement)cp, "id").orElse(null)), cp -> MigrationV13300.migrateCustomPageTables(cp, bpMapping, rowViewsMapping));
    }

    public static JsonObject migrateBpvViews(JsonObject bpv, Map<String, BlueprintInfo> bpMapping) {
        return MigrationV13300.migrateBpvViews(bpv, bpMapping, new RowViewsMappings());
    }

    private static JsonObject migrateBpvViews(JsonObject bpv, Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
        MigrationJsonUtils.getObjectSubpath((JsonElement)bpv, "uiDefinition").ifPresent(uiDefinition -> MigrationJsonUtils.getObjectSubpath((JsonElement)uiDefinition, "views").ifPresent(views -> uiDefinition.add("views", (JsonElement)MigrationV13300.migrateViews(views, MigrationJsonUtils.getStringSubpath((JsonElement)bpv, "id", "blueprintId").orElse(""), bpMapping, rowViewsMapping))));
        return bpv;
    }

    private static JsonObject migrateViews(JsonObject views, String bpId, Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
        RowViewsMapping viewMapping = rowViewsMapping.getMappingForBlueprintId(bpId);
        JsonObject newViews = new JsonObject();
        for (String id : views.keySet()) {
            MigrationJsonUtils.getObjectSubpath((JsonElement)views, id).ifPresent(view -> {
                String viewType = MigrationJsonUtils.getStringSubpath((JsonElement)view, "type").orElse("");
                if (Objects.equals(viewType, "row")) {
                    ViewIdMapping migratedViewsMapping = viewMapping.getMappingForViewId(id);
                    JsonArray viewComponents = MigrationJsonUtils.getArraySubpath((JsonElement)view, "viewComponents").orElse(new JsonArray());
                    if (viewComponents.isEmpty()) {
                        viewComponents.add((JsonElement)MigrationV13300.buildEmptyContainerViewComponent());
                    }
                    int cellId = 1;
                    for (JsonElement viewComponentRaw : viewComponents) {
                        Object newId;
                        JsonObject viewComponent = viewComponentRaw.getAsJsonObject();
                        JsonObject newView = new JsonObject();
                        newView.add("viewComponent", (JsonElement)viewComponent);
                        newView.addProperty("description", MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "description").orElse(""));
                        Object label = MigrationJsonUtils.getStringSubpath((JsonElement)view, "label").orElse("");
                        if (viewComponents.size() > 1) {
                            label = (String)label + " - " + MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "label").orElse("");
                        }
                        newView.addProperty("label", (String)label);
                        MigrationJsonUtils.getObjectSubpath((JsonElement)view, "analysisDefinition").ifPresent(analysisDefinition -> newView.add("analysisDefinition", (JsonElement)analysisDefinition));
                        if (migratedViewsMapping.hasViewComponent(viewComponent)) {
                            newId = migratedViewsMapping.getIdForViewComponent(viewComponent).orElse("");
                        } else {
                            if (viewComponents.size() == 1 && !migratedViewsMapping.hasViewComponentForViewId(id)) {
                                newId = id;
                            } else {
                                do {
                                    newId = id + "_col" + cellId;
                                    ++cellId;
                                } while (views.has((String)newId) || migratedViewsMapping.hasViewComponentForViewId((String)newId));
                            }
                            migratedViewsMapping.addView((String)newId, viewComponent);
                        }
                        newViews.add((String)newId, (JsonElement)newView);
                    }
                } else {
                    view.remove("type");
                    newViews.add(id, (JsonElement)view);
                }
            });
        }
        newViews.entrySet().stream().map(entry -> MigrationJsonUtils.getObjectSubpath((JsonElement)entry.getValue(), "viewComponent").orElse(new JsonObject())).forEach(vc -> MigrationV13300.migrateViewComponent(vc, bpId, bpMapping, rowViewsMapping));
        return newViews;
    }

    private static JsonObject migrateCustomPageTables(JsonObject cpSettings, Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
        MigrationJsonUtils.getObjectSubpath((JsonElement)cpSettings, "artifactTableSettings").ifPresent(artifactTableSettings -> {
            HashSet<String> blueprintsInTable = new HashSet<String>();
            JsonArray artifactFilters = MigrationJsonUtils.getArraySubpath((JsonElement)cpSettings, "artifactSearchSettings", "artifactFilters").orElse(new JsonArray());
            for (JsonElement artifactFilter : artifactFilters) {
                if (!MigrationJsonUtils.getStringSubpath(artifactFilter, "type").orElse("").equals("blueprints")) continue;
                JsonArray blueprintIdsJson = MigrationJsonUtils.getArraySubpath(artifactFilter, "blueprintIds").orElse(new JsonArray());
                for (JsonElement bpId : blueprintIdsJson) {
                    blueprintsInTable.add(bpId.getAsString());
                }
            }
            cpSettings.add("artifactTableSettings", (JsonElement)MigrationV13300.migrateArtifactTableSettings(artifactTableSettings, blueprintsInTable, bpMapping, rowViewsMapping));
        });
        return cpSettings;
    }

    private static JsonObject migrateViewComponent(JsonObject viewComponent, String bpId, Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
        String vcType = MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "type").orElse("");
        if (vcType.equals("table-reference-field")) {
            JsonObject artifactTableSettings = MigrationJsonUtils.getObjectSubpath((JsonElement)viewComponent, "artifactTableSettings").orElse(new JsonObject());
            Set blueprintsInTable = MigrationJsonUtils.getStringSubpath((JsonElement)viewComponent, "fieldId").flatMap(fieldId -> Optional.ofNullable((BlueprintInfo)bpMapping.get(bpId)).map(bpInfo -> bpInfo.referencedBlueprints.get(fieldId))).orElse(new HashSet());
            MigrationV13300.migrateArtifactTableSettings(artifactTableSettings, blueprintsInTable, bpMapping, rowViewsMapping);
        } else if (vcType.equals("container")) {
            MigrationJsonUtils.getArraySubpath((JsonElement)viewComponent, "layout", "viewComponents").orElse(new JsonArray()).forEach(subVc -> MigrationV13300.migrateViewComponent(subVc.getAsJsonObject(), bpId, bpMapping, rowViewsMapping));
        }
        return viewComponent;
    }

    private static JsonObject migrateArtifactTableSettings(JsonObject artifactTableSettings, Set<String> blueprintsInTable, Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
        JsonArray artifactTableColumns;
        block14: {
            block13: {
                artifactTableColumns = new JsonArray();
                JsonObject nameColumn = new JsonObject();
                nameColumn.addProperty("type", "name");
                nameColumn.addProperty("label", "Name");
                artifactTableColumns.add((JsonElement)nameColumn);
                if (blueprintsInTable.isEmpty()) break block13;
                if (!blueprintsInTable.stream().map(bpMapping::get).filter(Objects::nonNull).anyMatch(bpInfo -> bpInfo.displayWorkflow)) break block14;
            }
            JsonObject workflowColumn = new JsonObject();
            workflowColumn.addProperty("type", "workflow");
            workflowColumn.addProperty("label", "Workflow");
            artifactTableColumns.add((JsonElement)workflowColumn);
        }
        JsonArray bpIdViewIdPairs = MigrationJsonUtils.getArraySubpath((JsonElement)artifactTableSettings, "blueprintIdViewIdPairs").orElse(new JsonArray());
        for (JsonElement pair : bpIdViewIdPairs) {
            String bpId = MigrationJsonUtils.getStringSubpath((JsonElement)pair.getAsJsonObject(), "blueprintId").orElse("");
            String viewId = MigrationJsonUtils.getStringSubpath((JsonElement)pair.getAsJsonObject(), "viewId").orElse("");
            if (!StringUtils.isNotBlank((String)bpId) || !StringUtils.isNotBlank((String)viewId)) continue;
            List<Object> viewsToAdd = new ArrayList();
            ViewIdMapping views = rowViewsMapping.getMappingForBlueprintId(bpId).getMappingForViewId(viewId);
            if (!views.getAllViewIds().isEmpty()) {
                viewsToAdd = new ArrayList<String>(views.getAllViewIds());
            } else if (bpMapping.containsKey(bpId)) {
                viewsToAdd = bpMapping.get((Object)bpId).viewLabels.keySet().stream().filter(id -> id.equals(viewId) || id.matches(viewId + "_col\\d+")).sorted(Comparator.comparing(s -> {
                    if (s.equals(viewId)) {
                        return 0;
                    }
                    String[] splitArray = s.split("_col");
                    return Integer.parseInt(splitArray[splitArray.length - 1]);
                })).collect(Collectors.toList());
            }
            if (viewsToAdd.isEmpty()) {
                viewsToAdd.add(viewId);
            }
            for (String string : viewsToAdd) {
                String label;
                JsonObject newColumn = new JsonObject();
                newColumn.addProperty("type", "views");
                Optional<JsonObject> newViewComponent = views.getViewComponentForViewId(string);
                if (newViewComponent.isPresent()) {
                    label = MigrationJsonUtils.getStringSubpath((JsonElement)newViewComponent.get(), "label").orElse("");
                } else {
                    label = Optional.ofNullable(bpMapping.get(bpId)).map(bpInfo -> bpInfo.viewLabels.get(newViewId)).orElse("");
                    if (viewsToAdd.size() > 1 && label.contains(" - ")) {
                        label = label.split(" - ", 2)[1];
                    }
                }
                newColumn.addProperty("label", label);
                JsonArray newColumnPairs = new JsonArray();
                JsonObject newPair = new JsonObject();
                newPair.addProperty("viewId", string);
                newPair.addProperty("blueprintId", bpId);
                newColumnPairs.add((JsonElement)newPair);
                newColumn.add("blueprintIdViewIdPairs", (JsonElement)newColumnPairs);
                artifactTableColumns.add((JsonElement)newColumn);
            }
        }
        artifactTableSettings.remove("blueprintIdViewIdPairs");
        boolean allowRowEdit = MigrationJsonUtils.getUnboxedBooleanSubpath((JsonElement)artifactTableSettings, false, "allowRowEdit");
        artifactTableSettings.remove("allowRowEdit");
        if (allowRowEdit) {
            JsonObject editColumn = new JsonObject();
            editColumn.addProperty("type", "edit-row");
            editColumn.addProperty("label", "");
            artifactTableColumns.add((JsonElement)editColumn);
        }
        artifactTableSettings.add("artifactTableColumns", (JsonElement)artifactTableColumns);
        return artifactTableSettings;
    }

    private static void viewsHistoryMigration(IDBMigrationDAO dbMigrationDAO) throws IOException {
        JdbcTemplate jdbcTemplate = dbMigrationDAO.getJdbcTemplate();
        RowViewsMappings rowViewsMapping = new RowViewsMappings();
        BpvMappings bpvJsons = new BpvMappings();
        IdToJsonMapping<CustomPageJson> currentCustomPages = new IdToJsonMapping<CustomPageJson>();
        Long previousTimestamp = null;
        Map<String, BlueprintInfo> bpMapping = null;
        logger.info((Object)"Migrating views in history tables. This might take some time...");
        long lastUpdateLogTime = System.nanoTime();
        Long numberOfRevisions = (Long)jdbcTemplate.queryForObject("SELECT COUNT(*) FROM blueprint_versions_history", Long.class);
        long currentRevision = 0L;
        try (Stream queryStream = jdbcTemplate.queryForStream("SELECT _revision_json, blueprint_version_json FROM blueprint_versions_history ORDER BY _revision_timestamp, _revision_id FOR UPDATE", (rs, rowNum) -> Pair.of((Object)((JsonObject)JSON.parse((String)rs.getString("_revision_json"), JsonObject.class)), (Object)((JsonObject)JSON.parse((String)rs.getString("blueprint_version_json"), JsonObject.class))));){
            Iterator it = queryStream.iterator();
            while (it.hasNext()) {
                ++currentRevision;
                if (numberOfRevisions != null && System.nanoTime() - lastUpdateLogTime > 5000000000L) {
                    int progressPercentage = (int)((double)currentRevision / (double)numberOfRevisions.longValue() * 100.0);
                    logger.info((Object)("History migration : " + progressPercentage + "%"));
                    lastUpdateLogTime = System.nanoTime();
                }
                Pair pair = (Pair)it.next();
                try {
                    Long revisionId = MigrationJsonUtils.getLongSubpath((JsonElement)pair.getLeft(), "id").orElseThrow();
                    Long actionId = MigrationJsonUtils.getLongSubpath((JsonElement)pair.getLeft(), "actionId").orElseThrow();
                    String operation = MigrationJsonUtils.getStringSubpath((JsonElement)pair.getLeft(), "operation").orElseThrow();
                    Long currentTimestamp = MigrationJsonUtils.getLongSubpath((JsonElement)pair.getLeft(), "timestamp").orElseThrow();
                    if (!MigrationJsonUtils.getObjectSubpath((JsonElement)pair.getRight(), "uiDefinition", "views").isPresent()) continue;
                    String blueprintId = MigrationJsonUtils.getStringSubpath((JsonElement)pair.getRight(), "id", "blueprintId").orElse("");
                    String versionId = MigrationJsonUtils.getStringSubpath((JsonElement)pair.getRight(), "id", "versionId").orElse("");
                    if (previousTimestamp != null) {
                        try {
                            MigrationV13300.migrateInBetweenRevisionsOfCustomPages(jdbcTemplate, previousTimestamp, currentTimestamp, currentCustomPages, bpMapping, rowViewsMapping);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    try {
                        bpMapping = MigrationV13300.getBlueprintInfo(jdbcTemplate, currentTimestamp);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    if (operation.equals("DELETE")) {
                        JsonObject migratedDeletedBpv = bpvJsons.hasMigratedBpv(blueprintId, versionId) ? bpvJsons.getBpv((String)blueprintId, (String)versionId).migratedJson : MigrationV13300.migrateBpvViews((JsonObject)pair.getRight(), bpMapping, rowViewsMapping);
                        MigrationV13300.updateBpvRevision(jdbcTemplate, revisionId, migratedDeletedBpv);
                        bpvJsons.removeBpv(blueprintId, versionId);
                    } else {
                        bpvJsons.setBpv(blueprintId, versionId, (JsonObject)pair.getRight());
                    }
                    rowViewsMapping = new RowViewsMappings();
                    bpvJsons.emptyMigrateAll(bpMapping, rowViewsMapping);
                    MigrationV13300.createNewRevisionsForAffectedJsons("blueprint_versions_history", "blueprint_version_json", "BLUEPRINT_VERSION", jdbcTemplate, actionId, currentTimestamp, bpvJsons, bpMapping, rowViewsMapping);
                    if (!operation.equals("DELETE")) {
                        MigrationV13300.updateBpvRevision(jdbcTemplate, revisionId, bpvJsons.getBpv((String)blueprintId, (String)versionId).migratedJson);
                    }
                    MigrationV13300.createNewRevisionsForAffectedJsons("custom_pages_history", "custom_page_json", "CUSTOM_PAGE", jdbcTemplate, actionId, currentTimestamp, currentCustomPages, bpMapping, rowViewsMapping);
                    previousTimestamp = currentTimestamp;
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            MigrationV13300.migrateInBetweenRevisionsOfCustomPages(jdbcTemplate, previousTimestamp, null, currentCustomPages, MigrationV13300.getBlueprintInfo(jdbcTemplate, null), rowViewsMapping);
            logger.info((Object)"History tables views have been migrated.");
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static void updateBpvRevision(JdbcTemplate jdbcTemplate, Long revisionId, JsonObject bpvJson) {
        jdbcTemplate.update(String.format("UPDATE blueprint_versions_history SET blueprint_version_json = (?)::jsonb WHERE _revision_id=%d", revisionId), new Object[]{JSON.json((Object)bpvJson)});
    }

    private static void migrateInBetweenRevisionsOfCustomPages(JdbcTemplate jdbcTemplate, Long previousTimestamp, @Nullable Long currentTimestamp, IdToJsonMapping<CustomPageJson> currentCustomPages, Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) throws IOException {
        try (Stream queryStream = jdbcTemplate.queryForStream(String.format("SELECT _revision_json, custom_page_json FROM custom_pages_history WHERE (_revision_json->'timestamp')::BIGINT >= %d " + (currentTimestamp == null ? "" : "AND (_revision_json->'timestamp')::BIGINT < %d ") + "ORDER BY _revision_timestamp, _revision_id FOR UPDATE", previousTimestamp, currentTimestamp), (rs, rowNum) -> Pair.of((Object)((JsonObject)JSON.parse((String)rs.getString("_revision_json"), JsonObject.class)), (Object)((JsonObject)JSON.parse((String)rs.getString("custom_page_json"), JsonObject.class))));){
            Iterator queryIterator = queryStream.filter(p -> MigrationJsonUtils.getLongSubpath((JsonElement)p.getLeft(), "id").isPresent() && MigrationJsonUtils.getStringSubpath((JsonElement)p.getRight(), "id").isPresent()).map(p -> {
                JsonObject migratedCustomPage;
                long cpRevisionId = MigrationJsonUtils.getLongSubpath((JsonElement)p.getLeft(), "id").orElse(-1L);
                String cpId = MigrationJsonUtils.getStringSubpath((JsonElement)p.getRight(), "id").orElse("");
                if (MigrationJsonUtils.getStringSubpath((JsonElement)p.getLeft(), "operation").orElse("").equals("DELETE")) {
                    migratedCustomPage = currentCustomPages.hasMigratedJson(cpId) ? ((CustomPageJson)currentCustomPages.getJson((String)cpId)).migratedJson : ((CustomPageJson)currentCustomPages.getJson(cpId)).migrate(bpMapping, rowViewsMapping);
                    currentCustomPages.removeJson(cpId);
                } else {
                    CustomPageJson customPageToMigrate = new CustomPageJson((JsonObject)p.getRight());
                    currentCustomPages.putJson(cpId, customPageToMigrate);
                    migratedCustomPage = customPageToMigrate.migrate(bpMapping, rowViewsMapping);
                }
                return Pair.of((Object)cpRevisionId, (Object)migratedCustomPage);
            }).iterator();
            Iterators.partition(queryIterator, (int)100).forEachRemaining(listToUpdate -> jdbcTemplate.batchUpdate("UPDATE custom_pages_history SET custom_page_json = (?)::jsonb WHERE _revision_id = (?)", (Collection)listToUpdate, 100, (ps, toUpdate) -> {
                ps.setString(1, JSON.json((Object)toUpdate.getRight()));
                ps.setLong(2, (Long)toUpdate.getLeft());
            }));
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
    }

    private static void createNewRevisionsForAffectedJsons(String historyTableName, String jsonColumnName, String entityType, JdbcTemplate jdbcTemplate, long actionId, long currentTimestamp, CollectionToMigrate mappingToMigrate, Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMappings) {
        mappingToMigrate.migrateAll(bpMapping, rowViewsMappings);
        Iterator newRevisionsIterator = mappingToMigrate.getModifiedJsons().stream().map(affectedJson -> Pair.of((Object)affectedJson, (Object)MigrationEntitiesUtilsBetweenV13300AndBeyond.buildRevisionObject(jdbcTemplate, actionId, "UPDATE", entityType, currentTimestamp))).iterator();
        Iterators.partition(newRevisionsIterator, (int)100).forEachRemaining(listToUpdate -> jdbcTemplate.batchUpdate("INSERT INTO " + historyTableName + "(_revision_json, " + jsonColumnName + ") VALUES(?::jsonb, ?::jsonb)", (Collection)listToUpdate, 100, (ps, toUpdate) -> {
            ps.setString(1, (String)toUpdate.getRight());
            ps.setString(2, JSON.json((Object)toUpdate.getLeft()));
        }));
    }

    private static Map<String, BlueprintInfo> getBlueprintInfo(JdbcTemplate jdbcTemplate, @Nullable Long timestamp) throws IOException {
        HashMap<String, BlueprintInfo> blueprintInfoMap = new HashMap<String, BlueprintInfo>();
        String query = timestamp == null ? "SELECT blueprint_version_json FROM blueprint_versions" : String.format("SELECT blueprint_version_json FROM (SELECT DISTINCT ON (blueprint_version_blueprint_id, blueprint_version_version_id) _revision_json, blueprint_version_json FROM blueprint_versions_history WHERE (_revision_json->'timestamp')::BIGINT <= %d ORDER BY blueprint_version_blueprint_id, blueprint_version_version_id, _revision_timestamp DESC, _revision_id DESC ) bpvs WHERE _revision_json->>'operation' != 'DELETE'", timestamp);
        try (Stream queryStream = jdbcTemplate.queryForStream(query, (rs, rowNum) -> (JsonObject)JSON.parse((String)rs.getString("blueprint_version_json"), JsonObject.class));){
            queryStream.forEach(bpvDef -> {
                String bpId = MigrationJsonUtils.getStringSubpath((JsonElement)bpvDef, "id", "blueprintId").orElse("");
                String versionId = MigrationJsonUtils.getStringSubpath((JsonElement)bpvDef, "id", "versionId").orElse("");
                BlueprintInfo bpInfo = blueprintInfoMap.computeIfAbsent(bpId, key -> new BlueprintInfo());
                if (!MigrationJsonUtils.getArraySubpath((JsonElement)bpvDef, "workflowDefinition", "stepDefinitions").orElse(new JsonArray()).isEmpty()) {
                    bpInfo.displayWorkflow = true;
                }
                MigrationJsonUtils.getObjectSubpath((JsonElement)bpvDef, "uiDefinition", "views").orElse(new JsonObject()).entrySet().forEach(entry -> MigrationJsonUtils.getStringSubpath((JsonElement)entry.getValue(), "label").ifPresent(label -> {
                    if (!bpInfo.viewLabels.containsKey(entry.getKey()) || versionId.equals("bv.system.default")) {
                        bpInfo.viewLabels.put((String)entry.getKey(), (String)label);
                    }
                }));
                MigrationJsonUtils.getObjectSubpath((JsonElement)bpvDef, "fieldDefinitions").orElse(new JsonObject()).entrySet().stream().filter(field -> MigrationJsonUtils.getStringSubpath((JsonElement)field.getValue(), "type").orElse("").equals("REFERENCE")).forEach(field -> {
                    switch (MigrationJsonUtils.getStringSubpath((JsonElement)field.getValue(), "sourceType").orElse("")) {
                        case "STORE": {
                            MigrationJsonUtils.getArraySubpath((JsonElement)field.getValue(), "allowedBlueprints").ifPresent(allowedBlueprints -> {
                                Set bpInfoReferencedBlueprints = bpInfo.referencedBlueprints.computeIfAbsent((String)field.getKey(), key -> new HashSet());
                                allowedBlueprints.forEach(bp -> bpInfoReferencedBlueprints.add(bp.getAsString()));
                            });
                            break;
                        }
                        case "COMPUTE": {
                            MigrationJsonUtils.getArraySubpath((JsonElement)field.getValue(), "references").ifPresent(references -> {
                                Set bpInfoReferencedBlueprints = bpInfo.referencedBlueprints.computeIfAbsent((String)field.getKey(), key -> new HashSet());
                                references.forEach(ref -> MigrationJsonUtils.getStringSubpath(ref, "blueprintId").ifPresent(bpInfoReferencedBlueprints::add));
                            });
                        }
                    }
                });
            });
        }
        catch (DataAccessException e) {
            throw new IOException("Cannot reach Govern Database, verify the connection settings", e);
        }
        return blueprintInfoMap;
    }

    private static JsonObject buildEmptyContainerViewComponent() {
        JsonObject vc = new JsonObject();
        vc.addProperty("type", "container");
        JsonObject layout = new JsonObject();
        layout.addProperty("type", "sequential");
        layout.add("viewComponents", (JsonElement)new JsonArray());
        vc.add("layout", (JsonElement)layout);
        vc.addProperty("label", "");
        vc.addProperty("description", "");
        vc.addProperty("documentation", "");
        return vc;
    }

    private static class RowViewsMappings {
        private final Map<String, RowViewsMapping> rowViewsMappings = new HashMap<String, RowViewsMapping>();

        private RowViewsMappings() {
        }

        public RowViewsMapping getMappingForBlueprintId(String bpId) {
            return this.rowViewsMappings.computeIfAbsent(bpId, key -> new RowViewsMapping());
        }
    }

    private static class RowViewsMapping {
        private final Map<String, ViewIdMapping> viewIdMappings = new HashMap<String, ViewIdMapping>();

        private RowViewsMapping() {
        }

        public ViewIdMapping getMappingForViewId(String viewId) {
            return this.viewIdMappings.computeIfAbsent(viewId, key -> new ViewIdMapping());
        }
    }

    private static class ViewIdMapping {
        private final Map<String, JsonObject> migratedViewsMapping = new LinkedHashMap<String, JsonObject>();

        private ViewIdMapping() {
        }

        public boolean hasViewComponent(JsonObject view) {
            return this.migratedViewsMapping.containsValue(view);
        }

        public boolean hasViewComponentForViewId(String viewId) {
            return this.migratedViewsMapping.containsKey(viewId);
        }

        public Optional<JsonObject> getViewComponentForViewId(String viewId) {
            return Optional.ofNullable(this.migratedViewsMapping.get(viewId));
        }

        public Optional<String> getIdForViewComponent(JsonObject viewComponent) {
            return this.migratedViewsMapping.entrySet().stream().filter(e -> ((JsonObject)e.getValue()).equals((Object)viewComponent)).map(Map.Entry::getKey).findFirst();
        }

        public void addView(String viewId, JsonObject view) {
            this.migratedViewsMapping.put(viewId, view);
        }

        public Set<String> getAllViewIds() {
            return this.migratedViewsMapping.keySet();
        }
    }

    public static class BlueprintInfo {
        public boolean displayWorkflow = false;
        public Map<String, String> viewLabels = new HashMap<String, String>();
        public Map<String, Set<String>> referencedBlueprints = new HashMap<String, Set<String>>();
    }

    private static class BpvMappings
    implements CollectionToMigrate {
        private final Map<String, IdToJsonMapping<BpvJson>> bpvMappings = new HashMap<String, IdToJsonMapping<BpvJson>>();

        private BpvMappings() {
        }

        public IdToJsonMapping<BpvJson> getMappingForBlueprintId(String bpId) {
            return this.bpvMappings.computeIfAbsent(bpId, key -> new IdToJsonMapping());
        }

        public BpvJson getBpv(String blueprintId, String versionId) {
            return this.getMappingForBlueprintId(blueprintId).getJson(versionId);
        }

        public void setBpv(String blueprintId, String versionId, JsonObject bpv) {
            this.getMappingForBlueprintId((String)blueprintId).mapping.put(versionId, new BpvJson(bpv));
        }

        public void removeBpv(String blueprintId, String versionId) {
            this.getMappingForBlueprintId(blueprintId).getJson(versionId);
        }

        public boolean hasMigratedBpv(String blueprintId, String versionId) {
            return this.bpvMappings.containsKey(blueprintId) && this.getMappingForBlueprintId(blueprintId).hasMigratedJson(versionId);
        }

        @Override
        public void migrateAll(Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
            this.bpvMappings.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((IdToJsonMapping)entry.getValue()).migrateAll(bpMapping, rowViewsMapping));
        }

        public void emptyMigrateAll(Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
            this.bpvMappings.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((IdToJsonMapping)entry.getValue()).emptyMigrateAll(bpMapping, rowViewsMapping));
        }

        @Override
        public List<JsonObject> getModifiedJsons() {
            return this.bpvMappings.values().stream().flatMap(mapping -> mapping.getModifiedJsons().stream()).collect(Collectors.toList());
        }
    }

    private static class IdToJsonMapping<T extends JsonToMigrate>
    implements CollectionToMigrate {
        private final Map<String, T> mapping = new HashMap<String, T>();

        private IdToJsonMapping() {
        }

        public T getJson(String id) {
            return (T)((JsonToMigrate)this.mapping.get(id));
        }

        public void putJson(String id, T json) {
            this.mapping.put(id, json);
        }

        public void removeJson(String id) {
            this.mapping.remove(id);
        }

        public boolean hasMigratedJson(String id) {
            return this.mapping.containsKey(id) && ((JsonToMigrate)this.getJson(id)).hasMigrated();
        }

        private Stream<Map.Entry<String, T>> getSortedStream() {
            Comparator<Map.Entry> systemDefaultComparator = Comparator.comparing(entry -> {
                if (((String)entry.getKey()).equals("bv.system.default")) {
                    return 0;
                }
                return 1;
            });
            return this.mapping.entrySet().stream().sorted(systemDefaultComparator.thenComparing(Map.Entry.comparingByKey()));
        }

        @Override
        public void migrateAll(Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
            this.getSortedStream().forEach(entry -> ((JsonToMigrate)entry.getValue()).migrate(bpMapping, rowViewsMapping));
        }

        public void emptyMigrateAll(Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
            this.getSortedStream().forEach(entry -> ((JsonToMigrate)entry.getValue()).emptyMigrate(bpMapping, rowViewsMapping));
        }

        @Override
        public List<JsonObject> getModifiedJsons() {
            return this.mapping.values().stream().filter(JsonToMigrate::hasBeenModified).map(JsonToMigrate::getMigrated).collect(Collectors.toList());
        }
    }

    private static class BpvJson
    extends JsonToMigrate {
        public BpvJson(JsonObject originalJson) {
            super(originalJson);
        }

        @Override
        public JsonObject emptyMigrate(Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
            return MigrationV13300.migrateBpvViews(this.originalJson.deepCopy(), bpMapping, rowViewsMapping);
        }
    }

    private static interface CollectionToMigrate {
        public void migrateAll(Map<String, BlueprintInfo> var1, RowViewsMappings var2);

        public List<JsonObject> getModifiedJsons();
    }

    private static abstract class JsonToMigrate {
        protected final JsonObject originalJson;
        protected JsonObject previousMigratedJson;
        protected JsonObject migratedJson;

        private JsonToMigrate(JsonObject originalJson) {
            this.originalJson = originalJson.deepCopy();
        }

        public boolean hasBeenModified() {
            return this.migratedJson != null && this.previousMigratedJson != null && !this.migratedJson.equals((Object)this.previousMigratedJson);
        }

        public boolean hasMigrated() {
            return this.migratedJson != null;
        }

        public JsonObject getMigrated() {
            return this.migratedJson;
        }

        public abstract JsonObject emptyMigrate(Map<String, BlueprintInfo> var1, RowViewsMappings var2);

        public JsonObject migrate(Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
            this.previousMigratedJson = this.migratedJson;
            this.migratedJson = this.emptyMigrate(bpMapping, rowViewsMapping);
            return this.migratedJson;
        }
    }

    private static class CustomPageJson
    extends JsonToMigrate {
        public CustomPageJson(JsonObject originalJson) {
            super(originalJson);
        }

        @Override
        public JsonObject emptyMigrate(Map<String, BlueprintInfo> bpMapping, RowViewsMappings rowViewsMapping) {
            return MigrationV13300.migrateCustomPageTables(this.originalJson.deepCopy(), bpMapping, rowViewsMapping);
        }
    }
}

