/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.relationships.collectors;

import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.Attachments;
import com.dataiku.gh.core.models.fields.definitions.types.file.StoredUploadedFileFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.StoredReferenceFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.backreference.BackreferenceFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.time_series.StoredTimeSeriesFieldDefinition;
import com.dataiku.gh.core.models.relationships.AttachmentRelationshipData;
import com.dataiku.gh.core.models.relationships.ReferenceRelationship;
import com.dataiku.gh.core.models.relationships.UploadedFileRelationship;
import com.dataiku.gh.core.services.relationships.collectors.CollectorResult;
import com.dataiku.gh.core.services.relationships.collectors.ReferencesRelationshipFieldCollector;
import com.dataiku.gh.core.services.relationships.collectors.TimeSeriesRelationshipFieldCollector;
import com.dataiku.gh.core.services.relationships.collectors.UploadedFilesRelationshipFieldCollector;
import com.dataiku.gh.core.visitors.IEnrichedArtifactVisitor;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RelationshipsCollector
implements IEnrichedArtifactVisitor {
    private final Artifact artifact;
    public final CollectorResult result = new CollectorResult();

    public RelationshipsCollector(Artifact artifact) {
        this.artifact = artifact;
    }

    @Override
    public void visit(StoredReferenceFieldDefinition fieldDefinition, String fieldId) {
        ReferencesRelationshipFieldCollector collector = new ReferencesRelationshipFieldCollector(this.artifact.id, fieldId);
        collector.visit(this.artifact.fields.get(fieldId));
        collector.relationships.forEach(relationship -> this.result.artifactIdsAllowedBlueprintIds.add((Pair<String, List<String>>)Pair.of((Object)relationship.artifactIdTo, fieldDefinition.allowedBlueprints)));
        this.result.getReferenceRelationships().addAll(collector.relationships);
        this.result.getTransientFieldIds().add(fieldId);
    }

    @Override
    public void visit(StoredUploadedFileFieldDefinition fieldDefinition, String fieldId) {
        UploadedFilesRelationshipFieldCollector collector = new UploadedFilesRelationshipFieldCollector(this.artifact.id, fieldId);
        collector.visit(this.artifact.fields.get(fieldId));
        this.result.getUploadedFileRelationships().addAll(collector.relationships);
        this.result.getTransientFieldIds().add(fieldId);
    }

    @Override
    public void visit(StoredTimeSeriesFieldDefinition fieldDefinition, String fieldId) {
        TimeSeriesRelationshipFieldCollector collector = new TimeSeriesRelationshipFieldCollector(this.artifact.id, fieldId);
        collector.visit(this.artifact.fields.get(fieldId));
        this.result.getTimeSeriesRelationships().addAll(collector.relationships);
        this.result.getTransientFieldIds().add(fieldId);
    }

    @Override
    public void visit(BackreferenceFieldDefinition fieldDefinition, String fieldId) {
        this.result.getTransientFieldIds().add(fieldId);
    }

    @Override
    public void visit(Attachments attachments) {
        if (CollectionUtils.isNotEmpty(attachments.references)) {
            IntStream.range(0, attachments.references.size()).forEach(i -> {
                String fieldValue = attachments.references.get(i);
                if (StringUtils.isBlank((CharSequence)fieldValue)) {
                    return;
                }
                AttachmentRelationshipData relationshipData = new AttachmentRelationshipData();
                relationshipData.index = i;
                ReferenceRelationship referenceRelationship = new ReferenceRelationship();
                referenceRelationship.artifactIdFrom = this.artifact.id;
                referenceRelationship.artifactIdTo = fieldValue;
                referenceRelationship.relationshipData = relationshipData;
                this.result.artifactIdsAllowedBlueprintIds.add((Pair<String, List<String>>)Pair.of((Object)referenceRelationship.artifactIdTo, null));
                this.result.getReferenceRelationships().add(referenceRelationship);
            });
        }
        if (CollectionUtils.isNotEmpty(attachments.files)) {
            IntStream.range(0, attachments.files.size()).forEach(i -> {
                String fieldValue = attachments.files.get(i);
                if (StringUtils.isBlank((CharSequence)fieldValue)) {
                    return;
                }
                AttachmentRelationshipData relationshipData = new AttachmentRelationshipData();
                relationshipData.index = i;
                UploadedFileRelationship uploadedFileRelationship = new UploadedFileRelationship();
                uploadedFileRelationship.artifactId = this.artifact.id;
                uploadedFileRelationship.uploadedFileId = fieldValue;
                uploadedFileRelationship.relationshipData = relationshipData;
                this.result.getUploadedFileRelationships().add(uploadedFileRelationship);
            });
        }
    }
}

