/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.controllers;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.DkuLoginEventService;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAuthenticationException;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserNotFoundException;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.sso.OpenIDErrorCode;
import com.dataiku.dip.security.sso.SpnegoHelper;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.security.auth.GHUserAuthenticationService;
import com.dataiku.gh.security.auth.UIAuthService;
import com.dataiku.gh.security.sso.GHSSOService;
import com.lastpass.saml.AttributeSet;
import com.lastpass.saml.SAMLException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Optional;
import net.sourceforge.spnego.SpnegoHttpServletResponse;
import net.sourceforge.spnego.SpnegoPrincipal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AuthController
extends DIPInternalControllerBase {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");
    private static final String DKU_MAX_LOGIN_SIZE = "dku.max.login.size";
    private static final int DEFAULT_MAX_LOGIN_SIZE = 241;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private GHSSOService ssoAssistants;
    @Autowired
    private GHUserAuthenticationService userAuthenticationService;
    @Autowired
    private DkuLoginEventService loginEventService;

    @AuditInline
    @RequestMapping(value={"/api/login"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.LOGIN)
    public void login(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="login") String inputLogin, @RequestParam(value="password") String password) {
        long loginStart = System.currentTimeMillis();
        try {
            this.assertNotSaasInstance();
            int maxLoginSize = DKUApp.getProperty((String)DKU_MAX_LOGIN_SIZE, (int)241);
            if (inputLogin != null && inputLogin.length() > maxLoginSize) {
                logger.warnV("Rejecting too long login input (" + inputLogin.length() + " characters > limit " + maxLoginSize + "). Login size can be increased using the dip property 'dku.max.login.size'", new Object[0]);
                resp.setStatus(401);
                resp.getWriter().write("Authentication failed.");
                return;
            }
            logger.infoV("Start authentication of login '%s' with Login/Password method", new Object[]{inputLogin});
            try {
                DkuUser dkuUser = this.userAuthenticationService.authenticateWithPassword(inputLogin, password);
                logger.infoV("Authentication success for login '%s'", new Object[]{dkuUser.getLogin()});
                this.loginEventService.onPasswordBasedLoginSuccess(req, dkuUser);
                this.authService.createSession(resp, dkuUser.getLogin());
            }
            catch (UnauthorizedException | UserAuthenticationException e) {
                logger.infoV("Authentication failed for login '%s': %s", new Object[]{inputLogin, e.getMessage()});
                this.sleepConstantTime(loginStart);
                this.loginEventService.onLoginError(inputLogin);
                resp.setStatus(401);
                resp.getWriter().write("Authentication failed.");
            }
            catch (UserAuthenticationService.UserDisabledException e) {
                logger.infoV("Authentication failed for login '%s': %s", new Object[]{inputLogin, e.getMessage()});
                this.sleepConstantTime(loginStart);
                this.loginEventService.onLoginError(inputLogin);
                resp.setStatus(401);
                resp.getWriter().write("User is disabled");
            }
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while trying to log user '%s'", new Object[]{inputLogin});
            this.sleepConstantTime(loginStart);
            this.loginEventService.onLoginError(inputLogin);
            resp.setStatus(500);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/no-login-login"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.LOGIN)
    public void noLoginLogin(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        logger.infoV("Start No login login", new Object[0]);
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        DkuUser dkuUser = this.userAuthenticationService.authenticateWithNoLoginAuthMethod(gs.noLoginMode, gs.noLoginImpersonate);
        this.loginEventService.onNoLoginLoginSuccess(dkuUser);
        this.authService.createSession(resp, dkuUser.getLogin());
        logger.infoV("Authentication success to user '%s'", new Object[]{dkuUser.getLogin()});
    }

    @RequestMapping(value={"/api/get-saml-redirect-url"}, method={RequestMethod.POST})
    public void getSAMLRedirectURL(HttpServletRequest req, HttpServletResponse resp, @RequestParam String redirectTo) throws SAMLException, IOException {
        AuthController.writeJSON((HttpServletResponse)resp, (Object)this.ssoAssistants.saml().getRedirectURL(redirectTo));
    }

    @RequestMapping(value={"/api/saml-callback"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.LOGIN)
    public void samlLogin(HttpServletRequest req, HttpServletResponse resp) {
        logger.infoV("Start SSO SAML callback", new Object[0]);
        try {
            String redirectTo = this.ssoAssistants.saml().consumeRelayState(req.getParameter("RelayState"));
            String authResponse = req.getParameter("SAMLResponse");
            AttributeSet aset = this.ssoAssistants.saml().validateResponse(authResponse);
            logger.info((Object)("SAML response validated, Attribute Set:\n" + JSON.pretty((Object)aset)));
            UserIdentity userIdentity = this.ssoAssistants.saml().getUserIdentity(aset);
            logger.info((Object)("Extracted user identity from SSO before remapping: " + String.valueOf(userIdentity)));
            DkuUser dkuUser = this.linkToDSSUser(userIdentity);
            if (dkuUser != null) {
                logger.infoV("Authentication success for login '%s'", new Object[]{dkuUser.getLogin()});
                this.loginEventService.onSSOLoginSuccess(dkuUser);
                this.authService.createSession(resp, dkuUser.getLogin());
                resp.setStatus(302);
                resp.setHeader("Location", redirectTo);
            } else {
                logger.infoV("Authentication failed for login '%s'", new Object[]{userIdentity.login});
                this.loginEventService.onLoginError(userIdentity.login);
                resp.setStatus(HttpStatus.UNAUTHORIZED.value());
            }
        }
        catch (Exception e) {
            logger.error((Object)"SAML login failed", (Throwable)e);
            resp.setStatus(302);
            resp.setHeader("Location", "/sso-error?error=SAML%20Login%20failed&errorDescription=" + UserAuthenticationService.getDesensitizedMessageForUserAuthenticationException((Exception)e));
            this.auditTrailService.generic("login-failure").with("type", "saml").emit();
        }
    }

    @RequestMapping(value={"/api/get-openid-redirect-url"}, method={RequestMethod.GET})
    public void getOpenIDRedirectURL(HttpServletRequest req, HttpServletResponse resp, @RequestParam String dssUrl) throws IOException, URISyntaxException {
        try {
            Assert.notNull((Object)dssUrl, (String)"dssUrl must not be null");
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)"Missing parameter", (Throwable)e);
            resp.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        Pair redirectURLAndCodeVerifier = this.ssoAssistants.openid().getRedirectURL(dssUrl);
        this.authService.createPKCECodeVerifierCookie(resp, (String)redirectURLAndCodeVerifier.second);
        AuthController.writeJSON((HttpServletResponse)resp, (Object)redirectURLAndCodeVerifier.first);
    }

    @RequestMapping(value={"/api/openid-callback"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.LOGIN)
    public void openidCallback(HttpServletRequest req, HttpServletResponse resp, @RequestParam String code, @RequestParam String state, @RequestParam String dssUrl) throws Exception {
        UserIdentity userIdentity;
        logger.infoV("Start SSO OpenID callback", new Object[0]);
        if (this.ssoAssistants.openid().isPKCEEnabled()) {
            Optional<String> codeVerifier = this.authService.getCodeVerifierFromCookie(req);
            if (!codeVerifier.isPresent()) {
                throw new CodedException((InfoMessage.MessageCode)OpenIDErrorCode.ERR_OPENID_PKCE_CODE_VERIFIER_MISSING, "Couldn't exchange the authorization code, the PKCE code verifier is missing. Please contact your administrator.");
            }
            this.authService.deletePKCECodeVerifierCookie(resp);
            userIdentity = this.ssoAssistants.openid().getUserIdentity(code, state, dssUrl, codeVerifier.get());
        } else {
            userIdentity = this.ssoAssistants.openid().getUserIdentity(code, state, dssUrl, null);
        }
        logger.info((Object)("Extracted user identity from SSO before remapping: " + String.valueOf(userIdentity)));
        try {
            DkuUser dkuUser = this.linkToDSSUser(userIdentity);
            if (dkuUser != null) {
                logger.infoV("Authentication success for login '%s'", new Object[]{dkuUser.getLogin()});
                this.loginEventService.onSSOLoginSuccess(dkuUser);
                this.authService.createSession(resp, dkuUser.getLogin());
                resp.setStatus(HttpStatus.CREATED.value());
            } else {
                logger.warnV("Authentication failed for login '%s'", new Object[]{userIdentity.login});
                this.loginEventService.onLoginError(userIdentity.login);
                resp.setStatus(HttpStatus.UNAUTHORIZED.value());
            }
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "OpenID authentication failed for login '%s'", new Object[]{userIdentity.login});
            this.loginEventService.onLoginError(userIdentity.login);
            resp.setStatus(HttpStatus.UNAUTHORIZED.value());
            throw UserAuthenticationService.getDesensitizedExceptionForUserAuthenticationException((Exception)e);
        }
    }

    @RequestMapping(value={"/api/spnego-login"})
    @GovernAction(value=ActionType.LOGIN)
    public void spnegoLogin(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        SpnegoPrincipal principal;
        SpnegoHttpServletResponse spnegoResponse = new SpnegoHttpServletResponse(resp);
        logger.infoV("Start SPNEGO", new Object[0]);
        try {
            principal = this.ssoAssistants.spnego().authenticate(req, spnegoResponse);
        }
        catch (SpnegoHelper.SPNEGOAuthenticationBadRequest e) {
            logger.info((Object)("Bad request: " + e.getMessage()));
            resp.setStatus(400);
            resp.getWriter().write(e.getMessage());
            return;
        }
        catch (SpnegoHelper.SPNEGONegotiationPending e) {
            logger.info((Object)"SPNEGO auth loop not yet done");
            return;
        }
        catch (SpnegoHelper.SPNEGOAuthenticationFailure e) {
            logger.error((Object)"SPNEGO authentication failed.", (Throwable)e);
            resp.setStatus(500);
            return;
        }
        UserIdentity userIdentity = new UserIdentity(UserSourceType.LOCAL_NO_AUTH, principal.getName());
        logger.info((Object)("Got SPNEGO login with realm=" + principal.getRealm() + " and inputLogin=" + userIdentity.login));
        try {
            DkuUser dkuUser = this.linkToDSSUser(userIdentity);
            if (dkuUser != null) {
                logger.infoV("Authentication success for login '%s'", new Object[]{dkuUser.getLogin()});
                this.loginEventService.onSSOLoginSuccess(dkuUser);
                this.authService.createSession(resp, dkuUser.getLogin());
                resp.setStatus(302);
                resp.setHeader("Location", "/");
            } else {
                logger.infoV("Authentication failed for login '%s'", new Object[]{userIdentity.login});
                this.loginEventService.onLoginError(userIdentity.login);
                resp.setStatus(HttpStatus.UNAUTHORIZED.value());
            }
        }
        catch (Exception e) {
            this.loginEventService.onLoginError(userIdentity.login);
            logger.error((Object)"SPNEGO authentication failed.", (Throwable)e);
            resp.setStatus(500);
        }
    }

    @AuditedCall(value={"msgType", "logout"})
    @RequestMapping(value={"/api/logout"}, method={RequestMethod.POST})
    public void logout(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        AuthCtx user;
        this.assertNotSaasInstance();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getUser(req);
        }
        this.authService.destroyCurrentSession(req, resp);
        if (user != null) {
            this.loginEventService.onLogout(user);
        }
    }

    protected DkuUser linkToDSSUser(UserIdentity userIdentity) throws ServerAuthenticationFailure, UserNotFoundException, UserAuthenticationService.UserDisabledException, UnauthorizedException {
        userIdentity.login = this.ssoAssistants.userMapper().remapProvidedLogin(userIdentity.login);
        logger.infoV("Finding a matching DSS user for login '%s' or provision it if possible", new Object[]{userIdentity.login});
        DkuUser dkuUser = this.userAuthenticationService.syncOrProvisionFromTrustedSourceAtLoginTime(userIdentity, this.userAuthenticationService.getUserWithCaseSensitivenessRule(userIdentity.login));
        return dkuUser;
    }

    private void assertNotSaasInstance() {
        try (Transaction t = this.transactionService.beginRead();){
            if (ApplicationConfigurator.isSAASAuth()) {
                throw new IllegalArgumentException("Cannot login/logout on a SAAS instance");
            }
        }
    }

    private void sleepConstantTime(long loginStart) {
        long authFailureTargetTime = ApplicationConfigurator.getParams().getLongParam("dku.security.login.authFailureTargetTime", 2000L);
        long timeAlreadySpent = System.currentTimeMillis() - loginStart;
        if (timeAlreadySpent >= 0L && timeAlreadySpent < authFailureTargetTime) {
            try {
                Thread.sleep(authFailureTargetTime - timeAlreadySpent);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

