/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.httpclient;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.twitter.hbc.RateTracker;
import com.twitter.hbc.ReconnectionManager;
import com.twitter.hbc.SitestreamController;
import com.twitter.hbc.core.Client;
import com.twitter.hbc.core.Hosts;
import com.twitter.hbc.core.StatsReporter;
import com.twitter.hbc.core.endpoint.StreamingEndpoint;
import com.twitter.hbc.core.event.Event;
import com.twitter.hbc.core.processor.HosebirdMessageProcessor;
import com.twitter.hbc.httpclient.ClientBase;
import com.twitter.hbc.httpclient.RestartableHttpClient;
import com.twitter.hbc.httpclient.auth.Authentication;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicClient
implements Client {
    private static final int DEFAULT_STOP_TIMEOUT_MILLIS = 5000;
    private final ExecutorService executorService;
    private final ClientBase clientBase;
    private final AtomicBoolean canRun;
    private static final Logger logger = LoggerFactory.getLogger(BasicClient.class);

    public BasicClient(String name, Hosts hosts, StreamingEndpoint endpoint, Authentication auth, boolean enableGZip, HosebirdMessageProcessor processor, ReconnectionManager reconnectionManager, RateTracker rateTracker, ExecutorService executorService, @Nullable BlockingQueue<Event> eventsQueue, HttpParams params, ClientConnectionManager connectionManager) {
        RestartableHttpClient client;
        Preconditions.checkNotNull((Object)auth);
        if (enableGZip) {
            client = new RestartableHttpClient(auth, enableGZip, params, connectionManager);
        } else {
            DefaultHttpClient defaultClient = new DefaultHttpClient(connectionManager, params);
            auth.setupConnection((AbstractHttpClient)defaultClient);
            client = defaultClient;
        }
        this.canRun = new AtomicBoolean(true);
        this.executorService = executorService;
        this.clientBase = new ClientBase(name, client, hosts, endpoint, auth, processor, reconnectionManager, rateTracker, eventsQueue);
    }

    @VisibleForTesting
    BasicClient(ClientBase clientBase, ExecutorService executorService) {
        this.canRun = new AtomicBoolean(true);
        this.clientBase = clientBase;
        this.executorService = executorService;
    }

    @Override
    public void connect() {
        if (!this.canRun.compareAndSet(true, false) || this.clientBase.isDone()) {
            throw new IllegalStateException("There is already a connection thread running for " + this.clientBase);
        }
        this.executorService.execute(this.clientBase);
        logger.info("New connection executed: {}", (Object)this.clientBase);
    }

    @Override
    public SitestreamController createSitestreamController() {
        return this.clientBase.getSitestreamController();
    }

    @Override
    public StatsReporter.StatsTracker getStatsTracker() {
        return this.clientBase.getStatsTracker();
    }

    @Override
    public boolean isDone() {
        return this.clientBase.isDone();
    }

    public Event getExitEvent() {
        return this.clientBase.getExitEvent();
    }

    @Override
    public void stop() {
        this.stop(5000);
    }

    @Override
    public void stop(int waitMillis) {
        logger.info("Stopping the client: " + this.clientBase);
        try {
            this.clientBase.stop(waitMillis);
            logger.info("Successfully stopped the client: {}", (Object)this.clientBase);
        }
        catch (InterruptedException e) {
            logger.info("Thread interrupted when attempting to stop the client: {}", (Object)this.clientBase);
        }
        this.executorService.shutdown();
    }

    @Override
    public String getName() {
        return this.clientBase.getName();
    }

    @Override
    public StreamingEndpoint getEndpoint() {
        return this.clientBase.getEndpoint();
    }

    @Override
    public void reconnect() {
        this.clientBase.reconnect();
    }

    @VisibleForTesting
    boolean waitForFinish(int millis) throws InterruptedException {
        return this.clientBase.waitForFinish(millis);
    }
}

