/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.client;

import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.URIUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class RedirectURIValidator {
    public static final Set<String> PROHIBITED_REDIRECT_URI_SCHEMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("data", "javascript", "vbscript")));
    public static final Set<String> PROHIBITED_REDIRECT_URI_QUERY_PARAMETER_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("code", "state", "response")));

    public static void ensureLegal(URI redirectURI) {
        if (redirectURI == null) {
            return;
        }
        if (redirectURI.getFragment() != null) {
            throw new IllegalArgumentException("The redirect_uri must not contain fragment");
        }
        URIUtils.ensureSchemeIsNotProhibited(redirectURI, ClientMetadata.PROHIBITED_REDIRECT_URI_SCHEMES);
        URIUtils.ensureQueryIsNotProhibited(redirectURI, PROHIBITED_REDIRECT_URI_QUERY_PARAMETER_NAMES);
    }

    private RedirectURIValidator() {
    }
}

