/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.federation.api;

import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Subject;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.StringUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.URIUtils;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import com.dataiku.dss.shadelib.net.jcip.annotations.Immutable;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Immutable
public class ResolveRequest
extends FederationAPIRequest {
    private final Subject subject;
    private final EntityID anchor;
    private final EntityType entityType;

    public ResolveRequest(URI endpoint, Subject subject, EntityID anchor, EntityType entityType) {
        super(endpoint);
        if (subject == null) {
            throw new IllegalArgumentException("The subject must not be null");
        }
        this.subject = subject;
        if (anchor == null) {
            throw new IllegalArgumentException("The anchor must not be null");
        }
        this.anchor = anchor;
        this.entityType = entityType;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public EntityID getSubjectEntityID() {
        return new EntityID(this.subject);
    }

    public EntityID getTrustAnchor() {
        return this.anchor;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        params.put("sub", Collections.singletonList(this.getSubject().getValue()));
        params.put("anchor", Collections.singletonList(this.getTrustAnchor().getValue()));
        if (this.getEntityType() != null) {
            params.put("type", Collections.singletonList(this.getEntityType().getValue()));
        }
        return params;
    }

    public static ResolveRequest parse(Map<String, List<String>> params) throws ParseException {
        String value = MultivaluedMapUtils.getFirstValue(params, "sub");
        if (StringUtils.isBlank(value)) {
            throw new ParseException("Missing sub");
        }
        Subject subject = new Subject(value);
        value = MultivaluedMapUtils.getFirstValue(params, "anchor");
        if (StringUtils.isBlank(value)) {
            throw new ParseException("Missing anchor");
        }
        EntityID anchor = new EntityID(value);
        EntityType entityType = null;
        value = MultivaluedMapUtils.getFirstValue(params, "type");
        if (StringUtils.isNotBlank(value)) {
            entityType = new EntityType(value);
        }
        return new ResolveRequest(null, subject, anchor, entityType);
    }

    public static ResolveRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.GET);
        ResolveRequest request = ResolveRequest.parse(httpRequest.getQueryStringParameters());
        return new ResolveRequest(URIUtils.getBaseURI(httpRequest.getURI()), request.getSubject(), request.getTrustAnchor(), request.getEntityType());
    }
}

