/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.federation.api;

import com.dataiku.dss.shadelib.com.nimbusds.common.contenttype.ContentType;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.SignedJWT;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.util.DateUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Identifier;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Subject;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.StringUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.util.URLUtils;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import com.dataiku.dss.shadelib.net.jcip.annotations.Immutable;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Immutable
public class TrustMarkStatusRequest
extends FederationAPIRequest {
    private final Subject subject;
    private final Identifier id;
    private final Date iat;
    private final SignedJWT trustMark;

    public TrustMarkStatusRequest(URI endpoint, Subject subject, Identifier id, Date iat) {
        super(endpoint);
        if (subject == null) {
            throw new IllegalArgumentException("The subject must not be null");
        }
        this.subject = subject;
        if (id == null) {
            throw new IllegalArgumentException("The ID must not be null");
        }
        this.id = id;
        this.iat = iat;
        this.trustMark = null;
    }

    public TrustMarkStatusRequest(URI endpoint, SignedJWT trustMark) {
        super(endpoint);
        if (trustMark == null) {
            throw new IllegalArgumentException("The trust mark must not be null");
        }
        this.trustMark = trustMark;
        this.subject = null;
        this.id = null;
        this.iat = null;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public EntityID getSubjectEntityID() {
        return this.subject != null ? new EntityID(this.subject) : null;
    }

    public Identifier getID() {
        return this.id;
    }

    public Date getIssueTime() {
        return this.iat;
    }

    public SignedJWT getTrustMark() {
        return this.trustMark;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        if (this.getSubject() != null) {
            params.put("sub", Collections.singletonList(this.getSubject().getValue()));
        }
        if (this.getID() != null) {
            params.put("id", Collections.singletonList(this.getID().getValue()));
        }
        if (this.getIssueTime() != null) {
            params.put("iat", Collections.singletonList(DateUtils.toSecondsSinceEpoch(this.getIssueTime()) + ""));
        }
        if (this.getTrustMark() != null) {
            params.put("trust_mark", Collections.singletonList(this.getTrustMark().serialize()));
        }
        return params;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        httpRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        httpRequest.setBody(URLUtils.serializeParameters(this.toParameters()));
        return httpRequest;
    }

    public static TrustMarkStatusRequest parse(Map<String, List<String>> params) throws ParseException {
        Subject subject = null;
        String value = MultivaluedMapUtils.getFirstValue(params, "sub");
        if (StringUtils.isNotBlank(value)) {
            subject = new Subject(value);
        }
        Identifier id = null;
        value = MultivaluedMapUtils.getFirstValue(params, "id");
        if (StringUtils.isNotBlank(value)) {
            id = new Identifier(value);
        }
        Date iat = null;
        value = MultivaluedMapUtils.getFirstValue(params, "iat");
        if (StringUtils.isNotBlank(value)) {
            try {
                iat = DateUtils.fromSecondsSinceEpoch(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Illegal iat");
            }
        }
        SignedJWT trustMark = null;
        value = MultivaluedMapUtils.getFirstValue(params, "trust_mark");
        if (StringUtils.isNotBlank(value)) {
            try {
                trustMark = SignedJWT.parse(value);
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid trust mark: " + e.getMessage(), e);
            }
        }
        if (trustMark != null) {
            return new TrustMarkStatusRequest(null, trustMark);
        }
        try {
            return new TrustMarkStatusRequest(null, subject, id, iat);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Invalid request: " + e.getMessage());
        }
    }

    public static TrustMarkStatusRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        TrustMarkStatusRequest request = TrustMarkStatusRequest.parse(httpRequest.getBodyAsFormParameters());
        if (request.getTrustMark() != null) {
            return new TrustMarkStatusRequest(httpRequest.getURI(), request.trustMark);
        }
        return new TrustMarkStatusRequest(httpRequest.getURI(), request.getSubject(), request.getID(), request.getIssueTime());
    }
}

