/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.io.swagger.parser.processors;

import com.dataiku.dss.shadelib.io.swagger.models.Model;
import com.dataiku.dss.shadelib.io.swagger.models.RefResponse;
import com.dataiku.dss.shadelib.io.swagger.models.Response;
import com.dataiku.dss.shadelib.io.swagger.models.Swagger;
import com.dataiku.dss.shadelib.io.swagger.models.refs.RefFormat;
import com.dataiku.dss.shadelib.io.swagger.parser.ResolverCache;
import com.dataiku.dss.shadelib.io.swagger.parser.processors.ExternalRefProcessor;
import com.dataiku.dss.shadelib.io.swagger.parser.processors.ModelProcessor;
import com.dataiku.dss.shadelib.io.swagger.parser.util.RefUtils;

public class ResponseProcessor {
    private final ModelProcessor modelProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public ResponseProcessor(ResolverCache cache, Swagger swagger) {
        this.modelProcessor = new ModelProcessor(cache, swagger);
        this.externalRefProcessor = new ExternalRefProcessor(cache, swagger);
    }

    public void processResponse(Response response) {
        Model schema = response.getResponseSchema();
        if (response instanceof RefResponse) {
            RefResponse refResponse = (RefResponse)response;
            this.processReferenceResponse(refResponse);
        }
        if (schema != null) {
            this.modelProcessor.processModel(schema);
        }
    }

    public void processReferenceResponse(RefResponse refResponse) {
        RefFormat refFormat = refResponse.getRefFormat();
        String $ref = refResponse.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat)) {
            this.externalRefProcessor.processRefToExternalResponse($ref, refFormat);
        }
    }
}

