/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.TermFrequencyAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IgnoreRandomChains;
import java.io.IOException;

@IgnoreRandomChains(reason="requires a special encoded token value, so it may fail with random data")
public final class DelimitedTermFrequencyTokenFilter
extends TokenFilter {
    public static final char DEFAULT_DELIMITER = '|';
    private final char delimiter;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final TermFrequencyAttribute tfAtt = this.addAttribute(TermFrequencyAttribute.class);

    public DelimitedTermFrequencyTokenFilter(TokenStream input) {
        this(input, '|');
    }

    public DelimitedTermFrequencyTokenFilter(TokenStream input, char delimiter) {
        super(input);
        this.delimiter = delimiter;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length = this.termAtt.length();
            for (int i = 0; i < length; ++i) {
                if (buffer[i] != this.delimiter) continue;
                this.termAtt.setLength(i);
                this.tfAtt.setTermFrequency(ArrayUtil.parseInt(buffer, ++i, length - i));
                return true;
            }
            return true;
        }
        return false;
    }
}

