/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.pattern;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.pattern.PatternTypingFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoaderAware;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class PatternTypingFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "patternTyping";
    private final String patternFile;
    private PatternTypingFilter.PatternTypingRule[] rules;

    public PatternTypingFilterFactory(Map<String, String> args2) {
        super(args2);
        this.patternFile = this.require(args2, "patternFile");
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public PatternTypingFilterFactory() {
        throw PatternTypingFilterFactory.defaultCtorException();
    }

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        ArrayList<PatternTypingFilter.PatternTypingRule> ruleList = new ArrayList<PatternTypingFilter.PatternTypingRule>();
        List<String> lines = this.getLines(loader, this.patternFile);
        for (String line : lines) {
            int firstSpace = line.indexOf(32);
            int flagsVal = Integer.parseInt(line.substring(0, firstSpace));
            String[] split = (line = line.substring(firstSpace + 1)).split(" ::: ");
            if (split.length != 2) {
                throw new RuntimeException("The PatternTypingFilter: Always two there are, no more, no less, a pattern and a replacement (separated by ' ::: ' )");
            }
            Pattern compiled = Pattern.compile(split[0]);
            ruleList.add(new PatternTypingFilter.PatternTypingRule(compiled, flagsVal, split[1]));
        }
        this.rules = ruleList.toArray(new PatternTypingFilter.PatternTypingRule[0]);
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new PatternTypingFilter(input, this.rules);
    }
}

