/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.geo;

import com.dataiku.dss.shadelib.org.apache.lucene.geo.Component2D;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.EdgeTree;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.LatLonGeometry;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.Polygon;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.XYEncodingUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.XYGeometry;
import com.dataiku.dss.shadelib.org.apache.lucene.geo.XYPolygon;
import com.dataiku.dss.shadelib.org.apache.lucene.index.PointValues;

final class Polygon2D
implements Component2D {
    private final double minY;
    private final double maxY;
    private final double minX;
    private final double maxX;
    protected final Component2D holes;
    final EdgeTree tree;

    private Polygon2D(double minX, double maxX, double minY, double maxY, double[] x, double[] y, Component2D holes) {
        this.minY = minY;
        this.maxY = maxY;
        this.minX = minX;
        this.maxX = maxX;
        this.holes = holes;
        this.tree = EdgeTree.createTree(x, y);
    }

    private Polygon2D(XYPolygon polygon, Component2D holes) {
        this(polygon.minX, polygon.maxX, polygon.minY, polygon.maxY, XYEncodingUtils.floatArrayToDoubleArray(polygon.getPolyX()), XYEncodingUtils.floatArrayToDoubleArray(polygon.getPolyY()), holes);
    }

    private Polygon2D(Polygon polygon, Component2D holes) {
        this(polygon.minLon, polygon.maxLon, polygon.minLat, polygon.maxLat, polygon.getPolyLons(), polygon.getPolyLats(), holes);
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public boolean contains(double x, double y) {
        if (Component2D.containsPoint(x, y, this.minX, this.maxX, this.minY, this.maxY) && this.tree.contains(x, y)) {
            return this.holes == null || !this.holes.contains(x, y);
        }
        return false;
    }

    @Override
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        int numCorners;
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.within(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        if (this.holes != null) {
            PointValues.Relation holeRelation = this.holes.relate(minX, maxX, minY, maxY);
            if (holeRelation == PointValues.Relation.CELL_CROSSES_QUERY) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (holeRelation == PointValues.Relation.CELL_INSIDE_QUERY) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
        }
        if ((numCorners = this.numberOfCorners(minX, maxX, minY, maxY)) == 4) {
            if (this.tree.crossesBox(minX, maxX, minY, maxY, true)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (numCorners == 0) {
            if (Component2D.containsPoint(this.tree.x1, this.tree.y1, minX, maxX, minY, maxY)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (this.tree.crossesBox(minX, maxX, minY, maxY, true)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    @Override
    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return false;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true)) {
            return this.holes == null || !this.holes.containsLine(minX, maxX, minY, maxY, aX, aY, bX, bY);
        }
        return false;
    }

    @Override
    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return false;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY) || Component2D.pointInTriangle(minX, maxX, minY, maxY, this.tree.x1, this.tree.y1, aX, aY, bX, bY, cX, cY) || this.tree.crossesTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, true)) {
            return this.holes == null || !this.holes.containsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY);
        }
        return false;
    }

    @Override
    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return false;
        }
        if (this.contains(aX, aY) && this.contains(bX, bY) && !this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, false)) {
            return this.holes == null || !this.holes.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY);
        }
        return false;
    }

    @Override
    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return false;
        }
        if (this.contains(aX, aY) && this.contains(bX, bY) && this.contains(cX, cY) && !this.tree.crossesTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY, false)) {
            return this.holes == null || !this.holes.intersectsTriangle(minX, maxX, minY, maxY, aX, aY, bX, bY, cX, cY);
        }
        return false;
    }

    @Override
    public Component2D.WithinRelation withinPoint(double x, double y) {
        return this.contains(x, y) ? Component2D.WithinRelation.NOTWITHIN : Component2D.WithinRelation.DISJOINT;
    }

    @Override
    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (ab && this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    @Override
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (Component2D.disjoint(this.minX, this.maxX, this.minY, this.maxY, minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
        if (this.tree.crossesLine(minX, maxX, minY, maxY, aX, aY, bX, bY, true)) {
            if (ab) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, bX, bY, cX, cY, true)) {
            if (bc) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, cX, cY, aX, aY, true)) {
            if (ca) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (relation == Component2D.WithinRelation.CANDIDATE) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        if (Component2D.pointInTriangle(minX, maxX, minY, maxY, this.tree.x1, this.tree.y1, aX, aY, bX, bY, cX, cY)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return relation;
    }

    private int numberOfCorners(double minX, double maxX, double minY, double maxY) {
        int containsCount = 0;
        if (this.contains(minX, minY)) {
            ++containsCount;
        }
        if (this.contains(maxX, minY)) {
            ++containsCount;
        }
        if (containsCount == 1) {
            return containsCount;
        }
        if (this.contains(maxX, maxY)) {
            ++containsCount;
        }
        if (containsCount == 2) {
            return containsCount;
        }
        if (this.contains(minX, maxY)) {
            ++containsCount;
        }
        return containsCount;
    }

    static Component2D create(Polygon polygon) {
        LatLonGeometry[] gonHoles = polygon.getHoles();
        Component2D holes = null;
        if (gonHoles.length > 0) {
            holes = LatLonGeometry.create(gonHoles);
        }
        return new Polygon2D(polygon, holes);
    }

    static Component2D create(XYPolygon polygon) {
        XYGeometry[] gonHoles = polygon.getHoles();
        Component2D holes = null;
        if (gonHoles.length > 0) {
            holes = XYGeometry.create(gonHoles);
        }
        return new Polygon2D(polygon, holes);
    }
}

