/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.client.protocol;

import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.Header;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpRequest;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpRequestInterceptor;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.Contract;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.protocol.HttpContext;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.util.Args;
import java.io.IOException;
import java.util.Collection;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

