/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.reactor.core.publisher;

import com.dataiku.dss.shadelib.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelib.reactor.core.Scannable;
import com.dataiku.dss.shadelib.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelib.reactor.core.publisher.FluxTimeout;
import com.dataiku.dss.shadelib.reactor.core.publisher.InternalMonoOperator;
import com.dataiku.dss.shadelib.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelib.reactor.core.publisher.Operators;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;

final class MonoTimeout<T, U, V>
extends InternalMonoOperator<T, T> {
    final Publisher<U> firstTimeout;
    final Publisher<? extends T> other;
    final String timeoutDescription;
    static final Function NEVER = e -> Flux.never();

    MonoTimeout(Mono<? extends T> source, Publisher<U> firstTimeout, String timeoutDescription) {
        super(source);
        this.firstTimeout = Objects.requireNonNull(firstTimeout, "firstTimeout");
        this.other = null;
        this.timeoutDescription = timeoutDescription;
    }

    MonoTimeout(Mono<? extends T> source, Publisher<U> firstTimeout, Publisher<? extends T> other) {
        super(source);
        this.firstTimeout = Objects.requireNonNull(firstTimeout, "firstTimeout");
        this.other = Objects.requireNonNull(other, "other");
        this.timeoutDescription = null;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new FluxTimeout.TimeoutMainSubscriber(Operators.serialize(actual), this.firstTimeout, NEVER, this.other, FluxTimeout.addNameToTimeoutDescription(this.source, this.timeoutDescription));
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

