/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.io.opencensus.metrics;

import com.dataiku.dss.shadelibdatabricks.io.opencensus.common.ToDoubleFunction;
import com.dataiku.dss.shadelibdatabricks.io.opencensus.internal.Utils;
import com.dataiku.dss.shadelibdatabricks.io.opencensus.metrics.LabelKey;
import com.dataiku.dss.shadelibdatabricks.io.opencensus.metrics.LabelValue;
import com.dataiku.dss.shadelibdatabricks.javax.annotation.concurrent.ThreadSafe;
import java.util.List;

@ThreadSafe
public abstract class DerivedDoubleGauge {
    public abstract <T> void createTimeSeries(List<LabelValue> var1, T var2, ToDoubleFunction<T> var3);

    public abstract void removeTimeSeries(List<LabelValue> var1);

    public abstract void clear();

    static DerivedDoubleGauge newNoopDerivedDoubleGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
        return NoopDerivedDoubleGauge.create(name, description, unit, labelKeys);
    }

    private static final class NoopDerivedDoubleGauge
    extends DerivedDoubleGauge {
        private final int labelKeysSize;

        static NoopDerivedDoubleGauge create(String name, String description, String unit, List<LabelKey> labelKeys) {
            return new NoopDerivedDoubleGauge(name, description, unit, labelKeys);
        }

        NoopDerivedDoubleGauge(String name, String description, String unit, List<LabelKey> labelKeys) {
            Utils.checkNotNull(name, "name");
            Utils.checkNotNull(description, "description");
            Utils.checkNotNull(unit, "unit");
            Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
            this.labelKeysSize = labelKeys.size();
        }

        @Override
        public <T> void createTimeSeries(List<LabelValue> labelValues, T obj, ToDoubleFunction<T> function) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelValues, "labelValues"), "labelValue");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            Utils.checkNotNull(function, "function");
        }

        @Override
        public void removeTimeSeries(List<LabelValue> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        @Override
        public void clear() {
        }
    }
}

