/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.data.currency;

import com.dataiku.dip.data.currency.CurrencyData;
import com.dataiku.dip.input.formats.csv.NoDependenciesRFC4180CSVParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class CurrencyDataLoader {
    public static final String LAST_KNOWN_DATE = "lastKnownDate";
    private static CurrencyData currencyCache;
    private static String dateCache;
    private static CurrenciesData currenciesCache;
    public static final String CURRENCY_REFERENCE = "EUR";

    public static CurrenciesData load(File resourceFile) {
        Class<CurrencyDataLoader> clazz = CurrencyDataLoader.class;
        synchronized (CurrencyDataLoader.class) {
            if (currenciesCache != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return currenciesCache;
            }
            try {
                CurrenciesData cd = new CurrenciesData();
                try (GZIPInputStream gis = new GZIPInputStream(new FileInputStream(resourceFile));
                     InputStreamReader isr = new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8);
                     BufferedReader br = new BufferedReader(isr);){
                    NoDependenciesRFC4180CSVParser parser = new NoDependenciesRFC4180CSVParser(br, ',');
                    ArrayList<String> out = new ArrayList<String>();
                    parser.next(out);
                    while (parser.next(out)) {
                        if (out.size() < 55) continue;
                        CurrencyData data = new CurrencyData();
                        data.USD = (String)out.get(1);
                        data.JPY = (String)out.get(2);
                        data.BGN = (String)out.get(3);
                        data.CYP = (String)out.get(4);
                        data.CZK = (String)out.get(5);
                        data.DKK = (String)out.get(6);
                        data.EEK = (String)out.get(7);
                        data.GBP = (String)out.get(8);
                        data.HUF = (String)out.get(9);
                        data.LTL = (String)out.get(10);
                        data.LVL = (String)out.get(11);
                        data.MTL = (String)out.get(12);
                        data.PLN = (String)out.get(13);
                        data.ROL = (String)out.get(14);
                        data.RON = (String)out.get(15);
                        data.SEK = (String)out.get(16);
                        data.SIT = (String)out.get(17);
                        data.SKK = (String)out.get(18);
                        data.CHF = (String)out.get(19);
                        data.ISK = (String)out.get(20);
                        data.NOK = (String)out.get(21);
                        data.HRK = (String)out.get(22);
                        data.RUB = (String)out.get(23);
                        data.TRL = (String)out.get(24);
                        data.TRY = (String)out.get(25);
                        data.AUD = (String)out.get(26);
                        data.BRL = (String)out.get(27);
                        data.CAD = (String)out.get(28);
                        data.CNY = (String)out.get(29);
                        data.HKD = (String)out.get(30);
                        data.IDR = (String)out.get(31);
                        data.INR = (String)out.get(32);
                        data.KRW = (String)out.get(33);
                        data.MXN = (String)out.get(34);
                        data.MYR = (String)out.get(35);
                        data.NZD = (String)out.get(36);
                        data.PHP = (String)out.get(37);
                        data.SGD = (String)out.get(38);
                        data.THB = (String)out.get(39);
                        data.ZAR = (String)out.get(40);
                        data.ILS = (String)out.get(41);
                        data.QAR = (String)out.get(42);
                        data.SAR = (String)out.get(43);
                        data.TTD = (String)out.get(44);
                        data.CLP = (String)out.get(45);
                        data.KWD = (String)out.get(46);
                        data.BWP = (String)out.get(47);
                        data.AED = (String)out.get(48);
                        data.MUR = (String)out.get(49);
                        data.DZD = (String)out.get(50);
                        data.UYU = (String)out.get(51);
                        data.OMR = (String)out.get(52);
                        data.PEN = (String)out.get(53);
                        data.BND = (String)out.get(54);
                        cd.data.put((String)out.get(0), data);
                    }
                }
                currenciesCache = cd;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return currenciesCache;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load currency data", e);
            }
        }
    }

    public static class CurrenciesData {
        public Map<String, CurrencyData> data = new LinkedHashMap<String, CurrencyData>();

        public CurrencyData lookup(String date) {
            if (date != null && date.equals(dateCache) && currencyCache != null) {
                return currencyCache;
            }
            dateCache = date;
            currencyCache = CurrencyDataLoader.LAST_KNOWN_DATE.equals(date) ? this.data.get(this.getLastKnownRateDate()) : (this.data.containsKey(date) ? this.data.get(date) : null);
            return currencyCache;
        }

        public CurrencyData getCurrency(String date) {
            return this.lookup(date);
        }

        public String getLastKnownRateDate() {
            return this.data.entrySet().iterator().next().getKey();
        }
    }
}

