(function(){
  "use strict";
  const app = angular.module("dataiku.datasets.upload", [])

  const FileExtensionService = function(
    FILE_EXTENSIONS
  ) {
    this.isExcel = extension => extension == FILE_EXTENSIONS.EXCEL || extension == FILE_EXTENSIONS.EXCELX;
    /**
     * 
     * @param {Set<string>} extensions 
     * @returns {boolean}
     */
    this.hasExcel = extensions => extensions.has(FILE_EXTENSIONS.EXCEL) || extensions.has(FILE_EXTENSIONS.EXCELX);

    /**
     * 
     * @param {Set<string>} extensions 
     * @returns {boolean}
     */
    this.hasOnlyExcel = extensions => Array.from(extensions).every(extension => this.isExcel(extension));

    /**
     * Extract the extensions of uploaded files into a set
     * @param {Array<File>} files The list of uploaded files
     * @returns {Set<string>}
     */
    this.extractFileExtensions = (files) => {
      return new Set(
        files.map(
          file => {
            if (file.name.indexOf('.') !== -1) {
              return file.name.split('.').at(-1);
            }
          }
        )
      );
    };

    /**
     * Extract the extensions of DSS specific uploaded files into a set
     * @param {Array<UploadedFiles>} uploadedFiles 
     * @returns {Set<string>}
     */
    this.extractUploadedFileExtensions = (uploadedFiles) => {
      return new Set(
        uploadedFiles.map(
          file => {
            if (file.path.indexOf('.') !== -1) {
              return file.path.split('.').at(-1);
            }
          }
        )
      );
    }
  }
  app.service("FileExtensionService", FileExtensionService);
})();