(function() {
    'use strict';

    const app = angular.module('dataiku.directives.simple_report');

    /**
     * Controller for common logic to handle std aggregated measures in the dropdown.
     */
    app.controller('StdAggregatedMeasureController', ($scope, ChartLabels, ChartFeatures, ChartCustomMeasures, ColumnAvailability) => {
        $scope.ChartFeatures = ChartFeatures;
        $scope.ChartLabels = ChartLabels;
        $scope.getAggregationDescription = ColumnAvailability.getAggregationDescription;
        $scope.countOfRecordsLabel = ChartLabels.COUNT_OF_RECORDS_LABEL;
        $scope.getAvailableAggregations = (measureType, chartType) => ChartLabels.getAvailableAggregationsLabels(measureType, chartType, $scope.contextualMenuMeasureType);
        $scope.getCustomMeasure = ChartCustomMeasures.getCustomMeasure;
        $scope.getAvailableUnaggregatedModes = (measure) => ChartLabels.getAvailableUnaggregatedModesLabels(measure, $scope.chart.def, $scope.contextualMenuMeasureType);
        $scope.onUnaggregatedChange = function(isMeasureUnaggregated, measure) {
            if (isMeasureUnaggregated) {
                const compatibleUaComputeModes = Object.keys($scope.getAvailableUnaggregatedModes(measure));
                if (!compatibleUaComputeModes.includes(measure.uaComputeMode)) {
                    measure.uaComputeMode = compatibleUaComputeModes[0];
                }
            }
            if (!$scope.$$phase) {
                $scope.$apply();
            }
        };
    });

})();
