/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractCloudStorageConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FSProviderizableConnection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.connections.HDFSAbleConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkConfigurator;
import com.dataiku.dip.spark.SparkSQLConnectionPoolService;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.RuntimeIOException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ConnectionsDAO {
    @Autowired
    private VariablesService variablesService;
    public static final Pattern virtualConnectionPattern = Pattern.compile("^@virtual\\((.+)\\):([^:]*:)?(.+)$");
    private static Logger logger = Logger.getLogger(ConnectionsDAO.class);

    public static synchronized ConnectionsDAO get() {
        return (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
    }

    protected abstract ConnectionsFile read() throws IOException;

    protected abstract ConnectionsFile readUnsafe() throws IOException;

    protected abstract void write(ConnectionsFile var1) throws IOException;

    public List<String> getConnectionNames(String type, AuthCtx authCtx, boolean checkAllowManagedFolders) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (ConnectionTypeAndName tn : this.getConnectionTypesAndNames(type, authCtx, checkAllowManagedFolders)) {
            ret.add(tn.name);
        }
        return ret;
    }

    public List<CloudStorageConnectionWithPredictionLogsRoot> listCloudStorageConnectionWithPredictionLogsRoot(String type, AuthCtx authCtx, boolean checkAllowManagedFolders) throws IOException {
        if (!(type.equals("EC2") || type.equals("GCS") || type.equals("Azure"))) {
            throw new IllegalArgumentException(String.format("The connection type %s is not a supported cloud storage connection type.", type));
        }
        return this.streamFilteredConnections(type, authCtx, checkAllowManagedFolders).filter(dssConnection -> dssConnection instanceof AbstractCloudStorageConnection).map(dssConnection -> (AbstractCloudStorageConnection)dssConnection).map(connection -> new CloudStorageConnectionWithPredictionLogsRoot(connection.name, connection.type, connection.getPredictionLogsRoot())).collect(Collectors.toList());
    }

    public List<ConnectionTypeAndName> getConnectionTypesAndNames(String type, AuthCtx authCtx, boolean checkAllowManagedFolders) throws IOException {
        List<ConnectionTypeAndName> list = this.streamFilteredConnections(type, authCtx, checkAllowManagedFolders).map(connection -> new ConnectionTypeAndName(connection.name, (DSSConnection)connection)).collect(Collectors.toList());
        if ("DatabricksVolume".equals(type)) {
            String superType = "Databricks";
            List sublist = this.streamFilteredConnections(superType, authCtx, checkAllowManagedFolders).map(connection -> new ConnectionTypeAndName(connection.name, (DSSConnection)connection)).collect(Collectors.toList());
            list.addAll(sublist);
        }
        return list;
    }

    private Stream<DSSConnection> streamFilteredConnections(String type, AuthCtx authCtx, boolean checkAllowManagedFolders) throws IOException {
        ConnectionsFile cf = this.read();
        if (checkAllowManagedFolders && DKUApp.getParams().getBoolParam("dku.security.unsafe.securityBypasses.allowManagedFoldersDespiteConnectionRejectingThem", false)) {
            logger.warn((Object)"UNSECURE: Disabling security check for 'allowManagedFolders' flag on connections (requested by admin)");
            checkAllowManagedFolders = false;
        }
        boolean fCheckAllowManagedFolders = checkAllowManagedFolders;
        return cf.connections.entrySet().stream().map(entry -> {
            DSSConnection connection = (DSSConnection)entry.getValue();
            connection.name = (String)entry.getKey();
            return connection;
        }).filter(dssConnection -> this.connectionShouldBeAdded(authCtx, type, (DSSConnection)dssConnection, fCheckAllowManagedFolders));
    }

    private boolean connectionShouldBeAdded(AuthCtx authCtx, String type, DSSConnection connection, boolean checkAllowManagedFolders) {
        if ("sql".equalsIgnoreCase(type)) {
            try {
                ConnectionUtils.SQLConnectionType.valueOf(connection.getType().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        } else {
            if ("hdfsable".equalsIgnoreCase(type) && !(connection instanceof HDFSAbleConnection)) {
                return false;
            }
            if (!"all".equalsIgnoreCase(type) && !connection.getType().equalsIgnoreCase(type)) {
                return false;
            }
        }
        return connection.isFreelyUsableBy(authCtx) && (!checkAllowManagedFolders || connection.allowManagedFolders);
    }

    public void writeList(Map<String, DSSConnection> list) throws IOException {
        ConnectionsFile cf = this.read();
        for (Map.Entry<String, DSSConnection> c2 : list.entrySet()) {
            c2.getValue().name = null;
        }
        cf.connections = list;
        this.write(cf);
    }

    public Map<String, DSSConnection> list() throws IOException {
        ConnectionsFile cf = this.read();
        for (Map.Entry<String, DSSConnection> c2 : cf.connections.entrySet()) {
            c2.getValue().name = c2.getKey();
        }
        return cf.connections;
    }

    public Map<String, DSSConnection> listUnsafe() throws IOException {
        ConnectionsFile cf = this.readUnsafe();
        for (Map.Entry<String, DSSConnection> connection : cf.connections.entrySet()) {
            connection.getValue().name = connection.getKey();
        }
        return cf.connections;
    }

    public DSSConnection getConnectionUncheckedException(AuthCtx authCtx, String name) throws DKUSecurityException {
        try {
            return this.getMandatoryConnection(authCtx, name);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public <T extends DSSConnection> T getConnectionNoExceptionAs(AuthCtx authCtx, String name, Class<T> clazz) throws DKUSecurityException {
        try {
            return this.getMandatoryConnectionAs(authCtx, name, clazz);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public <T extends DSSConnection> T getMandatoryConnectionAs(AuthCtx authCtx, String name, Class<T> clazz) throws IOException, DKUSecurityException {
        DSSConnection conn = this.getMandatoryConnection(authCtx, name);
        try {
            return (T)((DSSConnection)clazz.cast(conn));
        }
        catch (Exception e) {
            logger.error((Object)("Failed to convert connection from " + conn.getClass().getName() + " to " + clazz.getName()), (Throwable)e);
            throw ErrorContext.iaef((String)"Unexpected connection type for %s: %s", (Object)clazz.getName(), (Object[])new Object[]{conn.getType()});
        }
    }

    public DSSConnection getMandatoryConnection(AuthCtx authCtx, String name) throws IOException, DKUSecurityException {
        DSSConnection conn = this.getConnection(authCtx, name);
        if (conn == null) {
            throw ErrorContext.iaef((String)"Connection '%s' does not exist", (Object)name, (Object[])new Object[0]);
        }
        return conn;
    }

    public DSSConnection getMandatoryConnectionUnsafeUnexpanded(AuthCtx authCtx, String name) throws IOException, DKUSecurityException {
        DSSConnection conn = this.getConnectionUnsafeUnexpanded(authCtx, name);
        if (conn == null) {
            throw ErrorContext.iaef((String)"Connection '%s' does not exist", (Object)name, (Object[])new Object[0]);
        }
        return conn;
    }

    public <T extends DSSConnection> T getMandatoryConnectionUnsafeUnexpandedAs(AuthCtx authCtx, String name, Class<T> clazz) throws IOException, DKUSecurityException {
        DSSConnection connection = this.getMandatoryConnectionUnsafeUnexpanded(authCtx, name);
        try {
            return (T)((DSSConnection)clazz.cast(connection));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to convert connection from %s to %s".formatted(connection.getClass().getName(), clazz.getName()), (Throwable)e);
            throw ErrorContext.iaef((String)"Unexpected connection type for %s: %s", (Object)clazz.getName(), (Object[])new Object[]{connection.getType()});
        }
    }

    public DSSConnection getConnection(AuthCtx authCtx, String name) throws IOException, DKUSecurityException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Connection name not specified");
        if (virtualConnectionPattern.matcher(name).find()) {
            return this.getVirtualConnection(authCtx, name);
        }
        DSSConnection connection = this.listUnsafe().get(name);
        if (connection == null) {
            return null;
        }
        connection = (DSSConnection)JSON.deepCopy((Object)connection);
        VariablesContext vc = this.variablesService.getForGlobalAndUserLogin(authCtx);
        connection.name = name;
        connection.expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(vc);
        return connection;
    }

    public List<DSSConnection> getConnections(AuthCtx authCtx, Collection<String> names) throws IOException, DKUSecurityException {
        ArrayList<DSSConnection> connections = new ArrayList<DSSConnection>();
        for (String name : names) {
            connections.add(this.getConnection(authCtx, name));
        }
        return connections;
    }

    public DSSConnection getConnectionUnsafeUnexpanded(AuthCtx authCtx, String name) throws IOException, DKUSecurityException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Connection name not specified");
        if (virtualConnectionPattern.matcher(name).find()) {
            return this.getVirtualConnection(authCtx, name);
        }
        return this.listUnsafe().get(name);
    }

    private DSSConnection getVirtualConnection(AuthCtx authCtx, String name) throws IOException, DKUSecurityException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Connection name not specified");
        DSSConnection conn = null;
        Matcher matcher = virtualConnectionPattern.matcher(name);
        if (matcher.find()) {
            String database = null;
            if (matcher.group(2) != null && matcher.group(2).length() > 0) {
                DSSConnection connection = this.getConnection(authCtx, matcher.group(3));
                if (connection == null) {
                    throw new IOException("Virtual connection is referencing an unknown connection " + matcher.group(3));
                }
                if (!(connection instanceof HDFSConnection)) {
                    throw new IOException("Virtual connection is referencing the non-hdfs connection " + connection.name + " of type " + connection.getType());
                }
                database = ((HDFSConnection)connection).getParams().defaultDatabase;
                if (database == null || database.length() == 0) {
                    throw new IOException("Hdfs connection " + connection.name + " referenced by virtual connection has no default hive database set");
                }
            } else {
                database = matcher.group(3);
            }
            String virtualConnectionType = matcher.group(1);
            if (VirtualConnectionType.HIVE_JDBC.getId().equals(virtualConnectionType)) {
                conn = HiveConfigurator.configureConnectionForDatabase(authCtx, database, null, (HiveServer2ConnectionPoolService)SpringUtils.getBean(HiveServer2ConnectionPoolService.class));
            } else if (VirtualConnectionType.IMPALA_JDBC.getId().equals(virtualConnectionType)) {
                conn = ImpalaConfigurator.configureConnectionForDatabase(authCtx, database);
            } else if (VirtualConnectionType.SPARK_LIVY.getId().equals(virtualConnectionType)) {
                conn = SparkConfigurator.configureConnectionForDatabase(database, null, (SparkSQLConnectionPoolService)SpringUtils.getBean(SparkSQLConnectionPoolService.class));
            } else if (VirtualConnectionType.JOB_TEMP.getId().equals(virtualConnectionType)) {
                conn = new FsConnection();
                conn.name = name;
                ((FsConnection)conn).params.root = FlowJobUtils.getCurrentJobActivityFolder().getAbsolutePath();
                conn.allowWrite = true;
                conn.allowManagedDatasets = true;
            } else {
                throw ErrorContext.iaef((String)"Unrecognized virtual connection type: %s", (Object)virtualConnectionType, (Object[])new Object[0]);
            }
        }
        return conn;
    }

    public static VirtualConnectionId parseVirtualConnection(String connection) {
        Matcher matcher = virtualConnectionPattern.matcher(connection);
        if (!matcher.find()) {
            return null;
        }
        if (matcher.group(2) != null && matcher.group(2).length() > 0) {
            return new VirtualConnectionId(connection, matcher.group(1), matcher.group(3), matcher.group(2).replace(":", ""));
        }
        return new VirtualConnectionId(connection, matcher.group(1), matcher.group(3), null);
    }

    public static class ConnectionTypeAndName {
        public String type;
        public String name;
        public String description;
        public List<String> fsTypes;

        public ConnectionTypeAndName(String name, DSSConnection c2) {
            this.type = c2.getType();
            this.name = name;
            this.description = c2.description;
            if (c2 instanceof FSProviderizableConnection) {
                this.fsTypes = ((FSProviderizableConnection)((Object)c2)).getProviderTypes();
            }
        }
    }

    public static class ConnectionsFile {
        public Map<String, DSSConnection> connections = new HashMap<String, DSSConnection>();
    }

    public static enum VirtualConnectionType {
        HIVE_HPROXY("hive-hproxy", "hive"),
        HIVE_JDBC("hive-jdbc", "hive"),
        IMPALA_JDBC("impala-jdbc", "impala"),
        SPARK_LIVY("spark-livy", "spark"),
        JOB_TEMP("job-tmp", "job");

        private final String id;
        private final String group;

        public static VirtualConnectionType forId(String id) {
            for (VirtualConnectionType v : VirtualConnectionType.values()) {
                if (!v.id.equals(id)) continue;
                return v;
            }
            throw new IllegalArgumentException("Unknown virtual connection type " + id);
        }

        private VirtualConnectionType(String id, String group) {
            this.id = id;
            this.group = group;
        }

        public String getId() {
            return this.id;
        }

        public String getGroup() {
            return this.group;
        }
    }

    public static class VirtualConnectionId {
        public final String type;
        public final String db;
        public final String connection;
        private final String virtualConnection;

        public String getId() {
            return this.virtualConnection;
        }

        public VirtualConnectionType getType() {
            return VirtualConnectionType.forId(this.type);
        }

        private VirtualConnectionId(String virtualConnection, String type, String db, String connection) {
            this.virtualConnection = virtualConnection;
            this.type = type;
            this.db = db;
            this.connection = connection;
        }
    }

    public static class CloudStorageConnectionWithPredictionLogsRoot {
        public String name;
        public String type;
        public String predictionLogsRoot;

        public CloudStorageConnectionWithPredictionLogsRoot(String name, String type, String predictionLogsRoot) {
            this.name = name;
            this.type = type;
            this.predictionLogsRoot = predictionLogsRoot;
        }
    }
}

