/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.cluster.ClusterSelection;
import com.dataiku.dip.code.ProjectCodeEnvsSelection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.ObjectCustomMetadata;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.git.IProjectCommitModeService;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.projects.importexport.model.BundleContainerSettings;
import com.dataiku.dip.projects.importexport.model.BundleExporterSettings;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.CommitEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionClosedEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionDeletedEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionReplyEvent;
import com.dataiku.dip.server.notifications.backend.InterestChangedEvent;
import com.dataiku.dip.server.notifications.backend.JobStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.MLTaskStateChangedEvent;
import com.dataiku.dip.server.notifications.backend.ScenarioStateChangeEvent;
import com.dataiku.dip.server.notifications.backend.TimelineItemEvent;
import com.dataiku.dip.server.notifications.emails.AbstractInviteEmailSendService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.webapps.VirtualWebAppBackendSettings;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class SerializedProject
extends TaggableObjectsService.TaggableObject {
    public ProjectDashboardAuthorizations dashboardAuthorizations = new ProjectDashboardAuthorizations();
    public ProjectExposedObjects exposedObjects = new ProjectExposedObjects();
    @JSON.FileTransient
    public String projectKey;
    public ProjectType projectType = ProjectType.REGULAR;
    public ProjectAppType projectAppType = ProjectAppType.REGULAR;
    public boolean hasSetupSection;
    @Nullable
    public String generatingAppId;
    public String generatingAppVersion;
    @Nullable
    public String appInstanceCreatorFullId;
    @Nullable
    public Boolean isTemporaryAppInstance;
    public BundleContainerSettings bundleContainerSettings;
    public BundleExporterSettings bundleExporterSettings;
    public String owner;
    public PermissionsVersion permissionsVersion = PermissionsVersion.LEGACY;
    public List<PermissionItem> permissions = new ArrayList<PermissionItem>();
    public AdditionalDashboardUsers additionalDashboardUsers = new AdditionalDashboardUsers();
    public boolean tutorialProject;
    public String tutorialId;
    public ProjectSettings settings = new ProjectSettings();
    public String name;
    public String projectStatus;
    public String imgColor;
    public Integer imgPattern;
    public Boolean showInitials;
    public ObjectCustomMetadata customMeta;
    public ProbesSet metrics = new ProbesSet();
    public ChecksSet metricsChecks = new ChecksSet();

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.PROJECT;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.projectKey;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.projectKey = id;
    }

    public Params getDkuPropertiesAsParams(boolean withSystem) {
        if (withSystem) {
            Map systemParams = DKUApp.getParams().getAll();
            Map<String, String> projectParams = AbstractSQLConnection.CustomDatabaseProperty.toMap(this.settings.dkuProperties);
            HashMap<String, String> resultingParams = new HashMap<String, String>();
            resultingParams.putAll(systemParams);
            resultingParams.putAll(projectParams);
            return new Params(resultingParams);
        }
        return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.settings.dkuProperties);
    }

    @UIModel
    public static class ProjectDashboardAuthorizations {
        public boolean allAuthorized;
        public List<ReaderAuthorization> authorizations = new ArrayList<ReaderAuthorization>();

        public boolean addAuthorization(SmartObjectRef ref, Set<ReaderAuthorization.Mode> modes) {
            Optional<ReaderAuthorization> existing = this.authorizations.stream().filter(auth -> auth.objectRef.equals(ref)).findFirst();
            if (existing.isPresent()) {
                return existing.get().modes.addAll(modes);
            }
            this.authorizations.add(new ReaderAuthorization(ref, modes));
            return true;
        }

        public ReaderAuthorization getOrSetAuthorization(SmartObjectRef ref) {
            Optional<ReaderAuthorization> existing = this.authorizations.stream().filter(auth -> auth.objectRef.equals(ref)).findFirst();
            if (existing.isPresent()) {
                return existing.get();
            }
            ReaderAuthorization newAuth = new ReaderAuthorization(ref, new HashSet<ReaderAuthorization.Mode>());
            this.authorizations.add(newAuth);
            return newAuth;
        }

        public ProjectsService.ObjectVisibility getObjectVisibility(SmartObjectRef ref) {
            if (this.allAuthorized) {
                return ProjectsService.ObjectVisibility.READ;
            }
            return this.getCurrentAuthorization(ref).map(auth -> auth.canRead() ? ProjectsService.ObjectVisibility.READ : (auth.canDiscover() ? ProjectsService.ObjectVisibility.DISCOVER : ProjectsService.ObjectVisibility.NONE)).orElse(ProjectsService.ObjectVisibility.NONE);
        }

        public Optional<ReaderAuthorization> getCurrentAuthorization(SmartObjectRef ref) {
            return this.authorizations.stream().filter(auth -> auth.objectRef.equals(ref)).findFirst();
        }

        public Set<ReaderAuthorization.Mode> getCurrentAuthorizationModes(SmartObjectRef ref) {
            return this.getCurrentAuthorization(ref).map(auth -> auth.modes).orElse(new HashSet());
        }

        public boolean hasObjectAuthorization(SmartObjectRef ref, ReaderAuthorization.Mode mode) {
            boolean isReadOrDiscover;
            boolean bl = isReadOrDiscover = mode == ReaderAuthorization.Mode.READ || mode == ReaderAuthorization.Mode.DISCOVER;
            if (this.allAuthorized && isReadOrDiscover) {
                return true;
            }
            return this.getCurrentAuthorization(ref).map(auth -> auth.can(mode)).orElse(false);
        }
    }

    public static class ProjectExposedObjects {
        public List<ExposedObject> objects = new ArrayList<ExposedObject>();

        public Set<String> getProjectsExposedTo(ITaggingService.TaggableType type, String localName) {
            HashSet<String> ret = new HashSet<String>();
            for (ExposedObject object : this.objects) {
                if (object.type != type || !localName.equals(object.localName)) continue;
                for (ExposedObject.Rule rule : object.rules) {
                    ret.add(rule.targetProject);
                }
            }
            return ret;
        }

        public boolean setQuickSharing(ITaggingService.TaggableType type, String id, boolean enabled) {
            Optional<ExposedObject> existing = this.objects.stream().filter(eo -> eo.type == type && eo.localName.equals(id)).findFirst();
            if (existing.isPresent()) {
                ExposedObject eo2 = existing.get();
                boolean previousValue = eo2.quickSharingEnabled;
                eo2.quickSharingEnabled = enabled;
                if (eo2.isUseless()) {
                    this.objects.remove(eo2);
                    return true;
                }
                return enabled != previousValue;
            }
            if (enabled) {
                this.objects.add(new ExposedObject(type, id, true));
                return true;
            }
            return false;
        }

        public boolean addTargetProjects(ITaggingService.TaggableType type, String id, Collection<String> targetProjectKeys) {
            if (targetProjectKeys.isEmpty()) {
                return false;
            }
            ExposedObject found = this.objects.stream().filter(eo -> eo.type == type && eo.localName.equals(id)).findFirst().orElseGet(() -> {
                ExposedObject newAuth = new ExposedObject(type, id, false);
                this.objects.add(newAuth);
                return newAuth;
            });
            return found.addTargetProjects(targetProjectKeys);
        }

        public boolean removeAllExpositionToTarget(String targetProjectKey) {
            boolean anyChanged = false;
            Iterator<ExposedObject> iter = this.objects.iterator();
            while (iter.hasNext()) {
                ExposedObject exposedObject = iter.next();
                boolean changed = exposedObject.removeProject(targetProjectKey);
                if (changed && exposedObject.isUseless()) {
                    iter.remove();
                }
                anyChanged |= changed;
            }
            return anyChanged;
        }

        public int hashCode() {
            int ret = 0;
            for (ExposedObject eo : this.objects) {
                ret += eo.hashCode();
            }
            return ret;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProjectExposedObjects)) {
                return false;
            }
            ProjectExposedObjects peo = (ProjectExposedObjects)obj;
            if (this.objects.size() != peo.objects.size()) {
                return false;
            }
            for (ExposedObject eo : this.objects) {
                if (peo.objects.contains(eo)) continue;
                return false;
            }
            return true;
        }
    }

    public static enum ProjectType {
        REGULAR,
        BUNDLE_CONTAINER;

    }

    public static enum ProjectAppType {
        REGULAR,
        APP_INSTANCE,
        APP_TEMPLATE;

    }

    public static enum PermissionsVersion {
        LEGACY,
        V2;

    }

    public static class AdditionalDashboardUsers {
        public List<AdditionalDashboardUser> users = new ArrayList<AdditionalDashboardUser>();
    }

    public static class ProjectSettings {
        public boolean flowAnchorSourcesAndSinks = true;
        public FlowDisplaySettings flowDisplaySettings = new FlowDisplaySettings();
        public IProjectCommitModeService.ProjectCommitMode gitCommitMode = IProjectCommitModeService.ProjectCommitMode.AUTO;
        public Boolean useRemoteGit;
        public boolean disableAutomaticTriggers = false;
        public IntegrationsSettings integrations = new IntegrationsSettings();
        public FlowBuildSettings flowBuildSettings = new FlowBuildSettings();
        public GeneralSettingsDAO.InheritableEnabledSetting.LocalValue sharingRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
        public GeneralSettingsDAO.InheritableEnabledSetting.LocalValue limitedVisibilityEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
        public GeneralSettingsDAO.InheritableEnabledSetting.LocalValue accessRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.INHERIT;
        public LimitsSettings limitsSettings = new LimitsSettings();
        public ProjectRelocationSettings relocationSettings = new ProjectRelocationSettings();
        public RecipeEnginesPreferenceConfig recipeEnginesPreferences = new RecipeEnginesPreferenceConfig();
        public ProjectCodeEnvsSelection codeEnvs = new ProjectCodeEnvsSelection();
        public ContainerExecSelection container = new ContainerExecSelection(ContainerExecSelection.ContainerExecMode.INHERIT);
        public ContainerExecSelection containerForVisualRecipesWorkloads = new ContainerExecSelection(ContainerExecSelection.ContainerExecMode.INHERIT);
        public GeneralSettingsDAO.ProjectDefaultDatasetCreationSettings datasetsCreationSettings = new GeneralSettingsDAO.ProjectDefaultDatasetCreationSettings();
        public ProjectHiveEngineCreationSettings hiveEngineCreationSettings = new ProjectHiveEngineCreationSettings();
        public ProjectSparkEngineCreationSettings sparkEngineCreationSettings = new ProjectSparkEngineCreationSettings();
        public ProjectImpalaEngineCreationSettings impalaEngineCreationSettings = new ProjectImpalaEngineCreationSettings();
        public ProjectWikiSettings wikiSettings = new ProjectWikiSettings();
        public ClusterSelection cluster = new ClusterSelection();
        public ClusterSelection k8sCluster = new ClusterSelection();
        public VirtualWebAppBackendSettings virtualWebAppBackendSettings = new VirtualWebAppBackendSettings(false);
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public boolean autogeneratedDocumentationEnabled = true;
    }

    public static class AdditionalDashboardUser {
        public String login;
    }

    public static class PermissionItem {
        public String group;
        public String user;
        public String pendingUserEmail;
        @Nullable
        public AbstractInviteEmailSendService.InvitationEmailStatus invitationEmailStatus;
        public boolean admin;
        public boolean editPermissions;
        public boolean readProjectContent;
        public boolean writeProjectContent;
        public boolean exportDatasetsData;
        public boolean readDashboards;
        public boolean writeDashboards;
        public boolean moderateDashboards;
        public boolean publishToDataCollections;
        public boolean shareToWorkspaces;
        public boolean runScenarios;
        public boolean manageDashboardAuthorizations;
        public boolean manageExposedElements;
        public boolean manageAdditionalDashboardUsers;
        public boolean executeApp;

        public PermissionItem() {
        }

        public PermissionItem(PermissionItem permissionItem) {
            this.group = permissionItem.group;
            this.user = permissionItem.user;
            this.pendingUserEmail = permissionItem.pendingUserEmail;
            this.invitationEmailStatus = permissionItem.invitationEmailStatus;
            this.admin = permissionItem.admin;
            this.editPermissions = permissionItem.editPermissions;
            this.readProjectContent = permissionItem.readProjectContent;
            this.writeProjectContent = permissionItem.writeProjectContent;
            this.exportDatasetsData = permissionItem.exportDatasetsData;
            this.readDashboards = permissionItem.readDashboards;
            this.writeDashboards = permissionItem.writeDashboards;
            this.moderateDashboards = permissionItem.moderateDashboards;
            this.publishToDataCollections = permissionItem.publishToDataCollections;
            this.shareToWorkspaces = permissionItem.shareToWorkspaces;
            this.runScenarios = permissionItem.runScenarios;
            this.manageDashboardAuthorizations = permissionItem.manageDashboardAuthorizations;
            this.manageExposedElements = permissionItem.manageExposedElements;
            this.manageAdditionalDashboardUsers = permissionItem.manageAdditionalDashboardUsers;
            this.executeApp = permissionItem.executeApp;
        }

        public PermissionItem deepCopy() {
            return new PermissionItem(this);
        }

        public boolean hasAnyAccess() {
            return this.admin || this.editPermissions || this.readProjectContent || this.writeProjectContent || this.exportDatasetsData || this.publishToDataCollections || this.shareToWorkspaces || this.readDashboards || this.writeDashboards || this.moderateDashboards || this.runScenarios || this.manageDashboardAuthorizations || this.manageExposedElements || this.manageAdditionalDashboardUsers;
        }

        public void setAdminPermissions() {
            this.admin = true;
            this.editPermissions = true;
            this.readProjectContent = true;
            this.writeProjectContent = true;
            this.exportDatasetsData = true;
            this.readDashboards = true;
            this.writeDashboards = true;
            this.moderateDashboards = true;
            this.publishToDataCollections = true;
            this.shareToWorkspaces = true;
            this.runScenarios = true;
            this.manageDashboardAuthorizations = true;
            this.manageExposedElements = true;
            this.manageAdditionalDashboardUsers = true;
            this.executeApp = true;
        }

        public boolean isEmpty() {
            return !this.executeApp && !this.hasAnyAccess();
        }

        public void addPermissionsFrom(PermissionItem other) {
            this.admin |= other.admin;
            this.editPermissions |= other.editPermissions;
            this.readProjectContent |= other.readProjectContent;
            this.writeProjectContent |= other.writeProjectContent;
            this.exportDatasetsData |= other.exportDatasetsData;
            this.publishToDataCollections |= other.publishToDataCollections;
            this.shareToWorkspaces |= other.shareToWorkspaces;
            this.readDashboards |= other.readDashboards;
            this.writeDashboards |= other.writeDashboards;
            this.moderateDashboards |= other.moderateDashboards;
            this.runScenarios |= other.runScenarios;
            this.manageDashboardAuthorizations |= other.manageDashboardAuthorizations;
            this.manageExposedElements |= other.manageExposedElements;
            this.manageAdditionalDashboardUsers |= other.manageAdditionalDashboardUsers;
            this.executeApp |= other.executeApp;
            this.invitationEmailStatus = this.invitationEmailStatus == null ? other.invitationEmailStatus : this.invitationEmailStatus;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PermissionItem)) {
                return false;
            }
            PermissionItem that = (PermissionItem)o;
            return this.admin == that.admin && this.editPermissions == that.editPermissions && this.readProjectContent == that.readProjectContent && this.writeProjectContent == that.writeProjectContent && this.exportDatasetsData == that.exportDatasetsData && this.publishToDataCollections == that.publishToDataCollections && this.shareToWorkspaces == that.shareToWorkspaces && this.readDashboards == that.readDashboards && this.writeDashboards == that.writeDashboards && this.moderateDashboards == that.moderateDashboards && this.runScenarios == that.runScenarios && this.manageDashboardAuthorizations == that.manageDashboardAuthorizations && this.manageExposedElements == that.manageExposedElements && this.manageAdditionalDashboardUsers == that.manageAdditionalDashboardUsers && this.executeApp == that.executeApp && Objects.equals(this.group, that.group) && Objects.equals(this.user, that.user) && Objects.equals(this.pendingUserEmail, that.pendingUserEmail) && Objects.equals((Object)this.invitationEmailStatus, (Object)that.invitationEmailStatus);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.group, this.user, this.pendingUserEmail, this.invitationEmailStatus, this.admin, this.editPermissions, this.readProjectContent, this.writeProjectContent, this.exportDatasetsData, this.publishToDataCollections, this.shareToWorkspaces, this.readDashboards, this.writeDashboards, this.moderateDashboards, this.runScenarios, this.manageDashboardAuthorizations, this.manageExposedElements, this.manageAdditionalDashboardUsers, this.executeApp});
        }

        public PermissionItem toReadOnly() {
            PermissionItem ret = new PermissionItem();
            ret.group = this.group;
            ret.user = this.user;
            ret.pendingUserEmail = this.pendingUserEmail;
            ret.readProjectContent = this.readProjectContent || this.writeProjectContent || this.admin;
            ret.readDashboards = this.readDashboards || this.writeDashboards || this.moderateDashboards || this.writeProjectContent || this.shareToWorkspaces || this.editPermissions || this.admin;
            ret.runScenarios = this.runScenarios || this.writeProjectContent || this.admin;
            boolean bl = ret.executeApp = this.executeApp || this.readProjectContent || this.writeProjectContent || this.admin;
            if (ret.readProjectContent || ret.readDashboards || ret.runScenarios || ret.executeApp) {
                return ret;
            }
            return null;
        }
    }

    public static class ReaderAuthorization {
        public SmartObjectRef objectRef;
        public Set<Mode> modes = new HashSet<Mode>();

        private ReaderAuthorization() {
        }

        public ReaderAuthorization(SmartObjectRef objectRef, Set<Mode> modes) {
            this.objectRef = objectRef;
            this.modes = modes;
        }

        public static ReaderAuthorization newReadAuthorization(SmartObjectRef objectRef) {
            ReaderAuthorization ret = new ReaderAuthorization(objectRef, Sets.newHashSet((Object[])new Mode[]{Mode.READ}));
            ret.makeDiscoverableIfPossible();
            return ret;
        }

        public boolean canRun() {
            return this.modes != null && this.modes.contains((Object)Mode.RUN);
        }

        public boolean canWrite() {
            return this.modes != null && this.modes.contains((Object)Mode.WRITE);
        }

        public boolean canRead() {
            return ReaderAuthorization.canRead(this.modes);
        }

        public static boolean canRead(Collection<Mode> modes) {
            return modes != null && (modes.contains((Object)Mode.READ) || modes.contains((Object)Mode.WRITE));
        }

        public boolean canDiscover() {
            return this.modes != null && (this.modes.contains((Object)Mode.DISCOVER) || this.modes.contains((Object)Mode.READ) || this.modes.contains((Object)Mode.WRITE));
        }

        public boolean can(Mode mode) {
            switch (mode) {
                case DISCOVER: {
                    return this.canDiscover();
                }
                case READ: {
                    return this.canRead();
                }
                case WRITE: {
                    return this.canWrite();
                }
                case RUN: {
                    return this.canRun();
                }
            }
            throw new IllegalStateException("Unknown authorization mode");
        }

        private void makeDiscoverableIfPossible() {
            if (this.objectRef.objectType == ITaggingService.TaggableType.DATASET) {
                this.modes.add(Mode.DISCOVER);
            }
        }

        public void makeReadable() {
            this.modes.add(Mode.READ);
            this.makeDiscoverableIfPossible();
        }

        public static enum Mode {
            READ,
            RUN,
            WRITE,
            DISCOVER;

        }
    }

    public static class FlowDisplaySettings {
        public ZonesGraphRenderingAlgorithm zonesGraphRenderingAlgorithm = ZonesGraphRenderingAlgorithm.DOT_OLDRANK;
        public boolean zonesGraphConnectZones = true;
        public boolean zonesGraphForJobs = true;
        public boolean respectTraversalOrder;
        public boolean zonesManualPositioning = false;

        public static enum ZonesGraphRenderingAlgorithm {
            DOT_OLDRANK,
            DOT_NEWRANK_FREERANK;

        }
    }

    public static class ProjectWikiSettings {
        public boolean promoted;
    }

    public static class ProjectRelocationSettings {
        public SQLLikeRecipeInitializationMode sqlLikeRecipesInitializationMode = SQLLikeRecipeInitializationMode.RESOLVED_TABLE_REFERENCES;
    }

    public static enum SQLLikeRecipeInitializationMode {
        RESOLVED_TABLE_REFERENCES,
        VARIABILIZED_TABLE_REFERENCES,
        DATASET_REFERENCES;

    }

    public static class ProjectImpalaEngineCreationSettings {
        public boolean useGlobal = true;
        public boolean streamMode = true;
    }

    public static class ProjectSparkEngineCreationSettings {
        public boolean useGlobal = true;
        public String executionConfig;
        public AbstractSparkRecipeParams.SparkExecutionEngine executionEngine = AbstractSparkRecipeParams.SparkExecutionEngine.SPARK_SUBMIT;
        public boolean useGlobalMetastore;
    }

    public static class ProjectHiveEngineCreationSettings {
        public boolean useGlobal = true;
        public HiveRecipeMeta.HiveExecutionEngine executionEngine = HiveRecipeMeta.HiveExecutionEngine.HIVECLI_LOCAL;
        public String executionConfig;
    }

    public static class LimitsSettings {
        public GeneralSettingsDAO.SoftHardLimit memSampleBytes = new GeneralSettingsDAO.SoftHardLimit();
        public GeneralSettingsDAO.SoftHardLimit shakerMemTableBytes = new GeneralSettingsDAO.SoftHardLimit();
        public GeneralSettingsDAO.SoftHardLimit attachmentBytes = new GeneralSettingsDAO.SoftHardLimit();
        public GeneralSettingsDAO.SoftHardLimit sqlNotebookResultSetBytes = new GeneralSettingsDAO.SoftHardLimit();
        public GeneralSettingsDAO.SoftHardLimit sqlScenarioResultSetBytes = new GeneralSettingsDAO.SoftHardLimit();
    }

    public static class FlowBuildSettings {
        public boolean mergeSparkPipelines = false;
        public boolean pruneBeforeSparkPipelines = true;
        public boolean mergeSqlPipelines = false;
        public boolean pruneBeforeSqlPipelines = true;
        public SerializedRecipe.RecipeHashPropagationBehavior defaultRecipeHashPropagationBehavior = SerializedRecipe.RecipeHashPropagationBehavior.ENABLED;
    }

    public static class IntegrationsSettings {
        public List<ProjectIntegration> integrations = new ArrayList<ProjectIntegration>();
    }

    public static class ProjectIntegration {
        public boolean active;
        public IntegrationHook hook;
    }

    public static class MessagingLikeProjectIntegrationSelection {
        public boolean discussions = true;
        public boolean timelineItemsExceptEditions = true;
        public boolean timelineEditionItems = true;
        public boolean scenarioStarts = true;
        public boolean scenarioEnds = true;
        public boolean watchStar = true;
        public boolean jobStarts;
        public boolean jobEnds;
        public boolean mlStarts;
        public boolean mlEnds;
        public boolean commits = false;

        public boolean shouldSend(DSSEvent event) {
            if (event instanceof MLTaskStateChangedEvent) {
                MLTaskStateChangedEvent mevent = (MLTaskStateChangedEvent)event;
                return mevent.isRunning && this.mlStarts || !mevent.isRunning && this.mlEnds;
            }
            if (event instanceof TimelineItemEvent) {
                TimelineItemEvent tie = (TimelineItemEvent)event;
                return tie.item.action.isEdition() && this.timelineEditionItems || !tie.item.action.isEdition() && this.timelineItemsExceptEditions;
            }
            if (event instanceof JobStateChangedEvent) {
                JobStateChangedEvent jsce = (JobStateChangedEvent)event;
                if (jsce.state.isNotReallyStarted()) {
                    return false;
                }
                return jsce.state.isFinished() && this.jobEnds || !jsce.state.isFinished() && this.jobStarts;
            }
            if (event instanceof ScenarioStateChangeEvent) {
                ScenarioStateChangeEvent ssce = (ScenarioStateChangeEvent)event;
                return ssce.state == ScenarioStateChangeEvent.State.RUNNING && this.scenarioStarts || ssce.state != ScenarioStateChangeEvent.State.RUNNING && this.scenarioEnds;
            }
            if (event instanceof InterestChangedEvent) {
                return this.watchStar;
            }
            if (event instanceof CommitEvent) {
                return this.commits;
            }
            if (event instanceof DiscussionReplyEvent || event instanceof DiscussionClosedEvent || event instanceof DiscussionDeletedEvent) {
                return this.discussions;
            }
            return false;
        }
    }
}

