/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao.impl;

import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.dao.ModelEvaluationComparatorsDAO;
import com.dataiku.dip.mec.ModelComparison;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ObjectUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedModelComparisonsDAO
extends AbstractStandardDAO<ModelComparison>
implements ModelEvaluationComparatorsDAO {
    @Override
    protected ModelComparison getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile rf;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isFile(rf = this.getDAOFile(projectKey, id))) {
            return null;
        }
        ModelComparison modelComparison = unsafe ? (ModelComparison)tr.readObjectUnsafe(rf, ModelComparison.class) : (ModelComparison)tr.readObject(rf, ModelComparison.class);
        if (modelComparison != null) {
            modelComparison.id = id;
            modelComparison.projectKey = projectKey;
            if (CollectionUtils.isNotEmpty(modelComparison.comparedModels)) {
                List comparedModelsWithNonNullRefs = modelComparison.comparedModels.stream().filter(cm -> null != cm.smartId).collect(Collectors.toList());
                int nullRefComparedModels = modelComparison.comparedModels.size() - comparedModelsWithNonNullRefs.size();
                if (0 != nullRefComparedModels) {
                    this.logger.error((Object)(nullRefComparedModels + " compared model(s) have a null reference and will be filtered. Names: " + StringUtils.join((Collection)modelComparison.comparedModels.stream().filter(cm -> null == cm.smartId).collect(Collectors.toList()), (String)",")));
                }
                modelComparison.comparedModels = comparedModelsWithNonNullRefs.stream().map(cm -> {
                    cm.refId = ModelLikeId.parse(cm.smartId, projectKey).toString();
                    return cm;
                }).collect(Collectors.toList());
            }
        }
        return modelComparison;
    }

    @Override
    protected List<ModelComparison> list_noTag(String projectKey, boolean unsafe) throws IOException {
        RelFile folder = this.modelComparisonsFolder(projectKey);
        TransactionRef tr = TransactionContext.retrieveRead();
        ArrayList<ModelComparison> ret = new ArrayList<ModelComparison>();
        if (tr.isDirectory(folder)) {
            for (RelFile f : tr.listFiles(folder)) {
                try {
                    String id = StringUtils.removeEnd((String)f.getLeafName(), (String)".json");
                    ModelComparison sr = (ModelComparison)this.getMandatory(projectKey, id, unsafe);
                    ret.add(sr);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to read model evaluation store file: " + String.valueOf(f)), (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Model evaluation store id is not specified");
        return new RelFile(this.modelComparisonsFolder(projectKey), new String[]{id + ".json"});
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.MODEL_COMPARISON.toHumanReadableString();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteFile(this.getDAOFile(projectKey, id));
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile folder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(folder = this.modelComparisonsFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(folder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    public void save(ModelComparison modelComparison) throws IOException {
        ModelComparison mecCopy = (ModelComparison)ObjectUtils.shallowCopy((Object)modelComparison);
        if (CollectionUtils.isNotEmpty(mecCopy.comparedModels)) {
            mecCopy.comparedModels = mecCopy.comparedModels.stream().map(cm -> {
                ModelComparison.ComparedModel cmCopy = (ModelComparison.ComparedModel)ObjectUtils.shallowCopy((Object)cm);
                if (null == cm.refId) {
                    throw new Error("A model compared in " + modelComparison.getRef().id + " has an empty refId");
                }
                cmCopy.smartId = ModelLikeId.parse(cm.refId, modelComparison.projectKey).toSmartModelLikeId(modelComparison.projectKey);
                return cmCopy;
            }).collect(Collectors.toList());
        }
        super.save(mecCopy);
    }

    private RelFile modelComparisonsFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "model_comparisons"});
    }
}

