/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.dao.HashesModel;
import com.dataiku.dip.dataflow.graph.ComputableWithPartition;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public abstract class RunnableSubgraph {
    public List<HashesModel.PropagatedHashInfo> hashToPropagate = new ArrayList<HashesModel.PropagatedHashInfo>();
    private Map<String, Partition> targetPartitions = new HashMap<String, Partition>();
    private Map<String, List<Partition>> sourcePartitions = new HashMap<String, List<Partition>>();

    public Map<String, Partition> getTargetPartitions() {
        return this.targetPartitions;
    }

    public void setTargetPartitions(Map<String, Partition> targetPartitions) {
        this.targetPartitions = targetPartitions;
    }

    public Map<String, List<Partition>> getSourcePartitions() {
        return this.sourcePartitions;
    }

    public void setSourcePartitions(Map<String, List<Partition>> sourcePartitions) {
        this.sourcePartitions = sourcePartitions;
    }

    public List<ComputableWithPartition> getAllSources() {
        ArrayList<ComputableWithPartition> ret = new ArrayList<ComputableWithPartition>();
        for (FlowComputable flowComputable : this.getSources()) {
            for (Partition p : this.getSourcePartitions(flowComputable)) {
                ComputableWithPartition cwp = new ComputableWithPartition();
                cwp.computable = flowComputable;
                cwp.partition = p;
                ret.add(cwp);
            }
        }
        return ret;
    }

    public List<ComputableWithPartition> getAllTargets() {
        ArrayList<ComputableWithPartition> ret = new ArrayList<ComputableWithPartition>();
        for (FlowComputable flowComputable : this.getTargets()) {
            Partition p = this.getTargetPartition(flowComputable);
            ComputableWithPartition cwp = new ComputableWithPartition();
            cwp.computable = flowComputable;
            cwp.partition = p;
            ret.add(cwp);
        }
        return ret;
    }

    public List<Partition> getSourcePartitions(FlowComputable source) {
        if (!source.isPartitionable()) {
            return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
        }
        ArrayList ret = this.sourcePartitions.get(source.getFullId());
        if (ret == null) {
            ret = Lists.newArrayList();
        }
        return ret;
    }

    public Partition getTargetPartition(FlowComputable target) {
        if (!target.isPartitionable()) {
            return new Partition(null);
        }
        return this.targetPartitions.get(target.getFullId());
    }

    public void testOnlySetTargetPartition(FlowDataset ds, Partition part) {
        this.targetPartitions.put(ds.getFullName(), part);
    }

    public void testOnlyAddSourcePartition(FlowDataset ds, Partition part) {
        List<Partition> list = this.sourcePartitions.get(ds.getFullName());
        if (list == null) {
            list = new ArrayList<Partition>();
            this.sourcePartitions.put(ds.getFullName(), list);
        }
        list.add(part);
    }

    public void addSourcePartitionIfNotPresent_ForTestsOnly(FlowComputable fc, Partition p) {
        if (!this.getSources().contains(fc)) {
            this.addSource_NoRole(fc);
        }
        if (!this.getSourcePartitions(fc).contains(p)) {
            List<Partition> list = this.sourcePartitions.get(fc.getFullId());
            if (list == null) {
                list = new ArrayList<Partition>();
                this.sourcePartitions.put(fc.getFullId(), list);
            }
            list.add(p);
        }
    }

    public void addTargetPartitionIfNotPresent_ForTestsOnly(FlowComputable fc, Partition p) {
        if (!this.getTargets().contains(fc)) {
            this.addTarget_NoRole(fc);
        }
        this.getTargetPartitions().put(fc.getFullId(), p);
    }

    public abstract boolean isAllTargetPartitions();

    public abstract Map<String, FlowComputable> getSourcesMap();

    public abstract Map<String, FlowComputable> getTargetsMap();

    public abstract List<? extends FlowComputable> getSources();

    public abstract List<? extends FlowComputable> getTargets();

    public abstract List<FlowComputable.FlowComputableWithRole> getSourcesWithRoles();

    public abstract List<FlowComputable.FlowComputableWithRole> getTargetsWithRoles();

    public abstract void addSource_NoRole(FlowComputable var1);

    public abstract void addTarget_NoRole(FlowComputable var1);

    public FlowDataset getSingleSourceDataset() {
        if (this.getSourceDatasets().size() != 1) {
            throw ErrorContext.iae((String)("Expected exactly one source dataset, got " + StringUtils.join(this.getSourceDatasets(), (String)",")));
        }
        return this.getSourceDatasets().get(0);
    }

    public FlowDataset getSingleTargetDataset() {
        if (this.getTargetsDatasets().size() != 1) {
            throw ErrorContext.iae((String)("Expected exactly one target dataset, got " + this.getTargetsDatasets().size()));
        }
        return this.getTargetsDatasets().get(0);
    }

    public FlowDataset getSourceDataset(String id) {
        FlowComputable source = this.getSourcesMap().get(id);
        if (!(source instanceof FlowDataset)) {
            throw ErrorContext.iaef((String)"Source %s is not a dataset", (Object)id, (Object[])new Object[0]);
        }
        return (FlowDataset)source;
    }

    public FlowDataset getTargetDataset(String id) {
        FlowComputable target = this.getTargetsMap().get(id);
        if (!(target instanceof FlowDataset)) {
            throw ErrorContext.iaef((String)"Target %s is not a dataset", (Object)id, (Object[])new Object[0]);
        }
        return (FlowDataset)target;
    }

    public List<FlowDataset> getSourceDatasets() {
        ArrayList<FlowDataset> datasets = new ArrayList<FlowDataset>();
        for (FlowComputable flowComputable : this.getSources()) {
            if (!(flowComputable instanceof FlowDataset)) continue;
            datasets.add((FlowDataset)flowComputable);
        }
        return datasets;
    }

    public List<FlowDataset> getTargetsDatasets() {
        ArrayList<FlowDataset> datasets = new ArrayList<FlowDataset>();
        for (FlowComputable flowComputable : this.getTargets()) {
            if (!(flowComputable instanceof FlowDataset)) continue;
            datasets.add((FlowDataset)flowComputable);
        }
        return datasets;
    }

    public List<FlowPartitionable> getPartitionedSources() {
        ArrayList<FlowPartitionable> partitioneds = new ArrayList<FlowPartitionable>();
        for (FlowComputable flowComputable : this.getSources()) {
            if (!(flowComputable instanceof FlowPartitionable)) continue;
            partitioneds.add((FlowPartitionable)((Object)flowComputable));
        }
        return partitioneds;
    }

    public List<FlowPartitionable> getPartitionedTargets() {
        ArrayList<FlowPartitionable> partitioneds = new ArrayList<FlowPartitionable>();
        for (FlowComputable flowComputable : this.getTargets()) {
            if (!(flowComputable instanceof FlowPartitionable)) continue;
            partitioneds.add((FlowPartitionable)((Object)flowComputable));
        }
        return partitioneds;
    }

    public abstract List<FlowRecipe> listRecipes();

    public abstract String getName();

    public String id() {
        if (this.getTargets().isEmpty()) {
            return this.getName();
        }
        TreeSet orderedPartitionIds = Sets.newTreeSet();
        for (Map.Entry<String, Partition> e : this.getTargetPartitions().entrySet()) {
            orderedPartitionIds.add(RunnableSubgraph.makePathSafePartitionValue(e.getValue().id()));
        }
        return this.getName() + "_" + Joiner.on((String)"_").join((Iterable)orderedPartitionIds);
    }

    public static String makePathSafePartitionValue(String partitionValue) {
        partitionValue = partitionValue.replace("|", "__");
        partitionValue = partitionValue.replaceAll("[^a-zA-Z0-9_.,-]", "_");
        return partitionValue;
    }

    public static class JsonifiableRunnableSubgraph {
        public List<HashesModel.PropagatedHashInfo> hashToPropagate = new ArrayList<HashesModel.PropagatedHashInfo>();
        public Map<String, PartitioningScheme> partitioningSchemes = new HashMap<String, PartitioningScheme>();
        public Map<String, String> targetPartitions = new HashMap<String, String>();
        public Map<String, List<String>> sourcePartitions = new HashMap<String, List<String>>();

        public void fromNative(RunnableSubgraph subgraph) {
            String objectId;
            this.hashToPropagate = Lists.newArrayList(subgraph.hashToPropagate);
            for (Map.Entry<String, Partition> entry : subgraph.targetPartitions.entrySet()) {
                objectId = entry.getKey();
                Partition partition = entry.getValue();
                this.partitioningSchemes.put(objectId, partition.getScheme());
                this.targetPartitions.put(objectId, partition.id());
            }
            for (Map.Entry<String, Object> entry : subgraph.sourcePartitions.entrySet()) {
                objectId = entry.getKey();
                this.sourcePartitions.put(objectId, Lists.newArrayList());
                for (Partition partition : (List)entry.getValue()) {
                    this.partitioningSchemes.put(objectId, partition.getScheme());
                    this.sourcePartitions.get(objectId).add(partition.id());
                }
            }
        }

        private Partition fromPartitionId(String objectId, String partitionId) {
            if ("ALL".equals(partitionId)) {
                return Partition.newALL((PartitioningScheme)this.partitioningSchemes.get(objectId));
            }
            if ("NP".equals(partitionId)) {
                return Partition.newNP();
            }
            return PartitionFactory.fromIdentifier(this.partitioningSchemes.get(objectId), partitionId);
        }

        public void toNative(RunnableSubgraph subgraph) {
            String objectId;
            subgraph.hashToPropagate = Lists.newArrayList(this.hashToPropagate);
            subgraph.targetPartitions = Maps.newHashMap();
            subgraph.sourcePartitions = Maps.newHashMap();
            for (Map.Entry<String, String> entry : this.targetPartitions.entrySet()) {
                objectId = entry.getKey();
                String partitionId = entry.getValue();
                subgraph.targetPartitions.put(objectId, this.fromPartitionId(objectId, partitionId));
            }
            for (Map.Entry<String, Object> entry : this.sourcePartitions.entrySet()) {
                objectId = entry.getKey();
                subgraph.sourcePartitions.put(objectId, Lists.newArrayList());
                for (String partitionId : (List)entry.getValue()) {
                    subgraph.sourcePartitions.get(objectId).add(this.fromPartitionId(objectId, partitionId));
                }
            }
        }
    }
}

