/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.h2;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.MiscCodes;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.exec.Initializable;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.h2.DatasetToH2Loader;
import com.dataiku.dip.dataflow.exec.h2.H2DB;
import com.dataiku.dip.dataflow.exec.h2.H2TemporarySQLConfig;
import com.dataiku.dip.dataflow.exec.h2.H2dbFactory;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datalayer.utils.FilterProcessorOutput;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class H2RecipeRunner
implements AbortableRecipeRunner,
Initializable {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private H2dbFactory h2dbFactory;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.h2");
    private static final long DEFAULT_DIRECTORY_SIZE_POLL_INTERVAL_SECONDS = 10L;
    private static final int DEFAULT_DIRECTORY_MAX_SIZE_MB = 20000;
    private final JobActivity activity;
    private final DatasetsDAO datasetsDAO;
    private final RecipeRunnableSubgraph subgraph;
    private final FlowRecipe recipe;
    boolean runTerminated;
    private volatile boolean abortNotified;
    private DirectorySizeMonitorThread directorySizeMonitorThread;
    private Statement runningStatement;
    private final DatasetToH2Loader h2Loader;
    List<StreamableDatasetSelection> preSelections;
    List<List<String>> requiredColumnsForAllInputs;
    List<List<JoinRecipeHelper.SimpleVirtualColumn>> virtualColumnsForAllInputs;
    FilterDesc postFilter;
    String sqlQuery;
    Output.WriteMode writeMode;

    public H2RecipeRunner(JobActivity activity, DatasetsDAO datasetsDAO, StreamableDatasetSelection preSelection, FilterDesc postFilter) throws Exception {
        this(activity, datasetsDAO, Lists.newArrayList((Object[])new StreamableDatasetSelection[]{preSelection}), postFilter);
    }

    public H2RecipeRunner(JobActivity activity, DatasetsDAO datasetsDAO, List<StreamableDatasetSelection> preSelections, FilterDesc postFilter) throws Exception {
        SpringUtils.getInstance().autowire((Object)this);
        this.activity = (JobActivity)Preconditions.checkNotNull((Object)activity);
        this.datasetsDAO = (DatasetsDAO)Preconditions.checkNotNull((Object)datasetsDAO);
        this.preSelections = preSelections;
        this.postFilter = postFilter;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
        Validate.notNull((Object)this.recipe.getModel().projectKey);
        this.h2Loader = new DatasetToH2Loader(this.authCtxService.getAuthCtx(), activity.warnContext, this.recipe.getProjectKey(), this.h2dbFactory.createFor(this.recipe.getProjectKey()));
    }

    public void setRequiredColumns(List<List<String>> requiredColumns) {
        this.requiredColumnsForAllInputs = requiredColumns;
    }

    public void setVirtualColumns(List<List<JoinRecipeHelper.SimpleVirtualColumn>> virtualColumns) {
        this.virtualColumnsForAllInputs = virtualColumns;
    }

    protected abstract String getSql(H2DB var1, JobActivity var2) throws Exception;

    protected void onPreQuery(H2DB dth, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, JobActivity activity) throws Exception {
    }

    @Override
    public void init() throws Exception {
        logger.info((Object)"Init H2 recipe runner");
        FlowDataset fd = this.subgraph.getSingleTargetDataset();
        Dataset ds = fd.getMandatory(this.datasetsDAO);
        try (DatasetHandler dh = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), ds);){
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(fd.getFullName());
            SerializedRecipe.RecipeOutput recipeOutput = this.subgraph.getRecipe().getModel().getOutputAnyRole(loc.getSmartName(this.recipe.getProjectKey()));
            this.writeMode = recipeOutput.getWriteMode();
            logger.info((Object)("Write mode : " + String.valueOf(this.writeMode)));
            if (this.writeMode == Output.WriteMode.OVERWRITE && dh.getMeta().isFSLike()) {
                if (!dh.outputHandlesClear()) {
                    dh.clearPartitions(Lists.newArrayList((Object[])new Partition[]{this.activity.getSubgraph().getTargetPartition(fd)}));
                }
                this.writeMode = Output.WriteMode.APPEND;
                logger.info((Object)("Cleared FS dataset. Write mode : " + String.valueOf(this.writeMode)));
            }
        }
        ArrayList<File> directoriesToMonitor = new ArrayList<File>();
        directoriesToMonitor.add(FlowJobUtils.getCurrentJobActivityFolder());
        String tempDirectory = System.getProperty("java.io.tmpdir");
        if (StringUtils.isNotBlank((String)tempDirectory)) {
            directoriesToMonitor.add(new File(tempDirectory));
        }
        long pollIntervalSeconds = DKUApp.getParams().getLongParam("dku.recipes.visual.h2based.directorySize.pollIntervalSeconds", 10L);
        int directoryMaxSizeMB = DKUApp.getParams().getIntParam("dku.recipes.visual.h2based.directorySize.maxMB", Integer.valueOf(20000));
        this.directorySizeMonitorThread = new DirectorySizeMonitorThread(directoriesToMonitor, directoryMaxSizeMB, pollIntervalSeconds, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        try {
            this.directorySizeMonitorThread.start();
            try (H2DB h2db = this.h2Loader.h2db;){
                Object config;
                this.activity.setStatusMessage("Setting temporary database");
                List<FlowDataset> sources = this.activity.getSubgraph().getSourceDatasets();
                for (int i = 0; i < sources.size(); ++i) {
                    FlowDataset fd = sources.get(i);
                    StreamableDatasetSelection sel = StreamableDatasetSelection.full();
                    if (this.preSelections != null) {
                        sel = this.preSelections.get(i);
                    }
                    Dataset source = fd.getMandatory(this.datasetsDAO);
                    List<String> requiredColumns = null;
                    if (this.requiredColumnsForAllInputs != null) {
                        requiredColumns = this.requiredColumnsForAllInputs.get(i);
                    }
                    List<JoinRecipeHelper.SimpleVirtualColumn> virtualColumns = null;
                    if (this.virtualColumnsForAllInputs != null) {
                        virtualColumns = this.virtualColumnsForAllInputs.get(i);
                    }
                    this.h2Loader.load(source, sel, source.getFullName(), requiredColumns, virtualColumns);
                }
                Dataset outputDataset = this.activity.getSubgraph().getSingleTargetDataset().getMandatory(this.datasetsDAO);
                Partition targetPartition = this.activity.getSubgraph().getTargetPartition(this.activity.getSubgraph().getSingleTargetDataset());
                DateTimeZone assumedTz = DateTimeZone.UTC;
                if (DatasetInspector.isSQL(outputDataset)) {
                    String timezone_id = outputDataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(outputDataset.getProjectKey()).getAssumedJavaTzForUnknownTz();
                    assumedTz = timezone_id != null && timezone_id.length() > 0 ? DateTimeZone.forID((String)timezone_id) : DateTimeZone.getDefault();
                }
                try (DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), outputDataset);){
                    SerializedRecipe.RecipeOutput recipeOutput = this.subgraph.getRecipe().getModel().getSingleOutput("main");
                    Output.WriteMode writeMode = recipeOutput.getWriteMode();
                    if (writeMode == Output.WriteMode.OVERWRITE && !outputDatasetHandler.outputHandlesClear()) {
                        if (outputDatasetHandler.getMeta().isFSLike()) {
                            outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{targetPartition}));
                        }
                        writeMode = Output.WriteMode.APPEND;
                    }
                }
                logger.info((Object)"Opening writer");
                StreamColumnFactory cf = new StreamColumnFactory();
                StreamRowFactory rf = new StreamRowFactory();
                ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing(this.authCtxService.getAuthCtx(), outputDataset, targetPartition, (ColumnFactory)cf, this.activity.warnContext, this.writeMode);
                Object out = streamer.getAsOutput();
                if (this.postFilter != null && FilterDescUtils.willFilter(this.postFilter)) {
                    out = new FilterProcessorOutput((ProcessorOutput)out, (ColumnFactory)cf, this.postFilter, outputDataset.getSchema());
                }
                logger.info((Object)"Opening reader");
                SQLConnectionProvider.SQLConnectionData connData = h2db.getConnData();
                SQLConnectionProvider.SQLConnectionWrapper conn = h2db.getConn();
                SerializedRecipe sr = new SerializedRecipe();
                sr.projectKey = this.recipe.getModel().projectKey;
                sr.type = this.subgraph.getRecipe().getModel().type;
                FlowRecipe fr = new FlowRecipe(sr);
                for (FlowDataset dataset : sources) {
                    Dataset source = dataset.getMandatory(this.datasetsDAO);
                    Dataset fakeSource = new Dataset();
                    config = new H2TemporarySQLConfig();
                    ((AbstractSQLDatasetHandler.AbstractSQLConfig)config).table = source.getFullName();
                    fakeSource.setParams((DatasetHandler.DatasetParams)config);
                    fakeSource.setFullName(source.getFullName());
                    fakeSource.setSchema(source.getSchema());
                    fr.addPredecessor(new FlowDataset(fakeSource), null);
                }
                fr.addSuccessor(this.activity.getSubgraph().getSingleTargetDataset(), null);
                JobActivity fakeActivity = new JobActivity(new RecipeRunnableSubgraph(fr));
                this.sqlQuery = this.getSql(h2db, fakeActivity);
                if (this.sqlQuery == null) {
                    throw new Error("Could not find SQL query for " + this.recipe.getName());
                }
                this.onPreQuery(h2db, connData, conn, fakeActivity);
                ExecutionPlanService eps = new ExecutionPlanService();
                ExecutionPlanService.ExecutionPlan plan = eps.getExecutionPlan(conn, connData, this.sqlQuery);
                logger.info((Object)("Execution plan is\n" + String.valueOf(plan)));
                try (Statement stmt = SQLUtils.getProperlyStreamableStatement(connData, conn);){
                    this.activity.setStatusMessage("Running recipe");
                    config = this;
                    synchronized (config) {
                        if (this.abortNotified) {
                            throw new ActivityAbortedException();
                        }
                        this.runningStatement = stmt;
                    }
                    logger.info((Object)"Execute statement: ");
                    logger.info((Object)this.sqlQuery);
                    stmt.execute(this.sqlQuery);
                    config = this;
                    synchronized (config) {
                        this.runningStatement = null;
                        this.directorySizeMonitorThread.disable();
                        if (this.abortNotified) {
                            throw new ActivityAbortedException();
                        }
                    }
                    ResultSet rs2 = stmt.getResultSet();
                    ResultSetMetaData meta = rs2.getMetaData();
                    ArrayList<Column> columns = new ArrayList<Column>();
                    ArrayList<SchemaColumn> schemaColumns = new ArrayList<SchemaColumn>();
                    for (SchemaColumn sc : outputDataset.getSchema().columns) {
                        columns.add(cf.column(sc.getName()));
                        schemaColumns.add(new SchemaColumn(sc).withTimestampNoTzAsDate(sc.timestampNoTzAsDate && !outputDataset.isManaged()));
                    }
                    if (meta.getColumnCount() > schemaColumns.size()) {
                        throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCOMPATIBLE_SCHEMA, String.format("Expected %s columns but output schema contains %s. Try to propagate the schema of the input(s) dataset(s) first.", meta.getColumnCount(), schemaColumns.size()));
                    }
                    this.activity.setStatusMessage("Emitting rows");
                    logger.info((Object)("Starting to emit rows with " + columns.size() + " columns: " + String.valueOf(columns)));
                    int rows = 0;
                    while (rs2.next()) {
                        if (this.abortNotified) {
                            throw new ActivityAbortedException();
                        }
                        Row r = rf.row();
                        for (int i = 1; i <= meta.getColumnCount(); ++i) {
                            String v = connData.getDialect().getValueAsDSSString(rs2, meta.getColumnType(i), i, (SchemaColumn)schemaColumns.get(i - 1), true, ((SchemaColumn)schemaColumns.get((int)(i - 1))).timestampNoTzAsDate, assumedTz);
                            r.put((Column)columns.get(i - 1), v);
                        }
                        out.emitRow(r);
                        if (++rows % 10000 != 0) continue;
                        logger.infoV("Emitted %d rows", new Object[]{rows});
                    }
                    out.lastRowEmitted();
                }
                catch (RuntimeException e) {
                    logger.error((Object)"Query failed", (Throwable)e);
                    throw e;
                }
            }
        }
        catch (Exception e) {
            if (this.abortNotified) {
                this.directorySizeMonitorThread.check(e);
            }
            if (this.findCauseMatching(e, cause -> cause instanceof IOException && cause.getMessage() != null && cause.getMessage().contains("No space left on device"))) {
                throw new CodedIOException((InfoMessage.MessageCode)MiscCodes.ERR_MISC_ENOSPC, "Running recipe filled up disk space.");
            }
            throw e;
        }
        finally {
            H2RecipeRunner h2RecipeRunner = this;
            synchronized (h2RecipeRunner) {
                this.runTerminated = true;
                this.notifyAll();
            }
        }
    }

    private boolean findCauseMatching(Throwable cause, Function<Throwable, Boolean> predicate) {
        assert (cause != null);
        Throwable currentCause = cause;
        boolean causeMatchesPredicate = predicate.apply(currentCause);
        while (currentCause != null && !causeMatchesPredicate) {
            currentCause = currentCause.getCause();
            try {
                causeMatchesPredicate = predicate.apply(currentCause);
            }
            catch (Exception exception) {}
        }
        return causeMatchesPredicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyBeforeAborting() {
        DatasetToH2Loader h2LoaderToKill;
        Statement statementToKill;
        H2RecipeRunner h2RecipeRunner = this;
        synchronized (h2RecipeRunner) {
            if (this.abortNotified) {
                return;
            }
            this.abortNotified = true;
            statementToKill = this.runningStatement;
            h2LoaderToKill = this.h2Loader;
        }
        if (statementToKill != null) {
            try {
                statementToKill.cancel();
            }
            catch (SQLException e) {
                logger.error((Object)"Unable to cancel statement");
            }
        }
        if (h2LoaderToKill != null) {
            h2LoaderToKill.notifyAbort();
        }
        h2RecipeRunner = this;
        synchronized (h2RecipeRunner) {
            long start = System.currentTimeMillis();
            while (!this.runTerminated) {
                long end = System.currentTimeMillis();
                if (end - start > 15000L) {
                    if (this.directorySizeMonitorThread.exceededSize > 0L) {
                        if (h2LoaderToKill != null) {
                            try {
                                h2LoaderToKill.h2db.shutdown();
                            }
                            catch (DKUSecurityException | InterruptedException | SQLException e) {
                                logger.error((Object)e);
                            }
                        }
                    } else {
                        logger.error((Object)"The H2 runner cannot be properly stopped. It'll be killed abruptly with the JEK.");
                    }
                    return;
                }
                logger.info((Object)"Waiting for the H2 runner to terminate...");
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            logger.info((Object)"H2 runner terminated!");
        }
    }

    @VisibleForTesting
    static class DirectorySizeMonitorThread
    extends Thread {
        private final List<File> directoriesToMonitor;
        private final long maxSizeInBytes;
        private final long pollIntervalInMs;
        private final AbortableRecipeRunner abortableRecipeRunner;
        private final AtomicBoolean enabled = new AtomicBoolean(false);
        private long exceededSize = 0L;

        public DirectorySizeMonitorThread(List<File> directoriesToMonitor, int maxSizeInMB, long pollIntervalInSeconds, AbortableRecipeRunner abortableRecipeRunner) {
            this.directoriesToMonitor = directoriesToMonitor.stream().filter(Objects::nonNull).collect(Collectors.toList());
            this.maxSizeInBytes = (long)maxSizeInMB * 1024L * 1024L;
            this.pollIntervalInMs = pollIntervalInSeconds * 1000L;
            this.abortableRecipeRunner = abortableRecipeRunner;
        }

        @Override
        public void run() {
            if (this.maxSizeInBytes <= 0L || this.pollIntervalInMs <= 0L) {
                logger.info((Object)"Max size or polling interval not greater than 0, not monitoring activity directory size");
                return;
            }
            if (this.directoriesToMonitor.isEmpty()) {
                logger.warn((Object)"No directories to monitor, monitor thread exiting");
                return;
            }
            String directoryNames = this.getDirectoryNames();
            this.enabled.set(true);
            logger.infoV("Start monitoring size of directories: %s, max size %d bytes, polling interval %d milliseconds", new Object[]{directoryNames, this.maxSizeInBytes, this.pollIntervalInMs});
            while (this.enabled.get()) {
                try {
                    long size = this.directoriesToMonitor.stream().mapToLong(FileUtils::sizeOfDirectory).sum();
                    if (size > this.maxSizeInBytes && this.enabled.get()) {
                        this.exceededSize = size;
                        logger.errorV("Directory(s) '%s' size over threshold, aborting activity: %d bytes (threshold is %d bytes)", new Object[]{directoryNames, this.exceededSize, this.maxSizeInBytes});
                        this.disable();
                        this.abortableRecipeRunner.notifyBeforeAborting();
                        return;
                    }
                    logger.info((Object)("Directory size monitoring: " + directoryNames + " has " + size + "B"));
                    Thread.sleep(this.pollIntervalInMs);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)("Directory size monitoring interrupted: " + directoryNames));
                    this.disable();
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    logger.warn((Object)("Directory size monitoring error: " + directoryNames), (Throwable)e);
                }
            }
        }

        private String getDirectoryNames() {
            return this.directoriesToMonitor.stream().map(File::toString).collect(Collectors.joining(", "));
        }

        public void disable() {
            this.enabled.set(false);
        }

        public void check(Exception e) {
            if (this.exceededSize > 0L) {
                logger.warn((Object)"Job directory max size overrun likely caused recipe runner to exit early, logging original exception", (Throwable)e);
                String message = String.format("%s: job activity directory(s) '%s' size over threshold, activity aborted: %d bytes (threshold is %d bytes)", new Object[]{RecipeCodes.ERR_ACTIVITY_DIRECTORY_SIZE_LIMIT_REACHED, this.getDirectoryNames(), this.exceededSize, this.maxSizeInBytes});
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_ACTIVITY_DIRECTORY_SIZE_LIMIT_REACHED, message);
            }
        }
    }
}

