/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.joinlike;

import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.ConditionsMode;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.dataflow.exec.joinlike.MatchingConditionBase;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.List;

public abstract class JoinDescBase<M extends MatchingConditionBase> {
    public int table1;
    public int table2;
    public JoinType type = JoinType.LEFT;
    public ConditionsMode conditionsMode = ConditionsMode.AND;
    public List<M> on = new ArrayList<M>();

    public QueryAst.JoinType sqlType(JoinOutputRole role) {
        switch (role) {
            case MAIN: {
                return this.mainSqlType();
            }
            case UNMATCHED_ROWS_LEFT: {
                return QueryAst.JoinType.LEFT;
            }
            case UNMATCHED_ROWS_RIGHT: {
                return QueryAst.JoinType.RIGHT;
            }
        }
        throw ErrorContext.iae((String)("Invalid join output role: " + String.valueOf((Object)role)));
    }

    private QueryAst.JoinType mainSqlType() {
        if (this.conditionsMode != ConditionsMode.NATURAL) {
            switch (this.type) {
                case INNER: {
                    return QueryAst.JoinType.INNER;
                }
                case LEFT_ANTI: 
                case LEFT: {
                    return QueryAst.JoinType.LEFT;
                }
                case RIGHT_ANTI: 
                case RIGHT: {
                    return QueryAst.JoinType.RIGHT;
                }
                case CROSS: {
                    return QueryAst.JoinType.CROSS;
                }
                case FULL: {
                    return QueryAst.JoinType.FULL;
                }
            }
        } else {
            switch (this.type) {
                case INNER: {
                    return QueryAst.JoinType.NATURAL_INNER;
                }
                case LEFT: {
                    return QueryAst.JoinType.NATURAL_LEFT;
                }
                case RIGHT: {
                    return QueryAst.JoinType.NATURAL_RIGHT;
                }
                case CROSS: {
                    return QueryAst.JoinType.CROSS;
                }
                case FULL: {
                    return QueryAst.JoinType.NATURAL_FULL;
                }
            }
        }
        throw ErrorContext.iae((String)("Invalid join type: " + String.valueOf((Object)this.type)));
    }

    public boolean hasImplicitOrExplicitRightLimit() {
        return false;
    }

    public JoinRecipePayloadParams.RightLimitDesc getRightLimit() {
        return null;
    }

    public boolean requiresJoinConditions() {
        return this.type != JoinType.CROSS && (this.conditionsMode == ConditionsMode.AND || this.conditionsMode == ConditionsMode.OR);
    }

    public List<M> getJoinConditions() {
        if (!this.requiresJoinConditions()) {
            return new ArrayList();
        }
        return this.on;
    }

    public boolean isEquiJoin() {
        for (MatchingConditionBase cond : this.getJoinConditions()) {
            if (cond.isEqualityCondition()) continue;
            return false;
        }
        return true;
    }
}

